/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.ResourcePackVanilla;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackSource;
import net.minecraft.server.packs.repository.ResourcePackSourceFolder;
import net.minecraft.world.level.validation.DirectoryValidator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public abstract class BuiltInPackSource
implements ResourcePackSource {
    private static final Logger c = LogUtils.getLogger();
    public static final String a = "vanilla";
    public static final KnownPack b = KnownPack.a("core");
    private final EnumResourcePackType d;
    private final ResourcePackVanilla e;
    private final MinecraftKey f;
    private final DirectoryValidator g;

    public BuiltInPackSource(EnumResourcePackType packType, ResourcePackVanilla vanillaPack, MinecraftKey packDir, DirectoryValidator validator) {
        this.d = packType;
        this.e = vanillaPack;
        this.f = packDir;
        this.g = validator;
    }

    @Override
    public void loadPacks(Consumer<ResourcePackLoader> onLoad) {
        ResourcePackLoader pack = this.a(this.e);
        if (pack != null) {
            onLoad.accept(pack);
        }
        this.a(onLoad);
    }

    @Nullable
    protected abstract ResourcePackLoader a(IResourcePack var1);

    protected abstract IChatBaseComponent a(String var1);

    public ResourcePackVanilla a() {
        return this.e;
    }

    private void a(Consumer<ResourcePackLoader> packConsumer) {
        HashMap<String, Function> map = new HashMap<String, Function>();
        this.a(map::put);
        map.forEach((string, packGetter) -> {
            ResourcePackLoader pack = (ResourcePackLoader)packGetter.apply(string);
            if (pack != null) {
                packConsumer.accept(pack);
            }
        });
    }

    protected void a(BiConsumer<String, Function<String, ResourcePackLoader>> populator) {
        this.e.a(this.d, this.f, (Path path) -> this.a((Path)path, populator));
    }

    protected void a(@Nullable Path directoryPath, BiConsumer<String, Function<String, ResourcePackLoader>> packGetter) {
        if (directoryPath != null && Files.isDirectory(directoryPath, new LinkOption[0])) {
            try {
                ResourcePackSourceFolder.a(directoryPath, this.g, (Path path, ResourcePackLoader.c resources) -> packGetter.accept(BuiltInPackSource.a(path), string -> this.a((String)string, (ResourcePackLoader.c)resources, this.a((String)string))));
            }
            catch (IOException var4) {
                c.warn("Failed to discover packs in {}", (Object)directoryPath, (Object)var4);
            }
        }
    }

    private static String a(Path path) {
        return StringUtils.removeEnd((String)path.getFileName().toString(), (String)".zip");
    }

    @Nullable
    protected abstract ResourcePackLoader a(String var1, ResourcePackLoader.c var2, IChatBaseComponent var3);

    protected static ResourcePackLoader.c b(final IResourcePack resources) {
        return new ResourcePackLoader.c(){

            @Override
            public IResourcePack a(PackLocationInfo location) {
                return resources;
            }

            @Override
            public IResourcePack a(PackLocationInfo location, ResourcePackLoader.a metadata) {
                return resources;
            }
        };
    }
}

