/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.ChatDeserializer;
import org.slf4j.Logger;

public abstract class ResourcePackAbstract
implements IResourcePack {
    private static final Logger c = LogUtils.getLogger();
    private final PackLocationInfo d;

    protected ResourcePackAbstract(PackLocationInfo location) {
        this.d = location;
    }

    @Override
    @Nullable
    public <T> T a(MetadataSectionType<T> type) throws IOException {
        T var4;
        IoSupplier<InputStream> rootResource = this.a("pack.mcmeta");
        if (rootResource == null) {
            return null;
        }
        try (InputStream inputStream = rootResource.get();){
            var4 = ResourcePackAbstract.a(type, inputStream);
        }
        return var4;
    }

    @Nullable
    public static <T> T a(MetadataSectionType<T> type, InputStream stream) {
        JsonObject jsonObject;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            jsonObject = ChatDeserializer.a(bufferedReader);
        }
        catch (Exception var8) {
            c.error("Couldn't load {} metadata", (Object)type.a(), (Object)var8);
            return null;
        }
        return !jsonObject.has(type.a()) ? null : type.b().parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject.get(type.a())).ifError(error -> c.error("Couldn't load {} metadata: {}", (Object)type.a(), error)).result().orElse(null);
    }

    @Override
    public PackLocationInfo a() {
        return this.d;
    }
}

