/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.LegacyTextFilter;
import net.minecraft.server.network.PlayerSafetyServiceTextFilter;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.UtilColor;
import net.minecraft.util.thread.ConsecutiveExecutor;
import org.slf4j.Logger;

public abstract class ServerTextFilter
implements AutoCloseable {
    protected static final Logger a = LogUtils.getLogger();
    private static final AtomicInteger b = new AtomicInteger(1);
    private static final ThreadFactory c = runnable -> {
        Thread thread = new Thread(runnable);
        thread.setName("Chat-Filter-Worker-" + b.getAndIncrement());
        return thread;
    };
    private final URL d;
    private final b e;
    final a f;
    final ExecutorService g;

    protected static ExecutorService a(int size) {
        return Executors.newFixedThreadPool(size, c);
    }

    protected ServerTextFilter(URL chatEndpoint, b chatEncoder, a chatIgnoreStrategy, ExecutorService workerPool) {
        this.f = chatIgnoreStrategy;
        this.g = workerPool;
        this.d = chatEndpoint;
        this.e = chatEncoder;
    }

    protected static URL a(URI apiServer, @Nullable JsonObject json, String key, String fallback) throws MalformedURLException {
        String endpointFromConfig = ServerTextFilter.a(json, key, fallback);
        return apiServer.resolve("/" + endpointFromConfig).toURL();
    }

    protected static String a(@Nullable JsonObject json, String key, String fallback) {
        return json != null ? ChatDeserializer.a(json, key, fallback) : fallback;
    }

    @Nullable
    public static ServerTextFilter a(DedicatedServerProperties config) {
        String string = config.R;
        if (UtilColor.h(string)) {
            return null;
        }
        return switch (config.S) {
            case 0 -> LegacyTextFilter.a(string);
            case 1 -> PlayerSafetyServiceTextFilter.a(string);
            default -> {
                a.warn("Could not create text filter - unsupported text filtering version used");
                yield null;
            }
        };
    }

    protected CompletableFuture<FilteredText> a(GameProfile profile, String filter, a chatIgnoreStrategy, Executor streamExecutor) {
        return filter.isEmpty() ? CompletableFuture.completedFuture(FilteredText.a) : CompletableFuture.supplyAsync(() -> {
            JsonObject jsonObject = this.e.encode(profile, filter);
            try {
                JsonObject jsonObject1 = this.b(jsonObject, this.d);
                return this.a(filter, chatIgnoreStrategy, jsonObject1);
            }
            catch (Exception var6) {
                a.warn("Failed to validate message '{}'", (Object)filter, (Object)var6);
                return FilteredText.b(filter);
            }
        }, streamExecutor);
    }

    protected abstract FilteredText a(String var1, a var2, JsonObject var3);

    protected FilterMask a(String text, JsonArray hashes, a ignoreStrategy) {
        if (hashes.isEmpty()) {
            return FilterMask.c;
        }
        if (ignoreStrategy.shouldIgnore(text, hashes.size())) {
            return FilterMask.b;
        }
        FilterMask filterMask = new FilterMask(text.length());
        for (int i2 = 0; i2 < hashes.size(); ++i2) {
            filterMask.a(hashes.get(i2).getAsInt());
        }
        return filterMask;
    }

    @Override
    public void close() {
        this.g.shutdownNow();
    }

    protected void a(InputStream stream) throws IOException {
        byte[] bytes = new byte[1024];
        while (stream.read(bytes) != -1) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonObject b(JsonObject request, URL endpoint) throws IOException {
        JsonObject var5;
        HttpURLConnection httpUrlConnection = this.a(request, endpoint);
        try (InputStream inputStream = httpUrlConnection.getInputStream();){
            if (httpUrlConnection.getResponseCode() == 204) {
                JsonObject jsonObject = new JsonObject();
                return jsonObject;
            }
            try {
                var5 = Streams.parse((JsonReader)new JsonReader((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8))).getAsJsonObject();
            }
            finally {
                this.a(inputStream);
            }
        }
        return var5;
    }

    protected HttpURLConnection a(JsonObject request, URL endpoint) throws IOException {
        HttpURLConnection urlConnection = this.a(endpoint);
        this.a(urlConnection);
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(urlConnection.getOutputStream(), StandardCharsets.UTF_8);
             JsonWriter jsonWriter = new JsonWriter((Writer)outputStreamWriter);){
            Streams.write((JsonElement)request, (JsonWriter)jsonWriter);
        }
        int responseCode = urlConnection.getResponseCode();
        if (responseCode >= 200 && responseCode < 300) {
            return urlConnection;
        }
        throw new d(responseCode + " " + urlConnection.getResponseMessage());
    }

    protected abstract void a(HttpURLConnection var1);

    protected int a() {
        return 2000;
    }

    protected HttpURLConnection a(URL url) throws IOException {
        HttpURLConnection httpUrlConnection = (HttpURLConnection)url.openConnection();
        httpUrlConnection.setConnectTimeout(15000);
        httpUrlConnection.setReadTimeout(this.a());
        httpUrlConnection.setUseCaches(false);
        httpUrlConnection.setDoOutput(true);
        httpUrlConnection.setDoInput(true);
        httpUrlConnection.setRequestMethod("POST");
        httpUrlConnection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        httpUrlConnection.setRequestProperty("Accept", "application/json");
        httpUrlConnection.setRequestProperty("User-Agent", "Minecraft server" + SharedConstants.b().c());
        return httpUrlConnection;
    }

    public ITextFilter a(GameProfile profile) {
        return new c(profile);
    }

    @FunctionalInterface
    public static interface a {
        public static final a a = (text, numHashes) -> false;
        public static final a b = (text, numHashes) -> text.length() == numHashes;

        public static a ignoreOverThreshold(int theshold) {
            return (text, numHashes) -> numHashes >= theshold;
        }

        public static a select(int threshold) {
            return switch (threshold) {
                case -1 -> a;
                case 0 -> b;
                default -> net.minecraft.server.network.ServerTextFilter$a.ignoreOverThreshold(threshold);
            };
        }

        public boolean shouldIgnore(String var1, int var2);
    }

    @FunctionalInterface
    protected static interface b {
        public JsonObject encode(GameProfile var1, String var2);
    }

    protected static class d
    extends RuntimeException {
        protected d(String message) {
            super(message);
        }
    }

    protected class c
    implements ITextFilter {
        protected final GameProfile b;
        protected final Executor c;

        protected c(GameProfile profile) {
            this.b = profile;
            ConsecutiveExecutor consecutiveExecutor = new ConsecutiveExecutor(ServerTextFilter.this.g, "chat stream for " + profile.getName());
            this.c = consecutiveExecutor::a_;
        }

        @Override
        public CompletableFuture<List<FilteredText>> a(List<String> texts) {
            List list = (List)texts.stream().map(string -> ServerTextFilter.this.a(this.b, (String)string, ServerTextFilter.this.f, this.c)).collect(ImmutableList.toImmutableList());
            return SystemUtils.e(list).exceptionally(throwable -> ImmutableList.of());
        }

        @Override
        public CompletableFuture<FilteredText> a(String text) {
            return ServerTextFilter.this.a(this.b, text, ServerTextFilter.this.f, this.c);
        }
    }
}

