/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import net.kyori.adventure.translation.Translator;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundServerLinksPacket;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.common.custom.BrandPayload;
import net.minecraft.network.protocol.configuration.ClientboundUpdateEnabledFeaturesPacket;
import net.minecraft.network.protocol.configuration.ServerConfigurationPacketListener;
import net.minecraft.network.protocol.configuration.ServerboundFinishConfigurationPacket;
import net.minecraft.network.protocol.configuration.ServerboundSelectKnownPacks;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ServerLinks;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.config.JoinWorldTask;
import net.minecraft.server.network.config.ServerResourcePackConfigurationTask;
import net.minecraft.server.network.config.SynchronizeRegistriesTask;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.flag.FeatureFlags;
import org.bukkit.craftbukkit.v1_21_R3.CraftServerLinks;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerLinksSendEvent;
import org.slf4j.Logger;

public class ServerConfigurationPacketListenerImpl
extends ServerCommonPacketListenerImpl
implements ServerConfigurationPacketListener,
TickablePacketListener {
    private static final Logger f = LogUtils.getLogger();
    private static final IChatBaseComponent g = IChatBaseComponent.c("multiplayer.disconnect.invalid_player_data");
    private final GameProfile h;
    private final Queue<ConfigurationTask> i = new ConcurrentLinkedQueue<ConfigurationTask>();
    @Nullable
    private ConfigurationTask j;
    private ClientInformation k;
    @Nullable
    private SynchronizeRegistriesTask l;

    public ServerConfigurationPacketListenerImpl(MinecraftServer server, NetworkManager connection, CommonListenerCookie cookie, EntityPlayer player) {
        super(server, connection, cookie, player);
        this.h = cookie.a();
        this.k = cookie.c();
    }

    @Override
    protected GameProfile i() {
        return this.h;
    }

    @Override
    public void a(DisconnectionDetails details) {
        if (this.d.isDebugging()) {
            f.info("{} lost connection: {}, while in configuration phase {}", new Object[]{this.h, details.a().getString(), this.j != null ? this.j.a().a() : "null"});
        } else {
            f.info("{} lost connection: {}", (Object)this.h, (Object)details.a().getString());
        }
        super.a(details);
    }

    @Override
    public boolean c() {
        return this.e.i();
    }

    public void l() {
        this.b(new ClientboundCustomPayloadPacket(new BrandPayload(this.d.getServerModName())));
        ServerLinks serverLinks = this.d.bp();
        CraftServerLinks wrapper = new CraftServerLinks(serverLinks);
        PlayerLinksSendEvent event = new PlayerLinksSendEvent((Player)this.player.getBukkitEntity(), (org.bukkit.ServerLinks)wrapper);
        this.cserver.getPluginManager().callEvent((Event)event);
        serverLinks = wrapper.getServerLinks();
        if (!serverLinks.a()) {
            this.b(new ClientboundServerLinksPacket(serverLinks.b()));
        }
        LayeredRegistryAccess<RegistryLayer> layeredRegistryAccess = this.d.bb();
        List<KnownPack> list = this.d.be().b().flatMap(packResources -> packResources.a().d().stream()).toList();
        this.b(new ClientboundUpdateEnabledFeaturesPacket(FeatureFlags.e.b(this.d.aZ().K())));
        this.l = new SynchronizeRegistriesTask(list, layeredRegistryAccess);
        this.i.add(this.l);
        this.n();
        this.i.add(new JoinWorldTask());
        this.o();
    }

    public void m() {
        this.i.add(new JoinWorldTask());
        this.o();
    }

    private void n() {
        this.d.Y().ifPresent(serverResourcePackInfo -> this.i.add(new ServerResourcePackConfigurationTask((MinecraftServer.ServerResourcePackInfo)serverResourcePackInfo)));
    }

    @Override
    public void a(ServerboundClientInformationPacket packet) {
        this.k = packet.b();
        this.e.n.attr(PaperAdventure.LOCALE_ATTRIBUTE).set((Object)Translator.parseLocale((String)packet.b().b()));
    }

    @Override
    public void a(ServerboundResourcePackPacket packet) {
        super.a(packet);
        if (packet.e().a()) {
            this.a(ServerResourcePackConfigurationTask.a);
        }
    }

    @Override
    public void a(ServerboundSelectKnownPacks packet) {
        PlayerConnectionUtils.a(packet, this, this.d);
        if (this.l == null) {
            throw new IllegalStateException("Unexpected response from client: received pack selection, but no negotiation ongoing");
        }
        this.l.a(packet.b(), this::b);
        this.a(SynchronizeRegistriesTask.a);
    }

    @Override
    public void a(ServerboundFinishConfigurationPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.d);
        this.a(JoinWorldTask.a);
        this.e.a(GameProtocols.b.a(RegistryFriendlyByteBuf.a(this.d.ba())));
        try {
            PlayerList playerList = this.d.ag();
            if (playerList.a(this.h.getId()) != null) {
                this.a(PlayerList.f);
                return;
            }
            IChatBaseComponent component = null;
            if (component != null) {
                this.a(component);
                return;
            }
            EntityPlayer playerForLogin = playerList.getPlayerForLogin(this.h, this.k, this.player);
            playerList.a(this.e, playerForLogin, this.a(this.k));
        }
        catch (Exception var5) {
            f.error("Couldn't place player in world", (Throwable)var5);
            if (this.d.isDebugging()) {
                var5.printStackTrace();
            }
            this.e.a(new ClientboundDisconnectPacket(g));
            this.e.a(g);
        }
    }

    @Override
    public void d() {
        this.e();
    }

    private void o() {
        ConfigurationTask configurationTask;
        if (this.j != null) {
            throw new IllegalStateException("Task " + this.j.a().a() + " has not finished yet");
        }
        if (this.c() && (configurationTask = this.i.poll()) != null) {
            this.j = configurationTask;
            configurationTask.a(this::b);
        }
    }

    private void a(ConfigurationTask.a taskType) {
        ConfigurationTask.a type;
        ConfigurationTask.a a2 = type = this.j != null ? this.j.a() : null;
        if (!taskType.equals(type)) {
            throw new IllegalStateException("Unexpected request for task finish, current task: " + String.valueOf(type) + ", requested: " + String.valueOf(taskType));
        }
        this.j = null;
        this.o();
    }
}

