/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import com.destroystokyo.paper.event.brigadier.AsyncPlayerSendSuggestionsEvent;
import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import com.destroystokyo.paper.event.player.PlayerRecipeBookClickEvent;
import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.ChatProcessor;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.brigadier.TagParseCommandSyntaxException;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.configuration.type.number.IntOr;
import io.papermc.paper.entity.TeleportFlag;
import io.papermc.paper.event.player.CartographyItemEvent;
import io.papermc.paper.event.player.PlayerArmSwingEvent;
import io.papermc.paper.event.player.PlayerClientLoadedWorldEvent;
import io.papermc.paper.event.player.PlayerFailMoveEvent;
import io.papermc.paper.event.player.PlayerPickItemEvent;
import io.papermc.paper.util.TraceUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.translation.Translator;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.arguments.ArgumentSignatures;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.LastSeenMessagesValidator;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.chat.SignableCommand;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.configuration.ConfigurationProtocols;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetCursorItemPacket;
import net.minecraft.network.protocol.game.ClientboundStartConfigurationPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.network.protocol.game.PacketPlayInAbilities;
import net.minecraft.network.protocol.game.PacketPlayInAdvancements;
import net.minecraft.network.protocol.game.PacketPlayInArmAnimation;
import net.minecraft.network.protocol.game.PacketPlayInAutoRecipe;
import net.minecraft.network.protocol.game.PacketPlayInBEdit;
import net.minecraft.network.protocol.game.PacketPlayInBeacon;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayInBlockPlace;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.protocol.game.PacketPlayInChat;
import net.minecraft.network.protocol.game.PacketPlayInClientCommand;
import net.minecraft.network.protocol.game.PacketPlayInCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyChange;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyLock;
import net.minecraft.network.protocol.game.PacketPlayInEnchantItem;
import net.minecraft.network.protocol.game.PacketPlayInEntityAction;
import net.minecraft.network.protocol.game.PacketPlayInEntityNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInFlying;
import net.minecraft.network.protocol.game.PacketPlayInHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayInItemName;
import net.minecraft.network.protocol.game.PacketPlayInJigsawGenerate;
import net.minecraft.network.protocol.game.PacketPlayInRecipeDisplayed;
import net.minecraft.network.protocol.game.PacketPlayInRecipeSettings;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandBlock;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandMinecart;
import net.minecraft.network.protocol.game.PacketPlayInSetCreativeSlot;
import net.minecraft.network.protocol.game.PacketPlayInSetJigsaw;
import net.minecraft.network.protocol.game.PacketPlayInSpectate;
import net.minecraft.network.protocol.game.PacketPlayInSteerVehicle;
import net.minecraft.network.protocol.game.PacketPlayInStruct;
import net.minecraft.network.protocol.game.PacketPlayInTabComplete;
import net.minecraft.network.protocol.game.PacketPlayInTeleportAccept;
import net.minecraft.network.protocol.game.PacketPlayInTileNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInTrSel;
import net.minecraft.network.protocol.game.PacketPlayInUpdateSign;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.network.protocol.game.PacketPlayInUseItem;
import net.minecraft.network.protocol.game.PacketPlayInVehicleMove;
import net.minecraft.network.protocol.game.PacketPlayInWindowClick;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutAutoRecipe;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayOutPosition;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.game.PacketPlayOutVehicleMove;
import net.minecraft.network.protocol.game.ServerboundChatAckPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandSignedPacket;
import net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundChunkBatchReceivedPacket;
import net.minecraft.network.protocol.game.ServerboundClientTickEndPacket;
import net.minecraft.network.protocol.game.ServerboundConfigurationAcknowledgedPacket;
import net.minecraft.network.protocol.game.ServerboundContainerSlotStateChangedPacket;
import net.minecraft.network.protocol.game.ServerboundDebugSampleSubscriptionPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemFromBlockPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemFromEntityPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerLoadedPacket;
import net.minecraft.network.protocol.game.ServerboundSelectBundleItemPacket;
import net.minecraft.network.protocol.ping.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.ping.ServerboundPingRequestPacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.Filterable;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerChunkSender;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.FutureChain;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.TickThrottler;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.ContainerBeacon;
import net.minecraft.world.inventory.ContainerMerchant;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockCommand;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Input;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R3.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R3.CraftInput;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftVector;
import org.bukkit.craftbukkit.v1_21_R3.util.LazyPlayerSet;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInputEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.CartographyInventory;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.util.RayTraceResult;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotConfig;

public class PlayerConnection
extends ServerCommonPacketListenerImpl
implements PacketListenerPlayIn,
ServerPlayerConnection,
TickablePacketListener {
    static final Logger h = LogUtils.getLogger();
    private static final int i = -1;
    private static final int j = 4096;
    private static final int k = 80;
    private static final IChatBaseComponent l = IChatBaseComponent.c("multiplayer.disconnect.chat_validation_failed");
    private static final IChatBaseComponent m = IChatBaseComponent.c("chat.disabled.invalid_command_signature").a(EnumChatFormat.m);
    private static final int n = 1000;
    public EntityPlayer f;
    public final PlayerChunkSender g;
    private int o;
    private int p = -1;
    private final TickThrottler q = new TickThrottler(20, 200);
    private final TickThrottler tabSpamThrottler;
    private final TickThrottler r;
    private final TickThrottler recipeSpamPackets;
    private double s;
    private double t;
    private double u;
    private double v;
    private double w;
    private double x;
    @Nullable
    private net.minecraft.world.entity.Entity y;
    private double z;
    private double A;
    private double B;
    private double C;
    private double D;
    private double E;
    @Nullable
    private Vec3D F;
    private int G;
    private int H;
    private boolean I;
    private int J;
    private boolean K;
    private int L;
    private int M;
    private int N;
    private boolean O;
    private int lastTick;
    private int allowedPlayerTicks;
    private int lastDropTick;
    private int lastBookTick;
    private int dropCount;
    private boolean hasMoved;
    private double lastPosX;
    private double lastPosY;
    private double lastPosZ;
    private float lastPitch;
    private float lastYaw;
    private boolean justTeleported;
    @Nullable
    private RemoteChatSession P;
    private boolean hasLoggedExpiry;
    private SignedMessageChain.b Q;
    private final LastSeenMessagesValidator R;
    private final MessageSignatureCache S;
    private final FutureChain T;
    private boolean U;
    private static final int MAX_SIGN_LINE_LENGTH = Integer.getInteger("Paper.maxSignLength", 80);
    private static final ExecutorService TAB_COMPLETE_EXECUTOR = Executors.newFixedThreadPool(4, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Async Tab Complete Thread - #%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(MinecraftServer.l)).build());
    private int limitedPackets;
    private long lastLimitedPacket;

    public PlayerConnection(MinecraftServer server, NetworkManager connection, EntityPlayer player, CommonListenerCookie cookie) {
        super(server, connection, cookie, player);
        this.tabSpamThrottler = new TickThrottler(GlobalConfiguration.get().spamLimiter.tabSpamIncrement, GlobalConfiguration.get().spamLimiter.tabSpamLimit);
        this.r = new TickThrottler(20, 1480);
        this.recipeSpamPackets = new TickThrottler(GlobalConfiguration.get().spamLimiter.recipeSpamIncrement, GlobalConfiguration.get().spamLimiter.recipeSpamLimit);
        this.lastTick = MinecraftServer.currentTick;
        this.allowedPlayerTicks = 1;
        this.lastDropTick = MinecraftServer.currentTick;
        this.lastBookTick = MinecraftServer.currentTick;
        this.dropCount = 0;
        this.hasMoved = false;
        this.lastPosX = Double.MAX_VALUE;
        this.lastPosY = Double.MAX_VALUE;
        this.lastPosZ = Double.MAX_VALUE;
        this.lastPitch = Float.MAX_VALUE;
        this.lastYaw = Float.MAX_VALUE;
        this.justTeleported = false;
        this.hasLoggedExpiry = false;
        this.R = new LastSeenMessagesValidator(20);
        this.S = MessageSignatureCache.a();
        this.lastLimitedPacket = -1L;
        this.g = new PlayerChunkSender(connection.e());
        this.f = player;
        player.f = this;
        player.Z().a();
        this.Q = SignedMessageChain.b.unsigned(player.cG(), server::aA);
        this.T = new FutureChain(server.chatExecutor);
    }

    @Override
    public void d() {
        if (this.p > -1) {
            this.b(new ClientboundBlockChangedAckPacket(this.p));
            this.p = -1;
        }
        this.l();
        this.f.K = this.f.dA();
        this.f.L = this.f.dC();
        this.f.M = this.f.dG();
        this.f.i();
        this.f.a(this.s, this.t, this.u, this.f.dL(), this.f.dN());
        ++this.o;
        this.N = this.M;
        if (this.I && !this.f.fR() && !this.f.bZ() && !this.f.eE()) {
            if (++this.J > this.a(this.f)) {
                h.warn("{} was kicked for floating too long!", (Object)this.f.al().getString());
                this.disconnect(GlobalConfiguration.get().messages.kick.flyingPlayer, PlayerKickEvent.Cause.FLYING_PLAYER);
                return;
            }
        } else {
            this.I = false;
            this.J = 0;
        }
        this.y = this.f.df();
        if (this.y != this.f && this.y.cW() == this.f) {
            this.z = this.y.dA();
            this.A = this.y.dC();
            this.B = this.y.dG();
            this.C = this.y.dA();
            this.D = this.y.dC();
            this.E = this.y.dG();
            if (this.K && this.y.cW() == this.f) {
                if (++this.L > this.a(this.y)) {
                    h.warn("{} was kicked for floating a vehicle too long!", (Object)this.f.al().getString());
                    this.disconnect(GlobalConfiguration.get().messages.kick.flyingVehicle, PlayerKickEvent.Cause.FLYING_VEHICLE);
                    return;
                }
            } else {
                this.K = false;
                this.L = 0;
            }
        } else {
            this.y = null;
            this.K = false;
            this.L = 0;
        }
        this.e();
        this.q.b();
        this.r.b();
        this.tabSpamThrottler.b();
        this.recipeSpamPackets.b();
        if (this.f.N() > 0L && this.d.ap() > 0 && SystemUtils.c() - this.f.N() > (long)this.d.ap() * 1000L * 60L && !this.f.k) {
            this.f.H();
            this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.idling"), PlayerKickEvent.Cause.IDLING);
        }
        if (!this.hasLoggedExpiry && this.P != null && this.P.d().b().a()) {
            h.info("Player profile key for {} has expired!", (Object)this.f.al().getString());
            this.hasLoggedExpiry = true;
        }
    }

    private int a(net.minecraft.world.entity.Entity entity) {
        double gravity = entity.be();
        if (gravity < (double)1.0E-5f) {
            return Integer.MAX_VALUE;
        }
        double d2 = 0.08 / gravity;
        return MathHelper.c(80.0 * Math.max(d2, 1.0));
    }

    public void l() {
        this.s = this.f.dA();
        this.t = this.f.dC();
        this.u = this.f.dG();
        this.v = this.f.dA();
        this.w = this.f.dC();
        this.x = this.f.dG();
    }

    @Override
    public boolean c() {
        return this.e.i() && !this.U;
    }

    @Override
    public boolean a(Packet<?> packet) {
        return super.a(packet) || this.U && this.e.i() && packet instanceof ServerboundConfigurationAcknowledgedPacket;
    }

    @Override
    protected GameProfile i() {
        return this.f.gh();
    }

    private <T, R> CompletableFuture<R> a(T message, BiFunction<ITextFilter, T, CompletableFuture<R>> processor) {
        return processor.apply(this.f.Z(), (ITextFilter)message).thenApply(result -> {
            if (!this.c()) {
                h.debug("Ignoring packet due to disconnection");
                throw new CancellationException("disconnected");
            }
            return result;
        });
    }

    private CompletableFuture<FilteredText> a(String text) {
        return this.a(text, ITextFilter::a);
    }

    private CompletableFuture<List<FilteredText>> a(List<String> texts) {
        return this.a(texts, ITextFilter::a);
    }

    @Override
    public void a(PacketPlayInSteerVehicle packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (!packet.b().equals(this.f.ai())) {
            PlayerInputEvent event = new PlayerInputEvent((Player)this.f.getBukkitEntity(), (Input)new CraftInput(packet.b()));
            this.cserver.getPluginManager().callEvent((Event)event);
        }
        this.f.a(packet.b());
    }

    private static boolean b(double x2, double y2, double z2, float yRot, float xRot) {
        return Double.isNaN(x2) || Double.isNaN(y2) || Double.isNaN(z2) || !Floats.isFinite((float)xRot) || !Floats.isFinite((float)yRot);
    }

    private static double a(double value) {
        return MathHelper.a(value, -3.0E7, 3.0E7);
    }

    private static double b(double value) {
        return MathHelper.a(value, -2.0E7, 2.0E7);
    }

    @Override
    public void a(PacketPlayInVehicleMove packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (PlayerConnection.b(packet.b().a(), packet.b().b(), packet.b().c(), packet.e(), packet.f())) {
            this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.invalid_vehicle_movement"), PlayerKickEvent.Cause.INVALID_VEHICLE_MOVEMENT);
        } else if (!this.p() && this.f.gJ()) {
            net.minecraft.world.entity.Entity rootVehicle = this.f.df();
            if (this.F != null || this.f.fi() || rootVehicle.dQ()) {
                return;
            }
            if (rootVehicle != this.f && rootVehicle.cW() == this.f && rootVehicle == this.y) {
                EntityLiving livingEntity;
                double d2;
                double d1;
                double d3;
                WorldServer serverLevel = this.f.y();
                double prevX = this.f.dA();
                double prevY = this.f.dC();
                double prevZ = this.f.dG();
                float prevYaw = this.f.dL();
                float prevPitch = this.f.dN();
                double x2 = rootVehicle.dA();
                double y2 = rootVehicle.dC();
                double z2 = rootVehicle.dG();
                double toX = d3 = PlayerConnection.a(packet.b().a());
                double toY = d1 = PlayerConnection.b(packet.b().b());
                double toZ = d2 = PlayerConnection.a(packet.b().c());
                float f2 = MathHelper.h(packet.e());
                float f1 = MathHelper.h(packet.f());
                double d32 = d3 - this.z;
                double d4 = d1 - this.A;
                double d5 = d2 - this.B;
                double d6 = rootVehicle.dy().h();
                double d7 = d32 * d32 + d4 * d4 + d5 * d5;
                double currDeltaX = toX - x2;
                double currDeltaY = toY - y2;
                double currDeltaZ = toZ - z2;
                d7 = Math.max(d7, currDeltaX * currDeltaX + currDeltaY * currDeltaY + currDeltaZ * currDeltaZ - 1.0);
                double otherFieldX = toX - this.C;
                double otherFieldY = toY - this.D;
                double otherFieldZ = toZ - this.E;
                d7 = Math.max(d7, otherFieldX * otherFieldX + otherFieldY * otherFieldY + otherFieldZ * otherFieldZ - 1.0);
                this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                this.lastTick = (int)(System.currentTimeMillis() / 50L);
                ++this.M;
                int i2 = this.M - this.N;
                if (i2 > Math.max(this.allowedPlayerTicks, 5)) {
                    h.debug(this.f.cI() + " is sending move packets too frequently (" + i2 + " packets since last tick)");
                    i2 = 1;
                }
                this.allowedPlayerTicks = d7 > 0.0 ? --this.allowedPlayerTicks : 20;
                double speed = this.f.gj().b ? (double)(this.f.gj().f * 20.0f) : (double)(this.f.gj().g * 10.0f);
                speed *= 2.0;
                if (!(!this.f.dV().paperConfig().chunks.preventMovingIntoUnloadedChunks || serverLevel.areChunksLoadedForMove(this.f.cR().b(new Vec3D(toX, toY, toZ).d(this.f.dt()))) && serverLevel.areChunksLoadedForMove(rootVehicle.cR().b(new Vec3D(toX, toY, toZ).d(rootVehicle.dt()))))) {
                    this.e.a(PacketPlayOutVehicleMove.a(rootVehicle));
                    return;
                }
                if (d7 - d6 > Math.max(100.0, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i2 * speed, 2.0)) && !this.h()) {
                    h.warn("{} (vehicle of {}) moved too quickly! {},{},{}", new Object[]{rootVehicle.al().getString(), this.f.al().getString(), d32, d4, d5});
                    this.b(PacketPlayOutVehicleMove.a(rootVehicle));
                    return;
                }
                AxisAlignedBB oldBox = rootVehicle.cR();
                d32 = d3 - this.C;
                d4 = d1 - this.D;
                d5 = d2 - this.E;
                boolean flag1 = rootVehicle.R;
                if (rootVehicle instanceof EntityLiving && (livingEntity = (EntityLiving)rootVehicle).q_()) {
                    livingEntity.k();
                }
                rootVehicle.a(EnumMoveType.b, new Vec3D(d32, d4, d5));
                boolean didCollide = toX != rootVehicle.dA() || toY != rootVehicle.dC() || toZ != rootVehicle.dG();
                double verticalDelta = d4;
                d32 = d3 - rootVehicle.dA();
                d4 = d1 - rootVehicle.dC();
                if (d4 > -0.5 || d4 < 0.5) {
                    d4 = 0.0;
                }
                d5 = d2 - rootVehicle.dG();
                d7 = d32 * d32 + d4 * d4 + d5 * d5;
                boolean flag2 = false;
                if (d7 > SpigotConfig.movedWronglyThreshold) {
                    flag2 = true;
                    h.warn("{} (vehicle of {}) moved wrongly! {}", new Object[]{rootVehicle.al().getString(), this.f.al().getString(), Math.sqrt(d7)});
                }
                rootVehicle.a(d3, d1, d2, f2, f1);
                this.f.a(d3, d1, d2, this.f.dL(), this.f.dN());
                boolean teleportBack = flag2;
                if (!teleportBack) {
                    AxisAlignedBB newBox = rootVehicle.cR();
                    if (didCollide || !oldBox.equals(newBox)) {
                        teleportBack = this.hasNewCollision(serverLevel, rootVehicle, oldBox, newBox);
                    }
                }
                if (teleportBack) {
                    rootVehicle.a(x2, y2, z2, f2, f1);
                    this.f.a(x2, y2, z2, this.f.dL(), this.f.dN());
                    this.b(PacketPlayOutVehicleMove.a(rootVehicle));
                    return;
                }
                CraftPlayer player = this.getCraftPlayer();
                if (!this.hasMoved) {
                    this.lastPosX = prevX;
                    this.lastPosY = prevY;
                    this.lastPosZ = prevZ;
                    this.lastYaw = prevYaw;
                    this.lastPitch = prevPitch;
                    this.hasMoved = true;
                }
                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                Location to = CraftLocation.toBukkit(packet.b(), player.getWorld(), packet.e(), packet.f());
                double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.f.fi()) {
                    this.lastPosX = to.getX();
                    this.lastPosY = to.getY();
                    this.lastPosZ = to.getZ();
                    this.lastYaw = to.getYaw();
                    this.lastPitch = to.getPitch();
                    Location oldTo = to.clone();
                    PlayerMoveEvent event = new PlayerMoveEvent((Player)player, from, to);
                    this.cserver.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        this.teleport(from);
                        return;
                    }
                    if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                        this.f.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                        return;
                    }
                    if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                        this.justTeleported = false;
                        return;
                    }
                }
                this.f.y().m().a(this.f);
                if (!rootVehicle.Z_() && rootVehicle.aL()) {
                    rootVehicle.b(new Vec3D(x2, y2, z2), rootVehicle.dt());
                }
                Vec3D vec3 = new Vec3D(rootVehicle.dA() - x2, rootVehicle.dC() - y2, rootVehicle.dG() - z2);
                this.a(vec3);
                rootVehicle.a(packet.g(), vec3);
                rootVehicle.a(vec3.d, vec3.e, vec3.f, packet.g());
                this.f.b(vec3.d, vec3.e, vec3.f);
                this.K = verticalDelta >= -0.03125 && !flag1 && !this.d.ad() && !rootVehicle.bc() && this.b(rootVehicle);
                this.C = rootVehicle.dA();
                this.D = rootVehicle.dC();
                this.E = rootVehicle.dG();
            }
        }
    }

    private boolean b(net.minecraft.world.entity.Entity entity) {
        AxisAlignedBB box = entity.cR().g(0.0625).b(0.0, -0.55, 0.0);
        int minX = MathHelper.a(box.a);
        int minY = MathHelper.a(box.b);
        int minZ = MathHelper.a(box.c);
        int maxX = MathHelper.a(box.d);
        int maxY = MathHelper.a(box.e);
        int maxZ = MathHelper.a(box.f);
        net.minecraft.world.level.World level = entity.dV();
        BlockPosition.MutableBlockPosition pos = new BlockPosition.MutableBlockPosition();
        for (int y2 = minY; y2 <= maxY; ++y2) {
            for (int z2 = minZ; z2 <= maxZ; ++z2) {
                for (int x2 = minX; x2 <= maxX; ++x2) {
                    pos.d(x2, y2, z2);
                    IBlockData blockState = level.getBlockStateIfLoaded(pos);
                    if (blockState == null || blockState.l()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void a(PacketPlayInTeleportAccept packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (packet.b() == this.G) {
            if (this.F == null) {
                this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.invalid_player_movement"), PlayerKickEvent.Cause.INVALID_PLAYER_MOVEMENT);
                return;
            }
            this.f.b(this.F.d, this.F.e, this.F.f, this.f.dL(), this.f.dN());
            this.v = this.F.d;
            this.w = this.F.e;
            this.x = this.F.f;
            this.f.R();
            this.F = null;
            this.f.y().m().a(this.f);
        }
    }

    @Override
    public void a(ServerboundPlayerLoadedPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (this.f.gJ()) {
            return;
        }
        PlayerClientLoadedWorldEvent event = new PlayerClientLoadedWorldEvent((Player)this.f.getBukkitEntity(), false);
        event.callEvent();
        this.f.w(true);
    }

    @Override
    public void a(PacketPlayInRecipeDisplayed packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        CraftingManager.d recipeFromDisplay = this.d.aI().a(packet.b());
        if (recipeFromDisplay != null) {
            this.f.J().d(recipeFromDisplay.b().a());
        }
    }

    @Override
    public void a(ServerboundSelectBundleItemPacket packet) {
        this.f.cd.a(packet.b(), packet.e());
    }

    @Override
    public void a(PacketPlayInRecipeSettings packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        CraftEventFactory.callRecipeBookSettingsEvent(this.f, packet.b(), packet.e(), packet.f());
        this.f.J().a(packet.b(), packet.e(), packet.f());
    }

    @Override
    public void a(PacketPlayInAdvancements packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (packet.e() == PacketPlayInAdvancements.Status.a) {
            MinecraftKey resourceLocation = Objects.requireNonNull(packet.f());
            AdvancementHolder advancementHolder = this.d.aD().a(resourceLocation);
            if (advancementHolder != null) {
                this.f.S().a(advancementHolder);
            }
        }
    }

    @Override
    public void a(PacketPlayInTabComplete packet) {
        int index;
        if (!(this.tabSpamThrottler.isIncrementAndUnderThreshold() || this.d.ag().f(this.f.gh()) || this.d.a(this.f.gh()))) {
            this.disconnectAsync(IChatBaseComponent.c("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
            return;
        }
        if (SpigotConfig.tabComplete < 0) {
            return;
        }
        if (packet.e().length() > 64 && ((index = packet.e().indexOf(32)) == -1 || index >= 64)) {
            this.disconnectAsync(IChatBaseComponent.c("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
            return;
        }
        TAB_COMPLETE_EXECUTOR.execute(() -> this.handleCustomCommandSuggestions0(packet));
    }

    private void handleCustomCommandSuggestions0(PacketPlayInTabComplete packet) {
        Object completions;
        StringReader stringReader = new StringReader(packet.e());
        if (stringReader.canRead() && stringReader.peek() == '/') {
            stringReader.skip();
        }
        AsyncTabCompleteEvent event = new AsyncTabCompleteEvent((CommandSender)this.getCraftPlayer(), packet.e(), true, null);
        event.callEvent();
        Object object = completions = event.isCancelled() ? ImmutableList.of() : event.completions();
        if (!event.isHandled()) {
            if (event.isCancelled()) {
                return;
            }
            this.d.scheduleOnMain(() -> this.sendServerSuggestions(packet, stringReader));
        } else if (!completions.isEmpty()) {
            SuggestionsBuilder builder0 = new SuggestionsBuilder(packet.e(), stringReader.getTotalLength());
            SuggestionsBuilder builder = builder0.createOffset(builder0.getInput().lastIndexOf(32) + 1);
            Iterator iterator = completions.iterator();
            while (iterator.hasNext()) {
                AsyncTabCompleteEvent.Completion completion = (AsyncTabCompleteEvent.Completion)iterator.next();
                Integer intSuggestion = Ints.tryParse((String)completion.suggestion());
                if (intSuggestion != null) {
                    builder.suggest(intSuggestion.intValue(), (Message)PaperAdventure.asVanilla(completion.tooltip()));
                    continue;
                }
                builder.suggest(completion.suggestion(), (Message)PaperAdventure.asVanilla(completion.tooltip()));
            }
            Suggestions suggestions = (Suggestions)builder.buildFuture().join();
            AsyncPlayerSendSuggestionsEvent suggestEvent = new AsyncPlayerSendSuggestionsEvent((Player)this.getCraftPlayer(), suggestions, packet.e());
            suggestEvent.setCancelled(suggestions.isEmpty());
            if (suggestEvent.callEvent()) {
                this.e.a(new PacketPlayOutTabComplete(packet.b(), PlayerConnection.limitTo(suggestEvent.getSuggestions(), 1000)));
            }
        }
    }

    private static Suggestions limitTo(Suggestions suggestions, int size) {
        return suggestions.getList().size() <= size ? suggestions : new Suggestions(suggestions.getRange(), suggestions.getList().subList(0, size));
    }

    private void sendServerSuggestions(PacketPlayInTabComplete packet, StringReader stringReader) {
        ParseResults<CommandListenerWrapper> parseResults = this.d.aG().a().parse(stringReader, this.f.A());
        if (!parseResults.getExceptions().isEmpty() && parseResults.getExceptions().values().stream().anyMatch(e2 -> e2 instanceof TagParseCommandSyntaxException)) {
            this.disconnect(IChatBaseComponent.c("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
            return;
        }
        this.d.aG().a().getCompletionSuggestions(parseResults).thenAccept(suggestions -> {
            if (!SpigotConfig.sendNamespaced && suggestions.getRange().getStart() <= 1) {
                suggestions.getList().removeIf(suggestion -> suggestion.getText().contains(":"));
            }
            AsyncPlayerSendSuggestionsEvent suggestEvent = new AsyncPlayerSendSuggestionsEvent((Player)this.getCraftPlayer(), suggestions, packet.e());
            suggestEvent.setCancelled(suggestions.isEmpty());
            if (suggestEvent.callEvent()) {
                this.b(new PacketPlayOutTabComplete(packet.b(), PlayerConnection.limitTo(suggestEvent.getSuggestions(), 1000)));
            }
        });
    }

    @Override
    public void a(PacketPlayInSetCommandBlock packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (!this.d.q()) {
            this.f.a(IChatBaseComponent.c("advMode.notEnabled"));
        } else if (!(this.f.gG() || this.f.b() && this.f.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            this.f.a(IChatBaseComponent.c("advMode.notAllowed"));
        } else {
            CommandBlockListenerAbstract baseCommandBlock = null;
            TileEntityCommand commandBlockEntity = null;
            BlockPosition pos = packet.b();
            TileEntity blockEntity = this.f.dV().c_(pos);
            if (blockEntity instanceof TileEntityCommand) {
                commandBlockEntity = (TileEntityCommand)blockEntity;
                baseCommandBlock = commandBlockEntity.b();
            }
            String command = packet.e();
            boolean isTrackOutput = packet.f();
            if (baseCommandBlock != null) {
                TileEntityCommand.Type mode = commandBlockEntity.s();
                IBlockData blockState = this.f.dV().a_(pos);
                EnumDirection direction = blockState.c(BlockCommand.b);
                IBlockData blockState1 = switch (packet.i()) {
                    case TileEntityCommand.Type.a -> Blocks.lj.m();
                    case TileEntityCommand.Type.b -> Blocks.li.m();
                    default -> Blocks.gi.m();
                };
                IBlockData blockState2 = (IBlockData)((IBlockData)blockState1.b(BlockCommand.b, direction)).b(BlockCommand.c, packet.g());
                if (blockState2 != blockState) {
                    this.f.dV().a(pos, blockState2, 2);
                    blockEntity.c(blockState2);
                    this.f.dV().m(pos).a(blockEntity);
                }
                baseCommandBlock.a(command);
                baseCommandBlock.a(isTrackOutput);
                if (!isTrackOutput) {
                    baseCommandBlock.c(null);
                }
                commandBlockEntity.b(packet.h());
                if (mode != packet.i()) {
                    commandBlockEntity.f();
                }
                baseCommandBlock.f();
                if (!UtilColor.b(command)) {
                    this.f.a(IChatBaseComponent.a("advMode.setCommand.success", new Object[]{command}));
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSetCommandMinecart packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (!this.d.q()) {
            this.f.a(IChatBaseComponent.c("advMode.notEnabled"));
        } else if (!(this.f.gG() || this.f.b() && this.f.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            this.f.a(IChatBaseComponent.c("advMode.notAllowed"));
        } else {
            CommandBlockListenerAbstract commandBlock = packet.a(this.f.dV());
            if (commandBlock != null) {
                commandBlock.a(packet.b());
                commandBlock.a(packet.e());
                if (!packet.e()) {
                    commandBlock.c(null);
                }
                commandBlock.f();
                this.f.a(IChatBaseComponent.a("advMode.setCommand.success", new Object[]{packet.b()}));
            }
        }
    }

    @Override
    public void a(ServerboundPickItemFromBlockPacket packet) {
        boolean flag;
        IBlockData blockState;
        ItemStack cloneItemStack;
        WorldServer serverLevel = this.f.y();
        PlayerConnectionUtils.a(packet, this, serverLevel);
        BlockPosition blockPos = packet.b();
        if (this.f.a(blockPos, 1.0) && serverLevel.p(blockPos) && !(cloneItemStack = (blockState = serverLevel.a_(blockPos)).a((IWorldReader)serverLevel, blockPos, flag = this.f.fV() && packet.e())).f()) {
            if (flag && this.f.getBukkitEntity().hasPermission("minecraft.nbt.copy")) {
                PlayerConnection.a(blockState, serverLevel, blockPos, cloneItemStack);
            }
            this.a(cloneItemStack);
        }
    }

    private static void a(IBlockData state, WorldServer level, BlockPosition pos, ItemStack stack) {
        TileEntity blockEntity;
        TileEntity tileEntity = blockEntity = state.x() ? level.c_(pos) : null;
        if (blockEntity != null) {
            NBTTagCompound compoundTag = blockEntity.e(level.K_());
            blockEntity.a(compoundTag);
            ItemBlock.a(stack, blockEntity.p(), compoundTag);
            stack.b(blockEntity.q());
        }
    }

    @Override
    public void a(ServerboundPickItemFromEntityPacket packet) {
        ItemStack pickResult;
        WorldServer serverLevel = this.f.y();
        PlayerConnectionUtils.a(packet, this, serverLevel);
        net.minecraft.world.entity.Entity entity = serverLevel.a(packet.b());
        if (entity != null && this.f.b(entity, 3.0) && (pickResult = entity.dI()) != null && !pickResult.f()) {
            this.a(pickResult);
        }
    }

    private void a(ItemStack stack) {
        if (stack.a(this.f.dV().K())) {
            PlayerInventory inventory = this.f.gi();
            int i2 = inventory.c(stack);
            int sourceSlot = i2;
            int targetSlot = PlayerInventory.d(sourceSlot) ? sourceSlot : inventory.i();
            CraftPlayer bukkitPlayer = this.f.getBukkitEntity();
            PlayerPickItemEvent event = new PlayerPickItemEvent((Player)bukkitPlayer, targetSlot, sourceSlot);
            if (!event.callEvent()) {
                return;
            }
            i2 = event.getSourceSlot();
            if (i2 != -1) {
                if (PlayerInventory.d(i2) && PlayerInventory.d(event.getTargetSlot())) {
                    inventory.j = event.getTargetSlot();
                } else {
                    inventory.pickSlot(i2, event.getTargetSlot());
                }
            } else if (this.f.fV()) {
                inventory.addAndPickItem(stack, event.getTargetSlot());
            }
            this.f.f.b(new PacketPlayOutHeldItemSlot(inventory.j));
            this.f.cc.d();
        }
    }

    @Override
    public void a(PacketPlayInItemName packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        Container container = this.f.cd;
        if (container instanceof ContainerAnvil) {
            ContainerAnvil anvilMenu = (ContainerAnvil)container;
            if (!anvilMenu.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)anvilMenu);
                return;
            }
            anvilMenu.a(packet.b());
        }
    }

    @Override
    public void a(PacketPlayInBeacon packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        Container container = this.f.cd;
        if (container instanceof ContainerBeacon) {
            ContainerBeacon beaconMenu = (ContainerBeacon)container;
            if (!this.f.cd.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)this.f.cd);
                return;
            }
            beaconMenu.a(packet.b(), packet.e());
        }
    }

    @Override
    public void a(PacketPlayInStruct packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (this.f.gG()) {
            BlockPosition pos = packet.b();
            IBlockData blockState = this.f.dV().a_(pos);
            TileEntity tileEntity = this.f.dV().c_(pos);
            if (tileEntity instanceof TileEntityStructure) {
                TileEntityStructure structureBlockEntity = (TileEntityStructure)tileEntity;
                structureBlockEntity.a(packet.f());
                structureBlockEntity.a(packet.g());
                structureBlockEntity.a(packet.h());
                structureBlockEntity.a(packet.i());
                structureBlockEntity.a(packet.j());
                structureBlockEntity.a(packet.k());
                structureBlockEntity.b(packet.l());
                structureBlockEntity.a(packet.m());
                structureBlockEntity.d(packet.n());
                structureBlockEntity.e(packet.o());
                structureBlockEntity.a(packet.p());
                structureBlockEntity.a(packet.q());
                if (structureBlockEntity.d()) {
                    String structureName = structureBlockEntity.c();
                    if (packet.e() == TileEntityStructure.UpdateType.b) {
                        if (structureBlockEntity.z()) {
                            this.f.a(IChatBaseComponent.a("structure_block.save_success", new Object[]{structureName}), false);
                        } else {
                            this.f.a(IChatBaseComponent.a("structure_block.save_failure", new Object[]{structureName}), false);
                        }
                    } else if (packet.e() == TileEntityStructure.UpdateType.c) {
                        if (!structureBlockEntity.B()) {
                            this.f.a(IChatBaseComponent.a("structure_block.load_not_found", new Object[]{structureName}), false);
                        } else if (structureBlockEntity.a(this.f.y())) {
                            this.f.a(IChatBaseComponent.a("structure_block.load_success", new Object[]{structureName}), false);
                        } else {
                            this.f.a(IChatBaseComponent.a("structure_block.load_prepare", new Object[]{structureName}), false);
                        }
                    } else if (packet.e() == TileEntityStructure.UpdateType.d) {
                        if (structureBlockEntity.y()) {
                            this.f.a(IChatBaseComponent.a("structure_block.size_success", new Object[]{structureName}), false);
                        } else {
                            this.f.a(IChatBaseComponent.c("structure_block.size_failure"), false);
                        }
                    }
                } else {
                    this.f.a(IChatBaseComponent.a("structure_block.invalid_structure_name", new Object[]{packet.g()}), false);
                }
                structureBlockEntity.e();
                this.f.dV().a(pos, blockState, blockState, 3);
            }
        }
    }

    @Override
    public void a(PacketPlayInSetJigsaw packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (this.f.gG()) {
            BlockPosition pos = packet.b();
            IBlockData blockState = this.f.dV().a_(pos);
            TileEntity tileEntity = this.f.dV().c_(pos);
            if (tileEntity instanceof TileEntityJigsaw) {
                TileEntityJigsaw jigsawBlockEntity = (TileEntityJigsaw)tileEntity;
                jigsawBlockEntity.a(packet.e());
                jigsawBlockEntity.b(packet.f());
                jigsawBlockEntity.a(ResourceKey.a(Registries.aX, packet.g()));
                jigsawBlockEntity.a(packet.h());
                jigsawBlockEntity.a(packet.i());
                jigsawBlockEntity.a(packet.k());
                jigsawBlockEntity.b(packet.j());
                jigsawBlockEntity.e();
                this.f.dV().a(pos, blockState, blockState, 3);
            }
        }
    }

    @Override
    public void a(PacketPlayInJigsawGenerate packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (this.f.gG()) {
            BlockPosition pos = packet.b();
            TileEntity tileEntity = this.f.dV().c_(pos);
            if (tileEntity instanceof TileEntityJigsaw) {
                TileEntityJigsaw jigsawBlockEntity = (TileEntityJigsaw)tileEntity;
                jigsawBlockEntity.a(this.f.y(), packet.e(), packet.f());
            }
        }
    }

    @Override
    public void a(PacketPlayInTrSel packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        int item = packet.b();
        Container container = this.f.cd;
        if (container instanceof ContainerMerchant) {
            ContainerMerchant merchantMenu = (ContainerMerchant)container;
            TradeSelectEvent tradeSelectEvent = CraftEventFactory.callTradeSelectEvent(this.f, item, merchantMenu);
            if (tradeSelectEvent.isCancelled()) {
                this.f.cd.b();
                return;
            }
            if (!merchantMenu.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)merchantMenu);
                return;
            }
            merchantMenu.e(item);
            merchantMenu.h(item);
        }
    }

    @Override
    public void a(PacketPlayInBEdit packet) {
        IntOr.Disabled pageMax = GlobalConfiguration.get().itemValidation.bookSize.pageMax;
        if (!this.cserver.isPrimaryThread() && pageMax.enabled()) {
            List<String> pageList = packet.e();
            long byteTotal = 0L;
            int maxBookPageSize = pageMax.intValue();
            double multiplier = Math.clamp(GlobalConfiguration.get().itemValidation.bookSize.totalMultiplier, 0.3, 1.0);
            long byteAllowed = maxBookPageSize;
            for (String page : pageList) {
                int byteLength = page.getBytes(StandardCharsets.UTF_8).length;
                byteTotal += (long)byteLength;
                int length = page.length();
                int multiByteCharacters = 0;
                if (byteLength != length) {
                    for (char c2 : page.toCharArray()) {
                        if (c2 <= '\u007f') continue;
                        ++multiByteCharacters;
                    }
                }
                byteAllowed = (long)((double)byteAllowed + (double)maxBookPageSize * Math.clamp((double)length / 255.0, 0.1, 1.0) * multiplier);
                if (multiByteCharacters <= 1) continue;
                byteAllowed -= (long)multiByteCharacters;
            }
            if (byteTotal > byteAllowed) {
                h.warn("{} tried to send a book too large. Book size: {} - Allowed: {} - Pages: {}", new Object[]{this.f.cI(), byteTotal, byteAllowed, pageList.size()});
                this.disconnectAsync(IChatBaseComponent.b("Book too large!"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
                return;
            }
        }
        if (this.lastBookTick + 20 > MinecraftServer.currentTick) {
            this.disconnectAsync(IChatBaseComponent.b("Book edited too quickly!"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
            return;
        }
        this.lastBookTick = MinecraftServer.currentTick;
        int slot = packet.b();
        if (PlayerInventory.d(slot) || slot == 40) {
            ArrayList list = Lists.newArrayList();
            Optional<String> optional = packet.f();
            optional.ifPresent(list::add);
            list.addAll(packet.e());
            Consumer<List> consumer = optional.isPresent() ? texts -> this.a((FilteredText)texts.get(0), texts.subList(1, texts.size()), slot) : texts -> this.a((List<FilteredText>)texts, slot);
            this.a(list).thenAcceptAsync(consumer, (Executor)this.d);
        }
    }

    private void a(List<FilteredText> pages, int index) {
        ItemStack handItem = this.f.gi().a(index);
        ItemStack item = handItem.v();
        if (item.b(DataComponents.S)) {
            List<Filterable<String>> list = pages.stream().map(this::a).toList();
            item.b(DataComponents.S, new WritableBookContent(list));
            this.f.gi().a(index, CraftEventFactory.handleEditBookEvent(this.f, index, handItem, item));
        }
    }

    private void a(FilteredText title, List<FilteredText> pages, int index) {
        ItemStack item = this.f.gi().a(index);
        if (item.b(DataComponents.S)) {
            ItemStack itemStack = item.a((IMaterial)Items.uY);
            itemStack.d(DataComponents.S);
            List<Filterable<IChatBaseComponent>> list = pages.stream().map(filteredText -> this.a((FilteredText)filteredText).a(IChatBaseComponent::b)).toList();
            itemStack.b(DataComponents.T, new WrittenBookContent(this.a(title), this.f.al().getString(), 0, list, true));
            CraftEventFactory.handleEditBookEvent(this.f, index, item, itemStack);
            this.f.gi().a(index, item);
        }
    }

    private Filterable<String> a(FilteredText filteredText) {
        return this.f.aa() ? Filterable.a(filteredText.b()) : Filterable.a(filteredText);
    }

    @Override
    public void a(PacketPlayInEntityNBTQuery packet) {
        net.minecraft.world.entity.Entity entity;
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (this.f.s(2) && (entity = this.f.dV().a(packet.e())) != null) {
            NBTTagCompound compoundTag = entity.f(new NBTTagCompound());
            this.f.f.b(new PacketPlayOutNBTQuery(packet.b(), compoundTag));
        }
    }

    @Override
    public void a(ServerboundContainerSlotStateChangedPacket packet) {
        CrafterMenu crafterMenu;
        Object object;
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (!this.f.Z_() && packet.e() == this.f.cd.l && (object = this.f.cd) instanceof CrafterMenu && (object = (crafterMenu = (CrafterMenu)object).m()) instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterBlockEntity = (CrafterBlockEntity)object;
            crafterBlockEntity.a(packet.b(), packet.f());
        }
    }

    @Override
    public void a(PacketPlayInTileNBTQuery packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (this.f.s(2)) {
            TileEntity blockEntity = this.f.dV().c_(packet.e());
            NBTTagCompound compoundTag = blockEntity != null ? blockEntity.d(this.f.dX()) : null;
            this.f.f.b(new PacketPlayOutNBTQuery(packet.b(), compoundTag));
        }
    }

    @Override
    public void a(PacketPlayInFlying packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (PlayerConnection.b(packet.a(0.0), packet.b(0.0), packet.c(0.0), packet.a(0.0f), packet.b(0.0f))) {
            this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.invalid_player_movement"), PlayerKickEvent.Cause.INVALID_PLAYER_MOVEMENT);
        } else {
            WorldServer serverLevel = this.f.y();
            if (!this.f.k && !this.f.fi()) {
                if (this.o == 0) {
                    this.l();
                }
                if (!this.p() && this.f.gJ()) {
                    float f1;
                    float f2;
                    double d2;
                    double d1;
                    double d3;
                    double toX = d3 = PlayerConnection.a(packet.a(this.f.dA()));
                    double toY = d1 = PlayerConnection.b(packet.b(this.f.dC()));
                    double toZ = d2 = PlayerConnection.a(packet.c(this.f.dG()));
                    float toYaw = f2 = MathHelper.h(packet.a(this.f.dL()));
                    float toPitch = f1 = MathHelper.h(packet.b(this.f.dN()));
                    if (this.f.bZ()) {
                        this.f.a(this.f.dA(), this.f.dC(), this.f.dG(), f2, f1);
                        this.f.y().m().a(this.f);
                        this.allowedPlayerTicks = 20;
                    } else {
                        double prevX = this.f.dA();
                        double prevY = this.f.dC();
                        double prevZ = this.f.dG();
                        float prevYaw = this.f.dL();
                        float prevPitch = this.f.dN();
                        double x2 = this.f.dA();
                        double y2 = this.f.dC();
                        double z2 = this.f.dG();
                        double d32 = d3 - this.s;
                        double d4 = d1 - this.t;
                        double d5 = d2 - this.u;
                        double d6 = this.f.dy().h();
                        double d7 = d32 * d32 + d4 * d4 + d5 * d5;
                        double currDeltaX = toX - prevX;
                        double currDeltaY = toY - prevY;
                        double currDeltaZ = toZ - prevZ;
                        d7 = Math.max(d7, currDeltaX * currDeltaX + currDeltaY * currDeltaY + currDeltaZ * currDeltaZ - 1.0);
                        double otherFieldX = d3 - this.v;
                        double otherFieldY = d1 - this.w;
                        double otherFieldZ = d2 - this.x;
                        d7 = Math.max(d7, otherFieldX * otherFieldX + otherFieldY * otherFieldY + otherFieldZ * otherFieldZ - 1.0);
                        if (this.f.fR()) {
                            if (d7 > 1.0) {
                                this.a(this.f.dA(), this.f.dC(), this.f.dG(), f2, f1);
                            }
                        } else {
                            PlayerFailMoveEvent event;
                            PlayerFailMoveEvent event2;
                            boolean didCollide;
                            boolean flag;
                            boolean isFallFlying = this.f.fJ();
                            if (serverLevel.u().i()) {
                                PlayerFailMoveEvent event3;
                                ++this.M;
                                int i2 = this.M - this.N;
                                this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                                this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                                this.lastTick = (int)(System.currentTimeMillis() / 50L);
                                if (i2 > Math.max(this.allowedPlayerTicks, 5)) {
                                    h.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.f.al().getString(), (Object)i2);
                                    i2 = 1;
                                }
                                this.allowedPlayerTicks = packet.i || d7 > 0.0 ? --this.allowedPlayerTicks : 20;
                                double speed = this.f.gj().b ? (double)(this.f.gj().f * 20.0f) : (double)(this.f.gj().g * 10.0f);
                                if (!(!this.f.dV().paperConfig().chunks.preventMovingIntoUnloadedChunks || this.f.dA() == toX && this.f.dG() == toZ || serverLevel.areChunksLoadedForMove(this.f.cR().b(new Vec3D(toX, toY, toZ).d(this.f.dt()))) || (event3 = this.fireFailMove(PlayerFailMoveEvent.FailReason.MOVED_INTO_UNLOADED_CHUNK, toX, toY, toZ, toYaw, toPitch, false)).isAllowed())) {
                                    this.internalTeleport(PositionMoveRotation.a(this.f), Collections.emptySet());
                                    return;
                                }
                                if (this.a(isFallFlying)) {
                                    PlayerFailMoveEvent event4;
                                    float f22;
                                    float f3 = f22 = isFallFlying ? 300.0f : 100.0f;
                                    if (d7 - d6 > Math.max((double)f22, MathHelper.k(SpigotConfig.movedTooQuicklyMultiplier * (double)i2 * speed)) && !(event4 = this.fireFailMove(PlayerFailMoveEvent.FailReason.MOVED_TOO_QUICKLY, toX, toY, toZ, toYaw, toPitch, true)).isAllowed()) {
                                        if (event4.getLogWarning()) {
                                            h.warn("{} moved too quickly! {},{},{}", new Object[]{this.f.al().getString(), d32, d4, d5});
                                        }
                                        this.a(this.f.dA(), this.f.dC(), this.f.dG(), this.f.dL(), this.f.dN());
                                        return;
                                    }
                                }
                            }
                            AxisAlignedBB boundingBox = this.f.cR();
                            d32 = d3 - this.v;
                            d4 = d1 - this.w;
                            d5 = d2 - this.x;
                            boolean bl = flag = d4 > 0.0;
                            if (this.f.aJ() && !packet.b() && flag) {
                                PlayerJumpEvent event5;
                                CraftPlayer player = this.getCraftPlayer();
                                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                Location to = player.getLocation().clone();
                                if (packet.h) {
                                    to.setX(packet.a);
                                    to.setY(packet.b);
                                    to.setZ(packet.c);
                                }
                                if (packet.i) {
                                    to.setYaw(packet.d);
                                    to.setPitch(packet.e);
                                }
                                if ((event5 = new PlayerJumpEvent((Player)player, from, to)).callEvent()) {
                                    this.f.s();
                                } else {
                                    from = event5.getFrom();
                                    this.internalTeleport(new PositionMoveRotation(CraftLocation.toVec3D(from), Vec3D.c, from.getYaw(), from.getPitch()), Collections.emptySet());
                                    return;
                                }
                            }
                            boolean flag1 = this.f.R;
                            this.f.a(EnumMoveType.b, new Vec3D(d32, d4, d5));
                            ((net.minecraft.world.entity.Entity)this.f).aD = packet.b();
                            boolean bl2 = didCollide = toX != this.f.dA() || toY != this.f.dC() || toZ != this.f.dG();
                            if (this.F != null) {
                                return;
                            }
                            double verticalDelta = d4;
                            d32 = d3 - this.f.dA();
                            d4 = d1 - this.f.dC();
                            if (d4 > -0.5 || d4 < 0.5) {
                                d4 = 0.0;
                            }
                            d5 = d2 - this.f.dG();
                            d7 = d32 * d32 + d4 * d4 + d5 * d5;
                            boolean movedWrongly = false;
                            if (!(this.f.Q() || !(d7 > SpigotConfig.movedWronglyThreshold) || this.f.fR() || this.f.h.e() || this.f.h.b() == EnumGamemode.d || (event2 = this.fireFailMove(PlayerFailMoveEvent.FailReason.MOVED_WRONGLY, toX, toY, toZ, toYaw, toPitch, true)).isAllowed())) {
                                movedWrongly = true;
                                if (event2.getLogWarning()) {
                                    h.warn("{} moved wrongly!", (Object)this.f.al().getString());
                                }
                            }
                            boolean teleportBack = !this.f.ad && !this.f.fR() && movedWrongly;
                            this.f.a(d3, d1, d2, f2, f1);
                            if (!(this.f.ad || this.f.fR() || teleportBack)) {
                                AxisAlignedBB newBox = this.f.cR();
                                if (didCollide || !boundingBox.equals(newBox)) {
                                    teleportBack = this.hasNewCollision(serverLevel, this.f, boundingBox, newBox);
                                }
                            }
                            if (teleportBack && (event = this.fireFailMove(PlayerFailMoveEvent.FailReason.CLIPPED_INTO_BLOCK, toX, toY, toZ, toYaw, toPitch, false)).isAllowed()) {
                                teleportBack = false;
                            }
                            if (!teleportBack) {
                                this.f.a(prevX, prevY, prevZ, prevYaw, prevPitch);
                                CraftPlayer player = this.getCraftPlayer();
                                if (!this.hasMoved) {
                                    this.lastPosX = prevX;
                                    this.lastPosY = prevY;
                                    this.lastPosZ = prevZ;
                                    this.lastYaw = prevYaw;
                                    this.lastPitch = prevPitch;
                                    this.hasMoved = true;
                                }
                                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                Location to = player.getLocation().clone();
                                if (packet.h) {
                                    to.setX(packet.a);
                                    to.setY(packet.b);
                                    to.setZ(packet.c);
                                }
                                if (packet.i) {
                                    to.setYaw(packet.d);
                                    to.setPitch(packet.e);
                                }
                                double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.f.fi()) {
                                    this.lastPosX = to.getX();
                                    this.lastPosY = to.getY();
                                    this.lastPosZ = to.getZ();
                                    this.lastYaw = to.getYaw();
                                    this.lastPitch = to.getPitch();
                                    Location oldTo = to.clone();
                                    PlayerMoveEvent event6 = new PlayerMoveEvent((Player)player, from, to);
                                    this.cserver.getPluginManager().callEvent((Event)event6);
                                    if (event6.isCancelled()) {
                                        this.teleport(from);
                                        return;
                                    }
                                    if (!oldTo.equals((Object)event6.getTo()) && !event6.isCancelled()) {
                                        this.f.getBukkitEntity().teleport(event6.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                                        return;
                                    }
                                    if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                                        this.justTeleported = false;
                                        return;
                                    }
                                }
                                this.f.a(d3, d1, d2, f2, f1);
                                boolean isAutoSpinAttack = this.f.fv();
                                this.I = verticalDelta >= -0.03125 && !flag1 && this.f.h.b() != EnumGamemode.d && !this.d.ad() && !this.f.gj().c && !this.f.b(MobEffects.y) && !isFallFlying && !isAutoSpinAttack && this.b(this.f);
                                this.f.y().m().a(this.f);
                                Vec3D vec3 = new Vec3D(this.f.dA() - x2, this.f.dC() - y2, this.f.dG() - z2);
                                this.f.a(packet.b(), packet.e(), vec3);
                                this.f.a(vec3.d, vec3.e, vec3.f, packet.b());
                                if (!this.f.Z_() && this.f.aL()) {
                                    this.f.b(new Vec3D(x2, y2, z2), this.f.dt());
                                }
                                this.a(vec3);
                                if (flag) {
                                    this.f.k();
                                }
                                if (packet.b() || this.f.ef() || this.f.q_() || this.f.Z_() || isFallFlying || isAutoSpinAttack) {
                                    this.f.gO();
                                }
                                this.f.b(this.f.dA() - x2, this.f.dC() - y2, this.f.dG() - z2);
                                this.v = this.f.dA();
                                this.w = this.f.dC();
                                this.x = this.f.dG();
                            } else {
                                this.internalTeleport(x2, y2, z2, f2, f1);
                                this.f.a(this.f.dA() - x2, this.f.dC() - y2, this.f.dG() - z2, packet.b());
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean a(boolean isElytraMovement) {
        if (this.h()) {
            return false;
        }
        if (this.f.Q()) {
            return false;
        }
        GameRules gameRules = this.f.y().O();
        return !gameRules.b(GameRules.t) && (!isElytraMovement || !gameRules.b(GameRules.u));
    }

    private boolean p() {
        if (this.F != null) {
            this.allowedPlayerTicks = 20;
            return true;
        }
        this.H = this.o;
        return false;
    }

    private boolean hasNewCollision(WorldServer level, net.minecraft.world.entity.Entity entity, AxisAlignedBB oldBox, AxisAlignedBB newBox) {
        int i2;
        ArrayList<AxisAlignedBB> collisionsBB = new ArrayList<AxisAlignedBB>();
        ArrayList<VoxelShape> collisionsVoxel = new ArrayList<VoxelShape>();
        CollisionUtil.getCollisions(level, entity, newBox, collisionsVoxel, collisionsBB, 6, null, null);
        int len = collisionsBB.size();
        for (i2 = 0; i2 < len; ++i2) {
            AxisAlignedBB box = (AxisAlignedBB)collisionsBB.get(i2);
            if (CollisionUtil.voxelShapeIntersect(box, oldBox)) continue;
            return true;
        }
        len = collisionsVoxel.size();
        for (i2 = 0; i2 < len; ++i2) {
            VoxelShape voxel = (VoxelShape)collisionsVoxel.get(i2);
            if (CollisionUtil.voxelShapeIntersectNoEmpty(voxel, oldBox)) continue;
            return true;
        }
        return false;
    }

    private boolean a(IWorldReader level, AxisAlignedBB box, double x2, double y2, double z2) {
        AxisAlignedBB aabb = this.f.cR().d(x2 - this.f.dA(), y2 - this.f.dC(), z2 - this.f.dG());
        Iterable<VoxelShape> collisions = level.d(this.f, aabb.h(1.0E-5f));
        VoxelShape voxelShape = VoxelShapes.a(box.h(1.0E-5f));
        for (VoxelShape voxelShape1 : collisions) {
            if (VoxelShapes.c(voxelShape1, voxelShape, OperatorBoolean.i)) continue;
            return true;
        }
        return false;
    }

    public void a(double x2, double y2, double z2, float yaw, float pitch) {
        this.teleport(x2, y2, z2, yaw, pitch, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(double d0, double d1, double d2, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(new PositionMoveRotation(new Vec3D(d0, d1, d2), Vec3D.c, f2, f1), Collections.emptySet(), cause);
    }

    public void a(PositionMoveRotation posMoveRotation, Set<Relative> relatives) {
        this.teleport(posMoveRotation, relatives, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(PositionMoveRotation posMoveRotation, Set<Relative> relatives, PlayerTeleportEvent.TeleportCause cause) {
        PositionMoveRotation absolutePosition;
        Location to;
        CraftPlayer player = this.getCraftPlayer();
        Location from = player.getLocation();
        if (from.equals((Object)(to = CraftLocation.toBukkit((absolutePosition = PositionMoveRotation.a(PositionMoveRotation.a(this.f), posMoveRotation, relatives)).a(), this.getCraftPlayer().getWorld(), absolutePosition.c(), absolutePosition.d())))) {
            this.internalTeleport(posMoveRotation, relatives);
            return true;
        }
        EnumSet<TeleportFlag.Relative> relativeFlags = EnumSet.noneOf(TeleportFlag.Relative.class);
        for (Relative relativeArgument : relatives) {
            TeleportFlag.Relative flag = CraftPlayer.deltaRelativeToAPI(relativeArgument);
            if (flag == null) continue;
            relativeFlags.add(flag);
        }
        PlayerTeleportEvent event = new PlayerTeleportEvent((Player)player, from.clone(), to.clone(), cause, Set.copyOf(relativeFlags));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || !to.equals((Object)event.getTo())) {
            to = event.isCancelled() ? event.getFrom() : event.getTo();
            posMoveRotation = new PositionMoveRotation(CraftLocation.toVec3D(to), Vec3D.c, to.getYaw(), to.getPitch());
        }
        this.internalTeleport(posMoveRotation, relatives);
        return !event.isCancelled();
    }

    public void teleport(Location dest) {
        this.internalTeleport(dest.getX(), dest.getY(), dest.getZ(), dest.getYaw(), dest.getPitch());
    }

    private void internalTeleport(double d0, double d1, double d2, float f2, float f1) {
        this.internalTeleport(new PositionMoveRotation(new Vec3D(d0, d1, d2), Vec3D.c, f2, f1), Collections.emptySet());
    }

    public void internalTeleport(PositionMoveRotation posMoveRotation, Set<Relative> relatives) {
        AsyncCatcher.catchOp("teleport");
        if (this.f.dQ()) {
            h.info("Attempt to teleport removed player {} restricted", (Object)this.f.cI());
            if (this.d.isDebugging()) {
                TraceUtil.dumpTraceForThread("Attempt to teleport removed player");
            }
            return;
        }
        if (Float.isNaN(posMoveRotation.c())) {
            posMoveRotation = new PositionMoveRotation(posMoveRotation.a(), posMoveRotation.b(), 0.0f, posMoveRotation.d());
        }
        if (Float.isNaN(posMoveRotation.d())) {
            posMoveRotation = new PositionMoveRotation(posMoveRotation.a(), posMoveRotation.b(), posMoveRotation.c(), 0.0f);
        }
        this.justTeleported = true;
        this.H = this.o;
        if (++this.G == Integer.MAX_VALUE) {
            this.G = 0;
        }
        this.f.a(posMoveRotation, relatives);
        this.F = this.f.dt();
        this.lastPosX = this.F.d;
        this.lastPosY = this.F.e;
        this.lastPosZ = this.F.f;
        this.lastYaw = this.f.dL();
        this.lastPitch = this.f.dN();
        this.f.f.b(PacketPlayOutPosition.a(this.G, posMoveRotation, relatives));
    }

    @Override
    public void a(PacketPlayInBlockDig packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (this.f.fi()) {
            return;
        }
        if (this.f.gJ()) {
            BlockPosition pos = packet.b();
            this.f.H();
            PacketPlayInBlockDig.EnumPlayerDigType action = packet.f();
            switch (action) {
                case g: {
                    if (!this.f.Z_()) {
                        ItemStack itemInHand = this.f.b(EnumHand.b);
                        CraftItemStack mainHand = CraftItemStack.asCraftMirror(itemInHand);
                        CraftItemStack offHand = CraftItemStack.asCraftMirror(this.f.b(EnumHand.a));
                        PlayerSwapHandItemsEvent swapItemsEvent = new PlayerSwapHandItemsEvent((Player)this.getCraftPlayer(), (org.bukkit.inventory.ItemStack)mainHand.clone(), (org.bukkit.inventory.ItemStack)offHand.clone());
                        this.cserver.getPluginManager().callEvent((Event)swapItemsEvent);
                        if (swapItemsEvent.isCancelled()) {
                            return;
                        }
                        if (swapItemsEvent.getOffHandItem().equals((Object)offHand)) {
                            this.f.a(EnumHand.b, this.f.b(EnumHand.a));
                        } else {
                            this.f.a(EnumHand.b, CraftItemStack.asNMSCopy(swapItemsEvent.getOffHandItem()));
                        }
                        if (swapItemsEvent.getMainHandItem().equals((Object)mainHand)) {
                            this.f.a(EnumHand.a, itemInHand);
                        } else {
                            this.f.a(EnumHand.a, CraftItemStack.asNMSCopy(swapItemsEvent.getMainHandItem()));
                        }
                        this.f.fF();
                    }
                    return;
                }
                case e: {
                    if (!this.f.Z_()) {
                        if (this.lastDropTick != MinecraftServer.currentTick) {
                            this.dropCount = 0;
                            this.lastDropTick = MinecraftServer.currentTick;
                        } else {
                            ++this.dropCount;
                            if (this.dropCount >= 20) {
                                h.warn(this.f.cI() + " dropped their items too quickly!");
                                this.disconnect(IChatBaseComponent.b("You dropped your items too quickly (Hacking?)"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
                                return;
                            }
                        }
                        this.f.a(false);
                    }
                    return;
                }
                case d: {
                    if (!this.f.Z_()) {
                        this.f.a(true);
                    }
                    return;
                }
                case f: {
                    if (this.f.fB() == this.f.b(this.f.fA())) {
                        this.f.fE();
                    }
                    return;
                }
                case a: 
                case b: 
                case c: {
                    if (this.f.dV().getChunkIfLoadedImmediately(pos.u() >> 4, pos.w() >> 4) == null) {
                        this.f.f.a(packet.g());
                        return;
                    }
                    this.f.h.capturedBlockEntity = false;
                    this.f.h.captureSentBlockEntities = true;
                    this.f.h.a(pos, action, packet.e(), this.f.dV().an(), packet.g());
                    this.f.f.a(packet.g());
                    this.f.h.captureSentBlockEntities = false;
                    if (this.f.h.capturedBlockEntity) {
                        this.b(new ClientboundBlockChangedAckPacket(this.p));
                        this.f.f.p = -1;
                        this.f.h.capturedBlockEntity = false;
                        TileEntity blockEntity = this.f.dV().c_(pos);
                        if (blockEntity != null) {
                            this.f.f.b(blockEntity.ax_());
                        }
                    }
                    return;
                }
            }
            throw new IllegalArgumentException("Invalid player action");
        }
    }

    private static boolean a(EntityPlayer player, ItemStack stack) {
        if (stack.f()) {
            return false;
        }
        Item item = stack.h();
        return (item instanceof ItemBlock || item instanceof ItemBucket) && !player.gE().a(stack);
    }

    private static int getSpamThreshold() {
        return GlobalConfiguration.get().spamLimiter.incomingPacketThreshold;
    }

    private boolean checkLimit(long timestamp) {
        if (this.lastLimitedPacket != -1L && timestamp - this.lastLimitedPacket < (long)PlayerConnection.getSpamThreshold() && this.limitedPackets++ >= 8) {
            return false;
        }
        if (this.lastLimitedPacket == -1L || timestamp - this.lastLimitedPacket >= (long)PlayerConnection.getSpamThreshold()) {
            this.lastLimitedPacket = timestamp;
            this.limitedPackets = 0;
            return true;
        }
        return true;
    }

    @Override
    public void a(PacketPlayInUseItem packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (this.f.fi()) {
            return;
        }
        if (!this.checkLimit(packet.timestamp)) {
            return;
        }
        if (this.f.gJ()) {
            this.f.f.a(packet.f());
            WorldServer serverLevel = this.f.y();
            EnumHand hand = packet.b();
            ItemStack itemInHand = this.f.b(hand);
            if (itemInHand.a(serverLevel.K())) {
                MovingObjectPositionBlock hitResult = packet.e();
                Vec3D location = hitResult.g();
                if (!(Double.isFinite(location.a()) && Double.isFinite(location.b()) && Double.isFinite(location.c()))) {
                    return;
                }
                BlockPosition blockPos = hitResult.b();
                if (this.f.a(blockPos, 1.0)) {
                    Vec3D vec3 = location.d(Vec3D.b(blockPos));
                    double d2 = 1.0000001;
                    if (Math.abs(vec3.a()) < 1.0000001 && Math.abs(vec3.b()) < 1.0000001 && Math.abs(vec3.c()) < 1.0000001) {
                        EnumDirection direction = hitResult.c();
                        this.f.H();
                        int maxY = this.f.dV().an();
                        if (blockPos.v() <= maxY) {
                            if (this.F == null && (serverLevel.a((EntityHuman)this.f, blockPos) || serverLevel.paperConfig().spawn.allowUsingSignsInsideSpawnProtection && serverLevel.a_(blockPos).b() instanceof BlockSign)) {
                                EnumInteractionResult.d success;
                                this.f.fF();
                                EnumInteractionResult interactionResult = this.f.h.a(this.f, serverLevel, itemInHand, hand, hitResult);
                                if (interactionResult.a()) {
                                    CriterionTriggers.P.a(this.f, hitResult.b(), itemInHand.v());
                                }
                                if (direction == EnumDirection.b && !interactionResult.a() && blockPos.v() >= maxY && PlayerConnection.a(this.f, itemInHand)) {
                                    IChatMutableComponent component = IChatBaseComponent.a("build.tooHigh", maxY).a(EnumChatFormat.m);
                                    this.f.b(component, true);
                                } else if (interactionResult instanceof EnumInteractionResult.d && (success = (EnumInteractionResult.d)interactionResult).e() == EnumInteractionResult.e.c && !this.f.h.interactResult) {
                                    this.f.a(hand, true);
                                }
                            } else {
                                this.f.cd.b();
                            }
                        } else {
                            IChatMutableComponent component1 = IChatBaseComponent.a("build.tooHigh", maxY).a(EnumChatFormat.m);
                            this.f.b(component1, true);
                        }
                        this.f.f.b(new PacketPlayOutBlockChange(serverLevel, blockPos));
                        this.f.f.b(new PacketPlayOutBlockChange(serverLevel, blockPos.a(direction)));
                    } else {
                        h.warn("Rejecting UseItemOnPacket from {}: Location {} too far away from hit block {}.", new Object[]{this.f.gh().getName(), location, blockPos});
                    }
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInBlockPlace packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (this.f.fi()) {
            return;
        }
        if (!this.checkLimit(packet.timestamp)) {
            return;
        }
        if (this.f.gJ()) {
            this.a(packet.e());
            WorldServer serverLevel = this.f.y();
            EnumHand hand = packet.b();
            ItemStack itemInHand = this.f.b(hand);
            this.f.H();
            if (!itemInHand.f() && itemInHand.a(serverLevel.K())) {
                EnumInteractionResult.d success;
                boolean cancelled;
                float f2 = MathHelper.h(packet.f());
                float f1 = MathHelper.h(packet.g());
                if (f1 != this.f.dN() || f2 != this.f.dL()) {
                    this.f.c(f2, f1);
                }
                double x2 = this.f.dA();
                double eyeY = this.f.dE();
                double z2 = this.f.dG();
                Vec3D from = new Vec3D(x2, eyeY, z2);
                float f3 = MathHelper.b(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
                float f4 = MathHelper.a(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
                float f5 = -MathHelper.b(-f1 * ((float)Math.PI / 180));
                float f6 = MathHelper.a(-f1 * ((float)Math.PI / 180));
                float f7 = f4 * f5;
                float f8 = f3 * f5;
                double d3 = this.f.gL();
                Vec3D to = from.b((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
                MovingObjectPositionBlock hitResult = this.f.dV().a(new RayTrace(from, to, RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, this.f));
                if (hitResult == null || hitResult.d() != MovingObjectPosition.EnumMovingObjectType.b) {
                    event = CraftEventFactory.callPlayerInteractEvent(this.f, Action.RIGHT_CLICK_AIR, itemInHand, hand);
                    cancelled = event.useItemInHand() == Event.Result.DENY;
                } else {
                    cancelled = this.f.h.firedInteract && this.f.h.interactPosition.equals(hitResult.b()) && this.f.h.interactHand == hand && ItemStack.c(this.f.h.interactItemStack, itemInHand) ? this.f.h.interactResult : (event = CraftEventFactory.callPlayerInteractEvent(this.f, Action.RIGHT_CLICK_BLOCK, hitResult.b(), hitResult.c(), itemInHand, true, hand, hitResult.g())).useItemInHand() == Event.Result.DENY;
                    this.f.h.firedInteract = false;
                }
                if (cancelled) {
                    this.f.resyncUsingItem(this.f);
                    this.f.cd.b();
                    return;
                }
                itemInHand = this.f.b(hand);
                if (itemInHand.f()) {
                    return;
                }
                EnumInteractionResult enumInteractionResult = this.f.h.a(this.f, serverLevel, itemInHand, hand);
                if (enumInteractionResult instanceof EnumInteractionResult.d && (success = (EnumInteractionResult.d)enumInteractionResult).e() == EnumInteractionResult.e.c) {
                    this.f.a(hand, true);
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSpectate packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (this.f.Z_()) {
            for (WorldServer serverLevel : this.d.L()) {
                net.minecraft.world.entity.Entity entity = packet.a(serverLevel);
                if (entity == null) continue;
                this.f.teleportTo(serverLevel, entity.dA(), entity.dC(), entity.dG(), Set.of(), entity.dL(), entity.dN(), true, PlayerTeleportEvent.TeleportCause.SPECTATE);
                return;
            }
        }
    }

    @Override
    public void a(PacketPlayInBoatMove packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        net.minecraft.world.entity.Entity entity = this.f.dl();
        if (entity instanceof AbstractBoat) {
            AbstractBoat abstractBoat = (AbstractBoat)entity;
            abstractBoat.a(packet.b(), packet.e());
        }
    }

    @Override
    public void a(DisconnectionDetails details) {
        this.onDisconnect(details, null);
    }

    @Override
    public void onDisconnect(DisconnectionDetails details, @Nullable Component quitMessage) {
        if (this.processedDisconnect) {
            return;
        }
        this.processedDisconnect = true;
        h.info("{} lost connection: {}", (Object)this.f.al().getString(), (Object)details.a().getString());
        this.removePlayerFromWorld(quitMessage);
        super.onDisconnect(details, quitMessage);
    }

    private void q() {
        this.removePlayerFromWorld(null);
    }

    private void removePlayerFromWorld(@Nullable Component quitMessage) {
        this.T.close();
        this.f.t();
        Component component = quitMessage = quitMessage == null ? this.d.ag().remove(this.f) : this.d.ag().remove(this.f, quitMessage);
        if (quitMessage != null && !quitMessage.equals((Object)Component.empty())) {
            this.d.ag().a(PaperAdventure.asVanilla(quitMessage), false);
        }
        this.f.Z().b();
    }

    public void a(int sequence) {
        if (sequence < 0) {
            this.disconnect(IChatBaseComponent.b("Expected packet sequence nr >= 0"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
            throw new IllegalArgumentException("Expected packet sequence nr >= 0");
        }
        this.p = Math.max(sequence, this.p);
    }

    @Override
    public void a(PacketPlayInHeldItemSlot packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (this.f.fi()) {
            return;
        }
        if (packet.b() >= 0 && packet.b() < PlayerInventory.g()) {
            if (packet.b() == this.f.gi().j) {
                return;
            }
            PlayerItemHeldEvent event = new PlayerItemHeldEvent((Player)this.getCraftPlayer(), this.f.gi().j, packet.b());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                this.b(new PacketPlayOutHeldItemSlot(this.f.gi().j));
                this.f.H();
                return;
            }
            if (this.f.gi().j != packet.b() && this.f.fA() == EnumHand.a) {
                this.f.fF();
            }
            this.f.gi().j = packet.b();
            this.f.H();
        } else {
            h.warn("{} tried to set an invalid carried item", (Object)this.f.al().getString());
            this.disconnect(IChatBaseComponent.b("Invalid hotbar selection (Hacking?)"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
        }
    }

    @Override
    public void a(PacketPlayInChat packet) {
        if (this.d.af()) {
            return;
        }
        Optional<LastSeenMessages> optional = this.a(packet.h());
        if (!optional.isEmpty()) {
            this.tryHandleChat(packet.b(), () -> {
                PlayerChatMessage signedMessage;
                try {
                    signedMessage = this.a(packet, (LastSeenMessages)optional.get());
                }
                catch (SignedMessageChain.a var6) {
                    this.a(var6);
                    return;
                }
                CompletionStage completableFuture = this.a(signedMessage.c()).thenApplyAsync(Function.identity(), (Executor)this.d.chatExecutor);
                CompletableFuture<IChatBaseComponent> componentFuture = this.d.bk().decorate(this.f, null, signedMessage.d());
                this.T.append(CompletableFuture.allOf(new CompletableFuture[]{completableFuture, componentFuture}), arg_0 -> this.lambda$handleChat$9(signedMessage, componentFuture, (CompletableFuture)completableFuture, arg_0));
            }, false);
        }
    }

    @Override
    public void a(ServerboundChatCommandPacket packet) {
        this.tryHandleChat(packet.b(), () -> {
            if (this.f.u()) {
                return;
            }
            this.b(packet.b());
            this.detectRateSpam("/" + packet.b());
        }, true);
    }

    private void b(String command) {
        String prefixedCommand = "/" + command;
        if (SpigotConfig.logCommands) {
            h.info("{} issued server command: {}", (Object)this.f.cI(), (Object)prefixedCommand);
        }
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)this.getCraftPlayer(), prefixedCommand, (Set)new LazyPlayerSet(this.d));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        command = event.getMessage().substring(1);
        ParseResults<CommandListenerWrapper> parseResults = this.c(command);
        if (this.d.aA() && SignableCommand.a(parseResults)) {
            h.error("Received unsigned command packet from {}, but the command requires signable arguments: {}", (Object)this.f.gh().getName(), (Object)command);
            this.f.a(m);
        } else {
            this.d.aG().a(parseResults, command);
        }
    }

    @Override
    public void a(ServerboundChatCommandSignedPacket packet) {
        Optional<LastSeenMessages> optional = this.a(packet.h());
        if (!optional.isEmpty()) {
            this.tryHandleChat(packet.b(), () -> {
                if (this.f.u()) {
                    return;
                }
                this.a(packet, (LastSeenMessages)optional.get());
                this.detectRateSpam("/" + packet.b());
            }, true);
        }
    }

    private void a(ServerboundChatCommandSignedPacket packet, LastSeenMessages lastSeenMessages) {
        Map<String, PlayerChatMessage> map;
        Object command = "/" + packet.b();
        if (SpigotConfig.logCommands) {
            h.info("{} issued server command: {}", (Object)this.f.cI(), command);
        }
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)this.getCraftPlayer(), (String)command, (Set)new LazyPlayerSet(this.d));
        this.cserver.getPluginManager().callEvent((Event)event);
        command = event.getMessage().substring(1);
        ParseResults<CommandListenerWrapper> parseResults = this.c(packet.b());
        try {
            map = this.a(packet, SignableCommand.b(parseResults), lastSeenMessages);
        }
        catch (SignedMessageChain.a var6) {
            this.a(var6);
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (!((String)command).equals(packet.b())) {
            parseResults = this.c((String)command);
            map = Collections.emptyMap();
        }
        CommandSigningContext.a commandSigningContext = new CommandSigningContext.a(map);
        parseResults = net.minecraft.commands.CommandDispatcher.a(parseResults, source -> source.a(commandSigningContext, this.T));
        this.d.aG().a(parseResults, (String)command);
    }

    private void a(SignedMessageChain.a exception) {
        h.warn("Failed to update secure chat state for {}: '{}'", (Object)this.f.gh().getName(), (Object)exception.a().getString());
        this.f.a(exception.a().f().a(EnumChatFormat.m));
    }

    private <S> Map<String, PlayerChatMessage> a(ServerboundChatCommandSignedPacket packet, SignableCommand<S> command, LastSeenMessages lastSeenMessages) throws SignedMessageChain.a {
        List<ArgumentSignatures.a> list = packet.g().a();
        List<SignableCommand.a<S>> list1 = command.a();
        if (list.isEmpty()) {
            return this.b(list1);
        }
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (ArgumentSignatures.a a2 : list) {
            SignableCommand.a<S> argument = command.a(a2.a());
            if (argument == null) {
                this.Q.setChainBroken();
                throw PlayerConnection.a(packet.b(), list, list1);
            }
            SignedMessageBody signedMessageBody = new SignedMessageBody(argument.c(), packet.e(), packet.f(), lastSeenMessages);
            map.put(argument.a(), this.Q.unpack(a2.b(), signedMessageBody));
        }
        for (SignableCommand.a a3 : list1) {
            if (map.containsKey(a3.a())) continue;
            throw PlayerConnection.a(packet.b(), list, list1);
        }
        return map;
    }

    private <S> Map<String, PlayerChatMessage> b(List<SignableCommand.a<S>> arguments) throws SignedMessageChain.a {
        HashMap<String, PlayerChatMessage> map = new HashMap<String, PlayerChatMessage>();
        for (SignableCommand.a<S> argument : arguments) {
            SignedMessageBody signedMessageBody = SignedMessageBody.a(argument.c());
            map.put(argument.a(), this.Q.unpack(null, signedMessageBody));
        }
        return map;
    }

    private static <S> SignedMessageChain.a a(String command, List<ArgumentSignatures.a> signedArguments, List<SignableCommand.a<S>> unsignedArguments) {
        String string = signedArguments.stream().map(ArgumentSignatures.a::a).collect(Collectors.joining(", "));
        String string1 = unsignedArguments.stream().map(SignableCommand.a::a).collect(Collectors.joining(", "));
        h.error("Signed command mismatch between server and client ('{}'): got [{}] from client, but expected [{}]", new Object[]{command, string, string1});
        return new SignedMessageChain.a(m);
    }

    private ParseResults<CommandListenerWrapper> c(String command) {
        CommandDispatcher<CommandListenerWrapper> dispatcher = this.d.aG().a();
        return dispatcher.parse(command, this.f.A());
    }

    private void tryHandleChat(String message, Runnable handler, boolean sync) {
        if (PlayerConnection.d(message)) {
            this.disconnectAsync(IChatBaseComponent.c("multiplayer.disconnect.illegal_characters"), PlayerKickEvent.Cause.ILLEGAL_CHARACTERS);
        } else if (this.f.dQ() || this.f.E() == EnumChatVisibility.c) {
            this.b(new ClientboundSystemChatPacket(IChatBaseComponent.c("chat.disabled.options").a(EnumChatFormat.m), false));
        } else {
            this.f.H();
            if (sync) {
                this.d.execute(handler);
            } else {
                handler.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<LastSeenMessages> a(LastSeenMessages.b update) {
        LastSeenMessagesValidator lastSeenMessagesValidator = this.R;
        synchronized (lastSeenMessagesValidator) {
            Optional<LastSeenMessages> optional = this.R.a(update);
            if (optional.isEmpty()) {
                h.warn("Failed to validate message acknowledgements from {}", (Object)this.f.al().getString());
                this.disconnectAsync(l, PlayerKickEvent.Cause.CHAT_VALIDATION_FAILED);
            }
            return optional;
        }
    }

    public static boolean d(String message) {
        for (int i2 = 0; i2 < message.length(); ++i2) {
            if (UtilColor.a(message.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public void chat(String msg, PlayerChatMessage original, boolean async) {
        if (msg.isEmpty() || this.f.E() == EnumChatVisibility.c) {
            return;
        }
        OutgoingChatMessage outgoing = OutgoingChatMessage.a(original);
        if (this.f.E() != EnumChatVisibility.b) {
            if (!async && !Bukkit.isPrimaryThread()) {
                AsyncCatcher.catchOp("Asynchronous player chat is not allowed here");
            }
            ChatProcessor cp = new ChatProcessor(this.d, this.f, original, async);
            cp.process();
        }
    }

    @Deprecated
    public void handleCommand(String s2) {
        if (s2.startsWith("/")) {
            s2 = s2.substring(1);
        }
        this.b(s2);
    }

    private PlayerChatMessage a(PacketPlayInChat packet, LastSeenMessages lastSeenMessages) throws SignedMessageChain.a {
        SignedMessageBody signedMessageBody = new SignedMessageBody(packet.b(), packet.e(), packet.f(), lastSeenMessages);
        return this.Q.unpack(packet.g(), signedMessageBody);
    }

    private void b(PlayerChatMessage message) {
        String rawMessage = message.c();
        if (rawMessage.isEmpty()) {
            h.warn("{} tried to send an empty message", (Object)this.f.cI());
        } else if (this.getCraftPlayer().isConversing()) {
            String conversationInput = rawMessage;
            this.d.processQueue.add(() -> this.getCraftPlayer().acceptConversationInput(conversationInput));
        } else if (this.f.E() == EnumChatVisibility.b) {
            this.b(new ClientboundSystemChatPacket(IChatBaseComponent.c("chat.cannotSend").a(EnumChatFormat.m), false));
        } else {
            this.chat(rawMessage, message, true);
        }
        this.detectRateSpam(rawMessage);
    }

    private void detectRateSpam(String message) {
        for (String exclude : SpigotConfig.spamExclusions) {
            if (exclude == null || !message.startsWith(exclude)) continue;
            return;
        }
        if (!(this.q.isIncrementAndUnderThreshold() || this.d.ag().f(this.f.gh()) || this.d.a(this.f.gh()))) {
            this.disconnectAsync(IChatBaseComponent.c("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(ServerboundChatAckPacket packet) {
        LastSeenMessagesValidator lastSeenMessagesValidator = this.R;
        synchronized (lastSeenMessagesValidator) {
            if (!this.R.a(packet.b())) {
                h.warn("Failed to validate message acknowledgements from {}", (Object)this.f.al().getString());
                this.disconnectAsync(l, PlayerKickEvent.Cause.CHAT_VALIDATION_FAILED);
            }
        }
    }

    @Override
    public void a(PacketPlayInArmAnimation packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (this.f.fi()) {
            return;
        }
        this.f.H();
        float f1 = this.f.dN();
        float f2 = this.f.dL();
        double d0 = this.f.dA();
        double d1 = this.f.dC() + (double)this.f.cS();
        double d2 = this.f.dG();
        Location origin = new Location((World)this.f.dV().getWorld(), d0, d1, d2, f2, f1);
        double d3 = Math.max(this.f.gL(), this.f.gM());
        RayTraceResult result = this.f.dV().getWorld().rayTrace(origin, origin.getDirection(), d3, FluidCollisionMode.NEVER, false, 0.0, entity -> {
            net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
            return entity != this.f.getBukkitEntity() && this.f.getBukkitEntity().canSee((Entity)entity) && !handle.Z_() && handle.bH() && !handle.z(this.f);
        });
        if (result == null) {
            CraftEventFactory.callPlayerInteractEvent(this.f, Action.LEFT_CLICK_AIR, this.f.gi().f(), EnumHand.a);
        } else {
            EnumGamemode gameType = this.f.h.b();
            if (gameType == EnumGamemode.c && result.getHitBlock() != null) {
                CraftEventFactory.callPlayerInteractEvent(this.f, Action.LEFT_CLICK_BLOCK, ((CraftBlock)result.getHitBlock()).getPosition(), CraftBlock.blockFaceToNotch(result.getHitBlockFace()), this.f.gi().f(), EnumHand.a);
            } else if (gameType != EnumGamemode.b && result.getHitEntity() != null && origin.toVector().distanceSquared(result.getHitPosition()) > this.f.gM() * this.f.gM()) {
                CraftEventFactory.callPlayerInteractEvent(this.f, Action.LEFT_CLICK_AIR, this.f.gi().f(), EnumHand.a);
            }
        }
        PlayerArmSwingEvent event = new PlayerArmSwingEvent((Player)this.getCraftPlayer(), CraftEquipmentSlot.getHand(packet.b()));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.f.a(packet.b());
    }

    @Override
    public void a(PacketPlayInEntityAction packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (this.f.gJ()) {
            if (this.f.dQ()) {
                return;
            }
            switch (packet.e()) {
                case a: 
                case b: {
                    PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((Player)this.getCraftPlayer(), packet.e() == PacketPlayInEntityAction.EnumPlayerAction.a);
                    this.cserver.getPluginManager().callEvent((Event)event);
                    if (!event.isCancelled()) break;
                    return;
                }
                case d: 
                case e: {
                    PlayerToggleSneakEvent event = new PlayerToggleSprintEvent((Player)this.getCraftPlayer(), packet.e() == PacketPlayInEntityAction.EnumPlayerAction.d);
                    this.cserver.getPluginManager().callEvent((Event)event);
                    if (!event.isCancelled()) break;
                    return;
                }
            }
            this.f.H();
            switch (packet.e()) {
                case a: {
                    this.f.g(true);
                    if (!this.f.dV().paperConfig().entities.behavior.parrotsAreUnaffectedByPlayerMovement) break;
                    this.f.gx();
                    break;
                }
                case b: {
                    this.f.g(false);
                    break;
                }
                case d: {
                    this.f.h(true);
                    break;
                }
                case e: {
                    this.f.h(false);
                    break;
                }
                case c: {
                    if (!this.f.fR()) break;
                    this.f.a(false, true);
                    this.F = this.f.dt();
                    break;
                }
                case f: {
                    net.minecraft.world.entity.Entity entity = this.f.dl();
                    if (!(entity instanceof IJumpable)) break;
                    IJumpable playerRideableJumping = (IJumpable)((Object)entity);
                    int data = packet.f();
                    if (!playerRideableJumping.a() || data <= 0) break;
                    playerRideableJumping.c(data);
                    break;
                }
                case g: {
                    net.minecraft.world.entity.Entity entity = this.f.dl();
                    if (!(entity instanceof IJumpable)) break;
                    IJumpable playerRideableJumping = (IJumpable)((Object)entity);
                    playerRideableJumping.b();
                    break;
                }
                case h: {
                    net.minecraft.world.entity.Entity entity = this.f.dk();
                    if (!(entity instanceof HasCustomInventoryScreen)) break;
                    HasCustomInventoryScreen hasCustomInventoryScreen = (HasCustomInventoryScreen)((Object)entity);
                    hasCustomInventoryScreen.b(this.f);
                    break;
                }
                case i: {
                    if (this.f.go()) break;
                    this.f.gq();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid client command!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(PlayerChatMessage message) {
        MessageSignature messageSignature = message.l();
        if (messageSignature != null) {
            int i2;
            this.S.a(message.m(), message.l());
            LastSeenMessagesValidator lastSeenMessagesValidator = this.R;
            synchronized (lastSeenMessagesValidator) {
                this.R.a(messageSignature);
                i2 = this.R.a();
            }
            if (i2 > 4096) {
                this.disconnectAsync(IChatBaseComponent.c("multiplayer.disconnect.too_many_pending_chats"), PlayerKickEvent.Cause.TOO_MANY_PENDING_CHATS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(PlayerChatMessage chatMessage, ChatMessageType.a boundType) {
        if (!this.getCraftPlayer().canSeePlayer(chatMessage.k().c())) {
            this.a(chatMessage.d(), boundType);
            return;
        }
        MessageSignatureCache messageSignatureCache = this.S;
        synchronized (messageSignatureCache) {
            this.b(new ClientboundPlayerChatPacket(chatMessage.k().c(), chatMessage.k().b(), chatMessage.l(), chatMessage.m().a(this.S), chatMessage.n(), chatMessage.o(), boundType));
            this.a(chatMessage);
        }
    }

    public void a(IChatBaseComponent message, ChatMessageType.a boundType) {
        this.b(new ClientboundDisguisedChatPacket(message, boundType));
    }

    public SocketAddress m() {
        return this.e.d();
    }

    public SocketAddress getRawAddress() {
        if (this.e.n.remoteAddress() == null) {
            return new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
        }
        return this.e.n.remoteAddress();
    }

    public void n() {
        this.U = true;
        this.q();
        this.b(ClientboundStartConfigurationPacket.a);
        this.e.a(ConfigurationProtocols.d);
    }

    @Override
    public void a(ServerboundPingRequestPacket packet) {
        this.e.a(new ClientboundPongResponsePacket(packet.b()));
    }

    @Override
    public void a(final PacketPlayInUseEntity packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (this.f.fi()) {
            return;
        }
        if (this.f.gJ()) {
            final WorldServer serverLevel = this.f.y();
            final net.minecraft.world.entity.Entity target = packet.a(serverLevel);
            if (target == this.f && !this.f.Z_()) {
                this.disconnect(IChatBaseComponent.b("Cannot interact with self!"), PlayerKickEvent.Cause.SELF_INTERACTION);
                return;
            }
            this.f.H();
            this.f.g(packet.b());
            if (target != null) {
                if (!serverLevel.F_().a(target.dv())) {
                    return;
                }
                AxisAlignedBB boundingBox = target.cR();
                if (this.f.a(boundingBox, GlobalConfiguration.get().misc.clientInteractionLeniencyDistance.or(3.0))) {
                    packet.a(new PacketPlayInUseEntity.c(){

                        private void performInteraction(EnumHand hand, a entityInteraction, PlayerInteractEntityEvent event) {
                            ItemStack itemInHand = PlayerConnection.this.f.b(hand);
                            if (itemInHand.a(serverLevel.K())) {
                                ItemStack itemStack = itemInHand.v();
                                boolean triggerLeashUpdate = itemInHand != null && itemInHand.h() == Items.vK && target instanceof EntityInsentient;
                                Item origItem = PlayerConnection.this.f.gi().f() == null ? null : PlayerConnection.this.f.gi().f().h();
                                PlayerConnection.this.cserver.getPluginManager().callEvent((Event)event);
                                if (target instanceof Bucketable && target instanceof EntityLiving && origItem != null && origItem.j() == Items.rg && (event.isCancelled() || PlayerConnection.this.f.gi().f() == null || PlayerConnection.this.f.gi().f().h() != origItem)) {
                                    target.resendPossiblyDesyncedEntityData(PlayerConnection.this.f);
                                    PlayerConnection.this.f.cd.b();
                                }
                                if (triggerLeashUpdate && (event.isCancelled() || PlayerConnection.this.f.gi().f() == null || PlayerConnection.this.f.gi().f().h() != origItem)) {
                                    PlayerConnection.this.b(new PacketPlayOutAttachEntity(target, ((EntityInsentient)target).D()));
                                }
                                if (event.isCancelled() || PlayerConnection.this.f.gi().f() == null || PlayerConnection.this.f.gi().f().h() != origItem) {
                                    target.refreshEntityData(PlayerConnection.this.f);
                                    if (target instanceof Allay || target instanceof EntityHorseAbstract) {
                                        PlayerConnection.this.b(new PacketPlayOutEntityEquipment(target.ar(), Arrays.stream(EnumItemSlot.values()).map(slot -> Pair.of((Object)slot, (Object)((EntityLiving)target).a((EnumItemSlot)slot).v())).collect(Collectors.toList()), true));
                                    }
                                    PlayerConnection.this.f.cd.b();
                                }
                                if (event.isCancelled()) {
                                    return;
                                }
                                EnumInteractionResult result = entityInteraction.run(PlayerConnection.this.f, target, hand);
                                if (!itemInHand.f() && itemInHand.M() <= -1) {
                                    PlayerConnection.this.f.cd.b();
                                }
                                if (result instanceof EnumInteractionResult.d) {
                                    EnumInteractionResult.d success = (EnumInteractionResult.d)result;
                                    ItemStack itemStack1 = success.c() ? itemStack : ItemStack.j;
                                    CriterionTriggers.T.a(PlayerConnection.this.f, itemStack1, target);
                                    if (success.e() == EnumInteractionResult.e.c) {
                                        PlayerConnection.this.f.a(hand, true);
                                    }
                                }
                            }
                        }

                        @Override
                        public void a(EnumHand hand) {
                            this.performInteraction(hand, EntityHuman::a, new PlayerInteractEntityEvent((Player)PlayerConnection.this.getCraftPlayer(), (Entity)target.getBukkitEntity(), CraftEquipmentSlot.getHand(hand)));
                        }

                        @Override
                        public void a(EnumHand hand, Vec3D interactionLocation) {
                            this.performInteraction(hand, (player, entity, interactionHand) -> entity.a(player, interactionLocation, interactionHand), (PlayerInteractEntityEvent)new PlayerInteractAtEntityEvent((Player)PlayerConnection.this.getCraftPlayer(), (Entity)target.getBukkitEntity(), CraftVector.toBukkit(interactionLocation), CraftEquipmentSlot.getHand(hand)));
                        }

                        @Override
                        public void a() {
                            EntityArrow abstractArrow;
                            if (!(target instanceof EntityItem || target instanceof EntityExperienceOrb || target == PlayerConnection.this.f && !PlayerConnection.this.f.Z_() || target instanceof EntityArrow && !(abstractArrow = (EntityArrow)target).cB())) {
                                ItemStack itemInHand = PlayerConnection.this.f.b(EnumHand.a);
                                if (itemInHand.a(serverLevel.K())) {
                                    PlayerConnection.this.f.e(target);
                                    if (!itemInHand.f() && itemInHand.M() <= -1) {
                                        PlayerConnection.this.f.cd.b();
                                    }
                                }
                            } else {
                                PlayerConnection.this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.invalid_entity_attacked"), PlayerKickEvent.Cause.INVALID_ENTITY_ATTACKED);
                                h.warn("Player {} tried to attack an invalid entity", (Object)PlayerConnection.this.f.al().getString());
                            }
                        }
                    });
                }
            } else {
                packet.a(new PacketPlayInUseEntity.c(){

                    @Override
                    public void a(EnumHand hand) {
                        CraftEventFactory.callPlayerUseUnknownEntityEvent(PlayerConnection.this.f, packet, hand, null);
                    }

                    @Override
                    public void a(EnumHand hand, Vec3D pos) {
                        CraftEventFactory.callPlayerUseUnknownEntityEvent(PlayerConnection.this.f, packet, hand, pos);
                    }

                    @Override
                    public void a() {
                        CraftEventFactory.callPlayerUseUnknownEntityEvent(PlayerConnection.this.f, packet, EnumHand.a, null);
                    }
                });
            }
        }
    }

    @Override
    public void a(PacketPlayInClientCommand packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        this.f.H();
        PacketPlayInClientCommand.EnumClientCommand action = packet.b();
        switch (action) {
            case a: {
                if (this.f.k) {
                    this.f.k = false;
                    this.f = this.d.ag().respawn(this.f, true, Entity.RemovalReason.e, PlayerRespawnEvent.RespawnReason.END_PORTAL);
                    this.l();
                    CriterionTriggers.w.a(this.f, net.minecraft.world.level.World.k, net.minecraft.world.level.World.i);
                    break;
                }
                if (this.f.eD() > 0.0f) {
                    return;
                }
                this.f = this.d.ag().respawn(this.f, false, Entity.RemovalReason.a, PlayerRespawnEvent.RespawnReason.DEATH);
                this.l();
                if (!this.d.w_()) break;
                this.f.setGameMode(EnumGamemode.d, PlayerGameModeChangeEvent.Cause.HARDCORE_DEATH, null);
                this.f.y().O().a(GameRules.r).set(false, this.f.y());
                break;
            }
            case b: {
                this.f.I().a(this.f);
            }
        }
    }

    @Override
    public void a(PacketPlayInCloseWindow packet) {
        this.handleContainerClose(packet, InventoryCloseEvent.Reason.PLAYER);
    }

    public void handleContainerClose(PacketPlayInCloseWindow packet, InventoryCloseEvent.Reason reason) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (this.f.fi()) {
            return;
        }
        CraftEventFactory.handleInventoryCloseEvent(this.f, reason);
        this.f.q();
    }

    @Override
    public void a(PacketPlayInWindowClick packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (this.f.fi()) {
            return;
        }
        this.f.H();
        if (this.f.cd.l == packet.b() && this.f.cd.b(this.f)) {
            boolean cancelled = this.f.Z_();
            if (!this.f.cd.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)this.f.cd);
            } else {
                int slotNum = packet.e();
                if (!this.f.cd.a(slotNum)) {
                    h.debug("Player {} clicked invalid slot index: {}, available slots: {}", new Object[]{this.f.al(), slotNum, this.f.cd.k.size()});
                } else {
                    boolean flag = packet.j() != this.f.cd.j();
                    this.f.cd.h();
                    if (slotNum < -1 && slotNum != -999) {
                        return;
                    }
                    InventoryView inventory = this.f.cd.getBukkitView();
                    InventoryType.SlotType type = inventory.getSlotType(slotNum);
                    ClickType click = ClickType.UNKNOWN;
                    InventoryAction action = InventoryAction.UNKNOWN;
                    switch (packet.i()) {
                        case a: {
                            if (packet.f() == 0) {
                                click = ClickType.LEFT;
                            } else if (packet.f() == 1) {
                                click = ClickType.RIGHT;
                            }
                            if (packet.f() != 0 && packet.f() != 1) break;
                            action = InventoryAction.NOTHING;
                            if (slotNum == -999) {
                                if (this.f.cd.g().f()) break;
                                action = packet.f() == 0 ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
                                break;
                            }
                            if (slotNum < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.f.cd.b(slotNum);
                            if (slot == null) break;
                            ItemStack clickedItem = slot.g();
                            ItemStack cursor = this.f.cd.g();
                            if (clickedItem.f()) {
                                if (cursor.f()) break;
                                if (cursor.h() instanceof BundleItem && packet.f() != 0) {
                                    action = cursor.a(DataComponents.P).g() ? InventoryAction.NOTHING : InventoryAction.PLACE_FROM_BUNDLE;
                                    break;
                                }
                                action = packet.f() == 0 ? InventoryAction.PLACE_ALL : InventoryAction.PLACE_ONE;
                                break;
                            }
                            if (!slot.a(this.f)) break;
                            if (cursor.f()) {
                                if (slot.g().h() instanceof BundleItem && packet.f() != 0) {
                                    action = slot.g().a(DataComponents.P).g() ? InventoryAction.NOTHING : InventoryAction.PICKUP_FROM_BUNDLE;
                                    break;
                                }
                                action = packet.f() == 0 ? InventoryAction.PICKUP_ALL : InventoryAction.PICKUP_HALF;
                                break;
                            }
                            if (slot.a(cursor)) {
                                int toPickup;
                                if (ItemStack.c(clickedItem, cursor)) {
                                    int toPlace = packet.f() == 0 ? cursor.M() : 1;
                                    toPlace = Math.min(toPlace, clickedItem.k() - clickedItem.M());
                                    if ((toPlace = Math.min(toPlace, slot.c.an_() - clickedItem.M())) == 1) {
                                        action = InventoryAction.PLACE_ONE;
                                        break;
                                    }
                                    if (toPlace == cursor.M()) {
                                        action = InventoryAction.PLACE_ALL;
                                        break;
                                    }
                                    if (toPlace < 0) {
                                        action = toPlace != -1 ? InventoryAction.PICKUP_SOME : InventoryAction.PICKUP_ONE;
                                        break;
                                    }
                                    if (toPlace == 0) break;
                                    action = InventoryAction.PLACE_SOME;
                                    break;
                                }
                                if (cursor.M() > slot.a()) break;
                                if (cursor.h() instanceof BundleItem && packet.f() == 0) {
                                    toPickup = cursor.a(DataComponents.P).getMaxAmountToAdd(slot.g());
                                    if (toPickup >= slot.g().M()) {
                                        action = InventoryAction.PICKUP_ALL_INTO_BUNDLE;
                                        break;
                                    }
                                    if (toPickup == 0) {
                                        action = InventoryAction.NOTHING;
                                        break;
                                    }
                                    action = InventoryAction.PICKUP_SOME_INTO_BUNDLE;
                                    break;
                                }
                                if (slot.g().h() instanceof BundleItem && packet.f() == 0) {
                                    toPickup = slot.g().a(DataComponents.P).getMaxAmountToAdd(cursor);
                                    if (toPickup >= cursor.M()) {
                                        action = InventoryAction.PLACE_ALL_INTO_BUNDLE;
                                        break;
                                    }
                                    if (toPickup == 0) {
                                        action = InventoryAction.NOTHING;
                                        break;
                                    }
                                    action = InventoryAction.PLACE_SOME_INTO_BUNDLE;
                                    break;
                                }
                                action = InventoryAction.SWAP_WITH_CURSOR;
                                break;
                            }
                            if (!ItemStack.c(cursor, clickedItem) || clickedItem.M() < 0 || clickedItem.M() + cursor.M() > cursor.k()) break;
                            action = InventoryAction.PICKUP_ALL;
                            break;
                        }
                        case b: {
                            if (packet.f() == 0) {
                                click = ClickType.SHIFT_LEFT;
                            } else if (packet.f() == 1) {
                                click = ClickType.SHIFT_RIGHT;
                            }
                            if (packet.f() != 0 && packet.f() != 1) break;
                            if (slotNum < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.f.cd.b(slotNum);
                            if (slot != null && slot.a(this.f) && slot.h()) {
                                action = InventoryAction.MOVE_TO_OTHER_INVENTORY;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case c: {
                            if ((packet.f() < 0 || packet.f() >= 9) && packet.f() != 40) break;
                            if (slotNum < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = packet.f() == 40 ? ClickType.SWAP_OFFHAND : ClickType.NUMBER_KEY;
                            Slot clickedSlot = this.f.cd.b(slotNum);
                            if (clickedSlot.a(this.f)) {
                                ItemStack hotbar = this.f.gi().a(packet.f());
                                if (!hotbar.f() && clickedSlot.a(hotbar) || hotbar.f() && clickedSlot.h()) {
                                    action = InventoryAction.HOTBAR_SWAP;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case d: {
                            Slot slot;
                            if (packet.f() == 2) {
                                click = ClickType.MIDDLE;
                                if (slotNum < 0) {
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                slot = this.f.cd.b(slotNum);
                                if (slot != null && slot.h() && this.f.gj().d && this.f.cd.g().f()) {
                                    action = InventoryAction.CLONE_STACK;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = ClickType.UNKNOWN;
                            action = InventoryAction.UNKNOWN;
                            break;
                        }
                        case e: {
                            Slot slot;
                            if (slotNum >= 0) {
                                if (packet.f() == 0) {
                                    click = ClickType.DROP;
                                    slot = this.f.cd.b(slotNum);
                                    if (slot != null && slot.h() && slot.a(this.f) && !slot.g().f() && slot.g().h() != Items.a) {
                                        action = InventoryAction.DROP_ONE_SLOT;
                                        break;
                                    }
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                if (packet.f() != 1) break;
                                click = ClickType.CONTROL_DROP;
                                slot = this.f.cd.b(slotNum);
                                if (slot != null && slot.h() && slot.a(this.f) && !slot.g().f() && slot.g().h() != Items.a) {
                                    action = InventoryAction.DROP_ALL_SLOT;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = ClickType.LEFT;
                            if (packet.f() == 1) {
                                click = ClickType.RIGHT;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case f: {
                            Container containerMenu = this.f.cd;
                            int currentStatus = this.f.cd.w;
                            int newStatus = Container.d(packet.f());
                            if (!(currentStatus != 1 || newStatus != 2 && currentStatus != newStatus || containerMenu.g().f() || newStatus == 0 || newStatus == 1 || newStatus != 2 || this.f.cd.x.isEmpty() || this.f.cd.x.size() != 1)) {
                                int index = containerMenu.x.iterator().next().d;
                                containerMenu.f();
                                this.a(new PacketPlayInWindowClick(packet.b(), packet.j(), index, containerMenu.v, InventoryClickType.a, packet.g(), packet.h()));
                                return;
                            }
                            this.f.cd.a(slotNum, packet.f(), packet.i(), this.f);
                            break;
                        }
                        case g: {
                            click = ClickType.DOUBLE_CLICK;
                            action = InventoryAction.NOTHING;
                            if (slotNum < 0 || this.f.cd.g().f()) break;
                            ItemStack cursor = this.f.cd.g();
                            action = InventoryAction.NOTHING;
                            if (!inventory.getTopInventory().contains(CraftItemType.minecraftToBukkit(cursor.h())) && !inventory.getBottomInventory().contains(CraftItemType.minecraftToBukkit(cursor.h()))) break;
                            action = InventoryAction.COLLECT_TO_CURSOR;
                            break;
                        }
                    }
                    if (packet.i() != InventoryClickType.f) {
                        CartographyInventory cartographyInventory;
                        org.bukkit.inventory.ItemStack result;
                        org.bukkit.inventory.ItemStack result2;
                        Recipe recipe;
                        InventoryClickEvent event = click == ClickType.NUMBER_KEY ? new InventoryClickEvent(inventory, type, slotNum, click, action, packet.f()) : new InventoryClickEvent(inventory, type, slotNum, click, action);
                        Inventory top = inventory.getTopInventory();
                        if (slotNum == 0 && top instanceof CraftingInventory && (recipe = ((CraftingInventory)top).getRecipe()) != null) {
                            event = click == ClickType.NUMBER_KEY ? new CraftItemEvent(recipe, inventory, type, slotNum, click, action, packet.f()) : new CraftItemEvent(recipe, inventory, type, slotNum, click, action);
                        }
                        if (slotNum == 3 && top instanceof SmithingInventory && (result2 = ((SmithingInventory)top).getResult()) != null) {
                            event = click == ClickType.NUMBER_KEY ? new SmithItemEvent(inventory, type, slotNum, click, action, packet.f()) : new SmithItemEvent(inventory, type, slotNum, click, action);
                        }
                        if (slotNum == 2 && top instanceof CartographyInventory && (result = (cartographyInventory = (CartographyInventory)top).getResult()) != null && !result.isEmpty()) {
                            event = click == ClickType.NUMBER_KEY ? new CartographyItemEvent(inventory, type, slotNum, click, action, packet.f()) : new CartographyItemEvent(inventory, type, slotNum, click, action);
                        }
                        event.setCancelled(cancelled);
                        Container oldContainer = this.f.cd;
                        this.cserver.getPluginManager().callEvent((Event)event);
                        if (this.f.cd != oldContainer) {
                            return;
                        }
                        block9 : switch (event.getResult()) {
                            case ALLOW: 
                            case DEFAULT: {
                                this.f.cd.a(slotNum, packet.f(), packet.i(), this.f);
                                break;
                            }
                            case DENY: {
                                switch (action) {
                                    case PICKUP_ALL: 
                                    case MOVE_TO_OTHER_INVENTORY: 
                                    case HOTBAR_MOVE_AND_READD: 
                                    case HOTBAR_SWAP: 
                                    case COLLECT_TO_CURSOR: 
                                    case UNKNOWN: {
                                        this.f.cd.b();
                                        break block9;
                                    }
                                    case PICKUP_SOME: 
                                    case PICKUP_HALF: 
                                    case PICKUP_ONE: 
                                    case PLACE_ALL: 
                                    case PLACE_SOME: 
                                    case PLACE_ONE: 
                                    case SWAP_WITH_CURSOR: {
                                        this.f.f.b(new ClientboundSetCursorItemPacket(this.f.cd.g().v()));
                                        this.f.f.b(new PacketPlayOutSetSlot(this.f.cd.l, this.f.cc.k(), slotNum, this.f.cd.b(slotNum).g()));
                                        break block9;
                                    }
                                    case DROP_ALL_SLOT: 
                                    case DROP_ONE_SLOT: {
                                        this.f.f.b(new PacketPlayOutSetSlot(this.f.cd.l, this.f.cc.k(), slotNum, this.f.cd.b(slotNum).g()));
                                        break block9;
                                    }
                                    case DROP_ALL_CURSOR: 
                                    case DROP_ONE_CURSOR: 
                                    case CLONE_STACK: {
                                        this.f.f.b(new ClientboundSetCursorItemPacket(this.f.cd.g().v()));
                                        break block9;
                                    }
                                }
                            }
                        }
                        if (event instanceof CraftItemEvent || event instanceof SmithItemEvent) {
                            this.f.cd.b();
                        }
                    }
                    for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(packet.h())) {
                        this.f.cd.b(entry.getIntKey(), (ItemStack)entry.getValue());
                    }
                    this.f.cd.a(packet.g());
                    this.f.cd.i();
                    if (flag) {
                        this.f.cd.e();
                    } else {
                        this.f.cd.d();
                    }
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInAutoRecipe packet) {
        if (!Bukkit.isPrimaryThread() && !this.recipeSpamPackets.isIncrementAndUnderThreshold()) {
            this.disconnectAsync(IChatBaseComponent.c("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
            return;
        }
        PlayerConnectionUtils.a(packet, this, this.f.y());
        this.f.H();
        if (!this.f.Z_() && this.f.cd.l == packet.b()) {
            if (!this.f.cd.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)this.f.cd);
            } else {
                CraftingManager.d recipeFromDisplay = this.d.aI().a(packet.e());
                if (recipeFromDisplay != null) {
                    Container container;
                    RecipeHolder recipeHolder = recipeFromDisplay.b();
                    if (this.f.J().b(recipeHolder.a()) && (container = this.f.cd) instanceof ContainerRecipeBook) {
                        ContainerRecipeBook recipeBookMenu = (ContainerRecipeBook)container;
                        if (recipeHolder.b().ao_().c()) {
                            h.debug("Player {} tried to place impossible recipe {}", (Object)this.f, (Object)recipeHolder.a().a());
                            return;
                        }
                        NamespacedKey recipeName = CraftNamespacedKey.fromMinecraft(recipeHolder.a().a());
                        boolean makeAll = packet.f();
                        PlayerRecipeBookClickEvent paperEvent = new PlayerRecipeBookClickEvent((Player)this.f.getBukkitEntity(), recipeName, makeAll);
                        if (!paperEvent.callEvent()) {
                            return;
                        }
                        recipeName = paperEvent.getRecipe();
                        makeAll = paperEvent.isMakeAll();
                        if (org.bukkit.event.player.PlayerRecipeBookClickEvent.getHandlerList().getRegisteredListeners().length > 0) {
                            Recipe recipe = this.cserver.getRecipe(recipeName);
                            if (recipe == null) {
                                return;
                            }
                            org.bukkit.event.player.PlayerRecipeBookClickEvent event = CraftEventFactory.callRecipeBookClickEvent(this.f, recipe, makeAll);
                            recipeName = ((Keyed)event.getRecipe()).getKey();
                            makeAll = event.isShiftClick();
                        }
                        if (!(this.f.cd instanceof ContainerRecipeBook)) {
                            return;
                        }
                        recipeHolder = this.d.aI().b(ResourceKey.a(Registries.bk, CraftNamespacedKey.toMinecraft(recipeName))).orElse(null);
                        if (recipeHolder == null) {
                            return;
                        }
                        ContainerRecipeBook.a postPlaceAction = recipeBookMenu.a(makeAll, this.f.b(), recipeHolder, this.f.y(), this.f.gi());
                        if (postPlaceAction == ContainerRecipeBook.a.b) {
                            this.f.f.b(new PacketPlayOutAutoRecipe(this.f.cd.l, recipeFromDisplay.a().b()));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInEnchantItem packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (this.f.fi()) {
            return;
        }
        this.f.H();
        if (this.f.cd.l == packet.b() && !this.f.Z_()) {
            if (!this.f.cd.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)this.f.cd);
            } else {
                boolean flag = this.f.cd.a((EntityHuman)this.f, packet.e());
                if (flag) {
                    this.f.cd.d();
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSetCreativeSlot packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (this.f.h.e()) {
            boolean flag2;
            boolean flag = packet.b() < 0;
            ItemStack itemStack = packet.e();
            if (!itemStack.a(this.f.dV().K())) {
                return;
            }
            boolean flag1 = packet.b() >= 1 && packet.b() <= 45;
            boolean bl = flag2 = itemStack.f() || itemStack.M() <= itemStack.k();
            if (flag || flag1 && !ItemStack.a(this.f.cc.b(packet.b()).g(), packet.e())) {
                CraftInventoryView inventory = this.f.cc.getBukkitView();
                org.bukkit.inventory.ItemStack item = CraftItemStack.asBukkitCopy(packet.e());
                InventoryType.SlotType type = InventoryType.SlotType.QUICKBAR;
                if (flag) {
                    type = InventoryType.SlotType.OUTSIDE;
                } else if (packet.b() < 36) {
                    type = packet.b() >= 5 && packet.b() < 9 ? InventoryType.SlotType.ARMOR : InventoryType.SlotType.CONTAINER;
                }
                InventoryCreativeEvent event = new InventoryCreativeEvent((InventoryView)inventory, type, flag ? -999 : (int)packet.b(), item);
                this.cserver.getPluginManager().callEvent((Event)event);
                itemStack = CraftItemStack.asNMSCopy(event.getCursor());
                switch (event.getResult()) {
                    case ALLOW: {
                        flag2 = true;
                        break;
                    }
                    case DEFAULT: {
                        break;
                    }
                    case DENY: {
                        if (packet.b() >= 0) {
                            this.f.f.b(new PacketPlayOutSetSlot(this.f.cc.l, this.f.cc.k(), packet.b(), this.f.cc.b(packet.b()).g()));
                            this.f.f.b(new ClientboundSetCursorItemPacket(ItemStack.j.v()));
                        }
                        return;
                    }
                }
            }
            if (flag1 && flag2) {
                this.f.cc.b(packet.b()).e(itemStack);
                this.f.cc.a((int)packet.b(), itemStack);
                this.f.cc.d();
            } else if (flag && flag2) {
                if (this.r.c()) {
                    this.r.a();
                    this.f.a(itemStack, true);
                } else {
                    h.warn("Player {} was dropping items too fast in creative mode, ignoring.", (Object)this.f.al().getString());
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInUpdateSign packet) {
        String[] lines = packet.f();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            int offset;
            if (MAX_SIGN_LINE_LENGTH <= 0 || lines[i2].length() <= MAX_SIGN_LINE_LENGTH || (offset = lines[i2].codePoints().limit(MAX_SIGN_LINE_LENGTH).map(Character::charCount).sum()) >= lines[i2].length()) continue;
            lines[i2] = lines[i2].substring(0, offset);
        }
        List<String> list = Stream.of(lines).map(EnumChatFormat::a).collect(Collectors.toList());
        this.a(list).thenAcceptAsync(list1 -> this.a(packet, (List<FilteredText>)list1), (Executor)this.d);
    }

    private void a(PacketPlayInUpdateSign packet, List<FilteredText> filteredText) {
        if (this.f.fi()) {
            return;
        }
        this.f.H();
        WorldServer serverLevel = this.f.y();
        BlockPosition pos = packet.b();
        if (serverLevel.B(pos)) {
            TileEntity tileEntity = serverLevel.c_(pos);
            if (!(tileEntity instanceof TileEntitySign)) {
                return;
            }
            TileEntitySign signBlockEntity = (TileEntitySign)tileEntity;
            signBlockEntity.a((EntityHuman)this.f, packet.e(), filteredText);
        }
    }

    @Override
    public void a(PacketPlayInAbilities packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (this.f.gj().c && this.f.gj().b != packet.b()) {
            PlayerToggleFlightEvent event = new PlayerToggleFlightEvent((Player)this.f.getBukkitEntity(), packet.b());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.f.gj().b = packet.b();
            } else {
                this.f.x();
            }
        }
    }

    @Override
    public void a(ServerboundClientInformationPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (packet.b().c() < 0) {
            h.warn("Disconnecting {} for invalid view distance: {}", (Object)this.f.cI(), (Object)packet.b().c());
            this.disconnect(IChatBaseComponent.b("Invalid client settings"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
            return;
        }
        boolean isModelPartShown = this.f.a(PlayerModelPart.g);
        this.f.a(packet.b());
        this.e.n.attr(PaperAdventure.LOCALE_ATTRIBUTE).set((Object)Translator.parseLocale((String)packet.b().b()));
        if (this.f.a(PlayerModelPart.g) != isModelPartShown) {
            this.d.ag().a(new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.h, this.f));
        }
    }

    @Override
    public void a(PacketPlayInDifficultyChange packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (this.f.s(2) || this.h()) {
            // empty if block
        }
    }

    @Override
    public void a(PacketPlayInDifficultyLock packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (this.f.s(2) || this.h()) {
            this.d.b(packet.b());
        }
    }

    @Override
    public void a(ServerboundChatSessionUpdatePacket packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        RemoteChatSession.a data = packet.b();
        ProfilePublicKey.a data1 = this.P != null ? this.P.d().b() : null;
        ProfilePublicKey.a data2 = data.b();
        if (!Objects.equals(data1, data2)) {
            if (data1 != null && data2.b().isBefore(data1.b())) {
                this.disconnect(ProfilePublicKey.a, PlayerKickEvent.Cause.EXPIRED_PROFILE_PUBLIC_KEY);
            } else {
                try {
                    SignatureValidator profileKeySignatureValidator = this.d.ar();
                    if (profileKeySignatureValidator == null) {
                        h.warn("Ignoring chat session from {} due to missing Services public key", (Object)this.f.gh().getName());
                        return;
                    }
                    this.a(data.a(this.f.gh(), profileKeySignatureValidator));
                }
                catch (ProfilePublicKey.b var6) {
                    this.disconnect(var6.a(), var6.kickCause);
                }
            }
        }
    }

    @Override
    public void a(ServerboundConfigurationAcknowledgedPacket packet) {
        if (!this.U) {
            throw new IllegalStateException("Client acknowledged config, but none was requested");
        }
        this.e.a(ConfigurationProtocols.b, new ServerConfigurationPacketListenerImpl(this.d, this.e, this.a(this.f.C()), this.f));
    }

    @Override
    public void a(ServerboundChunkBatchReceivedPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        this.g.a(packet.b());
    }

    @Override
    public void a(ServerboundDebugSampleSubscriptionPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        this.d.a(this.f, packet.b());
    }

    private void a(RemoteChatSession chatSession) {
        this.P = chatSession;
        this.hasLoggedExpiry = false;
        this.Q = chatSession.a(this.f.cG());
        this.T.append(() -> {
            this.f.a(chatSession);
            this.d.ag().broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.b), (Collection<EntityPlayer>)List.of(this.f)), this.f);
        });
    }

    @Override
    public void a(ServerboundClientTickEndPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.f.y());
        if (!this.O) {
            this.f.a(Vec3D.c);
        }
        this.O = false;
    }

    private void a(Vec3D movement) {
        if (movement.h() > (double)1.0E-5f) {
            this.f.H();
        }
        this.f.a(movement);
        this.O = true;
    }

    @Override
    public EntityPlayer o() {
        return this.f;
    }

    private PlayerFailMoveEvent fireFailMove(PlayerFailMoveEvent.FailReason failReason, double toX, double toY, double toZ, float toYaw, float toPitch, boolean logWarning) {
        CraftPlayer player = this.getCraftPlayer();
        Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
        Location to = new Location(player.getWorld(), toX, toY, toZ, toYaw, toPitch);
        PlayerFailMoveEvent event = new PlayerFailMoveEvent((Player)player, failReason, false, logWarning, from, to);
        event.callEvent();
        return event;
    }

    private /* synthetic */ void lambda$handleChat$9(PlayerChatMessage signedMessage, CompletableFuture componentFuture, CompletableFuture completableFuture, Void filteredtext) {
        PlayerChatMessage playerChatMessage = signedMessage.a((IChatBaseComponent)componentFuture.join()).a(((FilteredText)completableFuture.join()).e());
        this.b(playerChatMessage);
    }

    @FunctionalInterface
    static interface a {
        public EnumInteractionResult run(EntityPlayer var1, net.minecraft.world.entity.Entity var2, EnumHand var3);
    }
}

