/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import com.destroystokyo.paper.network.PaperLegacyStatusClient;
import com.destroystokyo.paper.network.PaperNetworkClient;
import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerInfo;
import net.minecraft.server.network.LegacyProtocolUtils;
import org.slf4j.Logger;

public class LegacyPingHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger a = LogUtils.getLogger();
    private final ServerInfo b;
    private ByteBuf buf;

    public LegacyPingHandler(ServerInfo server) {
        this.b = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void channelRead(ChannelHandlerContext context, Object message) {
        block24: {
            block25: {
                block22: {
                    block23: {
                        block20: {
                            block21: {
                                block18: {
                                    block19: {
                                        block16: {
                                            block17: {
                                                byteBuf = (ByteBuf)message;
                                                if (this.buf != null) {
                                                    try {
                                                        this.readLegacy1_6(context, byteBuf);
                                                    }
                                                    finally {
                                                        byteBuf.release();
                                                    }
                                                    return;
                                                }
                                                byteBuf.markReaderIndex();
                                                flag = true;
                                                if (byteBuf.readUnsignedByte() == 254) break block16;
                                                if (!flag) break block17;
                                                byteBuf.resetReaderIndex();
                                                context.channel().pipeline().remove((ChannelHandler)this);
                                                context.fireChannelRead(message);
                                            }
                                            return;
                                        }
                                        socketAddress = context.channel().remoteAddress();
                                        i = byteBuf.readableBytes();
                                        string = null;
                                        if (i != 0) ** GOTO lbl55
                                        LegacyPingHandler.a.debug("Ping: (<1.3.x) from {}", MinecraftServer.getServer().bl() != false ? socketAddress : "<ip address withheld>");
                                        event = PaperLegacyStatusClient.processRequest(MinecraftServer.getServer(), (InetSocketAddress)socketAddress, 39, null);
                                        if (event != null) break block18;
                                        context.close();
                                        byteBuf.release();
                                        flag = false;
                                        if (!flag) break block19;
                                        byteBuf.resetReaderIndex();
                                        context.channel().pipeline().remove((ChannelHandler)this);
                                        context.fireChannelRead(message);
                                    }
                                    return;
                                }
                                string = String.format(Locale.ROOT, "%s\u00a7%d\u00a7%d", new Object[]{PaperLegacyStatusClient.getUnformattedMotd(event), event.getNumPlayers(), event.getMaxPlayers()});
                                LegacyPingHandler.a(context, LegacyPingHandler.a(context.alloc(), string));
                                ** GOTO lbl103
lbl55:
                                // 1 sources

                                if (byteBuf.readUnsignedByte() == 1) break block20;
                                if (!flag) break block21;
                                byteBuf.resetReaderIndex();
                                context.channel().pipeline().remove((ChannelHandler)this);
                                context.fireChannelRead(message);
                            }
                            return;
                        }
                        if (!byteBuf.isReadable()) break block22;
                        if (byteBuf.readUnsignedByte() == 250 || (string = this.readLegacy1_6(context, byteBuf)) != null) ** GOTO lbl81
                        if (!flag) break block23;
                        byteBuf.resetReaderIndex();
                        context.channel().pipeline().remove((ChannelHandler)this);
                        context.fireChannelRead(message);
                    }
                    return;
                }
                LegacyPingHandler.a.debug("Ping: (1.4-1.5.x) from {}", MinecraftServer.getServer().bl() != false ? socketAddress : "<ip address withheld>");
lbl81:
                // 2 sources

                if (string != null) ** GOTO lbl102
                event = PaperLegacyStatusClient.processRequest(MinecraftServer.getServer(), (InetSocketAddress)socketAddress, 127, null);
                if (event != null) break block24;
                context.close();
                byteBuf.release();
                flag = false;
                if (!flag) break block25;
                byteBuf.resetReaderIndex();
                context.channel().pipeline().remove((ChannelHandler)this);
                context.fireChannelRead(message);
            }
            return;
        }
        try {
            try {
                string = String.format(Locale.ROOT, "\u00a71\u0000%d\u0000%s\u0000%s\u0000%d\u0000%d", new Object[]{event.getProtocolVersion(), this.b.M(), event.getMotd(), event.getNumPlayers(), event.getMaxPlayers()});
lbl102:
                // 2 sources

                LegacyPingHandler.a(context, LegacyPingHandler.a(context.alloc(), string));
lbl103:
                // 2 sources

                byteBuf.release();
                flag = false;
            }
            catch (RuntimeException var5_7) {
                // empty catch block
            }
        }
        catch (Throwable var9_12) {
            throw var9_12;
        }
        finally {
            if (flag) {
                byteBuf.resetReaderIndex();
                context.channel().pipeline().remove((ChannelHandler)this);
                context.fireChannelRead(message);
            }
        }
    }

    private static boolean a(ByteBuf buffer) {
        short unsignedByte = buffer.readUnsignedByte();
        if (unsignedByte != 250) {
            return false;
        }
        String legacyString = LegacyProtocolUtils.a(buffer);
        if (!"MC|PingHost".equals(legacyString)) {
            return false;
        }
        int unsignedShort = buffer.readUnsignedShort();
        if (buffer.readableBytes() != unsignedShort) {
            return false;
        }
        short unsignedByte1 = buffer.readUnsignedByte();
        if (unsignedByte1 < 73) {
            return false;
        }
        String legacyString1 = LegacyProtocolUtils.a(buffer);
        int _int = buffer.readInt();
        return _int <= 65535;
    }

    private static String a(ServerInfo server) {
        return String.format(Locale.ROOT, "%s\u00a7%d\u00a7%d", server.ae(), server.N(), server.O());
    }

    private static String b(ServerInfo server) {
        return String.format(Locale.ROOT, "\u00a71\u0000%d\u0000%s\u0000%s\u0000%d\u0000%d", 127, server.M(), server.ae(), server.N(), server.O());
    }

    private static String readLegacyString(ByteBuf buf) {
        int size = buf.readShort() * 2;
        if (!buf.isReadable(size)) {
            return null;
        }
        String result = buf.toString(buf.readerIndex(), size, StandardCharsets.UTF_16BE);
        buf.skipBytes(size);
        return result;
    }

    private String readLegacy1_6(ChannelHandlerContext ctx, ByteBuf part) {
        ByteBuf buf = this.buf;
        if (buf == null) {
            this.buf = buf = ctx.alloc().buffer();
            buf.markReaderIndex();
        } else {
            buf.resetReaderIndex();
        }
        buf.writeBytes(part);
        if (!buf.isReadable(11)) {
            return null;
        }
        String string = LegacyPingHandler.readLegacyString(buf);
        if (string == null) {
            return null;
        }
        if (!string.equals("MC|PingHost")) {
            this.removeHandler(ctx);
            return null;
        }
        if (!buf.isReadable(2) || !buf.isReadable((int)buf.readShort())) {
            return null;
        }
        byte protocolVersion = buf.readByte();
        String host = LegacyPingHandler.readLegacyString(buf);
        if (host == null) {
            this.removeHandler(ctx);
            return null;
        }
        int port = buf.readInt();
        if (buf.isReadable()) {
            this.removeHandler(ctx);
            return null;
        }
        buf.release();
        this.buf = null;
        a.debug("Ping: (1.6) from {}", MinecraftServer.getServer().bl() ? ctx.channel().remoteAddress() : "<ip address withheld>");
        MinecraftServer server = MinecraftServer.getServer();
        InetSocketAddress virtualHost = PaperNetworkClient.prepareVirtualHost(host, port);
        PaperServerListPingEvent event = PaperLegacyStatusClient.processRequest(server, (InetSocketAddress)ctx.channel().remoteAddress(), protocolVersion, virtualHost);
        if (event == null) {
            ctx.close();
            return null;
        }
        String response = String.format("\u00a71\u0000%d\u0000%s\u0000%s\u0000%d\u0000%d", event.getProtocolVersion(), event.getVersion(), PaperLegacyStatusClient.getMotd(event), event.getNumPlayers(), event.getMaxPlayers());
        return response;
    }

    private void removeHandler(ChannelHandlerContext ctx) {
        ByteBuf buf = this.buf;
        this.buf = null;
        buf.resetReaderIndex();
        ctx.pipeline().remove((ChannelHandler)this);
        ctx.fireChannelRead((Object)buf);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        if (this.buf != null) {
            this.buf.release();
            this.buf = null;
        }
    }

    private static void a(ChannelHandlerContext context, ByteBuf buffer) {
        context.pipeline().firstContext().writeAndFlush((Object)buffer).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static ByteBuf a(ByteBufAllocator bufferAllocator, String reason) {
        ByteBuf byteBuf = bufferAllocator.buffer();
        byteBuf.writeByte(255);
        LegacyProtocolUtils.a(byteBuf, reason);
        return byteBuf;
    }
}

