/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import alternate.current.wire.WireHandler;
import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.list.ShortList;
import ca.spottedleaf.moonrise.common.misc.NearbyPlayers;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.SimpleThreadUnsafeRandom;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.ChunkDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.EntityDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.PoiDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemLevelReader;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.server.ServerEntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_tick_iteration.ChunkTickServerLevel;
import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.PaperConfigurations;
import io.papermc.paper.entity.activation.ActivationRange;
import io.papermc.paper.event.block.BlockBreakProgressUpdateEvent;
import io.papermc.paper.threadedregions.TickRegions;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportType;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDamageEventPacket;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketPlayOutBlockAction;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExplosion;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.ServerEntityGetter;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.players.SleepStatus;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.IInventory;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.BlockActionData;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ForcedChunk;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSnow;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventDispatcher;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathTypeCache;
import net.minecraft.world.level.portal.PortalTravelAgent;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.PersistentIdCounts;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.ticks.TickListServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R3.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.v1_21_R3.generator.CustomWorldChunkManager;
import org.bukkit.craftbukkit.v1_21_R3.util.WorldUUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.Merchant;
import org.bukkit.map.MapView;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotWorldConfig;

public class WorldServer
extends net.minecraft.world.level.World
implements ServerEntityGetter,
GeneratorAccessSeed,
ChunkSystemServerLevel,
ChunkSystemLevelReader,
ChunkTickServerLevel {
    public static final BlockPosition a = new BlockPosition(100, 50, 0);
    public static final IntProvider b = UniformInt.a(12000, 180000);
    public static final IntProvider c = UniformInt.a(12000, 24000);
    private static final IntProvider E = UniformInt.a(12000, 180000);
    public static final IntProvider d = UniformInt.a(3600, 15600);
    private static final Logger F = LogUtils.getLogger();
    private static final int G = 300;
    private static final int H = 65536;
    final List<EntityPlayer> I = Lists.newArrayList();
    public final ChunkProviderServer J;
    private final MinecraftServer K;
    public final WorldDataServer L;
    private int M;
    final EntityTickList N = new EntityTickList();
    private final GameEventDispatcher P;
    public boolean e;
    private final SleepStatus Q;
    private int R;
    private final PortalTravelAgent S;
    private final TickListServer<Block> T = new TickListServer(this::d);
    private final TickListServer<FluidType> U = new TickListServer(this::d);
    private final PathTypeCache V = new PathTypeCache();
    final Set<EntityInsentient> W = new ObjectOpenHashSet();
    volatile boolean X;
    protected final PersistentRaid f;
    private final ObjectLinkedOpenHashSet<BlockActionData> Y = new ObjectLinkedOpenHashSet();
    private final List<BlockActionData> Z = new ArrayList<BlockActionData>(64);
    private boolean aa;
    private final List<MobSpawner> ab;
    @Nullable
    private EnderDragonBattle ac;
    final Int2ObjectMap<EntityComplexPart> ad = new Int2ObjectOpenHashMap();
    private final StructureManager ae;
    private final StructureCheck af;
    private final boolean ag;
    private final RandomSequences ah;
    public final Convertable.ConversionSession levelStorageAccess;
    public final UUID uuid;
    public boolean hasPhysicsEvent = true;
    public boolean hasEntityMoveEvent;
    private final WireHandler wireHandler = new WireHandler(this);
    private final RegionizedPlayerChunkLoader.ViewDistanceHolder viewDistanceHolder = new RegionizedPlayerChunkLoader.ViewDistanceHolder();
    private final RegionizedPlayerChunkLoader chunkLoader = new RegionizedPlayerChunkLoader(this);
    private final EntityDataController entityDataController;
    private final PoiDataController poiDataController;
    private final ChunkDataController chunkDataController;
    private final ChunkTaskScheduler chunkTaskScheduler;
    private long lastMidTickFailure;
    private long tickedBlocksOrFluids;
    private final NearbyPlayers nearbyPlayers = new NearbyPlayers(this);
    private static final ChunkProviderServer.a[] EMPTY_CHUNK_AND_HOLDERS = new ChunkProviderServer.a[0];
    private final ReferenceList<ChunkProviderServer.a> loadedChunks = new ReferenceList<ChunkProviderServer.a>(EMPTY_CHUNK_AND_HOLDERS);
    private final ReferenceList<ChunkProviderServer.a> tickingChunks = new ReferenceList<ChunkProviderServer.a>(EMPTY_CHUNK_AND_HOLDERS);
    private final ReferenceList<ChunkProviderServer.a> entityTickingChunks = new ReferenceList<ChunkProviderServer.a>(EMPTY_CHUNK_AND_HOLDERS);
    private static final ChunkProviderServer.a[] EMPTY_PLAYER_CHUNK_HOLDERS = new ChunkProviderServer.a[0];
    private final ReferenceList<ChunkProviderServer.a> playerTickingChunks = new ReferenceList<ChunkProviderServer.a>(EMPTY_PLAYER_CHUNK_HOLDERS);
    private final Long2IntOpenHashMap playerTickingRequests = new Long2IntOpenHashMap();
    private final SimpleThreadUnsafeRandom simpleRandom = new SimpleThreadUnsafeRandom(RandomSupport.a());
    static final AtomicReference<net.minecraft.world.entity.Entity> currentlyTickingEntity = new AtomicReference();
    private long lagCompensationTick = MinecraftServer.SERVER_INIT;

    @Override
    public Chunk getChunkIfLoaded(int x2, int z2) {
        return this.J.getChunkAtIfLoadedImmediately(x2, z2);
    }

    @Override
    public ResourceKey<WorldDimension> getTypeKey() {
        return this.levelStorageAccess.dimensionType;
    }

    public final boolean areChunksLoadedForMove(AxisAlignedBB axisalignedbb) {
        int minBlockX = MathHelper.a(axisalignedbb.a - 1.0E-7) - 3;
        int maxBlockX = MathHelper.a(axisalignedbb.d + 1.0E-7) + 3;
        int minBlockZ = MathHelper.a(axisalignedbb.c - 1.0E-7) - 3;
        int maxBlockZ = MathHelper.a(axisalignedbb.f + 1.0E-7) + 3;
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        ChunkProviderServer chunkProvider = this.m();
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                if (chunkProvider.getChunkAtIfLoadedImmediately(cx, cz) != null) continue;
                return false;
            }
        }
        return true;
    }

    public final void loadChunksForMoveAsync(AxisAlignedBB axisalignedbb, Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        int minBlockX = MathHelper.a(axisalignedbb.a - 1.0E-7) - 3;
        int minBlockZ = MathHelper.a(axisalignedbb.c - 1.0E-7) - 3;
        int maxBlockX = MathHelper.a(axisalignedbb.d + 1.0E-7) + 3;
        int maxBlockZ = MathHelper.a(axisalignedbb.f + 1.0E-7) + 3;
        int minChunkX = minBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkX = maxBlockX >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        this.loadChunks(minChunkX, minChunkZ, maxChunkX, maxChunkZ, priority, onLoad);
    }

    public final void loadChunks(int minChunkX, int minChunkZ, int maxChunkX, int maxChunkZ, Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(minChunkX, maxChunkX, minChunkZ, maxChunkZ, priority, onLoad);
    }

    @Override
    @Nullable
    public EntityHuman b(UUID uuid) {
        EntityPlayer player = this.p().ag().a(uuid);
        return player != null && player.dV() == this ? player : null;
    }

    @Override
    public final Chunk moonrise$getFullChunkIfLoaded(int chunkX, int chunkZ) {
        return this.J.a(chunkX, chunkZ);
    }

    @Override
    public final IChunkAccess moonrise$getAnyChunkIfLoaded(int chunkX, int chunkZ) {
        NewChunkHolder newChunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (newChunkHolder == null) {
            return null;
        }
        NewChunkHolder.ChunkCompletion lastCompletion = newChunkHolder.getLastChunkCompletion();
        return lastCompletion == null ? null : lastCompletion.chunk();
    }

    @Override
    public final IChunkAccess moonrise$getSpecificChunkIfLoaded(int chunkX, int chunkZ, ChunkStatus leastStatus) {
        NewChunkHolder newChunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (newChunkHolder == null) {
            return null;
        }
        return newChunkHolder.getChunkIfPresentUnchecked(leastStatus);
    }

    @Override
    public final void moonrise$midTickTasks() {
        this.K.moonrise$executeMidTickTasks();
    }

    @Override
    public final IChunkAccess moonrise$syncLoadNonFull(int chunkX, int chunkZ, ChunkStatus status) {
        return this.moonrise$getChunkTaskScheduler().syncLoadNonFull(chunkX, chunkZ, status);
    }

    @Override
    public final ChunkTaskScheduler moonrise$getChunkTaskScheduler() {
        return this.chunkTaskScheduler;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController moonrise$getChunkDataController() {
        return this.chunkDataController;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController moonrise$getPoiChunkDataController() {
        return this.poiDataController;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController moonrise$getEntityChunkDataController() {
        return this.entityDataController;
    }

    @Override
    public final int moonrise$getRegionChunkShift() {
        return TickRegions.getRegionChunkShift();
    }

    @Override
    public final RegionizedPlayerChunkLoader moonrise$getPlayerChunkLoader() {
        return this.chunkLoader;
    }

    @Override
    public final void moonrise$loadChunksAsync(BlockPosition pos, int radiusBlocks, Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(pos.u() - radiusBlocks >> 4, pos.u() + radiusBlocks >> 4, pos.w() - radiusBlocks >> 4, pos.w() + radiusBlocks >> 4, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(BlockPosition pos, int radiusBlocks, ChunkStatus chunkStatus, Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(pos.u() - radiusBlocks >> 4, pos.u() + radiusBlocks >> 4, pos.w() - radiusBlocks >> 4, pos.w() + radiusBlocks >> 4, chunkStatus, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(minChunkX, maxChunkX, minChunkZ, maxChunkZ, ChunkStatus.n, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, ChunkStatus chunkStatus, Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        ChunkTaskScheduler chunkTaskScheduler = this.moonrise$getChunkTaskScheduler();
        ChunkHolderManager chunkHolderManager = chunkTaskScheduler.chunkHolderManager;
        int requiredChunks = (maxChunkX - minChunkX + 1) * (maxChunkZ - minChunkZ + 1);
        AtomicInteger loadedChunks = new AtomicInteger();
        Long holderIdentifier = ChunkTaskScheduler.getNextChunkLoadId();
        int ticketLevel = ChunkTaskScheduler.getTicketLevel(chunkStatus);
        ArrayList ret = new ArrayList(requiredChunks);
        Consumer<IChunkAccess> consumer = chunk -> {
            if (chunk != null) {
                List list = ret;
                synchronized (list) {
                    ret.add(chunk);
                }
                chunkHolderManager.addTicketAtLevel(ChunkTaskScheduler.CHUNK_LOAD, chunk.f(), ticketLevel, holderIdentifier);
            }
            if (loadedChunks.incrementAndGet() == requiredChunks) {
                try {
                    onLoad.accept(Collections.unmodifiableList(ret));
                }
                finally {
                    int len = ret.size();
                    for (int i2 = 0; i2 < len; ++i2) {
                        ChunkCoordIntPair chunkPos = ((IChunkAccess)ret.get(i2)).f();
                        chunkHolderManager.removeTicketAtLevel(ChunkTaskScheduler.CHUNK_LOAD, chunkPos, ticketLevel, holderIdentifier);
                    }
                }
            }
        };
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                PlatformHooks.get().scheduleChunkLoad(this, cx, cz, ChunkStatus.n, true, priority, consumer);
            }
        }
    }

    @Override
    public final RegionizedPlayerChunkLoader.ViewDistanceHolder moonrise$getViewDistanceHolder() {
        return this.viewDistanceHolder;
    }

    @Override
    public final long moonrise$getLastMidTickFailure() {
        return this.lastMidTickFailure;
    }

    @Override
    public final void moonrise$setLastMidTickFailure(long time) {
        this.lastMidTickFailure = time;
    }

    @Override
    public final NearbyPlayers moonrise$getNearbyPlayers() {
        return this.nearbyPlayers;
    }

    @Override
    public final ReferenceList<ChunkProviderServer.a> moonrise$getLoadedChunks() {
        return this.loadedChunks;
    }

    @Override
    public final ReferenceList<ChunkProviderServer.a> moonrise$getTickingChunks() {
        return this.tickingChunks;
    }

    @Override
    public final ReferenceList<ChunkProviderServer.a> moonrise$getEntityTickingChunks() {
        return this.entityTickingChunks;
    }

    @Override
    public final boolean moonrise$areChunksLoaded(int fromX, int fromZ, int toX, int toZ) {
        ChunkProviderServer chunkSource = this.J;
        for (int currZ = fromZ; currZ <= toZ; ++currZ) {
            for (int currX = fromX; currX <= toX; ++currX) {
                if (chunkSource.b(currX, currZ)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final ReferenceList<ChunkProviderServer.a> moonrise$getPlayerTickingChunks() {
        return this.playerTickingChunks;
    }

    @Override
    public final void moonrise$markChunkForPlayerTicking(Chunk chunk) {
        ChunkCoordIntPair pos = chunk.f();
        if (!this.playerTickingRequests.containsKey(CoordinateUtils.getChunkKey(pos))) {
            return;
        }
        this.playerTickingChunks.add(chunk.moonrise$getChunkAndHolder());
    }

    @Override
    public final void moonrise$removeChunkForPlayerTicking(Chunk chunk) {
        this.playerTickingChunks.remove(chunk.moonrise$getChunkAndHolder());
    }

    @Override
    public final void moonrise$addPlayerTickingRequest(int chunkX, int chunkZ) {
        TickThread.ensureTickThread((net.minecraft.world.level.World)this, chunkX, chunkZ, "Cannot add ticking request async");
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        if (this.playerTickingRequests.addTo(chunkKey, 1) != 0) {
            return;
        }
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkKey);
        if (chunkHolder == null || !chunkHolder.isTickingReady()) {
            return;
        }
        this.playerTickingChunks.add(((Chunk)chunkHolder.getCurrentChunk()).moonrise$getChunkAndHolder());
    }

    @Override
    public final void moonrise$removePlayerTickingRequest(int chunkX, int chunkZ) {
        TickThread.ensureTickThread((net.minecraft.world.level.World)this, chunkX, chunkZ, "Cannot remove ticking request async");
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        int val = this.playerTickingRequests.addTo(chunkKey, -1);
        if (val <= 0) {
            throw new IllegalStateException("Negative counter");
        }
        if (val != 1) {
            return;
        }
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkKey);
        if (chunkHolder == null || !chunkHolder.isTickingReady()) {
            return;
        }
        this.playerTickingChunks.remove(((Chunk)chunkHolder.getCurrentChunk()).moonrise$getChunkAndHolder());
    }

    public WorldServer(MinecraftServer server, Executor dispatcher, Convertable.ConversionSession levelStorageAccess, WorldDataServer serverLevelData, ResourceKey<net.minecraft.world.level.World> dimension, WorldDimension levelStem, WorldLoadListener progressListener, boolean isDebug, long biomeZoomSeed, List<MobSpawner> customSpawners, boolean tickTime, @Nullable RandomSequences randomSequences, World.Environment env, org.bukkit.generator.ChunkGenerator gen, BiomeProvider biomeProvider) {
        super(serverLevelData, dimension, server.ba(), levelStem.a(), false, isDebug, biomeZoomSeed, server.bj(), gen, biomeProvider, env, spigotConfig -> server.paperConfigurations.createWorldConfig(PaperConfigurations.createWorldContextMap(levelStorageAccess.c.f(), serverLevelData.e(), dimension.a(), spigotConfig, server.ba(), serverLevelData.o())), dispatcher);
        this.pvpMode = server.ac();
        this.levelStorageAccess = levelStorageAccess;
        this.uuid = WorldUUID.getUUID(levelStorageAccess.c.f().toFile());
        this.ag = tickTime;
        this.K = server;
        this.ab = customSpawners;
        this.L = serverLevelData;
        ChunkGenerator chunkGenerator = levelStem.b();
        this.L.setWorld(this);
        if (biomeProvider != null) {
            CustomWorldChunkManager worldChunkManager = new CustomWorldChunkManager((WorldInfo)this.getWorld(), biomeProvider, this.K.ba().e(Registries.aI), chunkGenerator.d());
            if (chunkGenerator instanceof ChunkGeneratorAbstract) {
                ChunkGeneratorAbstract cga = (ChunkGeneratorAbstract)chunkGenerator;
                chunkGenerator = new ChunkGeneratorAbstract((WorldChunkManager)worldChunkManager, cga.e);
            } else if (chunkGenerator instanceof ChunkProviderFlat) {
                ChunkProviderFlat cpf = (ChunkProviderFlat)chunkGenerator;
                chunkGenerator = new ChunkProviderFlat(cpf.h(), worldChunkManager);
            }
        }
        if (gen != null) {
            chunkGenerator = new CustomChunkGenerator(this, chunkGenerator, gen);
        }
        boolean flag = server.aX();
        DataFixer fixerUpper = server.aC();
        this.J = new ChunkProviderServer(this, levelStorageAccess, fixerUpper, server.aY(), dispatcher, chunkGenerator, this.spigotConfig.viewDistance, this.spigotConfig.simulationDistance, flag, progressListener, null, () -> server.J().w());
        this.J.h().b();
        this.S = new PortalTravelAgent(this);
        this.Y();
        this.ab();
        this.F_().a(server.aw());
        this.f = this.w().a(PersistentRaid.a(this), PersistentRaid.a(this.ah()));
        if (!server.U()) {
            serverLevelData.a(server.u());
        }
        long seed = server.aZ().y().c();
        this.af = new StructureCheck(this.J.m(), this.K_(), server.aY(), this.getTypeKey(), chunkGenerator, this.J.i(), this, chunkGenerator.d(), seed, fixerUpper);
        this.ae = new StructureManager(this, this.L.y(), this.af);
        this.ac = this.ai() == net.minecraft.world.level.World.k && this.ah().a(BuiltinDimensionTypes.c) || env == World.Environment.THE_END ? new EnderDragonBattle(this, this.L.y().c(), this.L.C()) : null;
        this.Q = new SleepStatus();
        this.P = new GameEventDispatcher(this);
        this.ah = Objects.requireNonNullElseGet(randomSequences, () -> this.w().a(RandomSequences.a(seed), "random_sequences"));
        this.moonrise$setEntityLookup(new ServerEntityLookup(this, (LevelCallback<net.minecraft.world.entity.Entity>)new a()));
        this.chunkTaskScheduler = new ChunkTaskScheduler(this);
        this.entityDataController = new EntityDataController(new EntityDataController.EntityRegionFileStorage(new RegionStorageInfo(levelStorageAccess.f(), dimension, "entities"), levelStorageAccess.a(dimension).resolve("entities"), server.aX()), this.chunkTaskScheduler);
        this.poiDataController = new PoiDataController(this, this.chunkTaskScheduler);
        this.chunkDataController = new ChunkDataController(this, this.chunkTaskScheduler);
        this.getCraftServer().addWorld(this.getWorld());
    }

    @Override
    public boolean b(int chunkX, int chunkZ) {
        return this.m().getChunkAtIfLoadedImmediately(chunkX, chunkZ) != null;
    }

    @Deprecated
    @VisibleForTesting
    public void a(@Nullable EnderDragonBattle dragonFight) {
        this.ac = dragonFight;
    }

    public void a(int clearTime, int weatherTime, boolean isRaining, boolean isThundering) {
        this.L.a(clearTime);
        this.L.c(weatherTime);
        this.L.b(weatherTime);
        this.L.setRaining(isRaining, WeatherChangeEvent.Cause.COMMAND);
        this.L.setThundering(isThundering, ThunderChangeEvent.Cause.COMMAND);
    }

    @Override
    public Holder<BiomeBase> a(int x2, int y2, int z2) {
        return this.m().g().d().getNoiseBiome(x2, y2, z2, this.m().i().b());
    }

    public StructureManager b() {
        return this.ae;
    }

    public void a(BooleanSupplier hasTimeLeft) {
        boolean flag;
        int _int;
        GameProfilerFiller profilerFiller = Profiler.a();
        this.aa = true;
        TickRateManager tickRateManager = this.u();
        boolean runsNormally = tickRateManager.i();
        if (runsNormally) {
            profilerFiller.a("world border");
            this.F_().s();
            profilerFiller.b("weather");
            this.av();
            profilerFiller.c();
        }
        if (this.Q.a(_int = this.O().c(GameRules.Q)) && this.Q.a(_int, this.I)) {
            long newDayTime = this.B.d() + 24000L;
            TimeSkipEvent event = new TimeSkipEvent((World)this.getWorld(), TimeSkipEvent.SkipReason.NIGHT_SKIP, newDayTime - newDayTime % 24000L - this.ae());
            if (this.O().b(GameRules.l) && event.callEvent()) {
                this.b(this.ae() + event.getSkipAmount());
            }
            if (!event.isCancelled()) {
                this.at();
            }
            if (this.O().b(GameRules.w) && this.ag()) {
                this.h();
            }
        }
        this.Y();
        if (runsNormally) {
            this.c();
        }
        profilerFiller.a("tickPending");
        if (!this.aj() && runsNormally) {
            long l2 = this.ad();
            profilerFiller.a("blockTicks");
            this.T.a(l2, this.paperConfig().environment.maxBlockTicks, this::d);
            profilerFiller.b("fluidTicks");
            this.U.a(l2, this.paperConfig().environment.maxFluidTicks, this::a);
            profilerFiller.c();
        }
        profilerFiller.b("raid");
        if (runsNormally) {
            this.f.a();
        }
        profilerFiller.b("chunkSource");
        this.m().a(hasTimeLeft, true);
        profilerFiller.b("blockEvents");
        if (runsNormally) {
            this.aw();
        }
        this.aa = false;
        profilerFiller.c();
        boolean bl = flag = !this.paperConfig().unsupportedSettings.disableWorldTickingWhenEmpty || !this.I.isEmpty() || !this.y().isEmpty();
        if (flag) {
            this.i();
        }
        if (flag || this.R++ < 300) {
            profilerFiller.a("entities");
            if (this.ac != null && runsNormally) {
                profilerFiller.a("dragonFight");
                this.ac.c();
                profilerFiller.c();
            }
            ActivationRange.activateEntities(this);
            this.N.a((net.minecraft.world.entity.Entity entity) -> {
                if (!entity.dQ() && !tickRateManager.a((net.minecraft.world.entity.Entity)entity)) {
                    profilerFiller.a("checkDespawn");
                    entity.dH();
                    profilerFiller.c();
                    net.minecraft.world.entity.Entity vehicle = entity.dk();
                    if (vehicle != null) {
                        if (!vehicle.dQ() && vehicle.y((net.minecraft.world.entity.Entity)entity)) {
                            return;
                        }
                        entity.ae();
                    }
                    profilerFiller.a("tick");
                    this.a(this::a, entity);
                    profilerFiller.c();
                }
            });
            profilerFiller.c();
            this.X();
        }
        profilerFiller.a("entityManagement");
        profilerFiller.c();
    }

    @Override
    public boolean a(long chunkPos) {
        NewChunkHolder holder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return holder != null && holder.isTickingReady();
    }

    protected void c() {
        if (this.ag) {
            long l2 = this.B.c() + 1L;
            this.L.a(l2);
            Profiler.a().a("scheduledFunctions");
            this.L.s().a(this.K, l2);
            Profiler.a().c();
            if (this.L.o().b(GameRules.l)) {
                this.b(this.B.d() + 1L);
            }
        }
    }

    public void b(long time) {
        this.L.b(time);
    }

    public void a(boolean spawnEnemies, boolean spawnFriendlies) {
        for (MobSpawner customSpawner : this.ab) {
            customSpawner.a(this, spawnEnemies, spawnFriendlies);
        }
    }

    private void at() {
        this.Q.a();
        this.I.stream().filter(EntityLiving::fR).collect(Collectors.toList()).forEach(player -> player.a(false, false));
    }

    private void optimiseRandomTick(Chunk chunk, int tickSpeed) {
        ChunkSection[] sections = chunk.d();
        int minSection = WorldUtil.getMinSection(this);
        SimpleThreadUnsafeRandom simpleRandom = this.simpleRandom;
        boolean doubleTickFluids = !PlatformHooks.get().configFixMC224294();
        ChunkCoordIntPair cpos = chunk.f();
        int offsetX = cpos.h << 4;
        int offsetZ = cpos.i << 4;
        int sectionsLen = sections.length;
        for (int sectionIndex = 0; sectionIndex < sectionsLen; ++sectionIndex) {
            int offsetY = sectionIndex + minSection << 4;
            ChunkSection section = sections[sectionIndex];
            DataPaletteBlock<IBlockData> states = section.h;
            if (!section.e()) continue;
            ShortList tickList = section.moonrise$getTickingBlockList();
            for (int i2 = 0; i2 < tickSpeed; ++i2) {
                Fluid fluidState;
                int tickingBlocks = tickList.size();
                int index = simpleRandom.f() & 0xFFF;
                if (index >= tickingBlocks) continue;
                int location = tickList.getRaw(index) & 0xFFFF;
                IBlockData state = states.a(location);
                BlockPosition pos = new BlockPosition(location & 0xF | offsetX, location >>> 8 & 0xF | offsetY, location >>> 4 & 0xF | offsetZ);
                state.b(this, pos, simpleRandom);
                if (!doubleTickFluids || !(fluidState = state.y()).f()) continue;
                fluidState.a(this, pos, (RandomSource)simpleRandom);
            }
        }
    }

    public void a(Chunk chunk, int randomTickSpeed) {
        BlockPosition blockPos;
        SimpleThreadUnsafeRandom simpleRandom = this.simpleRandom;
        ChunkCoordIntPair pos = chunk.f();
        boolean isRaining = this.ag();
        int minBlockX = pos.d();
        int minBlockZ = pos.e();
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("thunder");
        if (!this.paperConfig().environment.disableThunder && isRaining && this.af() && this.spigotConfig.thunderChance > 0 && simpleRandom.a(this.spigotConfig.thunderChance) == 0 && this.r(blockPos = this.b(this.a(minBlockX, 0, minBlockZ, 15)))) {
            EntityLightning lightningBolt;
            EntityHorseSkeleton skeletonHorse;
            boolean flag;
            DifficultyDamageScaler currentDifficultyAt = this.d_(blockPos);
            boolean bl = flag = this.O().b(GameRules.e) && this.A.j() < (double)currentDifficultyAt.b() * this.paperConfig().entities.spawning.skeletonHorseThunderSpawnChance.or(0.01) && !this.a_(blockPos.e()).a(Blocks.sU);
            if (flag && (skeletonHorse = EntityTypes.bf.a(this, EntitySpawnReason.h)) != null) {
                skeletonHorse.x(true);
                skeletonHorse.c_(0);
                skeletonHorse.a_(blockPos.u(), blockPos.v(), blockPos.w());
                this.addFreshEntity(skeletonHorse, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            }
            if ((lightningBolt = EntityTypes.aw.a(this, EntitySpawnReason.h)) != null) {
                lightningBolt.f(Vec3D.c(blockPos));
                lightningBolt.a(flag);
                this.strikeLightning(lightningBolt, LightningStrikeEvent.Cause.WEATHER);
            }
        }
        profilerFiller.b("iceandsnow");
        if (!this.paperConfig().environment.disableIceAndSnow) {
            for (int i2 = 0; i2 < randomTickSpeed; ++i2) {
                if (simpleRandom.a(48) != 0) continue;
                this.a(this.a(minBlockX, 0, minBlockZ, 15));
            }
        }
        profilerFiller.b("tickBlocks");
        if (randomTickSpeed > 0) {
            this.optimiseRandomTick(chunk, randomTickSpeed);
        }
        profilerFiller.c();
    }

    @VisibleForTesting
    public void a(BlockPosition blockPos) {
        BlockPosition heightmapPos = this.a(HeightMap.Type.e, blockPos);
        BlockPosition blockPos1 = heightmapPos.e();
        BiomeBase biome = this.t(heightmapPos).a();
        if (biome.a(this, blockPos1)) {
            CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, blockPos1, Blocks.eb.m(), null);
        }
        if (this.ag()) {
            BiomeBase.Precipitation precipitationAt;
            int _int = this.O().c(GameRules.U);
            if (_int > 0 && biome.b(this, heightmapPos)) {
                IBlockData blockState = this.a_(heightmapPos);
                if (blockState.a(Blocks.ea)) {
                    int layersValue = blockState.c(BlockSnow.c);
                    if (layersValue < Math.min(_int, 8)) {
                        IBlockData blockState1 = (IBlockData)blockState.b(BlockSnow.c, layersValue + 1);
                        Block.a(blockState, blockState1, this, heightmapPos);
                        CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, heightmapPos, blockState1, null);
                    }
                } else {
                    CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, heightmapPos, Blocks.ea.m(), null);
                }
            }
            if ((precipitationAt = biome.a(blockPos1, this.P())) != BiomeBase.Precipitation.a) {
                IBlockData blockState2 = this.a_(blockPos1);
                blockState2.b().a(blockState2, (net.minecraft.world.level.World)this, blockPos1, precipitationAt);
            }
        }
    }

    public Optional<BlockPosition> E(BlockPosition pos) {
        Optional<BlockPosition> optional = this.A().e(pointOfInterestType -> pointOfInterestType.a(PoiTypes.t), blockPos -> blockPos.v() == this.a(HeightMap.Type.b, blockPos.u(), blockPos.w()) - 1, pos, 128, VillagePlace.Occupancy.c);
        return optional.map(blockPos -> blockPos.b(1));
    }

    protected BlockPosition b(BlockPosition pos) {
        return this.findLightningTargetAround(pos, false);
    }

    public BlockPosition findLightningTargetAround(BlockPosition pos, boolean returnNullWhenNoTarget) {
        BlockPosition heightmapPos = this.a(HeightMap.Type.e, pos);
        Optional<BlockPosition> optional = this.E(heightmapPos);
        if (optional.isPresent()) {
            return optional.get();
        }
        AxisAlignedBB aabb = AxisAlignedBB.a(heightmapPos, heightmapPos.h(this.an() + 1)).g(3.0);
        List<EntityLiving> entitiesOfClass = this.a(EntityLiving.class, aabb, (? super T entity) -> entity != null && entity.bL() && this.h(entity.dv()) && !entity.Z_());
        if (!entitiesOfClass.isEmpty()) {
            return entitiesOfClass.get(this.A.a(entitiesOfClass.size())).dv();
        }
        if (returnNullWhenNoTarget) {
            return null;
        }
        if (heightmapPos.v() == this.L_() - 1) {
            heightmapPos = heightmapPos.b(2);
        }
        return heightmapPos;
    }

    public boolean d() {
        return this.aa;
    }

    public boolean e() {
        return this.O().c(GameRules.Q) <= 100;
    }

    private void au() {
        if (this.e() && (!this.p().U() || this.p().r())) {
            int _int = this.O().c(GameRules.Q);
            IChatMutableComponent component = this.Q.a(_int) ? IChatBaseComponent.c("sleep.skipping_night") : IChatBaseComponent.a("sleep.players_sleeping", this.Q.b(), this.Q.b(_int));
            for (EntityPlayer serverPlayer : this.I) {
                serverPlayer.a(component, true);
            }
        }
    }

    public void f() {
        if (!this.I.isEmpty() && this.Q.a(this.I)) {
            this.au();
        }
    }

    public ScoreboardServer g() {
        return this.K.aJ();
    }

    private void av() {
        boolean isRaining = this.ag();
        if (this.G_().g()) {
            if (this.O().b(GameRules.w)) {
                int clearWeatherTime = this.L.f();
                int thunderTime = this.L.h();
                int rainTime = this.L.j();
                boolean isThundering = this.B.g();
                boolean isRaining1 = this.B.i();
                if (clearWeatherTime > 0) {
                    --clearWeatherTime;
                    thunderTime = isThundering ? 0 : 1;
                    rainTime = isRaining1 ? 0 : 1;
                    isThundering = false;
                    isRaining1 = false;
                } else {
                    if (thunderTime > 0) {
                        if (--thunderTime == 0) {
                            isThundering = !isThundering;
                        }
                    } else {
                        thunderTime = isThundering ? d.a(this.A) : E.a(this.A);
                    }
                    if (rainTime > 0) {
                        if (--rainTime == 0) {
                            isRaining1 = !isRaining1;
                        }
                    } else {
                        rainTime = isRaining1 ? c.a(this.A) : b.a(this.A);
                    }
                }
                this.L.b(thunderTime);
                this.L.c(rainTime);
                this.L.a(clearWeatherTime);
                this.L.setThundering(isThundering, ThunderChangeEvent.Cause.NATURAL);
                this.L.setRaining(isRaining1, WeatherChangeEvent.Cause.NATURAL);
            }
            this.y = this.z;
            this.z = this.B.g() ? (this.z += 0.01f) : (this.z -= 0.01f);
            this.z = MathHelper.a(this.z, 0.0f, 1.0f);
            this.w = this.x;
            this.x = this.B.i() ? (this.x += 0.01f) : (this.x -= 0.01f);
            this.x = MathHelper.a(this.x, 0.0f, 1.0f);
        }
        for (EntityPlayer player : this.I) {
            if (player.dV() != this) continue;
            player.tickWeather();
        }
        if (isRaining != this.ag()) {
            for (EntityPlayer player : this.I) {
                if (player.dV() != this) continue;
                player.setPlayerWeather(!isRaining ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
            }
        }
        for (EntityPlayer player : this.I) {
            if (player.dV() != this) continue;
            player.updateWeather(this.w, this.x, this.y, this.z);
        }
    }

    @VisibleForTesting
    public void h() {
        this.L.setRaining(false, WeatherChangeEvent.Cause.SLEEP);
        if (!this.L.i()) {
            this.L.c(0);
        }
        this.L.setThundering(false, ThunderChangeEvent.Cause.SLEEP);
        if (!this.L.g()) {
            this.L.b(0);
        }
    }

    public void i() {
        this.R = 0;
    }

    private void a(BlockPosition pos, FluidType fluid) {
        IBlockData blockState = this.a_(pos);
        Fluid fluidState = blockState.y();
        if (fluidState.b(fluid)) {
            fluidState.a(this, pos, blockState);
        }
        if ((++this.tickedBlocksOrFluids & 7L) != 0L) {
            this.K.moonrise$executeMidTickTasks();
        }
    }

    private void d(BlockPosition pos, Block block) {
        IBlockData blockState = this.a_(pos);
        if (blockState.a(block)) {
            blockState.a(this, pos, this.A);
        }
        if ((++this.tickedBlocksOrFluids & 7L) != 0L) {
            this.K.moonrise$executeMidTickTasks();
        }
    }

    public static List<net.minecraft.world.entity.Entity> getCurrentlyTickingEntities() {
        net.minecraft.world.entity.Entity[] entityArray;
        net.minecraft.world.entity.Entity ticking = currentlyTickingEntity.get();
        if (ticking == null) {
            entityArray = new net.minecraft.world.entity.Entity[]{};
        } else {
            net.minecraft.world.entity.Entity[] entityArray2 = new net.minecraft.world.entity.Entity[1];
            entityArray = entityArray2;
            entityArray2[0] = ticking;
        }
        List<net.minecraft.world.entity.Entity> ret = Arrays.asList(entityArray);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(net.minecraft.world.entity.Entity entity) {
        TickThread.ensureTickThread("Cannot tick an entity off-main");
        try {
            if (currentlyTickingEntity.get() == null) {
                currentlyTickingEntity.lazySet(entity);
            }
            entity.bz();
            GameProfilerFiller profilerFiller = Profiler.a();
            ++entity.af;
            ++entity.totalEntityAge;
            profilerFiller.a(() -> BuiltInRegistries.f.b(entity.aq()).toString());
            profilerFiller.f("tickNonPassenger");
            boolean isActive = ActivationRange.checkIfActive(entity);
            if (isActive) {
                entity.h();
                entity.postTick();
            } else {
                entity.inactiveTick();
            }
            profilerFiller.c();
            for (net.minecraft.world.entity.Entity entity1 : entity.cY()) {
                this.tickPassenger(entity, entity1, isActive);
            }
        }
        finally {
            if (currentlyTickingEntity.get() == entity) {
                currentlyTickingEntity.lazySet(null);
            }
        }
    }

    private void tickPassenger(net.minecraft.world.entity.Entity ridingEntity, net.minecraft.world.entity.Entity passengerEntity, boolean isActive) {
        if (passengerEntity.dQ() || passengerEntity.dk() != ridingEntity) {
            passengerEntity.ae();
        } else if (passengerEntity instanceof EntityHuman || this.N.c(passengerEntity)) {
            passengerEntity.bz();
            ++passengerEntity.af;
            ++passengerEntity.totalEntityAge;
            GameProfilerFiller profilerFiller = Profiler.a();
            profilerFiller.a(() -> BuiltInRegistries.f.b(passengerEntity.aq()).toString());
            profilerFiller.f("tickPassenger");
            if (isActive) {
                passengerEntity.r();
                passengerEntity.postTick();
            } else {
                passengerEntity.i(Vec3D.c);
                passengerEntity.inactiveTick();
                ridingEntity.j(passengerEntity);
            }
            profilerFiller.c();
            for (net.minecraft.world.entity.Entity entity : passengerEntity.cY()) {
                this.tickPassenger(passengerEntity, entity, isActive);
            }
        }
    }

    @Override
    public boolean a(EntityHuman player, BlockPosition pos) {
        return !this.K.a(this, pos, player) && this.F_().a(pos);
    }

    public void saveIncrementally(boolean doFull) {
        if (doFull) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
        }
        if (doFull) {
            this.b(true);
        }
        if (doFull) {
            WorldServer serverLevel1 = this;
            this.L.a(serverLevel1.F_().t());
            this.L.a(this.K.aM().a(this.K_()));
            this.levelStorageAccess.a(this.K.ba(), this.L, this.K.ag().r());
        }
    }

    public void a(@Nullable IProgressUpdate progress, boolean flush, boolean skipSave) {
        this.save(progress, flush, skipSave, false);
    }

    public void save(@Nullable IProgressUpdate progress, boolean flush, boolean skipSave, boolean close) {
        ChunkProviderServer chunkSource = this.m();
        if (!skipSave) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
            if (progress != null) {
                progress.a(IChatBaseComponent.c("menu.savingLevel"));
            }
            this.b(flush);
            if (progress != null) {
                progress.c(IChatBaseComponent.c("menu.savingChunks"));
            }
            if (!close) {
                chunkSource.a(flush);
            }
        }
        if (close) {
            try {
                chunkSource.close(!skipSave);
            }
            catch (IOException never) {
                throw new RuntimeException(never);
            }
        }
        WorldServer worldserver1 = this;
        this.L.a(worldserver1.F_().t());
        this.L.a(this.K.aM().a(this.K_()));
        this.levelStorageAccess.a(this.K.ba(), this.L, this.K.ag().r());
    }

    private void b(boolean join) {
        if (this.ac != null) {
            this.L.a(this.ac.b());
        }
        WorldPersistentData dataStorage = this.m().k();
        if (join) {
            dataStorage.b();
        } else {
            dataStorage.a();
        }
    }

    public <T extends net.minecraft.world.entity.Entity> List<? extends T> a(EntityTypeTest<net.minecraft.world.entity.Entity, T> typeTest, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.a(typeTest, predicate, list);
        return list;
    }

    public <T extends net.minecraft.world.entity.Entity> void a(EntityTypeTest<net.minecraft.world.entity.Entity, T> typeTest, Predicate<? super T> predicate, List<? super T> output) {
        this.a(typeTest, predicate, output, Integer.MAX_VALUE);
    }

    public <T extends net.minecraft.world.entity.Entity> void a(EntityTypeTest<net.minecraft.world.entity.Entity, T> typeTest, Predicate<? super T> predicate, List<? super T> output, int maxResults) {
        this.H().a(typeTest, (U entity) -> {
            if (predicate.test(entity)) {
                output.add((Object)entity);
                if (output.size() >= maxResults) {
                    return AbortableIterationConsumer.a.b;
                }
            }
            return AbortableIterationConsumer.a.a;
        });
    }

    public List<? extends EntityEnderDragon> j() {
        return this.a(EntityTypes.P, EntityLiving::bL);
    }

    public List<EntityPlayer> a(Predicate<? super EntityPlayer> predicate) {
        return this.a(predicate, Integer.MAX_VALUE);
    }

    public List<EntityPlayer> a(Predicate<? super EntityPlayer> predicate, int maxResults) {
        ArrayList list = Lists.newArrayList();
        for (EntityPlayer serverPlayer : this.I) {
            if (!predicate.test(serverPlayer)) continue;
            list.add(serverPlayer);
            if (list.size() < maxResults) continue;
            return list;
        }
        return list;
    }

    @Nullable
    public EntityPlayer k() {
        List<EntityPlayer> players = this.a(EntityLiving::bL);
        return players.isEmpty() ? null : players.get(this.A.a(players.size()));
    }

    @Override
    public boolean b(net.minecraft.world.entity.Entity entity) {
        return this.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Override
    public boolean addFreshEntity(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public boolean c(net.minecraft.world.entity.Entity entity) {
        return this.addWithUUID(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean addWithUUID(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public void d(net.minecraft.world.entity.Entity entity) {
        this.addDuringTeleport(entity, null);
    }

    public void addDuringTeleport(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            this.c(serverPlayer);
        } else {
            this.addEntity(entity, reason);
        }
    }

    public void a(EntityPlayer player) {
        this.c(player);
    }

    public void b(EntityPlayer player) {
        this.c(player);
    }

    private void c(EntityPlayer player) {
        net.minecraft.world.entity.Entity entity = this.H().a(player.cG());
        if (entity != null) {
            F.warn("Force-added player with duplicate UUID {}", (Object)player.cG());
            entity.ao();
            this.a((EntityPlayer)entity, Entity.RemovalReason.b);
        }
        this.moonrise$getEntityLookup().addNewEntity(player);
    }

    private boolean addEntity(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason spawnReason) {
        EntityItem itemEntity;
        AsyncCatcher.catchOp("entity add");
        entity.generation = false;
        if (entity.valid) {
            MinecraftServer.l.error("Attempted Double World add on {}", (Object)entity, (Object)new Throwable());
            return true;
        }
        if (entity.spawnReason == null) {
            entity.spawnReason = spawnReason;
        }
        if (entity.dQ()) {
            return false;
        }
        if (entity instanceof EntityItem && (itemEntity = (EntityItem)entity).l().f()) {
            return false;
        }
        if (this.captureDrops != null && entity instanceof EntityItem) {
            this.captureDrops.add((EntityItem)entity);
            return true;
        }
        if (spawnReason != null && !CraftEventFactory.doEntityAddEventCalling(this, entity, spawnReason)) {
            return false;
        }
        return this.moonrise$getEntityLookup().addNewEntity(entity);
    }

    public boolean e(net.minecraft.world.entity.Entity entity) {
        return this.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean tryAddFreshEntityWithPassengers(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        if (entity.da().map(net.minecraft.world.entity.Entity::cG).anyMatch(this.moonrise$getEntityLookup()::hasEntity)) {
            return false;
        }
        this.addFreshEntityWithPassengers(entity, reason);
        return true;
    }

    public void a(Chunk chunk) {
        for (TileEntity blockEntity : chunk.I().values()) {
            if (!(blockEntity instanceof IInventory)) continue;
            for (HumanEntity human : Lists.newArrayList(((IInventory)((Object)blockEntity)).getViewers())) {
                ((CraftHumanEntity)human).getHandle().closeUnloadedInventory(InventoryCloseEvent.Reason.UNLOADED);
            }
        }
        chunk.J();
        chunk.c(this);
    }

    public void a(EntityPlayer player, Entity.RemovalReason reason) {
        player.remove(reason, null);
    }

    public boolean strikeLightning(net.minecraft.world.entity.Entity entitylightning) {
        return this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.UNKNOWN);
    }

    public boolean strikeLightning(net.minecraft.world.entity.Entity entitylightning, LightningStrikeEvent.Cause cause) {
        LightningStrikeEvent lightning = CraftEventFactory.callLightningStrikeEvent((LightningStrike)entitylightning.getBukkitEntity(), cause);
        if (lightning.isCancelled()) {
            return false;
        }
        return this.b(entitylightning);
    }

    @Override
    public void a(int breakerId, BlockPosition pos, int progress) {
        EntityHuman breakerPlayer = null;
        net.minecraft.world.entity.Entity entity = this.a(breakerId);
        if (entity instanceof EntityHuman) {
            breakerPlayer = (EntityHuman)entity;
        }
        if (entity != null) {
            float progressFloat = (float)MathHelper.a(progress, 0, 10) / 10.0f;
            CraftBlock bukkitBlock = CraftBlock.at(this, pos);
            new BlockBreakProgressUpdateEvent((org.bukkit.block.Block)bukkitBlock, progressFloat, (Entity)entity.getBukkitEntity()).callEvent();
        }
        for (EntityPlayer serverPlayer : this.K.ag().t()) {
            if (serverPlayer == null || serverPlayer.dV() != this || serverPlayer.ar() == breakerId) continue;
            double d2 = (double)pos.u() - serverPlayer.dA();
            double d1 = (double)pos.v() - serverPlayer.dC();
            double d22 = (double)pos.w() - serverPlayer.dG();
            if (breakerPlayer != null && !serverPlayer.getBukkitEntity().canSee(breakerPlayer.getBukkitEntity()) || !(d2 * d2 + d1 * d1 + d22 * d22 < 1024.0)) continue;
            serverPlayer.f.b(new PacketPlayOutBlockBreakAnimation(breakerId, pos, progress));
        }
    }

    @Override
    public void a(@Nullable EntityHuman player, double x2, double y2, double z2, Holder<SoundEffect> sound, SoundCategory category, float volume, float pitch, long seed) {
        this.K.ag().a(player, x2, y2, z2, sound.a().a(volume), this.ai(), new PacketPlayOutNamedSoundEffect(sound, category, x2, y2, z2, volume, pitch, seed));
    }

    @Override
    public void a(@Nullable EntityHuman player, net.minecraft.world.entity.Entity entity, Holder<SoundEffect> sound, SoundCategory category, float volume, float pitch, long seed) {
        this.K.ag().a(player, entity.dA(), entity.dC(), entity.dG(), sound.a().a(volume), this.ai(), new PacketPlayOutEntitySound(sound, category, entity, volume, pitch, seed));
    }

    @Override
    public void b(int id, BlockPosition pos, int data) {
        if (this.O().b(GameRules.X)) {
            this.K.ag().t().forEach(player -> {
                Vec3D vec31;
                if (player.dV() == this) {
                    Vec3D vec3 = Vec3D.b(pos);
                    if (player.g(vec3) < (double)MathHelper.h(32)) {
                        vec31 = vec3;
                    } else {
                        Vec3D vec32 = vec3.d(player.dt()).d();
                        vec31 = player.dt().e(vec32.c(32.0));
                    }
                } else {
                    vec31 = player.dt();
                }
                player.f.b(new PacketPlayOutWorldEvent(id, BlockPosition.a(vec31), data, true));
            });
        } else {
            this.a(null, id, pos, data);
        }
    }

    @Override
    public void a(@Nullable EntityHuman player, int type, BlockPosition pos, int data) {
        this.K.ag().a(player, pos.u(), pos.v(), pos.w(), 64.0, this.ai(), new PacketPlayOutWorldEvent(type, pos, data, false));
    }

    public int l() {
        return this.G_().p();
    }

    @Override
    public void a(Holder<GameEvent> gameEvent, Vec3D pos, GameEvent.a context) {
        if (this.getChunkIfLoadedImmediately(MathHelper.a(pos.d) >> 4, MathHelper.a(pos.f) >> 4) == null) {
            return;
        }
        this.P.a(gameEvent, pos, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(BlockPosition pos, IBlockData oldState, IBlockData newState, int flags) {
        VoxelShape collisionShape1;
        VoxelShape collisionShape;
        if (this.X) {
            String string = "recursive call to sendBlockUpdated";
            SystemUtils.a("recursive call to sendBlockUpdated", (Throwable)new IllegalStateException("recursive call to sendBlockUpdated"));
        }
        this.m().a(pos);
        this.V.a(pos);
        if (this.paperConfig().misc.updatePathfindingOnBlockUpdate && VoxelShapes.c(collisionShape = oldState.g(this, pos), collisionShape1 = newState.g(this, pos), OperatorBoolean.g)) {
            ObjectArrayList list = new ObjectArrayList();
            try {
                for (EntityInsentient mob : this.W) {
                    NavigationAbstract navigation = mob.P();
                    if (!navigation.b(pos)) continue;
                    list.add(navigation);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                this.a(pos, oldState, newState, flags);
                return;
            }
            try {
                this.X = true;
                for (NavigationAbstract pathNavigation : list) {
                    pathNavigation.h();
                }
            }
            finally {
                this.X = false;
            }
        }
    }

    @Override
    public void a(BlockPosition pos, Block block) {
        if (this.captureBlockStates) {
            return;
        }
        this.a(pos, block, ExperimentalRedstoneUtils.a(this, null, null));
    }

    @Override
    public void a(BlockPosition pos, Block block, @Nullable Orientation orientation) {
        if (this.captureBlockStates) {
            return;
        }
        this.t.a(pos, block, null, orientation);
    }

    @Override
    public void a(BlockPosition pos, Block block, EnumDirection facing, @Nullable Orientation orientation) {
        this.t.a(pos, block, facing, orientation);
    }

    @Override
    public void b(BlockPosition pos, Block block, @Nullable Orientation orientation) {
        this.t.a(pos, block, orientation);
    }

    @Override
    public void a(IBlockData state, BlockPosition pos, Block block, @Nullable Orientation orientation, boolean movedByPiston) {
        this.t.a(state, pos, block, orientation, movedByPiston);
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, byte state) {
        this.m().a(entity, new PacketPlayOutEntityStatus(entity, state));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, DamageSource damageSource) {
        this.m().a(entity, new ClientboundDamageEventPacket(entity, damageSource));
    }

    public ChunkProviderServer m() {
        return this.J;
    }

    @Override
    public void a(@Nullable net.minecraft.world.entity.Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x2, double y2, double z2, float radius, boolean fire, World.a explosionInteraction, ParticleParam smallExplosionParticles, ParticleParam largeExplosionParticles, Holder<SoundEffect> explosionSound) {
        this.explode0(source, damageSource, damageCalculator, x2, y2, z2, radius, fire, explosionInteraction, smallExplosionParticles, largeExplosionParticles, explosionSound);
    }

    public ServerExplosion explode0(@Nullable net.minecraft.world.entity.Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x2, double y2, double z2, float radius, boolean fire, World.a explosionInteraction, ParticleParam smallExplosionParticles, ParticleParam largeExplosionParticles, Holder<SoundEffect> explosionSound) {
        return this.explode0(source, damageSource, damageCalculator, x2, y2, z2, radius, fire, explosionInteraction, smallExplosionParticles, largeExplosionParticles, explosionSound, null);
    }

    public ServerExplosion explode0(@Nullable net.minecraft.world.entity.Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x2, double y2, double z2, float radius, boolean fire, World.a explosionInteraction, ParticleParam smallExplosionParticles, ParticleParam largeExplosionParticles, Holder<SoundEffect> explosionSound, @Nullable Consumer<ServerExplosion> configurator) {
        Explosion.Effect blockInteraction = switch (explosionInteraction) {
            default -> throw new MatchException(null, null);
            case World.a.a -> Explosion.Effect.a;
            case World.a.b -> this.a(GameRules.R);
            case World.a.c -> {
                if (this.O().b(GameRules.c)) {
                    yield this.a(GameRules.S);
                }
                yield Explosion.Effect.a;
            }
            case World.a.d -> this.a(GameRules.T);
            case World.a.e -> Explosion.Effect.d;
            case World.a.STANDARD -> Explosion.Effect.b;
        };
        Vec3D vec3 = new Vec3D(x2, y2, z2);
        ServerExplosion serverExplosion = new ServerExplosion(this, source, damageSource, damageCalculator, vec3, radius, fire, blockInteraction);
        if (configurator != null) {
            configurator.accept(serverExplosion);
        }
        serverExplosion.i();
        if (serverExplosion.wasCanceled) {
            return serverExplosion;
        }
        ParticleParam particleOptions = serverExplosion.l() ? smallExplosionParticles : largeExplosionParticles;
        for (EntityPlayer serverPlayer : this.I) {
            if (!(serverPlayer.g(vec3) < 4096.0)) continue;
            Optional<Vec3D> optional = Optional.ofNullable(serverExplosion.j().get(serverPlayer));
            serverPlayer.f.b(new PacketPlayOutExplosion(vec3, optional, particleOptions, explosionSound));
        }
        return serverExplosion;
    }

    private Explosion.Effect a(GameRules.GameRuleKey<GameRules.GameRuleBoolean> decayGameRule) {
        return this.O().b(decayGameRule) ? Explosion.Effect.c : Explosion.Effect.b;
    }

    @Override
    public void a(BlockPosition pos, Block block, int eventID, int eventParam) {
        this.Y.add((Object)new BlockActionData(pos, block, eventID, eventParam));
    }

    private void aw() {
        this.Z.clear();
        while (!this.Y.isEmpty()) {
            BlockActionData blockEventData = (BlockActionData)this.Y.removeFirst();
            if (this.n(blockEventData.a())) {
                if (!this.a(blockEventData)) continue;
                this.K.ag().a(null, blockEventData.a().u(), blockEventData.a().v(), blockEventData.a().w(), 64.0, this.ai(), new PacketPlayOutBlockAction(blockEventData.a(), blockEventData.b(), blockEventData.c(), blockEventData.d()));
                continue;
            }
            this.Z.add(blockEventData);
        }
        this.Y.addAll(this.Z);
    }

    private boolean a(BlockActionData event) {
        IBlockData blockState = this.a_(event.a());
        return blockState.a(event.b()) && blockState.a((net.minecraft.world.level.World)this, event.a(), event.c(), event.d());
    }

    public TickListServer<Block> n() {
        return this.T;
    }

    public TickListServer<FluidType> o() {
        return this.U;
    }

    @Override
    @Nonnull
    public MinecraftServer p() {
        return this.K;
    }

    public PortalTravelAgent q() {
        return this.S;
    }

    public StructureTemplateManager r() {
        return this.K.aY();
    }

    public <T extends ParticleParam> int a(T type, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
        return this.sendParticlesSource(null, type, false, false, posX, posY, posZ, particleCount, xOffset, yOffset, zOffset, speed);
    }

    public <T extends ParticleParam> int a(T type, boolean overrideLimiter, boolean alwaysShow, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
        return this.sendParticlesSource(null, type, overrideLimiter, alwaysShow, posX, posY, posZ, particleCount, xOffset, yOffset, zOffset, speed);
    }

    public <T extends ParticleParam> int sendParticlesSource(@Nullable net.minecraft.world.entity.Entity sender, T type, boolean overrideLimiter, boolean alwaysShow, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
        return this.sendParticlesSource(this.I, sender, type, overrideLimiter, alwaysShow, posX, posY, posZ, particleCount, xOffset, yOffset, zOffset, speed);
    }

    public <T extends ParticleParam> int sendParticlesSource(List<EntityPlayer> receivers, @Nullable net.minecraft.world.entity.Entity sender, T type, boolean overrideLimiter, boolean alwaysShow, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
        PacketPlayOutWorldParticles clientboundLevelParticlesPacket = new PacketPlayOutWorldParticles(type, overrideLimiter, alwaysShow, posX, posY, posZ, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, particleCount);
        int i2 = 0;
        for (int i1 = 0; i1 < receivers.size(); ++i1) {
            EntityPlayer serverPlayer = receivers.get(i1);
            if (sender != null && !serverPlayer.getBukkitEntity().canSee(sender.getBukkitEntity()) || !this.a(serverPlayer, overrideLimiter, posX, posY, posZ, clientboundLevelParticlesPacket)) continue;
            ++i2;
        }
        return i2;
    }

    public <T extends ParticleParam> boolean a(EntityPlayer player, T particle, boolean overrideLimiter, boolean alwaysShow, double posX, double posY, double posZ, int count, double xDist, double yDist, double zDist, double maxSpeed) {
        PacketPlayOutWorldParticles packet = new PacketPlayOutWorldParticles(particle, overrideLimiter, alwaysShow, posX, posY, posZ, (float)xDist, (float)yDist, (float)zDist, (float)maxSpeed, count);
        return this.a(player, overrideLimiter, posX, posY, posZ, packet);
    }

    private boolean a(EntityPlayer player, boolean longDistance, double posX, double posY, double posZ, Packet<?> packet) {
        if (player.dV() != this) {
            return false;
        }
        BlockPosition blockPos = player.dv();
        if (blockPos.a(new Vec3D(posX, posY, posZ), longDistance ? 512.0 : 32.0)) {
            player.f.b(packet);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public net.minecraft.world.entity.Entity a(int id) {
        return this.H().a(id);
    }

    @Nullable
    public net.minecraft.world.entity.Entity a(UUID uniqueId) {
        return this.H().a(uniqueId);
    }

    @Deprecated
    @Nullable
    public net.minecraft.world.entity.Entity b(int id) {
        net.minecraft.world.entity.Entity entity = this.H().a(id);
        return entity != null ? entity : (net.minecraft.world.entity.Entity)this.ad.get(id);
    }

    @Override
    public Collection<EntityComplexPart> s() {
        return this.ad.values();
    }

    @Nullable
    public BlockPosition a(TagKey<Structure> structureTag, BlockPosition pos, int radius, boolean skipExistingChunks) {
        if (!this.L.y().d()) {
            return null;
        }
        Optional optional = this.K_().e(Registries.aU).a(structureTag);
        if (optional.isEmpty()) {
            return null;
        }
        Pair<BlockPosition, Holder<Structure>> pair = this.m().g().a(this, (HolderSet)optional.get(), pos, radius, skipExistingChunks);
        return pair != null ? (BlockPosition)pair.getFirst() : null;
    }

    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> a(Predicate<Holder<BiomeBase>> biomePredicate, BlockPosition pos, int radius, int horizontalStep, int verticalStep) {
        return this.m().g().d().a(pos, radius, horizontalStep, verticalStep, biomePredicate, this.m().i().b(), this);
    }

    public CraftingManager t() {
        return this.K.aI();
    }

    @Override
    public TickRateManager u() {
        return this.K.aP();
    }

    @Override
    public boolean v() {
        return this.e;
    }

    public WorldPersistentData w() {
        return this.m().k();
    }

    @Override
    @Nullable
    public WorldMap a(MapId mapId) {
        WorldPersistentData storage = this.p().J().w();
        Optional<PersistentBase> cacheEntry = storage.b.get(mapId.a());
        if (cacheEntry == null) {
            WorldMap mapData = storage.b(WorldMap.a(), mapId.a());
            if (mapData != null) {
                mapData.id = mapId;
                new MapInitializeEvent((MapView)mapData.mapView).callEvent();
                return mapData;
            }
            return null;
        }
        Object var5_6 = cacheEntry.orElse(null);
        if (var5_6 instanceof WorldMap) {
            WorldMap mapItemSavedData = var5_6;
            mapItemSavedData.id = mapId;
            return mapItemSavedData;
        }
        return null;
    }

    @Override
    public void a(MapId mapId, WorldMap mapData) {
        mapData.id = mapId;
        MapInitializeEvent event = new MapInitializeEvent((MapView)mapData.mapView);
        event.callEvent();
        this.p().J().w().a(mapId.a(), mapData);
    }

    @Override
    public MapId x() {
        return this.p().J().w().a(PersistentIdCounts.a(), "idcounts").b();
    }

    public void a(BlockPosition pos, float angle) {
        int i2;
        BlockPosition spawnPos = this.B.a();
        float spawnAngle = this.B.b();
        if (!spawnPos.equals(pos) || spawnAngle != angle) {
            Location prevSpawnLoc = this.getWorld().getSpawnLocation();
            this.B.a(pos, angle);
            new SpawnChangeEvent((World)this.getWorld(), prevSpawnLoc).callEvent();
            this.p().ag().a(new PacketPlayOutSpawnPosition(pos, angle));
        }
        if (this.M > 1) {
            for (ChunkCoordIntPair chunkPos : MCUtil.getSpiralOutChunks(spawnPos, this.M - 2)) {
                this.m().removeTicketAtLevel(TicketType.a, chunkPos, 31, Unit.a);
            }
        }
        if ((i2 = this.O().c(GameRules.ab) + 1) > 1) {
            for (ChunkCoordIntPair chunkPos : MCUtil.getSpiralOutChunks(pos, i2 - 2)) {
                this.m().addTicketAtLevel(TicketType.a, chunkPos, 31, Unit.a);
            }
        }
        this.M = i2;
    }

    public LongSet y() {
        ForcedChunk forcedChunksSavedData = this.w().b(ForcedChunk.a(), "chunks");
        return forcedChunksSavedData != null ? LongSets.unmodifiable((LongSet)forcedChunksSavedData.b()) : LongSets.EMPTY_SET;
    }

    public boolean a(int chunkX, int chunkZ, boolean add) {
        boolean flag;
        ForcedChunk forcedChunksSavedData = this.w().a(ForcedChunk.a(), "chunks");
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(chunkX, chunkZ);
        long packedChunkPos = chunkPos.a();
        if (add) {
            flag = forcedChunksSavedData.b().add(packedChunkPos);
            if (flag) {
                this.d(chunkX, chunkZ);
            }
        } else {
            flag = forcedChunksSavedData.b().remove(packedChunkPos);
        }
        forcedChunksSavedData.a(flag);
        if (flag) {
            this.m().a(chunkPos, add);
        }
        return flag;
    }

    public List<EntityPlayer> z() {
        return this.I;
    }

    @Override
    public void a(BlockPosition pos, IBlockData blockState, IBlockData newState) {
        Optional<Holder<VillagePlaceType>> optional1;
        Optional<Holder<VillagePlaceType>> optional = PoiTypes.a(blockState);
        if (!Objects.equals(optional, optional1 = PoiTypes.a(newState))) {
            BlockPosition blockPos = pos.j();
            optional.ifPresent(poiType -> this.p().execute(() -> {
                this.A().a(blockPos);
                PacketDebug.b(this, blockPos);
            }));
            optional1.ifPresent(poiType -> this.p().execute(() -> {
                if (optional.isEmpty() && this.A().a(blockPos, (Holder<VillagePlaceType> ignored) -> true)) {
                    this.A().a(blockPos);
                }
                this.A().a(blockPos, (Holder<VillagePlaceType>)poiType);
                PacketDebug.a(this, blockPos);
            }));
        }
    }

    public VillagePlace A() {
        return this.m().l();
    }

    public boolean c(BlockPosition pos) {
        return this.a(pos, 1);
    }

    public boolean a(SectionPosition pos) {
        return this.c(pos.k());
    }

    public boolean a(BlockPosition pos, int sections) {
        return sections <= 6 && this.b(SectionPosition.a(pos)) <= sections;
    }

    public int b(SectionPosition pos) {
        return this.A().a(pos);
    }

    public PersistentRaid B() {
        return this.f;
    }

    @Nullable
    public Raid d(BlockPosition pos) {
        return this.f.a(pos, 9216);
    }

    public boolean e(BlockPosition pos) {
        return this.d(pos) != null;
    }

    public void a(ReputationEvent type, net.minecraft.world.entity.Entity target, ReputationHandler host) {
        host.a(type, target);
    }

    public void a(Path path) throws IOException {
        Path path2;
        BufferedWriter bufferedWriter3;
        PlayerChunkMap chunkMap = this.m().a;
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path.resolve("stats.txt"), new OpenOption[0]);){
            bufferedWriter.write(String.format(Locale.ROOT, "spawning_chunks: %d\n", chunkMap.j().b()));
            SpawnerCreature.d lastSpawnState = this.m().n();
            if (lastSpawnState != null) {
                for (Object2IntMap.Entry entry : lastSpawnState.b().object2IntEntrySet()) {
                    bufferedWriter.write(String.format(Locale.ROOT, "spawn_count.%s: %d\n", ((EnumCreatureType)entry.getKey()).a(), entry.getIntValue()));
                }
            }
            bufferedWriter.write(String.format(Locale.ROOT, "entities: %s\n", this.moonrise$getEntityLookup().getDebugInfo()));
            bufferedWriter.write(String.format(Locale.ROOT, "block_entity_tickers: %d\n", this.s.size()));
            bufferedWriter.write(String.format(Locale.ROOT, "block_ticks: %d\n", this.n().a()));
            bufferedWriter.write(String.format(Locale.ROOT, "fluid_ticks: %d\n", this.o().a()));
            bufferedWriter.write("distance_manager: " + chunkMap.j().d() + "\n");
            bufferedWriter.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.m().f()));
        }
        CrashReport crashReport = new CrashReport("Level dump", new Exception("dummy"));
        this.a(crashReport);
        try (BufferedWriter bufferedWriter1 = Files.newBufferedWriter(path.resolve("example_crash.txt"), new OpenOption[0]);){
            bufferedWriter1.write(crashReport.a(ReportType.c));
        }
        Path path1 = path.resolve("chunks.csv");
        BufferedWriter bufferedWriter2 = Files.newBufferedWriter(path1, new OpenOption[0]);
        if (bufferedWriter2 != null) {
            ((Writer)bufferedWriter2).close();
        }
        if ((bufferedWriter3 = Files.newBufferedWriter(path2 = path.resolve("entity_chunks.csv"), new OpenOption[0])) != null) {
            ((Writer)bufferedWriter3).close();
        }
        Path path3 = path.resolve("entities.csv");
        try (BufferedWriter bufferedWriter4 = Files.newBufferedWriter(path3, new OpenOption[0]);){
            WorldServer.a(bufferedWriter4, this.H().a());
        }
        Path path4 = path.resolve("block_entities.csv");
        try (BufferedWriter bufferedWriter5 = Files.newBufferedWriter(path4, new OpenOption[0]);){
            this.a(bufferedWriter5);
        }
    }

    private static void a(Writer writer, Iterable<net.minecraft.world.entity.Entity> entities) throws IOException {
        CSVWriter csvOutput = CSVWriter.a().a("x").a("y").a("z").a("uuid").a("type").a("alive").a("display_name").a("custom_name").a(writer);
        for (net.minecraft.world.entity.Entity entity : entities) {
            IChatBaseComponent customName = entity.an();
            IChatBaseComponent displayName = entity.p_();
            csvOutput.a(entity.dA(), entity.dC(), entity.dG(), entity.cG(), BuiltInRegistries.f.b(entity.aq()), entity.bL(), displayName.getString(), customName != null ? customName.getString() : null);
        }
    }

    private void a(Writer output) throws IOException {
        CSVWriter csvOutput = CSVWriter.a().a("x").a("y").a("z").a("type").a(output);
        for (TickingBlockEntity tickingBlockEntity : this.s) {
            BlockPosition pos = tickingBlockEntity.c();
            csvOutput.a(pos.u(), pos.v(), pos.w(), tickingBlockEntity.d());
        }
    }

    @VisibleForTesting
    public void a(StructureBoundingBox boundingBox) {
        this.Y.removeIf(blockEventData -> boundingBox.b(blockEventData.a()));
    }

    @Override
    public void b(BlockPosition pos, Block block) {
        if (!this.aj()) {
            if (this.populating) {
                return;
            }
            this.a(pos, block);
        }
    }

    @Override
    public float a(EnumDirection direction, boolean shade) {
        return 1.0f;
    }

    public Iterable<net.minecraft.world.entity.Entity> C() {
        return this.H().a();
    }

    public String toString() {
        return "ServerLevel[" + this.L.e() + "]";
    }

    public boolean D() {
        return this.L.z();
    }

    @Override
    public long E() {
        return this.L.y().c();
    }

    @Nullable
    public EnderDragonBattle F() {
        return this.ac;
    }

    @Override
    public WorldServer a() {
        return this;
    }

    @VisibleForTesting
    public String G() {
        return String.format(Locale.ROOT, "players: %s, entities: %s [%s], block_entities: %d [%s], block_ticks: %d, fluid_ticks: %d, chunk_source: %s", this.I.size(), this.moonrise$getEntityLookup().getDebugInfo(), WorldServer.a(this.moonrise$getEntityLookup().a(), (T entity) -> BuiltInRegistries.f.b(entity.aq()).toString()), this.s.size(), WorldServer.a(this.s, TickingBlockEntity::d), this.n().a(), this.o().a(), this.J());
    }

    private static <T> String a(Iterable<T> objects, Function<T, String> typeGetter) {
        try {
            Object2IntOpenHashMap map = new Object2IntOpenHashMap();
            for (T object : objects) {
                String string = typeGetter.apply(object);
                map.addTo((Object)string, 1);
            }
            return map.object2IntEntrySet().stream().sorted(Comparator.comparing(Object2IntMap.Entry::getIntValue).reversed()).limit(5L).map(entry -> (String)entry.getKey() + ":" + entry.getIntValue()).collect(Collectors.joining(","));
        }
        catch (Exception var6) {
            return "";
        }
    }

    @Override
    public LevelEntityGetter<net.minecraft.world.entity.Entity> H() {
        AsyncCatcher.catchOp("Chunk getEntities call");
        return this.moonrise$getEntityLookup();
    }

    public void a(Stream<net.minecraft.world.entity.Entity> entities) {
        this.addLegacyChunkEntities(entities, null);
    }

    public void addLegacyChunkEntities(Stream<net.minecraft.world.entity.Entity> entities, ChunkCoordIntPair chunkPos) {
        this.moonrise$getEntityLookup().addLegacyChunkEntities(entities.toList(), chunkPos);
    }

    public void b(Stream<net.minecraft.world.entity.Entity> entities) {
        this.addWorldGenChunkEntities(entities, null);
    }

    public void addWorldGenChunkEntities(Stream<net.minecraft.world.entity.Entity> entities, ChunkCoordIntPair chunkPos) {
        this.moonrise$getEntityLookup().addWorldGenChunkEntities(entities.toList(), chunkPos);
    }

    public void b(Chunk chunk) {
        chunk.d(this.D_().c());
    }

    public void a(IChunkAccess chunk) {
        this.K.execute(() -> this.af.a(chunk.f(), chunk.g()));
    }

    public PathTypeCache I() {
        return this.V;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public String J() {
        return "Chunks[S] W: " + this.J.e() + " E: " + this.moonrise$getEntityLookup().getDebugInfo();
    }

    public boolean c(long chunkPos) {
        return this.moonrise$getAnyChunkIfLoaded(CoordinateUtils.getChunkX(chunkPos), CoordinateUtils.getChunkZ(chunkPos)) != null;
    }

    private boolean d(long chunkPos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return chunkHolder != null && chunkHolder.isTickingReady();
    }

    public boolean f(BlockPosition pos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    public boolean g(BlockPosition pos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    public boolean a(ChunkCoordIntPair chunkPos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(chunkPos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    @Override
    public FeatureFlagSet K() {
        return this.K.aZ().K();
    }

    @Override
    public PotionBrewer L() {
        return this.K.bn();
    }

    @Override
    public FuelValues M() {
        return this.K.bo();
    }

    public RandomSource a(MinecraftKey location) {
        return this.ah.a(location);
    }

    public RandomSequences N() {
        return this.ah;
    }

    public GameRules O() {
        return this.L.o();
    }

    public List<EntityPlayer> getPlayersForGlobalSoundGamerule() {
        return this.O().b(GameRules.X) ? this.p().ag().l : this.z();
    }

    public double getGlobalSoundRangeSquared(Function<SpigotWorldConfig, Integer> rangeFunction) {
        double range = rangeFunction.apply(this.spigotConfig).intValue();
        return range <= 0.0 ? 4096.0 : range * range;
    }

    public void checkCapturedTreeStateForObserverNotify(BlockPosition pos, CraftBlockState craftBlockState) {
        if (craftBlockState.getPosition().v() == pos.v() && this.a_(craftBlockState.getPosition()) == craftBlockState.getHandle()) {
            this.notifyAndUpdatePhysics(craftBlockState.getPosition(), null, craftBlockState.getHandle(), craftBlockState.getHandle(), craftBlockState.getHandle(), craftBlockState.getFlag(), 512);
        }
    }

    @Override
    public CrashReportSystemDetails a(CrashReport report) {
        CrashReportSystemDetails crashReportCategory = super.a(report);
        crashReportCategory.a("Loaded entity count", () -> String.valueOf(this.moonrise$getEntityLookup().getEntityCount()));
        return crashReportCategory;
    }

    @Override
    public int P() {
        return this.J.g().f();
    }

    @Override
    public WireHandler getWireHandler() {
        return this.wireHandler;
    }

    @Override
    @Nullable
    public EntityHuman getGlobalPlayerByUUID(UUID uuid) {
        return this.K.ag().a(uuid);
    }

    public long getLagCompensationTick() {
        return this.lagCompensationTick;
    }

    public void updateLagCompensationTick() {
        this.lagCompensationTick = (System.nanoTime() - MinecraftServer.SERVER_INIT) / TimeUnit.MILLISECONDS.toNanos(50L);
    }

    final class a
    implements LevelCallback<net.minecraft.world.entity.Entity> {
        a() {
        }

        @Override
        public void a(net.minecraft.world.entity.Entity entity) {
        }

        @Override
        public void b(net.minecraft.world.entity.Entity entity) {
            WorldServer.this.g().a(entity);
        }

        @Override
        public void c(net.minecraft.world.entity.Entity entity) {
            if (entity instanceof Marker && !WorldServer.this.paperConfig().entities.markers.tick) {
                return;
            }
            WorldServer.this.N.a(entity);
        }

        @Override
        public void d(net.minecraft.world.entity.Entity entity) {
            WorldServer.this.N.b(entity);
            if (WorldServer.this.paperConfig().fixes.disableUnloadedChunkEnderpearlExploit && WorldServer.this.paperConfig().misc.legacyEnderPearlBehavior && entity instanceof EntityEnderPearl) {
                EntityEnderPearl pearl = (EntityEnderPearl)entity;
                pearl.b = null;
                ((IProjectile)pearl).a = null;
            }
        }

        @Override
        public void e(net.minecraft.world.entity.Entity entity) {
            AsyncCatcher.catchOp("entity register");
            if (entity instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)entity;
                WorldServer.this.I.add(serverPlayer);
                WorldServer.this.f();
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient mob = (EntityInsentient)entity;
                WorldServer.this.W.add(mob);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon enderDragon = (EntityEnderDragon)entity;
                for (EntityComplexPart enderDragonPart : enderDragon.x()) {
                    WorldServer.this.ad.put(enderDragonPart.ar(), (Object)enderDragonPart);
                }
            }
            entity.a(DynamicGameEventListener::a);
            entity.inWorld = true;
            entity.valid = true;
            WorldServer.this.m().b(entity);
            if (entity.getOriginVector() == null) {
                entity.setOrigin(entity.getBukkitEntity().getLocation());
            }
            if (entity.getOriginWorld() == null) {
                entity.setOrigin(entity.getOriginVector().toLocation((World)WorldServer.this.getWorld()));
            }
            new EntityAddToWorldEvent((Entity)entity.getBukkitEntity(), (World)WorldServer.this.getWorld()).callEvent();
        }

        @Override
        public void f(net.minecraft.world.entity.Entity entity) {
            AsyncCatcher.catchOp("entity unregister");
            if (entity instanceof EntityHuman) {
                EntityHuman player = (EntityHuman)entity;
                for (WorldServer level : WorldServer.this.p().L()) {
                    for (Optional<PersistentBase> savedData : level.w().b.values()) {
                        PersistentBase persistentBase;
                        if (savedData.isEmpty() || !((persistentBase = savedData.get()) instanceof WorldMap)) continue;
                        WorldMap map = (WorldMap)persistentBase;
                        map.p.remove(player);
                        if (!map.o.removeIf(holdingPlayer -> holdingPlayer.a == player)) continue;
                        map.r.remove(player.al().getString());
                    }
                }
            }
            if (entity.getBukkitEntity() instanceof InventoryHolder && (!(entity instanceof EntityPlayer) || entity.dR() != Entity.RemovalReason.a)) {
                Object merchant;
                CraftEntity craftEntity = entity.getBukkitEntity();
                if (craftEntity instanceof Merchant && (merchant = (Merchant)craftEntity).getTrader() != null) {
                    merchant.getTrader().closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                }
                for (HumanEntity h2 : Lists.newArrayList((Iterable)((InventoryHolder)entity.getBukkitEntity()).getInventory().getViewers())) {
                    h2.closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                }
            }
            WorldServer.this.m().a(entity);
            if (entity instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)entity;
                WorldServer.this.I.remove(serverPlayer);
                WorldServer.this.f();
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient mob = (EntityInsentient)entity;
                WorldServer.this.W.remove(mob);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon enderDragon = (EntityEnderDragon)entity;
                for (HumanEntity enderDragonPart : enderDragon.x()) {
                    WorldServer.this.ad.remove(enderDragonPart.ar());
                }
            }
            entity.a(DynamicGameEventListener::b);
            entity.valid = false;
            if (!(entity instanceof EntityPlayer)) {
                for (EntityPlayer player : WorldServer.this.K.ag().l) {
                    player.getBukkitEntity().onEntityRemove(entity);
                }
            }
            new EntityRemoveFromWorldEvent((Entity)entity.getBukkitEntity(), (World)WorldServer.this.getWorld()).callEvent();
        }

        @Override
        public void g(net.minecraft.world.entity.Entity entity) {
            entity.a(DynamicGameEventListener::c);
        }
    }
}

