/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutLightUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutMultiBlockChange;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.lighting.LevelLightEngine;

public class PlayerChunk
extends GenerationChunkHolder
implements ChunkSystemChunkHolder {
    public static final ChunkResult<Chunk> a = ChunkResult.a("Unloaded level chunk");
    private static final CompletableFuture<ChunkResult<Chunk>> e = CompletableFuture.completedFuture(a);
    private final LevelHeightAccessor f;
    private boolean m;
    private final ShortSet[] n;
    private final BitSet o = new BitSet();
    private final BitSet p = new BitSet();
    private final LevelLightEngine q;
    public final b s;
    private NewChunkHolder newChunkHolder;
    private static final EntityPlayer[] EMPTY_PLAYER_ARRAY = new EntityPlayer[0];
    private final ReferenceList<EntityPlayer> playersSentChunkTo = new ReferenceList<EntityPlayer>(EMPTY_PLAYER_ARRAY);

    private PlayerChunkMap getChunkMap() {
        return (PlayerChunkMap)this.s;
    }

    @Override
    public final NewChunkHolder moonrise$getRealChunkHolder() {
        return this.newChunkHolder;
    }

    @Override
    public final void moonrise$setRealChunkHolder(NewChunkHolder newChunkHolder) {
        this.newChunkHolder = newChunkHolder;
    }

    @Override
    public final void moonrise$addReceivedChunk(EntityPlayer player) {
        if (!this.playersSentChunkTo.add(player)) {
            throw new IllegalStateException("Already sent chunk " + String.valueOf(this.d) + " in world '" + WorldUtil.getWorldName(this.getChunkMap().t) + "' to player " + String.valueOf(player));
        }
    }

    @Override
    public final void moonrise$removeReceivedChunk(EntityPlayer player) {
        if (!this.playersSentChunkTo.remove(player)) {
            throw new IllegalStateException("Already sent chunk " + String.valueOf(this.d) + " in world '" + WorldUtil.getWorldName(this.getChunkMap().t) + "' to player " + String.valueOf(player));
        }
    }

    @Override
    public final boolean moonrise$hasChunkBeenSent() {
        return this.playersSentChunkTo.size() != 0;
    }

    @Override
    public final boolean moonrise$hasChunkBeenSent(EntityPlayer to) {
        return this.playersSentChunkTo.contains(to);
    }

    @Override
    public final List<EntityPlayer> moonrise$getPlayers(boolean onlyOnWatchDistanceEdge) {
        ArrayList<EntityPlayer> ret = new ArrayList<EntityPlayer>();
        EntityPlayer[] raw = this.playersSentChunkTo.getRawDataUnchecked();
        int len = this.playersSentChunkTo.size();
        for (int i2 = 0; i2 < len; ++i2) {
            EntityPlayer player = raw[i2];
            if (onlyOnWatchDistanceEdge && !this.getChunkMap().t.moonrise$getPlayerChunkLoader().isChunkSent(player, this.d.h, this.d.i, onlyOnWatchDistanceEdge)) continue;
            ret.add(player);
        }
        return ret;
    }

    @Override
    public final Chunk moonrise$getFullChunk() {
        IChunkAccess iChunkAccess;
        if (this.newChunkHolder.isFullChunkReady() && (iChunkAccess = this.newChunkHolder.getCurrentChunk()) instanceof Chunk) {
            Chunk levelChunk = (Chunk)iChunkAccess;
            return levelChunk;
        }
        return null;
    }

    private boolean isRadiusLoaded(int radius) {
        ChunkHolderManager manager = this.getChunkMap().t.moonrise$getChunkTaskScheduler().chunkHolderManager;
        ChunkCoordIntPair pos = this.d;
        int chunkX = pos.h;
        int chunkZ = pos.i;
        for (int dz = -radius; dz <= radius; ++dz) {
            for (int dx = -radius; dx <= radius; ++dx) {
                NewChunkHolder holder;
                if ((dx | dz) == 0 || (holder = manager.getChunkHolder(dx + chunkX, dz + chunkZ)) != null && holder.isFullChunkReady()) continue;
                return false;
            }
        }
        return true;
    }

    public PlayerChunk(ChunkCoordIntPair pos, int ticketLevel, LevelHeightAccessor levelHeightAccessor, LevelLightEngine lightEngine, a onLevelChange, b playerProvider) {
        super(pos);
        this.f = levelHeightAccessor;
        this.q = lightEngine;
        this.s = playerProvider;
        this.a(ticketLevel);
        this.n = new ShortSet[levelHeightAccessor.ao()];
    }

    public Chunk getFullChunkNow() {
        if (!this.newChunkHolder.isFullChunkReady()) {
            return null;
        }
        return this.getFullChunkNowUnchecked();
    }

    public Chunk getFullChunkNowUnchecked() {
        return (Chunk)this.a(ChunkStatus.n);
    }

    public CompletableFuture<ChunkResult<Chunk>> a() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ChunkResult<Chunk>> b() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ChunkResult<Chunk>> c() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public final Chunk d() {
        IChunkAccess iChunkAccess;
        if (this.newChunkHolder.isTickingReady() && (iChunkAccess = this.newChunkHolder.getCurrentChunk()) instanceof Chunk) {
            Chunk levelChunk = (Chunk)iChunkAccess;
            return levelChunk;
        }
        return null;
    }

    @Nullable
    public Chunk e() {
        Chunk ret = this.moonrise$getFullChunk();
        if (ret != null && this.isRadiusLoaded(1)) {
            return ret;
        }
        return null;
    }

    public CompletableFuture<?> f() {
        throw new UnsupportedOperationException();
    }

    public void a(CompletableFuture<?> dependency) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<?> g() {
        throw new UnsupportedOperationException();
    }

    public boolean h() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void b(CompletableFuture<?> dependency) {
        throw new UnsupportedOperationException();
    }

    public boolean a(BlockPosition pos) {
        Chunk tickingChunk;
        Chunk chunk = tickingChunk = this.playersSentChunkTo.size() == 0 ? null : this.e();
        if (tickingChunk == null) {
            return false;
        }
        boolean flag = this.m;
        int sectionIndex = this.f.f(pos.v());
        if (sectionIndex < 0 || sectionIndex >= this.n.length) {
            return false;
        }
        if (this.n[sectionIndex] == null) {
            this.m = true;
            this.n[sectionIndex] = new ShortOpenHashSet();
        }
        this.n[sectionIndex].add(SectionPosition.b(pos));
        return !flag;
    }

    public boolean a(EnumSkyBlock lightLayer, int y2) {
        Chunk tickingChunk;
        IChunkAccess chunkIfPresent = this.b(ChunkStatus.k);
        if (chunkIfPresent == null) {
            return false;
        }
        chunkIfPresent.i();
        Chunk chunk = tickingChunk = this.playersSentChunkTo.size() == 0 ? null : this.e();
        if (tickingChunk == null) {
            return false;
        }
        int minLightSection = this.q.d();
        int maxLightSection = this.q.e();
        if (y2 >= minLightSection && y2 <= maxLightSection) {
            int i2;
            BitSet bitSet = lightLayer == EnumSkyBlock.a ? this.p : this.o;
            if (!bitSet.get(i2 = y2 - minLightSection)) {
                bitSet.set(i2);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean i() {
        return this.m || !this.p.isEmpty() || !this.o.isEmpty();
    }

    public void a(Chunk chunk) {
        if (this.i()) {
            List<EntityPlayer> players;
            World level = chunk.H();
            if (!this.p.isEmpty() || !this.o.isEmpty()) {
                players = this.moonrise$getPlayers(true);
                if (!players.isEmpty()) {
                    PacketPlayOutLightUpdate clientboundLightUpdatePacket = new PacketPlayOutLightUpdate(chunk.f(), this.q, this.p, this.o);
                    this.a(players, clientboundLightUpdatePacket);
                }
                this.p.clear();
                this.o.clear();
            }
            if (this.m) {
                players = this.moonrise$getPlayers(false);
                for (int i2 = 0; i2 < this.n.length; ++i2) {
                    ShortSet set = this.n[i2];
                    if (set == null) continue;
                    this.n[i2] = null;
                    if (players.isEmpty()) continue;
                    int sectionYFromSectionIndex = this.f.h(i2);
                    SectionPosition sectionPos = SectionPosition.a(chunk.f(), sectionYFromSectionIndex);
                    if (set.size() == 1) {
                        BlockPosition blockPos = sectionPos.g(set.iterator().nextShort());
                        IBlockData blockState = level.a_(blockPos);
                        this.a(players, new PacketPlayOutBlockChange(blockPos, blockState));
                        this.a(players, level, blockPos, blockState);
                        continue;
                    }
                    ChunkSection section = chunk.b(i2);
                    PacketPlayOutMultiBlockChange clientboundSectionBlocksUpdatePacket = new PacketPlayOutMultiBlockChange(sectionPos, set, section);
                    this.a(players, clientboundSectionBlocksUpdatePacket);
                    clientboundSectionBlocksUpdatePacket.a((BlockPosition blockPos1, IBlockData blockState1) -> this.a(players, level, (BlockPosition)blockPos1, (IBlockData)blockState1));
                }
                this.m = false;
            }
        }
    }

    private void a(List<EntityPlayer> players, World level, BlockPosition pos, IBlockData state) {
        if (state.x()) {
            this.a(players, level, pos);
        }
    }

    private void a(List<EntityPlayer> players, World level, BlockPosition pos) {
        Packet<PacketListenerPlayOut> updatePacket;
        TileEntity blockEntity = level.c_(pos);
        if (blockEntity != null && (updatePacket = blockEntity.ax_()) != null) {
            this.a(players, updatePacket);
        }
    }

    private void a(List<EntityPlayer> players, Packet<?> packet) {
        players.forEach(player -> player.f.b(packet));
    }

    @Override
    public int j() {
        return this.newChunkHolder.getTicketLevel();
    }

    @Override
    public int k() {
        throw new UnsupportedOperationException();
    }

    private void b(int queueLevel) {
        throw new UnsupportedOperationException();
    }

    public void a(int level) {
    }

    private void a(PlayerChunkMap chunkMap, CompletableFuture<ChunkResult<Chunk>> future, Executor executor, FullChunkStatus fullChunkStatus) {
        throw new UnsupportedOperationException();
    }

    private void a(PlayerChunkMap chunkMap, FullChunkStatus fullChunkStatus) {
        throw new UnsupportedOperationException();
    }

    protected void callEventIfUnloading(PlayerChunkMap chunkMap) {
        throw new UnsupportedOperationException();
    }

    protected void a(PlayerChunkMap chunkMap, Executor executor) {
        throw new UnsupportedOperationException();
    }

    public boolean l() {
        throw new UnsupportedOperationException();
    }

    public void m() {
        throw new UnsupportedOperationException();
    }

    public static interface b {
        public List<EntityPlayer> a(ChunkCoordIntPair var1, boolean var2);
    }

    @FunctionalInterface
    public static interface a {
        public void onLevelChange(ChunkCoordIntPair var1, IntSupplier var2, int var3, IntConsumer var4);
    }
}

