/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.patches.chunk_system.player.ChunkSystemServerPlayer;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.PaperSkinParts;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.destroystokyo.paper.event.player.PlayerClientOptionsChangeEvent;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.destroystokyo.paper.event.player.PlayerStartSpectatingEntityEvent;
import com.destroystokyo.paper.event.player.PlayerStopSpectatingEntityEvent;
import com.destroystokyo.paper.event.player.PlayerTeleportEndGatewayEvent;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.player.PlayerInventorySlotChangeEvent;
import io.papermc.paper.util.MCUtil;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.translation.Translator;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.EnumChatFormat;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerRotationPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetCursorItemPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutCamera;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutLookAt;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowHorse;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowMerchant;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.network.protocol.game.PacketPlayOutWindowData;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldProviderNormal;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHorse;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotResult;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemCooldownPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.ItemWrittenBook;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockEndGateway;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityEndGateway;
import net.minecraft.world.level.block.entity.TileEntityEnderChest;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.EndGateway;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R3.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftEndGateway;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftDimensionUtil;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedMainHandEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerLocaleChangeEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.MainHand;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EntityPlayer
extends EntityHuman
implements ChunkSystemServerPlayer {
    private static final Logger cC = LogUtils.getLogger();
    public long lastSave = MinecraftServer.currentTick;
    private static final int cD = 32;
    private static final int cE = 10;
    private static final int cF = 25;
    public static final double a = 1.0;
    public static final double b = 3.0;
    public static final int c = 2;
    public static final String d = "ender_pearls";
    public static final String e = "ender_pearl_dimension";
    private static final AttributeModifier cG = new AttributeModifier(MinecraftKey.b("creative_mode_block_range"), 0.5, AttributeModifier.Operation.a);
    private static final AttributeModifier cH = new AttributeModifier(MinecraftKey.b("creative_mode_entity_range"), 2.0, AttributeModifier.Operation.a);
    public PlayerConnection f;
    public final MinecraftServer g;
    public final PlayerInteractManager h;
    private final AdvancementDataPlayer cI;
    private final ServerStatisticManager cJ;
    private float cK = Float.MIN_VALUE;
    private int cL = Integer.MIN_VALUE;
    private int cM = Integer.MIN_VALUE;
    private int cN = Integer.MIN_VALUE;
    private int cO = Integer.MIN_VALUE;
    private int cP = Integer.MIN_VALUE;
    private float cQ = -1.0E8f;
    private int cR = -99999999;
    private boolean cS = true;
    public int cT = -99999999;
    private EnumChatVisibility cU = EnumChatVisibility.a;
    public ParticleStatus cV = ParticleStatus.a;
    private boolean cW = true;
    private long cX = SystemUtils.c();
    @Nullable
    private net.minecraft.world.entity.Entity cY;
    public boolean cZ;
    public boolean i;
    private final RecipeBookServer da;
    @Nullable
    private Vec3D db;
    private int dc;
    private boolean dd;
    private int de = 2;
    public String df = null;
    public Locale adventure$locale = Locale.US;
    @Nullable
    private Vec3D dg;
    @Nullable
    private Vec3D dh;
    @Nullable
    private Vec3D di;
    private SectionPosition dj = SectionPosition.a(0, 0, 0);
    private ChunkTrackingView dk = ChunkTrackingView.a;
    private ResourceKey<net.minecraft.world.level.World> dl = net.minecraft.world.level.World.i;
    @Nullable
    private BlockPosition dm;
    private boolean dn;
    private float do;
    private final ITextFilter dp;
    private boolean dq;
    private boolean dr;
    private boolean ds;
    public WardenSpawnTracker dt = new WardenSpawnTracker(0, 0, 0);
    @Nullable
    private BlockPosition du;
    private Vec3D dv = Vec3D.c;
    private Input dw = Input.b;
    private final Set<EntityEnderPearl> dx = new HashSet<EntityEnderPearl>();
    public final ContainerSynchronizer dy = new ContainerSynchronizer(){

        @Override
        public void a(Container container, NonNullList<ItemStack> items, ItemStack carriedItem, int[] initialData) {
            EntityPlayer.this.f.b(new PacketPlayOutWindowItems(container.l, container.k(), items, carriedItem));
            for (int i2 = 0; i2 < initialData.length; ++i2) {
                this.b(container, i2, initialData[i2]);
            }
        }

        @Override
        public void sendOffHandSlotChange() {
            EntityPlayer.this.f.b(new PacketPlayOutSetSlot(EntityPlayer.this.cc.l, EntityPlayer.this.cc.k(), 45, EntityPlayer.this.cc.b(45).g().v()));
        }

        @Override
        public void a(Container container, int slot, ItemStack itemStack) {
            EntityPlayer.this.f.b(new PacketPlayOutSetSlot(container.l, container.k(), slot, itemStack));
        }

        @Override
        public void a(Container containerMenu, ItemStack stack) {
            EntityPlayer.this.f.b(new ClientboundSetCursorItemPacket(stack.v()));
        }

        @Override
        public void a(Container container, int id, int value) {
            this.b(container, id, value);
        }

        private void b(Container container, int id, int value) {
            EntityPlayer.this.f.b(new PacketPlayOutWindowData(container.l, id, value));
        }
    };
    private final ICrafting dz = new ICrafting(){

        @Override
        public void a(Container containerToSend, int dataSlotIndex, ItemStack stack) {
            Slot slot = containerToSend.b(dataSlotIndex);
            if (!(slot instanceof SlotResult) && slot.c == EntityPlayer.this.gi()) {
                CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.gi(), stack);
            }
        }

        @Override
        public void slotChanged(Container containerToSend, int dataSlotIndex, ItemStack oldStack, ItemStack stack) {
            Slot slot = containerToSend.b(dataSlotIndex);
            if (!(slot instanceof SlotResult) && slot.c == EntityPlayer.this.gi()) {
                if (PlayerInventorySlotChangeEvent.getHandlerList().getRegisteredListeners().length == 0) {
                    CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.gi(), stack);
                    return;
                }
                PlayerInventorySlotChangeEvent event = new PlayerInventorySlotChangeEvent((Player)EntityPlayer.this.getBukkitEntity(), dataSlotIndex, CraftItemStack.asBukkitCopy(oldStack), CraftItemStack.asBukkitCopy(stack));
                event.callEvent();
                if (event.shouldTriggerAdvancements()) {
                    CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.gi(), stack);
                }
            }
        }

        @Override
        public void a(Container containerMenu, int dataSlotIndex, int value) {
        }
    };
    @Nullable
    private RemoteChatSession dA;
    @Nullable
    public final Object j;
    private final ICommandListener dB = new ICommandListener(){

        @Override
        public boolean y_() {
            return EntityPlayer.this.y().O().b(GameRules.p);
        }

        @Override
        public boolean z_() {
            return true;
        }

        @Override
        public boolean c() {
            return true;
        }

        @Override
        public void a(IChatBaseComponent component) {
            EntityPlayer.this.a(component);
        }

        @Override
        public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
            return EntityPlayer.this.getBukkitEntity();
        }
    };
    private int dC;
    public boolean k;
    private int containerUpdateDelay;
    public long loginTime;
    public int patrolSpawnDelay;
    public boolean queueHealthUpdatePacket;
    public PacketPlayOutUpdateHealth queuedHealthUpdatePacket;
    public static final int MOBCATEGORY_TOTAL_ENUMS = EnumCreatureType.values().length;
    public final int[] mobCounts = new int[MOBCATEGORY_TOTAL_ENUMS];
    public final int[] mobBackoffCounts = new int[MOBCATEGORY_TOTAL_ENUMS];
    public CraftPlayer.TransferCookieConnection transferCookieConnection;
    public String displayName;
    public Component adventure$displayName;
    public IChatBaseComponent listName;
    public int listOrder = 0;
    public Location compassTarget;
    public int newExp = 0;
    public int newLevel = 0;
    public int newTotalExp = 0;
    public boolean keepLevel = false;
    public double maxHealthCache;
    public boolean joining = true;
    public boolean sentListPacket = false;
    public boolean supressTrackerForLogin = false;
    public boolean isRealPlayer;
    public PlayerNaturallySpawnCreaturesEvent playerNaturallySpawnedEvent;
    @Nullable
    public String clientBrandName = null;
    public PlayerQuitEvent.QuitReason quitReason = null;
    private RegionizedPlayerChunkLoader.PlayerChunkLoaderData chunkLoader;
    private final RegionizedPlayerChunkLoader.ViewDistanceHolder viewDistanceHolder = new RegionizedPlayerChunkLoader.ViewDistanceHolder();
    public long timeOffset = 0L;
    public boolean relativeTime = true;
    public WeatherType weather = null;
    private float pluginRainPosition;
    private float pluginRainPositionPrevious;

    @Override
    public final boolean moonrise$isRealPlayer() {
        return this.isRealPlayer;
    }

    @Override
    public final void moonrise$setRealPlayer(boolean real) {
        this.isRealPlayer = real;
    }

    @Override
    public final RegionizedPlayerChunkLoader.PlayerChunkLoaderData moonrise$getChunkLoader() {
        return this.chunkLoader;
    }

    @Override
    public final void moonrise$setChunkLoader(RegionizedPlayerChunkLoader.PlayerChunkLoaderData loader) {
        this.chunkLoader = loader;
    }

    @Override
    public final RegionizedPlayerChunkLoader.ViewDistanceHolder moonrise$getViewDistanceHolder() {
        return this.viewDistanceHolder;
    }

    public EntityPlayer(MinecraftServer server, WorldServer level, GameProfile gameProfile, ClientInformation clientInformation) {
        super(level, level.Z(), level.aa(), gameProfile);
        this.dp = server.a(this);
        this.h = server.b(this);
        this.da = new RecipeBookServer((recipe, output) -> server.aI().a(recipe, output));
        this.g = server;
        this.cJ = server.ag().getPlayerStats(this);
        this.cI = server.ag().g(this);
        this.updateOptionsNoEvents(clientInformation);
        this.j = null;
        this.displayName = this.cI();
        this.adventure$displayName = Component.text((String)this.cI());
        this.bukkitPickUpLoot = true;
        this.maxHealthCache = this.eS();
    }

    @Override
    public BlockPosition a(WorldServer level, BlockPosition pos) {
        AxisAlignedBB aabb = this.a(EntityPose.a).a(Vec3D.c);
        BlockPosition blockPos = pos;
        if (level.G_().g() && level.L.k() != EnumGamemode.c) {
            long l2;
            long l1;
            int max = Math.max(0, this.g.a(level));
            int floor = MathHelper.a(level.F_().b(pos.u(), pos.w()));
            if (floor < max) {
                max = floor;
            }
            if (floor <= 1) {
                max = 1;
            }
            int i2 = (l1 = (l2 = (long)(max * 2 + 1)) * l2) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l1;
            int coprime = this.t(i2);
            int randomInt = RandomSource.a().a(i2);
            for (int i1 = 0; i1 < i2; ++i1) {
                int i22 = (randomInt + coprime * i1) % i2;
                int i3 = i22 % (max * 2 + 1);
                int i4 = i22 / (max * 2 + 1);
                int i5 = pos.u() + i3 - max;
                int i6 = pos.w() + i4 - max;
                try {
                    blockPos = WorldProviderNormal.a(level, i5, i6);
                    if (blockPos == null || !this.a(level, aabb.c(blockPos.c()))) continue;
                    return blockPos;
                }
                catch (Exception var25) {
                    int i7 = i1;
                    int i8 = max;
                    CrashReport crashReport = CrashReport.a(var25, "Searching for spawn");
                    CrashReportSystemDetails crashReportCategory = crashReport.a("Spawn Lookup");
                    crashReportCategory.a("Origin", pos::toString);
                    crashReportCategory.a("Radius", () -> Integer.toString(i8));
                    crashReportCategory.a("Candidate", () -> "[" + i5 + "," + i6 + "]");
                    crashReportCategory.a("Progress", () -> i7 + " out of " + i2);
                    throw new ReportedException(crashReport);
                }
            }
            blockPos = pos;
        }
        while (!this.a(level, aabb.c(blockPos.c())) && blockPos.v() < level.an()) {
            blockPos = blockPos.d();
        }
        while (this.a(level, aabb.c(blockPos.e().c())) && blockPos.v() > level.L_() + 1) {
            blockPos = blockPos.e();
        }
        return blockPos;
    }

    private boolean a(WorldServer level, AxisAlignedBB collisionBox) {
        return level.a((net.minecraft.world.entity.Entity)this, collisionBox, true);
    }

    private int t(int spawnArea) {
        return spawnArea <= 16 ? spawnArea - 1 : 17;
    }

    @Override
    public void a(NBTTagCompound compound) {
        String spawnWorld;
        CraftWorld oldWorld;
        super.a(compound);
        if (compound.b("warden_spawn_tracker", 10)) {
            WardenSpawnTracker.a.parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, compound.c("warden_spawn_tracker"))).resultOrPartial(arg_0 -> ((Logger)cC).error(arg_0)).ifPresent(wardenSpawnTracker -> {
                this.dt = wardenSpawnTracker;
            });
        }
        if (compound.b("enteredNetherPosition", 10)) {
            NBTTagCompound compound1 = compound.p("enteredNetherPosition");
            this.dh = new Vec3D(compound1.k("x"), compound1.k("y"), compound1.k("z"));
        }
        this.i = compound.q("seenCredits");
        if (compound.b("recipeBook", 10)) {
            this.da.a(compound.p("recipeBook"), (ResourceKey<IRecipe<?>> key) -> this.g.aI().b((ResourceKey<IRecipe<?>>)key).isPresent());
        }
        this.getBukkitEntity().readExtraData(compound);
        if (this.fR()) {
            this.fS();
        }
        if ((oldWorld = (CraftWorld)Bukkit.getWorld((String)(spawnWorld = compound.l("SpawnWorld")))) != null) {
            this.dl = oldWorld.getHandle().ai();
        }
        if (compound.b("SpawnX", 99) && compound.b("SpawnY", 99) && compound.b("SpawnZ", 99)) {
            this.dm = new BlockPosition(compound.h("SpawnX"), compound.h("SpawnY"), compound.h("SpawnZ"));
            this.dn = compound.q("SpawnForced");
            this.do = compound.j("SpawnAngle");
            if (compound.e("SpawnDimension")) {
                this.dl = net.minecraft.world.level.World.h.parse((DynamicOps)DynamicOpsNBT.a, (Object)compound.c("SpawnDimension")).resultOrPartial(arg_0 -> ((Logger)cC).error(arg_0)).orElse(net.minecraft.world.level.World.i);
            }
        }
        this.ds = compound.q("spawn_extra_particles_on_fall");
        NBTBase tag = compound.c("raid_omen_position");
        if (tag != null) {
            BlockPosition.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)tag).resultOrPartial(arg_0 -> ((Logger)cC).error(arg_0)).ifPresent(pos -> {
                this.du = pos;
            });
        }
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        WardenSpawnTracker.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.dt).resultOrPartial(arg_0 -> ((Logger)cC).error(arg_0)).ifPresent(wardenSpawnTracker -> compound.a("warden_spawn_tracker", (NBTBase)wardenSpawnTracker));
        this.m(compound);
        compound.a("seenCredits", this.i);
        if (this.dh != null) {
            NBTTagCompound compoundTag = new NBTTagCompound();
            compoundTag.a("x", this.dh.d);
            compoundTag.a("y", this.dh.e);
            compoundTag.a("z", this.dh.f);
            compound.a("enteredNetherPosition", compoundTag);
        }
        this.k(compound);
        compound.a("recipeBook", this.da.b());
        compound.a("Dimension", this.dV().ai().a().toString());
        if (this.dm != null) {
            compound.a("SpawnX", this.dm.u());
            compound.a("SpawnY", this.dm.v());
            compound.a("SpawnZ", this.dm.w());
            compound.a("SpawnForced", this.dn);
            compound.a("SpawnAngle", this.do);
            MinecraftKey.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.dl.a()).resultOrPartial(arg_0 -> ((Logger)cC).error(arg_0)).ifPresent(spawnDimension -> compound.a("SpawnDimension", (NBTBase)spawnDimension));
        }
        this.getBukkitEntity().setExtraData(compound);
        compound.a("spawn_extra_particles_on_fall", this.ds);
        if (this.du != null) {
            BlockPosition.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.du).resultOrPartial(arg_0 -> ((Logger)cC).error(arg_0)).ifPresent(raidOmenPosition -> compound.a("raid_omen_position", (NBTBase)raidOmenPosition));
        }
        this.l(compound);
    }

    private void k(NBTTagCompound tag) {
        net.minecraft.world.entity.Entity rootVehicle = this.df();
        net.minecraft.world.entity.Entity vehicle = this.dk();
        boolean persistVehicle = true;
        if (vehicle != null) {
            for (net.minecraft.world.entity.Entity topVehicle = vehicle; topVehicle != null; topVehicle = topVehicle.dk()) {
                if (topVehicle.persist) continue;
                persistVehicle = false;
                break;
            }
        }
        if (persistVehicle && vehicle != null && rootVehicle != this && rootVehicle.de() && !rootVehicle.dQ()) {
            NBTTagCompound compoundTag = new NBTTagCompound();
            NBTTagCompound compoundTag1 = new NBTTagCompound();
            rootVehicle.e(compoundTag1);
            compoundTag.a("Attach", vehicle.cG());
            compoundTag.a("Entity", compoundTag1);
            tag.a("RootVehicle", compoundTag);
        }
    }

    public void a(Optional<NBTTagCompound> tag) {
        net.minecraft.world.level.World world;
        if (tag.isPresent() && tag.get().b("RootVehicle", 10) && (world = this.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            NBTTagCompound compound = tag.get().p("RootVehicle");
            net.minecraft.world.entity.Entity entity = EntityTypes.a(compound.p("Entity"), (net.minecraft.world.level.World)serverLevel, EntitySpawnReason.r, entity2 -> !serverLevel.addWithUUID((net.minecraft.world.entity.Entity)entity2, CreatureSpawnEvent.SpawnReason.MOUNT) ? null : entity2);
            if (entity == null) {
                return;
            }
            UUID uuid = compound.b("Attach") ? compound.a("Attach") : null;
            if (entity.cG().equals(uuid)) {
                this.a(entity, true);
            } else {
                for (net.minecraft.world.entity.Entity entity1 : entity.dc()) {
                    if (!entity1.cG().equals(uuid)) continue;
                    this.a(entity1, true);
                    break;
                }
            }
            if (!this.bZ()) {
                cC.warn("Couldn't reattach entity to player");
                entity.discard(null);
                for (net.minecraft.world.entity.Entity entity1x : entity.dc()) {
                    entity1x.discard(null);
                }
            }
        }
    }

    private void l(NBTTagCompound tag) {
        if (!this.dx.isEmpty()) {
            NBTTagList listTag = new NBTTagList();
            for (EntityEnderPearl thrownEnderpearl : this.dx) {
                if (thrownEnderpearl.dV().paperConfig().misc.legacyEnderPearlBehavior) continue;
                if (thrownEnderpearl.dQ()) {
                    cC.warn("Trying to save removed ender pearl, skipping");
                    continue;
                }
                NBTTagCompound compoundTag = new NBTTagCompound();
                thrownEnderpearl.e(compoundTag);
                MinecraftKey.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)thrownEnderpearl.dV().ai().a()).resultOrPartial(arg_0 -> ((Logger)cC).error(arg_0)).ifPresent(enderPearlDimension -> compoundTag.a(e, (NBTBase)enderPearlDimension));
                listTag.add(compoundTag);
            }
            tag.a(d, listTag);
        }
    }

    public void b(Optional<NBTTagCompound> tag) {
        NBTBase nBTBase;
        if (tag.isPresent() && tag.get().b(d, 9) && (nBTBase = tag.get().c(d)) instanceof NBTTagList) {
            NBTTagList listTag = (NBTTagList)nBTBase;
            listTag.forEach(enderPearlTag -> {
                NBTTagCompound compoundTag;
                if (enderPearlTag instanceof NBTTagCompound && (compoundTag = (NBTTagCompound)enderPearlTag).e(e)) {
                    Optional optional = net.minecraft.world.level.World.h.parse((DynamicOps)DynamicOpsNBT.a, (Object)compoundTag.c(e)).resultOrPartial(arg_0 -> ((Logger)cC).error(arg_0));
                    if (optional.isEmpty()) {
                        cC.warn("No dimension defined for ender pearl, skipping");
                        return;
                    }
                    WorldServer level = this.dV().p().a((ResourceKey)optional.get());
                    if (level != null) {
                        net.minecraft.world.entity.Entity entity = EntityTypes.a(compoundTag, (net.minecraft.world.level.World)level, EntitySpawnReason.r, entity1 -> !level.c((net.minecraft.world.entity.Entity)entity1) ? null : entity1);
                        if (entity != null) {
                            EntityPlayer.a(level, entity.dx());
                        } else {
                            cC.warn("Failed to spawn player ender pearl in level ({}), skipping", optional.get());
                        }
                    } else {
                        cC.warn("Trying to load ender pearl without level ({}) being loaded, skipping", optional.get());
                    }
                }
            });
        }
    }

    public void spawnIn(WorldServer level) {
        if (level == null) {
            throw new IllegalArgumentException("level can't be null");
        }
        this.a((net.minecraft.world.level.World)level);
        this.h.a(level);
    }

    public void a(int experiencePoints) {
        float f2 = this.gs();
        float f1 = (f2 - 1.0f) / f2;
        this.ct = MathHelper.a((float)experiencePoints / f2, 0.0f, f1);
        this.cT = -1;
    }

    public void b(int level) {
        this.cr = level;
        this.cT = -1;
    }

    @Override
    public void c(int levels) {
        super.c(levels);
        this.cT = -1;
    }

    @Override
    public void a(ItemStack enchantedItem, int cost) {
        super.a(enchantedItem, cost);
        this.cT = -1;
    }

    public void a(Container menu) {
        menu.a(this.dz);
        menu.a(this.dy);
    }

    public void d() {
        this.a(this.cc);
    }

    @Override
    public void i_() {
        super.i_();
        this.f.b(ClientboundPlayerCombatEnterPacket.a);
    }

    @Override
    public void j_() {
        super.j_();
        this.f.b(new ClientboundPlayerCombatEndPacket(this.eQ()));
    }

    @Override
    public void a(IBlockData state) {
        CriterionTriggers.e.a(this, state);
    }

    @Override
    protected ItemCooldown g() {
        return new ItemCooldownPlayer(this);
    }

    @Override
    public void h() {
        net.minecraft.world.entity.Entity camera;
        if (this.joining) {
            this.joining = false;
        }
        this.gK();
        this.h.a();
        this.dt.a();
        if (this.aj > 0) {
            --this.aj;
        }
        if (--this.containerUpdateDelay <= 0) {
            this.cd.d();
            this.containerUpdateDelay = this.dV().paperConfig().tickRates.containerUpdate;
        }
        if (this.cd != this.cc && (this.fi() || !this.cd.b(this))) {
            this.closeContainer(InventoryCloseEvent.Reason.CANT_USE);
            this.cd = this.cc;
        }
        if ((camera = this.L()) != this) {
            if (camera.bL()) {
                this.a(camera.dA(), camera.dC(), camera.dG(), camera.dL(), camera.dN());
                this.y().m().a(this);
                if (this.fZ()) {
                    this.d((net.minecraft.world.entity.Entity)this);
                }
            } else {
                this.d((net.minecraft.world.entity.Entity)this);
            }
        }
        CriterionTriggers.x.a(this);
        if (this.db != null) {
            CriterionTriggers.v.a(this, this.db, this.af - this.dc);
        }
        this.l();
        this.m();
        this.gR();
        this.cI.b(this);
    }

    private void gR() {
        AttributeModifiable attribute1;
        AttributeModifiable attribute = this.g(GenericAttributes.g);
        if (attribute != null) {
            if (this.b()) {
                attribute.a(cG);
            } else {
                attribute.e(cG);
            }
        }
        if ((attribute1 = this.g(GenericAttributes.j)) != null) {
            if (this.b()) {
                attribute1.a(cH);
            } else {
                attribute1.e(cH);
            }
        }
    }

    public void i() {
        try {
            if (this.valid && !this.Z_() || !this.do()) {
                super.h();
            }
            for (int i2 = 0; i2 < this.gi().b(); ++i2) {
                ItemStack item = this.gi().a(i2);
                if (item.f()) continue;
                this.j(item);
            }
            if (this.eD() != this.cQ || this.cR != this.ce.a() || this.ce.c() == 0.0f != this.cS) {
                this.f.b(new PacketPlayOutUpdateHealth(this.getBukkitEntity().getScaledHealth(), this.ce.a(), this.ce.c()));
                this.cQ = this.eD();
                this.cR = this.ce.a();
                boolean bl = this.cS = this.ce.c() == 0.0f;
            }
            if (this.eD() + this.fw() != this.cK) {
                this.cK = this.eD() + this.fw();
                this.a(IScoreboardCriteria.g, MathHelper.f(this.cK));
            }
            if (this.ce.a() != this.cL) {
                this.cL = this.ce.a();
                this.a(IScoreboardCriteria.h, MathHelper.f((float)this.cL));
            }
            if (this.ct() != this.cM) {
                this.cM = this.ct();
                this.a(IScoreboardCriteria.i, MathHelper.f((float)this.cM));
            }
            if (this.eP() != this.cN) {
                this.cN = this.eP();
                this.a(IScoreboardCriteria.j, MathHelper.f((float)this.cN));
            }
            if (this.cs != this.cP) {
                this.cP = this.cs;
                this.a(IScoreboardCriteria.k, MathHelper.f((float)this.cP));
            }
            if (this.maxHealthCache != (double)this.eS()) {
                this.getBukkitEntity().updateScaledHealth();
            }
            if (this.cr != this.cO) {
                this.cO = this.cr;
                this.a(IScoreboardCriteria.l, MathHelper.f((float)this.cO));
            }
            if (this.cs != this.cT) {
                this.cT = this.cs;
                this.f.b(new PacketPlayOutExperience(this.ct, this.cs, this.cr));
            }
            if (this.af % 20 == 0) {
                CriterionTriggers.q.a(this);
            }
            if (this.oldLevel == -1) {
                this.oldLevel = this.cr;
            }
            if (this.oldLevel != this.cr) {
                CraftEventFactory.callPlayerLevelChangeEvent(this.getBukkitEntity(), this.oldLevel, this.cr);
                this.oldLevel = this.cr;
            }
            if (this.getBukkitEntity().hasClientWorldBorder()) {
                ((CraftWorldBorder)this.getBukkitEntity().getWorldBorder()).getHandle().s();
            }
        }
        catch (Throwable var4) {
            CrashReport crashReport = CrashReport.a(var4, "Ticking player");
            CrashReportSystemDetails crashReportCategory = crashReport.a("Player being ticked");
            this.a(crashReportCategory);
            throw new ReportedException(crashReport);
        }
    }

    private void j(ItemStack stack) {
        Packet<?> updatePacket;
        MapId mapId = stack.a(DataComponents.L);
        WorldMap savedData = ItemWorldMap.a(mapId, this.dV());
        if (savedData != null && (updatePacket = savedData.a(mapId, this)) != null) {
            this.f.b(updatePacket);
        }
    }

    @Override
    protected void j() {
        if (this.dV().am() == EnumDifficulty.a && this.y().O().b(GameRules.k)) {
            if (this.af % 20 == 0) {
                float saturationLevel;
                if (this.eD() < this.eS()) {
                    this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
                }
                if ((saturationLevel = this.ce.c()) < 20.0f) {
                    this.ce.b(saturationLevel + 1.0f);
                }
            }
            if (this.af % 10 == 0 && this.ce.b()) {
                this.ce.a(this.ce.a() + 1);
            }
        }
    }

    @Override
    public void k() {
        if (this.eD() > 0.0f && this.dg != null) {
            CriterionTriggers.X.a(this, this.dg);
        }
        this.dg = null;
        super.k();
    }

    public void l() {
        if (this.Z > 0.0f && this.dg == null) {
            this.dg = this.dt();
            if (this.cy != null && this.cy.e <= this.dg.e) {
                CriterionTriggers.ae.a(this, this.cy, this.cz);
            }
        }
    }

    public void m() {
        if (this.dk() != null && this.dk().bx()) {
            if (this.di == null) {
                this.di = this.dt();
            } else {
                CriterionTriggers.Y.a(this, this.di);
            }
        }
        if (!(this.di == null || this.dk() != null && this.dk().bx())) {
            this.di = null;
        }
    }

    private void a(IScoreboardCriteria criteria, int points) {
        this.dV().getCraftServer().getScoreboardManager().forAllObjectives(criteria, this, scoreAccess -> scoreAccess.a(points));
    }

    private static void processKeep(PlayerDeathEvent event, NonNullList<ItemStack> inv) {
        List itemsToKeep = event.getItemsToKeep();
        if (inv == null) {
            if (!itemsToKeep.isEmpty()) {
                for (org.bukkit.inventory.ItemStack itemStack : itemsToKeep) {
                    event.getEntity().getInventory().addItem(new org.bukkit.inventory.ItemStack[]{itemStack});
                }
            }
            return;
        }
        for (int i2 = 0; i2 < inv.size(); ++i2) {
            ItemStack item = inv.get(i2);
            if (EnchantmentManager.a(item, EnchantmentEffectComponents.D) || itemsToKeep.isEmpty() || item.f()) {
                inv.set(i2, ItemStack.j);
                continue;
            }
            org.bukkit.inventory.ItemStack bukkitStack = item.getBukkitStack();
            boolean keep = false;
            Iterator iterator = itemsToKeep.iterator();
            while (iterator.hasNext()) {
                org.bukkit.inventory.ItemStack itemStack = (org.bukkit.inventory.ItemStack)iterator.next();
                if (!bukkitStack.equals((Object)itemStack)) continue;
                iterator.remove();
                keep = true;
                break;
            }
            if (keep) continue;
            inv.set(i2, ItemStack.j);
        }
    }

    @Override
    public void a(DamageSource cause) {
        TextComponent apiDeathMessage;
        boolean keepInventory;
        boolean _boolean;
        boolean showDeathMessage = _boolean = this.y().O().b(GameRules.n);
        if (this.dQ()) {
            return;
        }
        ArrayList<Entity.DefaultDrop> loot = new ArrayList<Entity.DefaultDrop>(this.gi().b());
        boolean bl = keepInventory = this.y().O().b(GameRules.d) || this.Z_();
        if (!keepInventory) {
            for (ItemStack item : this.gi().getContents()) {
                if (item.f() || EnchantmentManager.a(item, EnchantmentEffectComponents.D)) continue;
                loot.add(new Entity.DefaultDrop(item, stack -> this.drop((ItemStack)stack, true, false, false)));
            }
        }
        if (this.en() && this.y().O().b(GameRules.f)) {
            this.b(this.y(), cause, this.bd > 0);
            loot.addAll(this.drops);
            this.drops.clear();
        }
        IChatBaseComponent defaultMessage = this.eQ().a();
        String deathmessage = defaultMessage.getString();
        this.keepLevel = keepInventory;
        PlayerDeathEvent event = CraftEventFactory.callPlayerDeathEvent(this, cause, loot, PaperAdventure.asAdventure(defaultMessage), keepInventory);
        if (event.isCancelled()) {
            if (this.eD() <= 0.0f) {
                this.x((float)event.getReviveHealth());
            }
            return;
        }
        ((net.minecraft.world.entity.Entity)this).a(GameEvent.p);
        if (this.cd != this.cc) {
            this.closeContainer(InventoryCloseEvent.Reason.DEATH);
        }
        Object object = apiDeathMessage = event.deathMessage() != null ? event.deathMessage() : Component.empty();
        if (apiDeathMessage != null && apiDeathMessage != Component.empty() && showDeathMessage) {
            IChatBaseComponent deathMessage = PaperAdventure.asVanilla((Component)apiDeathMessage);
            this.f.a(new ClientboundPlayerCombatKillPacket(this.ar(), deathMessage), PacketSendListener.a(() -> {
                int i2 = 256;
                String string = deathMessage.a(256);
                IChatMutableComponent component = IChatBaseComponent.a("death.attack.message_too_long", IChatBaseComponent.b(string).a(EnumChatFormat.o));
                IChatMutableComponent component1 = IChatBaseComponent.a("death.attack.even_more_magic", this.p_()).a(style -> style.a(new ChatHoverable(ChatHoverable.EnumHoverAction.a, component)));
                return new ClientboundPlayerCombatKillPacket(this.ar(), component1);
            }));
            ScoreboardTeam scoreboardTeam = this.cr();
            if (scoreboardTeam == null || ((ScoreboardTeamBase)scoreboardTeam).k() == ScoreboardTeamBase.EnumNameTagVisibility.a) {
                this.g.ag().a(deathMessage, false);
            } else if (((ScoreboardTeamBase)scoreboardTeam).k() == ScoreboardTeamBase.EnumNameTagVisibility.c) {
                this.g.ag().a((EntityHuman)this, deathMessage);
            } else if (((ScoreboardTeamBase)scoreboardTeam).k() == ScoreboardTeamBase.EnumNameTagVisibility.d) {
                this.g.ag().b(this, deathMessage);
            }
        } else {
            this.f.b(new ClientboundPlayerCombatKillPacket(this.ar(), CommonComponents.a));
        }
        this.gx();
        if (this.y().O().b(GameRules.O)) {
            this.gS();
        }
        if (event.shouldDropExperience()) {
            this.b(this.y(), cause.d());
        }
        if (!event.getKeepInventory()) {
            for (NonNullList nonNullList : this.gi().l) {
                EntityPlayer.processKeep(event, nonNullList);
            }
            EntityPlayer.processKeep(event, null);
        }
        this.d((net.minecraft.world.entity.Entity)this);
        this.dV().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.d, this, ScoreAccess::b);
        EntityLiving killCredit = this.eR();
        if (killCredit != null) {
            this.b(StatisticList.h.b(killCredit.aq()));
            killCredit.a((net.minecraft.world.entity.Entity)this, cause);
            this.f(killCredit);
        }
        this.dV().a((net.minecraft.world.entity.Entity)this, (byte)3);
        this.a(StatisticList.N);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aH();
        this.k(0);
        this.c(false);
        this.eQ().c();
        this.c(Optional.of(GlobalPos.a(this.dV().ai(), this.dv())));
        this.w(false);
    }

    private void gS() {
        AxisAlignedBB aabb = new AxisAlignedBB(this.dv()).c(32.0, 10.0, 32.0);
        this.dV().a(EntityInsentient.class, aabb, IEntitySelector.f).stream().filter(mob -> mob instanceof IEntityAngerable).forEach(mob -> ((IEntityAngerable)((Object)mob)).a_(this.y(), this));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, DamageSource damageSource) {
        if (entity != this) {
            super.a(entity, damageSource);
            this.dV().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.f, this, ScoreAccess::b);
            if (entity instanceof EntityHuman) {
                this.a(StatisticList.Q);
                this.dV().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.e, this, ScoreAccess::b);
            } else {
                this.a(StatisticList.O);
            }
            this.a((ScoreHolder)this, (ScoreHolder)entity, IScoreboardCriteria.m);
            this.a((ScoreHolder)entity, (ScoreHolder)this, IScoreboardCriteria.n);
            CriterionTriggers.c.a(this, entity, damageSource);
        }
    }

    private void a(ScoreHolder scoreHolder, ScoreHolder teamMember, IScoreboardCriteria[] crtieria) {
        int id;
        ScoreboardTeam playersTeam = this.gy().e(teamMember.cI());
        if (playersTeam != null && (id = playersTeam.n().b()) >= 0 && id < crtieria.length) {
            this.dV().getCraftServer().getScoreboardManager().forAllObjectives(crtieria[id], scoreHolder, ScoreAccess::b);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        EntityHuman player1;
        EntityArrow abstractArrow;
        net.minecraft.world.entity.Entity entity;
        EntityHuman player;
        if (this.a(level, damageSource)) {
            return false;
        }
        net.minecraft.world.entity.Entity entity2 = damageSource.d();
        if (entity2 instanceof EntityHuman && !this.a(player = (EntityHuman)entity2) || entity2 instanceof EntityArrow && (entity = (abstractArrow = (EntityArrow)entity2).p()) instanceof EntityHuman && !this.a(player1 = (EntityHuman)entity)) {
            return false;
        }
        this.queueHealthUpdatePacket = true;
        boolean damaged = super.a(level, damageSource, amount);
        this.queueHealthUpdatePacket = false;
        if (this.queuedHealthUpdatePacket != null) {
            this.f.b(this.queuedHealthUpdatePacket);
            this.queuedHealthUpdatePacket = null;
        }
        return damaged;
    }

    @Override
    public boolean a(EntityHuman other) {
        return this.gT() && super.a(other);
    }

    private boolean gT() {
        return this.dV().pvpMode;
    }

    public TeleportTransition findRespawnPositionAndUseSpawnBlock(boolean useCharge, TeleportTransition.a postTeleportTransition, PlayerRespawnEvent.RespawnReason respawnReason) {
        TeleportTransition teleportTransition;
        boolean isBedSpawn = false;
        boolean isAnchorSpawn = false;
        BlockPosition respawnPosition = this.T();
        float respawnAngle = this.U();
        boolean isRespawnForced = this.W();
        WorldServer level = this.g.a(this.V());
        if (level != null && respawnPosition != null) {
            Optional<RespawnPosAngle> optional = EntityPlayer.a(level, respawnPosition, respawnAngle, isRespawnForced, useCharge);
            if (optional.isPresent()) {
                RespawnPosAngle respawnPosAngle = optional.get();
                isBedSpawn = respawnPosAngle.isBedSpawn();
                isAnchorSpawn = respawnPosAngle.isAnchorSpawn();
                teleportTransition = new TeleportTransition(level, respawnPosAngle.a(), Vec3D.c, respawnPosAngle.b(), 0.0f, postTeleportTransition);
            } else {
                teleportTransition = TeleportTransition.a(this.g.J(), this, postTeleportTransition);
            }
        } else {
            teleportTransition = new TeleportTransition(this.g.J(), this, postTeleportTransition);
        }
        if (respawnReason == null) {
            return teleportTransition;
        }
        CraftPlayer respawnPlayer = this.getBukkitEntity();
        Location location = CraftLocation.toBukkit(teleportTransition.c(), (World)teleportTransition.b().getWorld(), teleportTransition.e(), teleportTransition.f());
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (respawnReason == PlayerRespawnEvent.RespawnReason.END_PORTAL) {
            builder.add((Object)PlayerRespawnEvent.RespawnFlag.END_PORTAL);
        }
        PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent((Player)respawnPlayer, location, isBedSpawn, isAnchorSpawn, respawnReason, builder);
        this.dV().getCraftServer().getPluginManager().callEvent((Event)respawnEvent);
        if (this.f.isDisconnected()) {
            return null;
        }
        location = respawnEvent.getRespawnLocation();
        return new TeleportTransition(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3D(location), teleportTransition.d(), location.getYaw(), location.getPitch(), teleportTransition.g(), teleportTransition.h(), teleportTransition.i(), teleportTransition.j(), teleportTransition.cause());
    }

    public static Optional<RespawnPosAngle> a(WorldServer level, BlockPosition pos, float angle, boolean forced, boolean useCharge) {
        IBlockData blockState = level.a_(pos);
        Block block = blockState.b();
        if (block instanceof BlockRespawnAnchor && (forced || blockState.c(BlockRespawnAnchor.d) > 0) && BlockRespawnAnchor.a(level)) {
            Optional<Vec3D> optional = BlockRespawnAnchor.a(EntityTypes.bR, level, pos);
            if (!forced && useCharge && optional.isPresent()) {
                level.a(pos, (IBlockData)blockState.b(BlockRespawnAnchor.d, blockState.c(BlockRespawnAnchor.d) - 1), 3);
            }
            return optional.map(vec3 -> RespawnPosAngle.of(vec3, pos, false, true));
        }
        if (block instanceof BlockBed && BlockBed.a(level)) {
            return BlockBed.a(EntityTypes.bR, (ICollisionAccess)level, pos, blockState.c(BlockFacingHorizontal.aF), angle).map(vec3 -> RespawnPosAngle.of(vec3, pos, true, false));
        }
        if (!forced) {
            return Optional.empty();
        }
        boolean isPossibleToRespawnInThis = block.a(blockState);
        IBlockData blockState1 = level.a_(pos.d());
        boolean isPossibleToRespawnInThis1 = blockState1.b().a(blockState1);
        return isPossibleToRespawnInThis && isPossibleToRespawnInThis1 ? Optional.of(new RespawnPosAngle(new Vec3D((double)pos.u() + 0.5, (double)pos.v() + 0.1, (double)pos.w() + 0.5), angle, false, false)) : Optional.empty();
    }

    public void n() {
        this.ao();
        this.y().a(this, Entity.RemovalReason.e);
        if (!this.k) {
            this.k = true;
            this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.f, 0.0f));
            this.i = true;
        }
    }

    @Nullable
    public EntityPlayer a(TeleportTransition teleportTransition) {
        TileEntity tileEntity;
        if (this.fR()) {
            return null;
        }
        if (this.dQ()) {
            return null;
        }
        if (teleportTransition.g()) {
            this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f));
        }
        WorldServer level = teleportTransition.b();
        WorldServer serverLevel = this.y();
        ResourceKey<WorldDimension> resourceKey = serverLevel.getTypeKey();
        Location enter = this.getBukkitEntity().getLocation();
        PositionMoveRotation absolutePosition = PositionMoveRotation.a(PositionMoveRotation.a(this), PositionMoveRotation.a(teleportTransition), teleportTransition.i());
        Location exit = CraftLocation.toBukkit(absolutePosition.a(), (World)level.getWorld(), absolutePosition.c(), absolutePosition.d());
        PlayerTeleportEvent tpEvent = new PlayerTeleportEvent((Player)this.getBukkitEntity(), enter, exit, teleportTransition.cause());
        if (this.as != null && this.as.a((BlockEndGateway)Blocks.lh) && (tileEntity = this.y().c_(this.as.c())) instanceof TileEntityEndGateway) {
            TileEntityEndGateway theEndGatewayBlockEntity = (TileEntityEndGateway)tileEntity;
            tpEvent = new PlayerTeleportEndGatewayEvent((Player)this.getBukkitEntity(), enter, exit, (EndGateway)new CraftEndGateway((World)this.y().getWorld(), theEndGatewayBlockEntity));
        }
        Bukkit.getServer().getPluginManager().callEvent((Event)tpEvent);
        Location newExit = tpEvent.getTo();
        if (tpEvent.isCancelled() || newExit == null) {
            return null;
        }
        if (!newExit.equals((Object)exit)) {
            level = ((CraftWorld)newExit.getWorld()).getHandle();
            teleportTransition = new TeleportTransition(level, CraftLocation.toVec3D(newExit), Vec3D.c, newExit.getYaw(), newExit.getPitch(), teleportTransition.g(), teleportTransition.h(), Set.of(), teleportTransition.j(), teleportTransition.cause());
        }
        if (!teleportTransition.h()) {
            this.ae();
        }
        if (level != null && level.ai() == serverLevel.ai()) {
            this.f.internalTeleport(PositionMoveRotation.a(teleportTransition), teleportTransition.i());
            this.f.l();
            teleportTransition.j().onTransition(this);
            return this;
        }
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("moving");
        if (level != null && resourceKey == WorldDimension.b && level.getTypeKey() == WorldDimension.c) {
            this.dh = this.dt();
        }
        profilerFiller.c();
        profilerFiller.a("placing");
        this.cZ = true;
        WorldData worlddata = level.D_();
        this.f.b(new PacketPlayOutRespawn(this.b(level), 3));
        this.f.b(new PacketPlayOutServerDifficulty(worlddata.q(), worlddata.r()));
        PlayerList playerList = this.g.ag();
        playerList.e(this);
        serverLevel.a(this, Entity.RemovalReason.e);
        this.dS();
        this.a(level);
        this.f.internalTeleport(PositionMoveRotation.a(teleportTransition), teleportTransition.i());
        this.f.l();
        level.d(this);
        profilerFiller.c();
        this.g(serverLevel);
        this.fF();
        this.f.b(new PacketPlayOutAbilities(this.gj()));
        playerList.a(this, level);
        playerList.f(this);
        playerList.d(this);
        teleportTransition.j().onTransition(this);
        this.cT = -1;
        this.cQ = -1.0f;
        this.cR = -1;
        PlayerChangedWorldEvent changeEvent = new PlayerChangedWorldEvent((Player)this.getBukkitEntity(), (World)serverLevel.getWorld());
        this.dV().getCraftServer().getPluginManager().callEvent((Event)changeEvent);
        if (this.fG()) {
            this.fF();
        }
        return this;
    }

    @Override
    public CraftPortalEvent callPortalEvent(net.minecraft.world.entity.Entity entity, Location exit, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        Location enter = this.getBukkitEntity().getLocation();
        PlayerPortalEvent event = new PlayerPortalEvent((Player)this.getBukkitEntity(), enter, exit, cause, searchRadius, true, creationRadius);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    @Override
    public void a(float yRot, float xRot) {
        this.f.b(new ClientboundPlayerRotationPacket(yRot, xRot));
    }

    public void g(WorldServer level) {
        ResourceKey<net.minecraft.world.level.World> resourceKey = level.ai();
        ResourceKey<net.minecraft.world.level.World> resourceKey1 = this.dV().ai();
        ResourceKey<net.minecraft.world.level.World> maindimensionkey = CraftDimensionUtil.getMainDimensionKey(level);
        ResourceKey<net.minecraft.world.level.World> maindimensionkey1 = CraftDimensionUtil.getMainDimensionKey(this.dV());
        if (GlobalConfiguration.get().misc.strictAdvancementDimensionCheck) {
            maindimensionkey = resourceKey;
            maindimensionkey1 = resourceKey1;
        }
        CriterionTriggers.w.a(this, maindimensionkey, maindimensionkey1);
        if (maindimensionkey != resourceKey || maindimensionkey1 != resourceKey1) {
            CriterionTriggers.w.a(this, resourceKey, resourceKey1);
        }
        if (maindimensionkey == net.minecraft.world.level.World.j && maindimensionkey1 == net.minecraft.world.level.World.i && this.dh != null) {
            CriterionTriggers.D.a(this, this.dh);
        }
        if (maindimensionkey1 != net.minecraft.world.level.World.j) {
            this.dh = null;
        }
    }

    @Override
    public boolean a(EntityPlayer player) {
        return player.Z_() ? this.L() == this : !this.Z_() && super.a(player);
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, int quantity) {
        super.a(entity, quantity);
        this.cd.d();
    }

    private Either<EntityHuman.EnumBedResult, Unit> getBedResult(BlockPosition at, EnumDirection direction) {
        if (this.fR() || !this.bL()) {
            return Either.left(EntityHuman.EnumBedResult.e);
        }
        if (!this.dV().G_().j() && !this.dV().G_().l()) {
            return Either.left(EntityHuman.EnumBedResult.a);
        }
        if (!this.a(at, direction)) {
            return Either.left(EntityHuman.EnumBedResult.c);
        }
        if (this.b(at, direction)) {
            return Either.left(EntityHuman.EnumBedResult.d);
        }
        this.setRespawnPosition(this.dV().ai(), at, this.dL(), false, true, PlayerSetSpawnEvent.Cause.BED);
        if (this.dV().V()) {
            return Either.left(EntityHuman.EnumBedResult.b);
        }
        if (!this.b()) {
            double d2 = 8.0;
            double d1 = 5.0;
            Vec3D vec3 = Vec3D.c(at);
            List<EntityMonster> entitiesOfClass = this.dV().a(EntityMonster.class, new AxisAlignedBB(vec3.a() - 8.0, vec3.b() - 5.0, vec3.c() - 8.0, vec3.a() + 8.0, vec3.b() + 5.0, vec3.c() + 8.0), (? super T monster) -> monster.a(this.y(), this));
            if (!entitiesOfClass.isEmpty()) {
                return Either.left(EntityHuman.EnumBedResult.f);
            }
        }
        return Either.right(Unit.a);
    }

    @Override
    public Either<EntityHuman.EnumBedResult, Unit> startSleepInBed(BlockPosition at, boolean force) {
        EnumDirection enumdirection = this.dV().a_(at).c(BlockFacingHorizontal.aF);
        Either<EntityHuman.EnumBedResult, Unit> bedResult = this.getBedResult(at, enumdirection);
        if (bedResult.left().orElse(null) == EntityHuman.EnumBedResult.e) {
            return bedResult;
        }
        if (force) {
            bedResult = Either.right(Unit.a);
        }
        if ((bedResult = CraftEventFactory.callPlayerBedEnterEvent(this, at, bedResult)).left().isPresent()) {
            return bedResult;
        }
        Either<EntityHuman.EnumBedResult, Unit> either = super.startSleepInBed(at, force).ifRight(unit -> {
            this.a(StatisticList.ap);
            CriterionTriggers.r.a(this);
        });
        if (!this.y().e()) {
            this.a(IChatBaseComponent.c("sleep.not_possible"), true);
        }
        ((WorldServer)this.dV()).f();
        return either;
    }

    @Override
    public void b(BlockPosition pos) {
        this.a(StatisticList.i.b(StatisticList.n));
        super.b(pos);
    }

    private boolean a(BlockPosition pos, EnumDirection direction) {
        return this.i(pos) || this.i(pos.a(direction.g()));
    }

    private boolean i(BlockPosition pos) {
        Vec3D vec3 = Vec3D.c(pos);
        return Math.abs(this.dA() - vec3.a()) <= 3.0 && Math.abs(this.dC() - vec3.b()) <= 2.0 && Math.abs(this.dG() - vec3.c()) <= 3.0;
    }

    private boolean b(BlockPosition pos, EnumDirection direction) {
        BlockPosition blockPos = pos.d();
        return !this.h(blockPos) || !this.h(blockPos.a(direction.g()));
    }

    @Override
    public void a(boolean wakeImmediately, boolean updateLevelForSleepingPlayers) {
        if (!this.fR()) {
            return;
        }
        CraftPlayer player = this.getBukkitEntity();
        BlockPosition bedPosition = this.fP().orElse(null);
        org.bukkit.block.Block bed = bedPosition != null ? this.dV().getWorld().getBlockAt(bedPosition.u(), bedPosition.v(), bedPosition.w()) : this.dV().getWorld().getBlockAt(player.getLocation());
        PlayerBedLeaveEvent event = new PlayerBedLeaveEvent((Player)player, bed, true);
        this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (this.fR()) {
            this.y().m().a(this, new PacketPlayOutAnimation(this, 2));
        }
        super.a(wakeImmediately, updateLevelForSleepingPlayers);
        if (this.f != null) {
            this.f.teleport(this.dA(), this.dC(), this.dG(), this.dL(), this.dN(), PlayerTeleportEvent.TeleportCause.EXIT_BED);
        }
    }

    @Override
    public void a(double x2, double y2, double z2) {
        this.bQ();
        this.a_(x2, y2, z2);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource) {
        return super.a(level, damageSource) || this.Q() && !damageSource.a(DamageTypes.m) || !this.gJ() || !this.dV().paperConfig().collisions.allowPlayerCrammingDamage && damageSource.a(DamageTypes.h);
    }

    @Override
    protected void b(WorldServer level, BlockPosition pos) {
        if (!this.Z_()) {
            super.b(level, pos);
        }
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
        if (this.ds && onGround && this.Z > 0.0f) {
            Vec3D vec3 = pos.b().b(0.0, 0.5, 0.0);
            int i2 = (int)MathHelper.a(50.0f * this.Z, 0.0f, 200.0f);
            this.y().a(new ParticleParamBlock(Particles.b, state), vec3.d, vec3.e, vec3.f, i2, (double)0.3f, (double)0.3f, (double)0.3f, (double)0.15f);
            this.ds = false;
        }
        super.a(y2, onGround, state, pos);
    }

    @Override
    public void b_(@Nullable net.minecraft.world.entity.Entity entity) {
        super.b_(entity);
        this.cy = this.dt();
        this.cz = entity;
        this.x(entity != null && entity.aq() == EntityTypes.bG);
    }

    @Override
    protected void o() {
        if (this.dV().u().i()) {
            super.o();
        }
    }

    @Override
    public void a(TileEntitySign signEntity, boolean isFrontText) {
        this.f.b(new PacketPlayOutBlockChange(this.dV(), signEntity.aA_()));
        this.f.b(new PacketPlayOutOpenSignEditor(signEntity.aA_(), isFrontText));
    }

    public int nextContainerCounter() {
        this.dC = this.dC % 100 + 1;
        return this.dC;
    }

    @Override
    public OptionalInt a(@Nullable ITileInventory menu) {
        if (menu == null) {
            return OptionalInt.empty();
        }
        this.nextContainerCounter();
        Container abstractContainerMenu = menu.createMenu(this.dC, this.gi(), this);
        IChatBaseComponent title = null;
        if (abstractContainerMenu != null) {
            abstractContainerMenu.setTitle(menu.p_());
            boolean cancelled = false;
            Pair<Component, Container> result = CraftEventFactory.callInventoryOpenEventWithTitle(this, abstractContainerMenu, cancelled);
            abstractContainerMenu = (Container)result.getSecond();
            title = PaperAdventure.asVanilla((Component)result.getFirst());
            if (abstractContainerMenu == null && !cancelled) {
                if (menu instanceof IInventory) {
                    ((IInventory)((Object)menu)).c(this);
                } else if (menu instanceof BlockChest.DoubleInventory) {
                    BlockChest.DoubleInventory doubleInventory = (BlockChest.DoubleInventory)menu;
                    doubleInventory.container.c(this);
                } else if (!this.cb.b((TileEntityEnderChest)null)) {
                    this.cb.c(this);
                }
                return OptionalInt.empty();
            }
        }
        if (abstractContainerMenu == null) {
            if (this.Z_()) {
                this.a(IChatBaseComponent.c("container.spectatorCantOpen").a(EnumChatFormat.m), true);
            }
            return OptionalInt.empty();
        }
        this.cd = abstractContainerMenu;
        if (!this.fi()) {
            this.f.b(new PacketPlayOutOpenWindow(abstractContainerMenu.l, abstractContainerMenu.a(), Objects.requireNonNullElseGet(title, abstractContainerMenu::getTitle)));
        }
        this.a(abstractContainerMenu);
        return OptionalInt.of(this.dC);
    }

    @Override
    public void a(int containerId, MerchantRecipeList offers, int level, int xp, boolean flag, boolean flag1) {
        this.f.b(new PacketPlayOutOpenWindowMerchant(containerId, offers, level, xp, flag, flag1));
    }

    @Override
    public void a(EntityHorseAbstract horse, IInventory inventory) {
        this.nextContainerCounter();
        Container container = new ContainerHorse(this.dC, this.gi(), inventory, horse, horse.af_());
        container.setTitle(horse.p_());
        container = CraftEventFactory.callInventoryOpenEvent(this, container);
        if (container == null) {
            inventory.c(this);
            return;
        }
        if (this.cd != this.cc) {
            this.closeContainer(InventoryCloseEvent.Reason.OPEN_NEW);
        }
        int inventoryColumns = horse.af_();
        this.f.b(new PacketPlayOutOpenWindowHorse(this.dC, inventoryColumns, horse.ar()));
        this.cd = container;
        this.a(this.cd);
    }

    @Override
    public void a(ItemStack stack, EnumHand hand) {
        if (stack.b(DataComponents.T)) {
            if (ItemWrittenBook.a(stack, this.A(), this)) {
                this.cd.d();
            }
            this.f.b(new PacketPlayOutOpenBook(hand));
        }
    }

    @Override
    public void a(TileEntityCommand commandBlock) {
        this.f.b(PacketPlayOutTileEntityData.a(commandBlock, TileEntity::e));
    }

    @Override
    public void p() {
        this.closeContainer(InventoryCloseEvent.Reason.UNKNOWN);
    }

    @Override
    public void closeContainer(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.f.b(new PacketPlayOutCloseWindow(this.cd.l));
        this.q();
    }

    @Override
    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.f.b(new PacketPlayOutCloseWindow(this.cd.l));
        this.cd = this.cc;
    }

    @Override
    public void q() {
        this.cd.a(this);
        this.cc.a(this.cd);
        this.cd = this.cc;
    }

    @Override
    public void r() {
        double x2 = this.dA();
        double y2 = this.dC();
        double z2 = this.dG();
        super.r();
        this.q(this.dA() - x2, this.dC() - y2, this.dG() - z2);
    }

    public void b(double dx, double dy, double dz) {
        if (!this.bZ() && !EntityPlayer.r(dx, dy, dz)) {
            if (this.ck()) {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                if (rounded > 0) {
                    this.a(StatisticList.C, rounded);
                    this.causeFoodExhaustion(this.dV().spigotConfig.swimMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.SWIM);
                }
            } else if (((net.minecraft.world.entity.Entity)this).a(TagsFluid.a)) {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                if (rounded > 0) {
                    this.a(StatisticList.w, rounded);
                    this.causeFoodExhaustion(this.dV().spigotConfig.swimMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_UNDERWATER);
                }
            } else if (this.bj()) {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (rounded > 0) {
                    this.a(StatisticList.s, rounded);
                    this.causeFoodExhaustion(this.dV().spigotConfig.swimMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_ON_WATER);
                }
            } else if (this.q_()) {
                if (dy > 0.0) {
                    this.a(StatisticList.u, (int)Math.round(dy * 100.0));
                }
            } else if (this.aJ()) {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (rounded > 0) {
                    if (this.cj()) {
                        this.a(StatisticList.r, rounded);
                        this.causeFoodExhaustion(this.dV().spigotConfig.sprintMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.SPRINT);
                    } else if (this.ci()) {
                        this.a(StatisticList.q, rounded);
                        this.causeFoodExhaustion(this.dV().spigotConfig.otherMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.CROUCH);
                    } else {
                        this.a(StatisticList.p, rounded);
                        this.causeFoodExhaustion(this.dV().spigotConfig.otherMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK);
                    }
                }
            } else if (this.fJ()) {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                this.a(StatisticList.B, rounded);
            } else {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (rounded > 25) {
                    this.a(StatisticList.v, rounded);
                }
            }
        }
    }

    private void q(double dx, double dy, double dz) {
        if (this.bZ() && !EntityPlayer.r(dx, dy, dz)) {
            int rounded = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
            net.minecraft.world.entity.Entity vehicle = this.dk();
            if (vehicle instanceof EntityMinecartAbstract) {
                this.a(StatisticList.x, rounded);
            } else if (vehicle instanceof AbstractBoat) {
                this.a(StatisticList.y, rounded);
            } else if (vehicle instanceof EntityPig) {
                this.a(StatisticList.z, rounded);
            } else if (vehicle instanceof EntityHorseAbstract) {
                this.a(StatisticList.A, rounded);
            } else if (vehicle instanceof EntityStrider) {
                this.a(StatisticList.D, rounded);
            }
        }
    }

    private static boolean r(double dx, double dy, double dz) {
        return dx == 0.0 && dy == 0.0 && dz == 0.0;
    }

    @Override
    public void a(Statistic<?> stat, int amount) {
        this.cJ.b(this, stat, amount);
        this.dV().getCraftServer().getScoreboardManager().forAllObjectives(stat, this, score -> score.b(amount));
    }

    @Override
    public void a(Statistic<?> stat) {
        this.cJ.a(this, stat, 0);
        this.dV().getCraftServer().getScoreboardManager().forAllObjectives(stat, this, ScoreAccess::c);
    }

    @Override
    public int a(Collection<RecipeHolder<?>> recipes) {
        return this.da.a(recipes, this);
    }

    @Override
    public void a(RecipeHolder<?> recipe, List<ItemStack> items) {
        CriterionTriggers.ac.a(this, recipe.a(), items);
    }

    @Override
    public void b(List<ResourceKey<IRecipe<?>>> recipes) {
        List<RecipeHolder<?>> list = recipes.stream().flatMap(resourceKey -> this.g.aI().b((ResourceKey<IRecipe<?>>)resourceKey).stream()).collect(Collectors.toList());
        this.a((Collection<RecipeHolder<?>>)list);
    }

    @Override
    public int b(Collection<RecipeHolder<?>> recipes) {
        return this.da.b(recipes, this);
    }

    @Override
    public void s() {
        super.s();
        this.a(StatisticList.E);
        if (this.cj()) {
            this.causeFoodExhaustion(this.dV().spigotConfig.jumpSprintExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP_SPRINT);
        } else {
            this.causeFoodExhaustion(this.dV().spigotConfig.jumpWalkExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP);
        }
    }

    @Override
    public void d(int xpPoints) {
        super.d(xpPoints);
        this.cT = -1;
    }

    public void t() {
        this.dd = true;
        this.bP();
        if (this.bZ() && this.dk() instanceof EntityPlayer) {
            this.ae();
        }
        if (this.fR()) {
            this.a(true, false);
        }
    }

    @Override
    public boolean u() {
        return this.dd;
    }

    public void v() {
        this.cQ = -1.0E8f;
        this.cT = -1;
    }

    @Override
    public void a(IChatBaseComponent chatComponent, boolean actionBar) {
        this.b(chatComponent, actionBar);
    }

    @Override
    public void w() {
        if (!this.by.f() && this.fz()) {
            this.f.b(new PacketPlayOutEntityStatus(this, 9));
            super.w();
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor anchor, Vec3D target) {
        super.a(anchor, target);
        this.f.b(new PacketPlayOutLookAt(anchor, target.d, target.e, target.f));
    }

    public void a(ArgumentAnchor.Anchor fromAnchor, net.minecraft.world.entity.Entity entity, ArgumentAnchor.Anchor toAnchor) {
        Vec3D vec3 = toAnchor.a(entity);
        super.a(fromAnchor, vec3);
        this.f.b(new PacketPlayOutLookAt(fromAnchor, entity, toAnchor));
    }

    public void a(EntityPlayer that, boolean keepEverything) {
        this.dt = that.dt;
        this.dA = that.dA;
        this.h.a(that.h.b(), that.h.c());
        this.x();
        if (keepEverything) {
            this.eY().b(that.eY());
            this.x(that.eD());
            this.ce = that.ce;
            for (MobEffect mobEffect : that.eA()) {
            }
            this.gi().a(that.gi());
            this.cr = that.cr;
            this.cs = that.cs;
            this.ct = that.ct;
            this.q(that.gd());
            this.as = that.as;
        } else {
            this.eY().b(that.eY());
            if (this.y().O().b(GameRules.d) || that.Z_()) {
                this.gi().a(that.gi());
                this.cr = that.cr;
                this.cs = that.cs;
                this.ct = that.ct;
                this.q(that.gd());
            }
        }
        this.cu = that.cu;
        this.cb = that.cb;
        this.au().a(EntityHuman.bW, that.au().a(EntityHuman.bW));
        this.cT = -1;
        this.cQ = -1.0f;
        this.cR = -1;
        this.i = that.i;
        this.dh = that.dh;
        this.dk = that.dk;
        this.i(that.gA());
        this.j(that.gB());
        this.c(that.gI());
    }

    @Override
    protected void a(MobEffect effectInstance, @Nullable net.minecraft.world.entity.Entity entity) {
        super.a(effectInstance, entity);
        this.f.b(new PacketPlayOutEntityEffect(this.ar(), effectInstance, true));
        if (effectInstance.a(MobEffects.y)) {
            this.dc = this.af;
            this.db = this.dt();
        }
        CriterionTriggers.B.a(this, entity);
    }

    @Override
    protected void a(MobEffect effectInstance, boolean forced, @Nullable net.minecraft.world.entity.Entity entity) {
        super.a(effectInstance, forced, entity);
        this.f.b(new PacketPlayOutEntityEffect(this.ar(), effectInstance, false));
        CriterionTriggers.B.a(this, entity);
    }

    @Override
    protected void c(Collection<MobEffect> effects) {
        super.c(effects);
        for (MobEffect mobEffectInstance : effects) {
            this.f.b(new PacketPlayOutRemoveEntityEffect(this.ar(), mobEffectInstance.c()));
            if (!mobEffectInstance.a(MobEffects.y)) continue;
            this.db = null;
        }
        CriterionTriggers.B.a(this, (net.minecraft.world.entity.Entity)null);
    }

    @Override
    public void c(double x2, double y2, double z2) {
        this.f.a(new PositionMoveRotation(new Vec3D(x2, y2, z2), Vec3D.c, 0.0f, 0.0f), Relative.a(Relative.l, Relative.k));
    }

    @Override
    public void d(double dx, double dy, double dz) {
        this.f.a(new PositionMoveRotation(new Vec3D(dx, dy, dz), Vec3D.c, 0.0f, 0.0f), Relative.j);
    }

    @Override
    public boolean teleportTo(WorldServer level, double x2, double y2, double z2, Set<Relative> relativeMovements, float yaw, float pitch, boolean setCamera, PlayerTeleportEvent.TeleportCause cause) {
        boolean flag;
        if (this.fR()) {
            this.a(true, true);
        }
        if (setCamera) {
            this.d((net.minecraft.world.entity.Entity)this);
        }
        if (flag = super.teleportTo(level, x2, y2, z2, relativeMovements, yaw, pitch, setCamera, cause)) {
            this.q(relativeMovements.contains((Object)Relative.d) ? this.cA() + yaw : yaw);
        }
        return flag;
    }

    @Override
    public void e(double x2, double y2, double z2) {
        super.e(x2, y2, z2);
        this.f.l();
    }

    @Override
    public void b(net.minecraft.world.entity.Entity entityHit) {
        this.y().m().a(this, new PacketPlayOutAnimation(entityHit, 4));
    }

    @Override
    public void c(net.minecraft.world.entity.Entity entityHit) {
        this.y().m().a(this, new PacketPlayOutAnimation(entityHit, 5));
    }

    @Override
    public void x() {
        if (this.f != null) {
            this.f.b(new PacketPlayOutAbilities(this.gj()));
            this.K();
        }
    }

    public WorldServer y() {
        return (WorldServer)this.dV();
    }

    public boolean a(EnumGamemode gameMode) {
        PlayerGameModeChangeEvent event = this.setGameMode(gameMode, PlayerGameModeChangeEvent.Cause.UNKNOWN, null);
        return event == null ? false : event.isCancelled();
    }

    @Nullable
    public PlayerGameModeChangeEvent setGameMode(EnumGamemode gameMode, PlayerGameModeChangeEvent.Cause cause, @Nullable Component message) {
        boolean isSpectator = this.Z_();
        PlayerGameModeChangeEvent event = this.h.changeGameModeForPlayer(gameMode, cause, message);
        if (event == null || event.isCancelled()) {
            return null;
        }
        this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.e, gameMode.a()));
        if (gameMode == EnumGamemode.d) {
            this.gx();
            this.ae();
            EnchantmentManager.a(this);
        } else {
            this.d((net.minecraft.world.entity.Entity)this);
            if (isSpectator) {
                EnchantmentManager.a(this.y(), (EntityLiving)this);
            }
        }
        this.x();
        this.fx();
        return event;
    }

    @Override
    public boolean Z_() {
        return this.h.b() == EnumGamemode.d;
    }

    @Override
    public boolean b() {
        return this.h.b() == EnumGamemode.b;
    }

    public ICommandListener z() {
        return this.dB;
    }

    public CommandListenerWrapper A() {
        return new CommandListenerWrapper(this.z(), this.dt(), this.bU(), this.y(), this.G(), this.al().getString(), this.p_(), this.g, this);
    }

    public void a(IChatBaseComponent mesage) {
        this.b(mesage, false);
    }

    public void b(IChatBaseComponent message, boolean overlay) {
        if (this.y(overlay)) {
            this.f.a(new ClientboundSystemChatPacket(message, overlay), PacketSendListener.a(() -> {
                if (this.y(false)) {
                    int i2 = 256;
                    String string = message.a(256);
                    IChatMutableComponent component = IChatBaseComponent.b(string).a(EnumChatFormat.o);
                    return new ClientboundSystemChatPacket(IChatBaseComponent.a("multiplayer.message_not_delivered", component).a(EnumChatFormat.m), false);
                }
                return null;
            }));
        }
    }

    public void a(OutgoingChatMessage message, boolean filtered, ChatMessageType.a boundType) {
        this.sendChatMessage(message, filtered, boundType, null);
    }

    public void sendChatMessage(OutgoingChatMessage message, boolean filtered, ChatMessageType.a boundType, @Nullable IChatBaseComponent unsigned) {
        if (this.gV()) {
            message.sendToPlayer(this, filtered, boundType, unsigned);
        }
    }

    public String B() {
        String string;
        SocketAddress socketAddress = this.f.m();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            string = InetAddresses.toAddrString((InetAddress)inetSocketAddress.getAddress());
        } else {
            string = "<unknown>";
        }
        return string;
    }

    public void a(ClientInformation clientInformation) {
        PlayerChangedMainHandEvent event;
        new PlayerClientOptionsChangeEvent((Player)this.getBukkitEntity(), (Map)SystemUtils.a(new IdentityHashMap(), (? super T map) -> {
            map.put(ClientOption.LOCALE, clientInformation.b());
            map.put(ClientOption.VIEW_DISTANCE, clientInformation.c());
            map.put(ClientOption.CHAT_VISIBILITY, ClientOption.ChatVisibility.valueOf((String)clientInformation.d().name()));
            map.put(ClientOption.CHAT_COLORS_ENABLED, clientInformation.e());
            map.put(ClientOption.SKIN_PARTS, new PaperSkinParts(clientInformation.f()));
            map.put(ClientOption.MAIN_HAND, clientInformation.g() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT);
            map.put(ClientOption.TEXT_FILTERING_ENABLED, clientInformation.h());
            map.put(ClientOption.ALLOW_SERVER_LISTINGS, clientInformation.i());
            map.put(ClientOption.PARTICLE_VISIBILITY, ClientOption.ParticleVisibility.valueOf((String)clientInformation.j().name()));
        })).callEvent();
        if (this.fy() != clientInformation.g()) {
            event = new PlayerChangedMainHandEvent((Player)this.getBukkitEntity(), clientInformation.g() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT);
            this.g.server.getPluginManager().callEvent((Event)event);
        }
        if (this.df == null || !this.df.equals(clientInformation.b())) {
            event = new PlayerLocaleChangeEvent((Player)this.getBukkitEntity(), clientInformation.b());
            this.g.server.getPluginManager().callEvent((Event)event);
        }
        this.updateOptionsNoEvents(clientInformation);
    }

    public void updateOptionsNoEvents(ClientInformation clientInformation) {
        this.df = clientInformation.b();
        this.adventure$locale = Objects.requireNonNullElse(Translator.parseLocale((String)this.df), Locale.US);
        this.de = clientInformation.c();
        this.cU = clientInformation.d();
        this.cW = clientInformation.e();
        this.dq = clientInformation.h();
        this.dr = clientInformation.i();
        this.cV = clientInformation.j();
        this.au().a(EntityHuman.bW, (byte)clientInformation.f());
        this.au().a(EntityHuman.bX, (byte)clientInformation.g().b());
    }

    public ClientInformation C() {
        byte i2 = this.au().a(EntityHuman.bW);
        EnumMainHand humanoidArm = EnumMainHand.d.apply(this.au().a(EntityHuman.bX).byteValue());
        return new ClientInformation(this.df, this.de, this.cU, this.cW, i2, humanoidArm, this.dq, this.dr, this.cV);
    }

    public boolean D() {
        return this.cW;
    }

    public EnumChatVisibility E() {
        return this.cU;
    }

    private boolean y(boolean overlay) {
        return this.cU != EnumChatVisibility.c || overlay;
    }

    private boolean gV() {
        return this.cU == EnumChatVisibility.a;
    }

    public int F() {
        return this.de;
    }

    public void a(ServerPing serverStatus) {
        this.f.b(new ClientboundServerDataPacket(serverStatus.a(), serverStatus.d().map(ServerPing.a::a)));
    }

    @Override
    public int G() {
        return this.g.c(this.gh());
    }

    @Override
    public void H() {
        this.cX = SystemUtils.c();
    }

    public ServerStatisticManager I() {
        return this.cJ;
    }

    public RecipeBookServer J() {
        return this.da;
    }

    @Override
    protected void K() {
        if (this.Z_()) {
            this.ey();
            this.k(true);
        } else {
            super.K();
        }
    }

    public net.minecraft.world.entity.Entity L() {
        return this.cY == null ? this : this.cY;
    }

    public void d(@Nullable net.minecraft.world.entity.Entity entityToSpectate) {
        net.minecraft.world.entity.Entity camera = this.L();
        net.minecraft.world.entity.Entity entity = this.cY = entityToSpectate == null ? this : entityToSpectate;
        if (camera != this.cY) {
            net.minecraft.world.level.World world;
            if (this.cY == this) {
                PlayerStopSpectatingEntityEvent playerStopSpectatingEntityEvent = new PlayerStopSpectatingEntityEvent((Player)this.getBukkitEntity(), (Entity)camera.getBukkitEntity());
                if (!playerStopSpectatingEntityEvent.callEvent()) {
                    this.cY = camera;
                    return;
                }
            } else {
                PlayerStartSpectatingEntityEvent playerStartSpectatingEntityEvent = new PlayerStartSpectatingEntityEvent((Player)this.getBukkitEntity(), (Entity)camera.getBukkitEntity(), (Entity)entityToSpectate.getBukkitEntity());
                if (!playerStartSpectatingEntityEvent.callEvent()) {
                    this.cY = camera;
                    return;
                }
            }
            if ((world = this.cY.dV()) instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                this.teleportTo(serverLevel, this.cY.dA(), this.cY.dC(), this.cY.dG(), Set.of(), this.dL(), this.dN(), false, PlayerTeleportEvent.TeleportCause.SPECTATE);
            }
            if (entityToSpectate != null) {
                this.y().m().a(this);
            }
            this.f.b(new PacketPlayOutCamera(this.cY));
            this.f.l();
        }
    }

    @Override
    protected void M() {
        if (!this.cZ) {
            super.M();
        }
    }

    @Override
    public void e(net.minecraft.world.entity.Entity targetEntity) {
        if (this.h.b() == EnumGamemode.d) {
            this.d(targetEntity);
        } else {
            super.e(targetEntity);
        }
    }

    public long N() {
        return this.cX;
    }

    @Nullable
    public IChatBaseComponent O() {
        return this.listName;
    }

    public int P() {
        return this.listOrder;
    }

    @Override
    public void a(EnumHand hand) {
        super.a(hand);
        this.gD();
    }

    public boolean Q() {
        return this.cZ;
    }

    public void R() {
        this.cZ = false;
    }

    public AdvancementDataPlayer S() {
        return this.cI;
    }

    @Nullable
    public BlockPosition T() {
        return this.dm;
    }

    public float U() {
        return this.do;
    }

    public ResourceKey<net.minecraft.world.level.World> V() {
        return this.dl;
    }

    public boolean W() {
        return this.dn;
    }

    public void b(EntityPlayer player) {
        this.a(player.V(), player.T(), player.U(), player.W(), false);
    }

    @Deprecated
    public void a(ResourceKey<net.minecraft.world.level.World> dimension, @Nullable BlockPosition position, float angle, boolean forced, boolean sendMessage) {
        this.setRespawnPosition(dimension, position, angle, forced, sendMessage, PlayerSetSpawnEvent.Cause.UNKNOWN);
    }

    @Deprecated
    public boolean setRespawnPosition(ResourceKey<net.minecraft.world.level.World> dimension, @Nullable BlockPosition position, float angle, boolean forced, boolean sendMessage, PlayerSpawnChangeEvent.Cause cause) {
        return this.setRespawnPosition(dimension, position, angle, forced, sendMessage, cause == PlayerSpawnChangeEvent.Cause.RESET ? PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN : PlayerSetSpawnEvent.Cause.valueOf((String)cause.name()));
    }

    public boolean setRespawnPosition(ResourceKey<net.minecraft.world.level.World> dimension, @Nullable BlockPosition position, float angle, boolean forced, boolean sendMessage, PlayerSetSpawnEvent.Cause cause) {
        Location spawnLoc = null;
        boolean willNotify = false;
        if (position != null) {
            boolean flag = position.equals(this.dm) && dimension.equals(this.dl);
            spawnLoc = MCUtil.toLocation(this.cV().a(dimension), position);
            spawnLoc.setYaw(angle);
            willNotify = sendMessage && !flag;
        }
        PlayerSpawnChangeEvent dumbEvent = new PlayerSpawnChangeEvent((Player)this.getBukkitEntity(), spawnLoc, forced, cause == PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN ? PlayerSpawnChangeEvent.Cause.RESET : PlayerSpawnChangeEvent.Cause.valueOf((String)cause.name()));
        dumbEvent.callEvent();
        PlayerSetSpawnEvent event = new PlayerSetSpawnEvent((Player)this.getBukkitEntity(), cause, dumbEvent.getNewSpawn(), dumbEvent.isForced(), willNotify, (Component)(willNotify ? Component.translatable((String)"block.minecraft.set_spawn") : null));
        event.setCancelled(dumbEvent.isCancelled());
        if (!event.callEvent()) {
            return false;
        }
        if (event.getLocation() != null) {
            dimension = event.getLocation().getWorld() != null ? ((CraftWorld)event.getLocation().getWorld()).getHandle().ai() : dimension;
            position = MCUtil.toBlockPosition(event.getLocation());
            angle = event.getLocation().getYaw();
            forced = event.isForced();
            if (event.willNotifyPlayer() && event.getNotification() != null) {
                this.a(PaperAdventure.asVanilla(event.getNotification()));
            }
            this.dm = position;
            this.dl = dimension;
            this.do = angle;
            this.dn = forced;
        } else {
            this.dm = null;
            this.dl = net.minecraft.world.level.World.i;
            this.do = 0.0f;
            this.dn = false;
        }
        return true;
    }

    public SectionPosition X() {
        return this.dj;
    }

    public void a(SectionPosition sectionPos) {
        this.dj = sectionPos;
    }

    public ChunkTrackingView Y() {
        return this.dk;
    }

    public void a(ChunkTrackingView chunkTrackingView) {
        this.dk = chunkTrackingView;
    }

    @Override
    public void a(SoundEffect sound, SoundCategory source, float volume, float pitch) {
        this.f.b(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.b.e(sound), source, this.dA(), this.dC(), this.dG(), volume, pitch, this.ae.g()));
    }

    @Override
    public EntityItem drop(ItemStack droppedItem, boolean dropAround, boolean traceItem, boolean callEvent, @Nullable Consumer<Item> entityOperation) {
        WorldMap mapData;
        EntityItem itemEntity = this.b(droppedItem, dropAround, traceItem);
        if (itemEntity == null) {
            return null;
        }
        if (entityOperation != null) {
            entityOperation.accept((Item)itemEntity.getBukkitEntity());
        }
        if (callEvent) {
            CraftPlayer player = this.getBukkitEntity();
            Item drop = (Item)itemEntity.getBukkitEntity();
            PlayerDropItemEvent event = new PlayerDropItemEvent((Player)player, drop);
            this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                org.bukkit.inventory.ItemStack cur = player.getInventory().getItemInHand();
                if (traceItem && (cur == null || cur.getAmount() == 0)) {
                    player.getInventory().setItemInHand(drop.getItemStack());
                } else if (traceItem && cur.isSimilar(drop.getItemStack()) && cur.getAmount() < cur.getMaxStackSize() && drop.getItemStack().getAmount() == 1) {
                    cur.setAmount(cur.getAmount() + 1);
                    player.getInventory().setItemInHand(cur);
                } else {
                    player.getInventory().addItem(new org.bukkit.inventory.ItemStack[]{drop.getItemStack()});
                }
                return null;
            }
        }
        this.dV().b(itemEntity);
        ItemStack item = itemEntity.l();
        if (traceItem) {
            if (!item.f()) {
                this.a(StatisticList.f.b(item.h()), item.M());
            }
            this.a(StatisticList.F);
        }
        if (item.h() == Items.sR && (mapData = ItemWorldMap.b(item, this.dV())) != null) {
            mapData.a(this, item);
        }
        return itemEntity;
    }

    @Nullable
    private EntityItem b(ItemStack droppedItem, boolean dropAround, boolean includeThrowerName) {
        if (droppedItem.f()) {
            return null;
        }
        double d2 = this.dE() - (double)0.3f;
        ItemStack tmp = droppedItem.v();
        droppedItem.e(0);
        droppedItem = tmp;
        EntityItem itemEntity = new EntityItem(this.dV(), this.dA(), d2, this.dG(), droppedItem);
        itemEntity.b(40);
        if (includeThrowerName) {
            itemEntity.b((net.minecraft.world.entity.Entity)this);
        }
        if (dropAround) {
            float f2 = this.ae.i() * 0.5f;
            float f1 = this.ae.i() * ((float)Math.PI * 2);
            itemEntity.n(-MathHelper.a(f1) * f2, 0.2f, MathHelper.b(f1) * f2);
        } else {
            float f3 = 0.3f;
            float f1 = MathHelper.a(this.dN() * ((float)Math.PI / 180));
            float cos = MathHelper.b(this.dN() * ((float)Math.PI / 180));
            float sin = MathHelper.a(this.dL() * ((float)Math.PI / 180));
            float cos1 = MathHelper.b(this.dL() * ((float)Math.PI / 180));
            float f2 = this.ae.i() * ((float)Math.PI * 2);
            float f32 = 0.02f * this.ae.i();
            itemEntity.n((double)(-sin * cos * 0.3f) + Math.cos(f2) * (double)f32, -f1 * 0.3f + 0.1f + (this.ae.i() - this.ae.i()) * 0.1f, (double)(cos1 * cos * 0.3f) + Math.sin(f2) * (double)f32);
        }
        return itemEntity;
    }

    public ITextFilter Z() {
        return this.dp;
    }

    public void a(WorldServer level) {
        this.a((net.minecraft.world.level.World)level);
        this.h.a(level);
    }

    @Nullable
    private static EnumGamemode a(@Nullable NBTTagCompound tag, String key) {
        return tag != null && tag.b(key, 99) ? EnumGamemode.a(tag.h(key)) : null;
    }

    private EnumGamemode b(@Nullable EnumGamemode gameType) {
        EnumGamemode forcedGameType = this.g.bd();
        if (forcedGameType != null) {
            return forcedGameType;
        }
        return gameType != null ? gameType : this.g.u();
    }

    public void c(@Nullable NBTTagCompound tag) {
        if (this.g.bd() != null && this.g.bd() != EntityPlayer.a(tag, "playerGameType")) {
            if (new PlayerGameModeChangeEvent((Player)this.getBukkitEntity(), GameMode.getByValue((int)this.g.u().a()), PlayerGameModeChangeEvent.Cause.DEFAULT_GAMEMODE, null).callEvent()) {
                this.h.a(this.g.bd(), EnumGamemode.e);
            } else {
                this.h.a(EntityPlayer.a(tag, "playerGameType"), EntityPlayer.a(tag, "previousPlayerGameType"));
            }
            return;
        }
        this.h.a(this.b(EntityPlayer.a(tag, "playerGameType")), EntityPlayer.a(tag, "previousPlayerGameType"));
    }

    private void m(NBTTagCompound tag) {
        tag.a("playerGameType", this.h.b().a());
        EnumGamemode previousGameModeForPlayer = this.h.c();
        if (previousGameModeForPlayer != null) {
            tag.a("previousPlayerGameType", previousGameModeForPlayer.a());
        }
    }

    @Override
    public boolean aa() {
        return this.dq;
    }

    public boolean c(EntityPlayer player) {
        return player != this && (this.dq || player.dq);
    }

    @Override
    public boolean c(WorldServer level, BlockPosition pos) {
        return super.c(level, pos) && level.a((EntityHuman)this, pos);
    }

    @Override
    protected void a(ItemStack usingItem) {
        CriterionTriggers.W.a(this, usingItem);
        super.a(usingItem);
    }

    public boolean a(boolean dropStack) {
        PlayerInventory inventory = this.gi();
        ItemStack itemStack = inventory.a(dropStack);
        this.cd.b(inventory, inventory.j).ifPresent(i2 -> this.cd.a(i2, inventory.f()));
        return this.a(itemStack, false, true) != null;
    }

    @Override
    public void b(ItemStack stack) {
        if (!this.gi().f(stack)) {
            this.a(stack, false);
        }
    }

    public boolean ab() {
        return this.dr;
    }

    @Override
    public Optional<WardenSpawnTracker> ac() {
        return Optional.of(this.dt);
    }

    public void b(boolean spawnExtraParticlesOnFall) {
        this.ds = spawnExtraParticlesOnFall;
    }

    @Override
    public void a(EntityItem itemEntity) {
        super.a(itemEntity);
        net.minecraft.world.entity.Entity owner = itemEntity.p();
        if (owner != null) {
            CriterionTriggers.S.a(this, itemEntity.l(), owner);
        }
    }

    public void a(RemoteChatSession chatSession) {
        this.dA = chatSession;
    }

    @Nullable
    public RemoteChatSession ad() {
        return this.dA != null && this.dA.b() ? null : this.dA;
    }

    @Override
    public void a(double xDistance, double zDistance) {
        this.cx = (float)(MathHelper.d(zDistance, xDistance) * 180.0 / 3.1415927410125732 - (double)this.dL());
        this.f.b(new ClientboundHurtAnimationPacket(this));
    }

    @Override
    public boolean a(net.minecraft.world.entity.Entity vehicle, boolean force) {
        if (super.a(vehicle, force)) {
            vehicle.j(this);
            this.f.a(new PositionMoveRotation(this.dt(), Vec3D.c, 0.0f, 0.0f), Relative.k);
            if (vehicle instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)vehicle;
                this.g.ag().a(livingEntity, this.f);
            }
            return true;
        }
        return false;
    }

    @Override
    public void ae() {
        this.stopRiding(false);
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        net.minecraft.world.entity.Entity vehicle = this.dk();
        super.stopRiding(suppressCancellation);
        if (vehicle instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)vehicle;
            for (MobEffect mobEffectInstance : livingEntity.eA()) {
                this.f.b(new PacketPlayOutRemoveEntityEffect(vehicle.ar(), mobEffectInstance.c()));
            }
        }
    }

    public CommonPlayerSpawnInfo b(WorldServer level) {
        return new CommonPlayerSpawnInfo(level.ah(), level.ai(), BiomeManager.a(level.E()), this.h.b(), this.h.c(), level.aj(), level.D(), this.gI(), this.aC(), level.P());
    }

    public void c(BlockPosition raidOmenPosition) {
        this.du = raidOmenPosition;
    }

    public void af() {
        this.du = null;
    }

    @Nullable
    public BlockPosition ag() {
        return this.du;
    }

    @Override
    public Vec3D ah() {
        net.minecraft.world.entity.Entity vehicle = this.dk();
        return vehicle != null && vehicle.cW() != this ? vehicle.ah() : this.dv;
    }

    public void a(Vec3D knownMovement) {
        this.dv = knownMovement;
    }

    @Override
    protected float a(net.minecraft.world.entity.Entity entity, float damage, DamageSource damageSource) {
        return EnchantmentManager.a(this.y(), this.dZ(), entity, damageSource, damage);
    }

    @Override
    public void a(net.minecraft.world.item.Item item, EnumItemSlot slot) {
        super.a(item, slot);
        this.b(StatisticList.d.b(item));
    }

    public Input ai() {
        return this.dw;
    }

    public void a(Input lastClientInput) {
        this.dw = lastClientInput;
    }

    public Vec3D aj() {
        float f2;
        float f3 = this.dw.c() == this.dw.d() ? 0.0f : (f2 = this.dw.c() ? 1.0f : -1.0f);
        float f1 = this.dw.a() == this.dw.b() ? 0.0f : (this.dw.a() ? 1.0f : -1.0f);
        return EntityPlayer.a(new Vec3D(f2, 0.0, f1), 1.0f, this.dL());
    }

    public void a(EntityEnderPearl enderPearl) {
        this.dx.add(enderPearl);
    }

    public void b(EntityEnderPearl enderPearl) {
        this.dx.remove(enderPearl);
    }

    public Set<EntityEnderPearl> ak() {
        return this.dx;
    }

    public long c(EntityEnderPearl enderPearl) {
        net.minecraft.world.level.World world = enderPearl.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            ChunkCoordIntPair chunkPos = enderPearl.dx();
            this.a(enderPearl);
            serverLevel.i();
            return EntityPlayer.a(serverLevel, chunkPos) - 1L;
        }
        return 0L;
    }

    public static long a(WorldServer level, ChunkCoordIntPair pos) {
        if (!level.paperConfig().misc.legacyEnderPearlBehavior) {
            level.m().a(TicketType.f, pos, 2, pos);
        }
        return TicketType.f.b();
    }

    public long getPlayerTime() {
        if (this.relativeTime) {
            return this.dV().ae() + this.timeOffset;
        }
        return this.dV().ae() - this.dV().ae() % 24000L + this.timeOffset;
    }

    public WeatherType getPlayerWeather() {
        return this.weather;
    }

    public void setPlayerWeather(WeatherType type, boolean plugin) {
        if (!plugin && this.weather != null) {
            return;
        }
        if (plugin) {
            this.weather = type;
        }
        if (type == WeatherType.DOWNFALL) {
            this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.d, 0.0f));
        } else {
            this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.c, 0.0f));
        }
    }

    public void updateWeather(float oldRain, float newRain, float oldThunder, float newThunder) {
        if (this.weather == null) {
            if (oldRain != newRain) {
                this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, newRain));
            }
        } else if (this.pluginRainPositionPrevious != this.pluginRainPosition) {
            this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, this.pluginRainPosition));
        }
        if (oldThunder != newThunder) {
            if (this.weather == WeatherType.DOWNFALL || this.weather == null) {
                this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.j, newThunder));
            } else {
                this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.j, 0.0f));
            }
        }
    }

    public void tickWeather() {
        if (this.weather == null) {
            return;
        }
        this.pluginRainPositionPrevious = this.pluginRainPosition;
        this.pluginRainPosition = this.weather == WeatherType.DOWNFALL ? (float)((double)this.pluginRainPosition + 0.01) : (float)((double)this.pluginRainPosition - 0.01);
        this.pluginRainPosition = MathHelper.a(this.pluginRainPosition, 0.0f, 1.0f);
    }

    public void resetPlayerWeather() {
        this.weather = null;
        this.setPlayerWeather(this.dV().D_().i() ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.cI() + " at " + this.dA() + "," + this.dC() + "," + this.dG() + ")";
    }

    public void forceSetPositionRotation(double x2, double y2, double z2, float yaw, float pitch) {
        this.b(x2, y2, z2, yaw, pitch);
        this.f.l();
    }

    @Override
    public boolean fi() {
        return super.fi() || this.f != null && this.f.isDisconnected();
    }

    @Override
    public Scoreboard gy() {
        return this.getBukkitEntity().getScoreboard().getHandle();
    }

    public void reset() {
        float exp = 0.0f;
        if (this.keepLevel) {
            exp = this.ct;
            this.newTotalExp = this.cs;
            this.newLevel = this.cr;
        }
        this.x(this.eS());
        this.fF();
        this.j(this.cs());
        this.h(0);
        this.Z = 0.0f;
        this.ce = new FoodMetaData();
        this.cr = this.newLevel;
        this.cs = this.newTotalExp;
        this.ct = 0.0f;
        this.aP = 0;
        this.setArrowCount(0, true);
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        ((EntityLiving)this).bY = true;
        this.cd = this.cc;
        this.bc = null;
        ((EntityLiving)this).bZ = null;
        ((EntityLiving)this).bS = new CombatTracker(this);
        this.cT = -1;
        if (this.keepLevel) {
            this.ct = exp;
        } else {
            this.d(this.newExp);
        }
        this.keepLevel = false;
        this.n(0.0, 0.0, 0.0);
        ((EntityLiving)this).cm = false;
    }

    @Override
    public CraftPlayer getBukkitEntity() {
        return (CraftPlayer)super.getBukkitEntity();
    }

    public record RespawnPosAngle(Vec3D a, float b, boolean isBedSpawn, boolean isAnchorSpawn) {
        public static RespawnPosAngle of(Vec3D position, BlockPosition towardsPos, boolean isBedSpawn, boolean isAnchorSpawn) {
            return new RespawnPosAngle(position, RespawnPosAngle.b(position, towardsPos), isBedSpawn, isAnchorSpawn);
        }

        private static float b(Vec3D position, BlockPosition towardsPos) {
            Vec3D vec3 = Vec3D.c(towardsPos).d(position).d();
            return (float)MathHelper.d(MathHelper.d(vec3.f, vec3.d) * 180.0 / 3.1415927410125732 - 90.0);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;isBedSpawn;isAnchorSpawn", "a", "b", "isBedSpawn", "isAnchorSpawn"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;isBedSpawn;isAnchorSpawn", "a", "b", "isBedSpawn", "isAnchorSpawn"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;isBedSpawn;isAnchorSpawn", "a", "b", "isBedSpawn", "isAnchorSpawn"}, this, o2);
        }
    }
}

