/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.concurrentutil.map.ConcurrentLong2ReferenceChainedHashTable;
import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.misc.NearbyPlayers;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.SimpleThreadUnsafeRandom;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkData;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.world.ChunkSystemServerChunkCache;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.slf4j.Logger;

public class ChunkProviderServer
extends IChunkProvider
implements ChunkSystemServerChunkCache {
    private static final Logger b = LogUtils.getLogger();
    private final ChunkMapDistance c;
    private final WorldServer d;
    public final Thread e;
    final LightEngineThreaded f;
    public final b g;
    public final PlayerChunkMap a;
    private final WorldPersistentData h;
    private long i;
    public boolean j = true;
    public boolean k = true;
    private static final int l = 4;
    private final long[] m = new long[4];
    private final ChunkStatus[] n = new ChunkStatus[4];
    private final IChunkAccess[] o = new IChunkAccess[4];
    private final List<Chunk> p = new ArrayList<Chunk>();
    private final Set<PlayerChunk> q = new ReferenceOpenHashSet();
    @Nullable
    @VisibleForDebug
    private SpawnerCreature.d r;
    private final ConcurrentLong2ReferenceChainedHashTable<Chunk> fullChunks = new ConcurrentLong2ReferenceChainedHashTable();
    long chunkFutureAwaitCounter;
    private final SimpleThreadUnsafeRandom shuffleRandom = new SimpleThreadUnsafeRandom(0L);

    public int getFullChunksCount() {
        return this.fullChunks.size();
    }

    @Override
    public final void moonrise$setFullChunk(int chunkX, int chunkZ, Chunk chunk) {
        long key = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        if (chunk == null) {
            this.fullChunks.remove(key);
        } else {
            this.fullChunks.put(key, (Object)chunk);
        }
    }

    @Override
    public final Chunk moonrise$getFullChunkIfLoaded(int chunkX, int chunkZ) {
        return (Chunk)this.fullChunks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    private IChunkAccess syncLoad(int chunkX, int chunkZ, ChunkStatus toStatus) {
        IChunkAccess ret;
        ChunkTaskScheduler chunkTaskScheduler = this.d.moonrise$getChunkTaskScheduler();
        CompletableFuture completable = new CompletableFuture();
        chunkTaskScheduler.scheduleChunkLoad(chunkX, chunkZ, toStatus, true, Priority.BLOCKING, completable::complete);
        if (!completable.isDone() && chunkTaskScheduler.hasShutdown()) {
            throw new IllegalStateException("Chunk system has shut down, cannot process chunk requests in world '" + WorldUtil.getWorldName(this.d) + "' at (" + chunkX + "," + chunkZ + ") status: " + String.valueOf(toStatus));
        }
        if (TickThread.isTickThreadFor((World)this.d, chunkX, chunkZ)) {
            ChunkTaskScheduler.pushChunkWait(this.d, chunkX, chunkZ);
            this.g.b(completable::isDone);
            ChunkTaskScheduler.popChunkWait();
        }
        if ((ret = (IChunkAccess)completable.join()) == null) {
            throw new IllegalStateException("Chunk not loaded when requested");
        }
        return ret;
    }

    private IChunkAccess getChunkFallback(int chunkX, int chunkZ, ChunkStatus toStatus, boolean load) {
        Chunk loading;
        IChunkAccess ifPresent;
        ChunkTaskScheduler chunkTaskScheduler = this.d.moonrise$getChunkTaskScheduler();
        ChunkHolderManager chunkHolderManager = chunkTaskScheduler.chunkHolderManager;
        NewChunkHolder currentChunk = chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        IChunkAccess iChunkAccess = ifPresent = currentChunk == null ? null : currentChunk.getChunkIfPresent(toStatus);
        if (ifPresent != null && (toStatus != ChunkStatus.n || currentChunk.isFullChunkReady())) {
            return ifPresent;
        }
        PlatformHooks platformHooks = PlatformHooks.get();
        if (platformHooks.hasCurrentlyLoadingChunk() && currentChunk != null && (loading = platformHooks.getCurrentlyLoadingChunk(currentChunk.vanillaChunkHolder)) != null && TickThread.isTickThread()) {
            return loading;
        }
        return load ? this.syncLoad(chunkX, chunkZ, toStatus) : null;
    }

    private boolean isChunkNearPlayer(PlayerChunkMap chunkMap, ChunkCoordIntPair chunkPos, Chunk levelChunk) {
        ChunkData chunkData = levelChunk.moonrise$getChunkAndHolder().b().moonrise$getRealChunkHolder().holderData;
        NearbyPlayers.TrackedChunk nearbyPlayers = chunkData.nearbyPlayers;
        if (nearbyPlayers == null) {
            return false;
        }
        ReferenceList<EntityPlayer> players = nearbyPlayers.getPlayers(NearbyPlayers.NearbyMapType.SPAWN_RANGE);
        if (players == null) {
            return false;
        }
        EntityPlayer[] raw = players.getRawDataUnchecked();
        int len = players.size();
        Objects.checkFromIndexSize(0, len, raw.length);
        for (int i2 = 0; i2 < len; ++i2) {
            if (!chunkMap.playerIsCloseEnoughForSpawning(raw[i2], chunkPos, 16384.0)) continue;
            return true;
        }
        return false;
    }

    public ChunkProviderServer(WorldServer level, Convertable.ConversionSession levelStorageAccess, DataFixer fixerUpper, StructureTemplateManager structureManager, Executor dispatcher, ChunkGenerator generator, int viewDistance, int simulationDistance, boolean sync, WorldLoadListener progressListener, ChunkStatusUpdateListener chunkStatusListener, Supplier<WorldPersistentData> overworldDataStorage) {
        this.d = level;
        this.g = new b(level);
        this.e = Thread.currentThread();
        Path path = levelStorageAccess.a(level.ai()).resolve("data");
        try {
            FileUtils.c(path);
        }
        catch (IOException var15) {
            b.error("Failed to create dimension data storage directory", (Throwable)var15);
        }
        this.h = new WorldPersistentData(path, fixerUpper, level.K_());
        this.a = new PlayerChunkMap(level, levelStorageAccess, fixerUpper, structureManager, dispatcher, this.g, this, generator, progressListener, chunkStatusListener, overworldDataStorage, viewDistance, sync);
        this.f = this.a.d();
        this.c = this.a.j();
        this.c.b(simulationDistance);
        this.r();
    }

    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        PlayerChunk chunk = this.a.a(ChunkCoordIntPair.c(chunkX, chunkZ));
        if (chunk == null) {
            return false;
        }
        return chunk.getFullChunkNow() != null;
    }

    @Nullable
    public IChunkAccess getChunkAtImmediately(int x2, int z2) {
        PlayerChunk holder = this.a.b(ChunkCoordIntPair.c(x2, z2));
        if (holder == null) {
            return null;
        }
        return holder.p();
    }

    public <T> void addTicketAtLevel(TicketType<T> ticketType, ChunkCoordIntPair chunkPos, int ticketLevel, T identifier) {
        this.c.a(ticketType, chunkPos, ticketLevel, identifier);
    }

    public <T> void removeTicketAtLevel(TicketType<T> ticketType, ChunkCoordIntPair chunkPos, int ticketLevel, T identifier) {
        this.c.b(ticketType, chunkPos, ticketLevel, identifier);
    }

    @Nullable
    public Chunk getChunkAtIfCachedImmediately(int x2, int z2) {
        long k2 = ChunkCoordIntPair.c(x2, z2);
        PlayerChunk playerChunk = this.b(k2);
        if (playerChunk == null) {
            return null;
        }
        return playerChunk.getFullChunkNowUnchecked();
    }

    @Nullable
    public Chunk getChunkAtIfLoadedImmediately(int x2, int z2) {
        return (Chunk)this.fullChunks.get(ChunkCoordIntPair.c(x2, z2));
    }

    public LightEngineThreaded a() {
        return this.f;
    }

    @Nullable
    private PlayerChunk b(long chunkPos) {
        return this.a.b(chunkPos);
    }

    public int b() {
        return this.a.h();
    }

    private void a(long chunkPos, @Nullable IChunkAccess chunk, ChunkStatus chunkStatus) {
        for (int i2 = 3; i2 > 0; --i2) {
            this.m[i2] = this.m[i2 - 1];
            this.n[i2] = this.n[i2 - 1];
            this.o[i2] = this.o[i2 - 1];
        }
        this.m[0] = chunkPos;
        this.n[0] = chunkStatus;
        this.o[0] = chunk;
    }

    @Override
    @Nullable
    public IChunkAccess a(int x2, int z2, ChunkStatus chunkStatus, boolean requireChunk) {
        if (chunkStatus == ChunkStatus.n) {
            Chunk ret = (Chunk)this.fullChunks.get(CoordinateUtils.getChunkKey(x2, z2));
            if (ret != null) {
                return ret;
            }
            return requireChunk ? this.getChunkFallback(x2, z2, chunkStatus, requireChunk) : null;
        }
        return this.getChunkFallback(x2, z2, chunkStatus, requireChunk);
    }

    @Override
    @Nullable
    public Chunk a(int chunkX, int chunkZ) {
        Chunk ret = (Chunk)this.fullChunks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (!PlatformHooks.get().hasCurrentlyLoadingChunk()) {
            return ret;
        }
        if (ret != null || !TickThread.isTickThread()) {
            return ret;
        }
        NewChunkHolder holder = this.d.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (holder == null) {
            return ret;
        }
        return PlatformHooks.get().getCurrentlyLoadingChunk(holder.vanillaChunkHolder);
    }

    private void r() {
        Arrays.fill(this.m, ChunkCoordIntPair.c);
        Arrays.fill(this.n, null);
        Arrays.fill(this.o, null);
    }

    public CompletableFuture<ChunkResult<IChunkAccess>> b(int x2, int z2, ChunkStatus chunkStatus, boolean requireChunk) {
        CompletionStage<ChunkResult<IChunkAccess>> chunkFutureMainThread;
        boolean flag;
        boolean bl = flag = Thread.currentThread() == this.e;
        if (flag) {
            chunkFutureMainThread = this.c(x2, z2, chunkStatus, requireChunk);
            this.g.b(() -> chunkFutureMainThread.isDone());
        } else {
            chunkFutureMainThread = CompletableFuture.supplyAsync(() -> this.c(x2, z2, chunkStatus, requireChunk), this.g).thenCompose(future -> future);
        }
        return chunkFutureMainThread;
    }

    private CompletableFuture<ChunkResult<IChunkAccess>> c(int x2, int z2, ChunkStatus chunkStatus, boolean requireChunk) {
        IChunkAccess ifPresent;
        boolean needsFullScheduling;
        TickThread.ensureTickThread((World)this.d, x2, z2, "Scheduling chunk load off-main");
        int minLevel = ChunkLevel.a(chunkStatus);
        NewChunkHolder chunkHolder = this.d.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(x2, z2);
        boolean bl = needsFullScheduling = chunkStatus == ChunkStatus.n && (chunkHolder == null || !chunkHolder.getChunkStatus().a(FullChunkStatus.b));
        if ((chunkHolder == null || chunkHolder.getTicketLevel() > minLevel || needsFullScheduling) && !requireChunk) {
            return GenerationChunkHolder.c;
        }
        IChunkAccess iChunkAccess = ifPresent = chunkHolder == null ? null : chunkHolder.getChunkIfPresent(chunkStatus);
        if (needsFullScheduling || ifPresent == null) {
            CompletableFuture<ChunkResult<IChunkAccess>> ret = new CompletableFuture<ChunkResult<IChunkAccess>>();
            Consumer<IChunkAccess> complete = chunk -> {
                if (chunk == null) {
                    ret.complete(GenerationChunkHolder.b);
                } else {
                    ret.complete(ChunkResult.a(chunk));
                }
            };
            this.d.moonrise$getChunkTaskScheduler().scheduleChunkLoad(x2, z2, chunkStatus, true, Priority.HIGHER, complete);
            return ret;
        }
        return CompletableFuture.completedFuture(ChunkResult.a(ifPresent));
    }

    @Override
    public boolean b(int x2, int z2) {
        return this.a(x2, z2) != null;
    }

    @Override
    @Nullable
    public LightChunk c(int chunkX, int chunkZ) {
        NewChunkHolder newChunkHolder = this.d.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (newChunkHolder == null) {
            return null;
        }
        return newChunkHolder.getChunkIfPresentUnchecked(ChunkStatus.k.c());
    }

    public World c() {
        return this.d;
    }

    public boolean d() {
        return this.g.B();
    }

    public boolean s() {
        return this.d.moonrise$getChunkTaskScheduler().chunkHolderManager.processTicketUpdates();
    }

    public boolean a(long chunkPos) {
        NewChunkHolder newChunkHolder = this.d.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return newChunkHolder != null && newChunkHolder.isTickingReady();
    }

    public void a(boolean flush) {
        this.a.a(flush);
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean save) throws IOException {
        this.h.close();
        this.d.moonrise$getChunkTaskScheduler().chunkHolderManager.close(save, true);
    }

    public void purgeUnload() {
    }

    @Override
    public void a(BooleanSupplier hasTimeLeft, boolean tickChunks) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("purge");
        if (this.d.u().i() || !tickChunks || this.d.spigotConfig.unloadFrozenChunks) {
            this.c.a();
        }
        this.s();
        profilerFiller.b("chunks");
        if (tickChunks) {
            this.d.moonrise$getPlayerChunkLoader().tick();
            this.t();
            this.a.l();
        }
        profilerFiller.b("unload");
        this.a.a(hasTimeLeft);
        profilerFiller.c();
        this.r();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void t() {
        long gameTime = this.d.ad();
        long l2 = gameTime - this.i;
        this.i = gameTime;
        if (!this.d.aj()) {
            GameProfilerFiller profilerFiller = Profiler.a();
            profilerFiller.a("pollingChunks");
            if (this.d.u().i()) {
                List<Chunk> list = this.p;
                try {
                    profilerFiller.a("filteringTickingChunks");
                    this.a(list);
                    profilerFiller.b("shuffleChunks");
                    this.shuffleRandom.b(this.d.A.g());
                    if (!this.d.paperConfig().entities.spawning.perPlayerMobSpawns) {
                        SystemUtils.c(list, this.shuffleRandom);
                    }
                    this.a(profilerFiller, l2, list);
                    profilerFiller.c();
                }
                finally {
                    list.clear();
                }
            }
            this.a(profilerFiller);
            profilerFiller.c();
        }
    }

    private void a(GameProfilerFiller profiler) {
        profiler.a("broadcast");
        for (PlayerChunk chunkHolder : this.q) {
            Chunk tickingChunk = chunkHolder.e();
            if (tickingChunk == null) continue;
            chunkHolder.a(tickingChunk);
        }
        this.q.clear();
        profiler.c();
    }

    private void a(List<Chunk> output) {
        ReferenceList<a> tickingChunks = this.d.moonrise$getPlayerTickingChunks();
        a[] raw = tickingChunks.getRawDataUnchecked();
        int size = tickingChunks.size();
        PlayerChunkMap chunkMap = this.a;
        for (int i2 = 0; i2 < size; ++i2) {
            a chunkAndHolder = raw[i2];
            Chunk levelChunk = chunkAndHolder.a();
            if (!this.isChunkNearPlayer(chunkMap, levelChunk.f(), levelChunk)) continue;
            output.add(levelChunk);
        }
    }

    private void a(GameProfilerFiller profiler, long timeInhabited, List<Chunk> chunks) {
        List<EnumCreatureType> filteredSpawningCategories;
        SpawnerCreature.d spawnState;
        profiler.b("naturalSpawnCount");
        int naturalSpawnChunkCount = this.c.b();
        if ((this.k || this.j) && this.d.paperConfig().entities.spawning.perPlayerMobSpawns) {
            for (EntityPlayer player : this.d.I) {
                for (int ii = 0; ii < EntityPlayer.MOBCATEGORY_TOTAL_ENUMS; ++ii) {
                    player.mobCounts[ii] = 0;
                    int newBackoff = player.mobBackoffCounts[ii] - 1;
                    if (newBackoff < 0) {
                        newBackoff = 0;
                    }
                    player.mobBackoffCounts[ii] = newBackoff;
                }
            }
            spawnState = SpawnerCreature.createState(naturalSpawnChunkCount, this.d.C(), this::a, null, true);
        } else {
            spawnState = SpawnerCreature.createState(naturalSpawnChunkCount, this.d.C(), this::a, !this.d.paperConfig().entities.spawning.perPlayerMobSpawns ? new LocalMobCapCalculator(this.a) : null, false);
        }
        this.r = spawnState;
        profiler.b("spawnAndTick");
        boolean _boolean = this.d.O().b(GameRules.e) && !this.d.z().isEmpty();
        int _int = this.d.O().c(GameRules.o);
        if (_boolean && (this.j || this.k)) {
            for (EntityPlayer entityPlayer : this.d.z()) {
                int chunkRange = Math.min(this.d.spigotConfig.mobSpawnRange, entityPlayer.getBukkitEntity().getViewDistance());
                chunkRange = Math.min(chunkRange, 8);
                entityPlayer.playerNaturallySpawnedEvent = new PlayerNaturallySpawnCreaturesEvent((Player)entityPlayer.getBukkitEntity(), (byte)chunkRange);
                entityPlayer.playerNaturallySpawnedEvent.callEvent();
            }
            boolean flag = this.d.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) != 0L && this.d.D_().c() % this.d.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) == 0L;
            filteredSpawningCategories = SpawnerCreature.getFilteredSpawningCategories(spawnState, this.k, this.j, flag, this.d);
        } else {
            filteredSpawningCategories = List.of();
        }
        for (Chunk levelChunk : chunks) {
            ChunkCoordIntPair pos = levelChunk.f();
            levelChunk.b(timeInhabited);
            if (!filteredSpawningCategories.isEmpty() && this.d.F_().a(pos) && this.a.anyPlayerCloseEnoughForSpawning(pos, true)) {
                SpawnerCreature.a(this.d, levelChunk, spawnState, filteredSpawningCategories);
            }
            this.d.a(levelChunk, _int);
        }
        profiler.b("customSpawners");
        if (_boolean) {
            this.d.a(this.j, this.k);
        }
    }

    private void a(long chunkPos, Consumer<Chunk> fullChunkGetter) {
        Chunk fullChunk = (Chunk)this.fullChunks.get(chunkPos);
        if (fullChunk != null) {
            fullChunkGetter.accept(fullChunk);
        }
    }

    @Override
    public String e() {
        return Integer.toString(this.j());
    }

    @VisibleForTesting
    public int f() {
        return this.g.by();
    }

    public ChunkGenerator g() {
        return this.a.a();
    }

    public ChunkGeneratorStructureState h() {
        return this.a.b();
    }

    public RandomState i() {
        return this.a.c();
    }

    @Override
    public int j() {
        return this.a.i();
    }

    public void a(BlockPosition pos) {
        int sectionPosZ;
        int sectionPosX = SectionPosition.a(pos.u());
        PlayerChunk visibleChunkIfPresent = this.b(ChunkCoordIntPair.c(sectionPosX, sectionPosZ = SectionPosition.a(pos.w())));
        if (visibleChunkIfPresent != null && visibleChunkIfPresent.a(pos)) {
            this.q.add(visibleChunkIfPresent);
        }
    }

    @Override
    public void a(EnumSkyBlock type, SectionPosition pos) {
        this.g.execute(() -> {
            PlayerChunk visibleChunkIfPresent = this.b(pos.r().a());
            if (visibleChunkIfPresent != null && visibleChunkIfPresent.a(type, pos.b())) {
                this.q.add(visibleChunkIfPresent);
            }
        });
    }

    public <T> void a(TicketType<T> type, ChunkCoordIntPair pos, int distance, T value) {
        this.c.c(type, pos, distance, value);
    }

    public <T> void b(TicketType<T> type, ChunkCoordIntPair pos, int distance, T value) {
        this.c.d(type, pos, distance, value);
    }

    @Override
    public void a(ChunkCoordIntPair pos, boolean add) {
        this.c.a(pos, add);
    }

    public void a(EntityPlayer player) {
        if (!player.dQ()) {
            this.a.a(player);
        }
    }

    public void a(Entity entity) {
        this.a.b(entity);
    }

    public void b(Entity entity) {
        this.a.a(entity);
    }

    public void a(Entity entity, Packet<?> packet) {
        this.a.b(entity, packet);
    }

    public void b(Entity entity, Packet<?> packet) {
        this.a.a(entity, packet);
    }

    public void a(int viewDistance) {
        this.a.a(viewDistance);
    }

    public void setSendViewDistance(int viewDistance) {
        this.d.moonrise$getPlayerChunkLoader().setSendDistance(viewDistance);
    }

    public void b(int simulationDistance) {
        this.c.b(simulationDistance);
    }

    @Override
    public void b(boolean spawnSettings) {
        this.setSpawnSettings(spawnSettings, this.k);
    }

    public void setSpawnSettings(boolean spawnSettings, boolean spawnFriendlies) {
        this.j = spawnSettings;
        this.k = spawnFriendlies;
    }

    public String a(ChunkCoordIntPair chunkPos) {
        return this.a.a(chunkPos);
    }

    public WorldPersistentData k() {
        return this.h;
    }

    public VillagePlace l() {
        return this.a.m();
    }

    public ChunkScanAccess m() {
        return this.a.p();
    }

    @Nullable
    @VisibleForDebug
    public SpawnerCreature.d n() {
        return this.r;
    }

    public void o() {
        this.c.g();
    }

    public void a(PlayerChunk chunkHolder) {
        if (chunkHolder.i()) {
            this.q.add(chunkHolder);
        }
    }

    private static /* synthetic */ boolean lambda$purgeUnload$3() {
        return true;
    }

    public final class b
    extends IAsyncTaskHandler<Runnable> {
        b(World level) {
            super("Chunk source main thread executor for " + String.valueOf(level.ai().a()));
        }

        @Override
        public void b(BooleanSupplier isDone) {
            super.b(() -> MinecraftServer.z() && isDone.getAsBoolean());
        }

        @Override
        public Runnable f(Runnable runnable) {
            return runnable;
        }

        @Override
        protected boolean e(Runnable runnable) {
            return true;
        }

        @Override
        protected boolean ax() {
            return true;
        }

        @Override
        protected Thread ay() {
            return ChunkProviderServer.this.e;
        }

        @Override
        protected void d(Runnable task) {
            Profiler.a().f("runTask");
            super.d(task);
        }

        @Override
        public boolean B() {
            ChunkProviderServer serverChunkCache = ChunkProviderServer.this;
            if (serverChunkCache.s()) {
                return true;
            }
            return super.B() | serverChunkCache.d.moonrise$getChunkTaskScheduler().executeMainThreadTask();
        }
    }

    public record a(Chunk a, PlayerChunk b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "chunk;holder", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "chunk;holder", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "chunk;holder", "a", "b"}, this, o2);
        }
    }
}

