/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.common.misc.PositionCountingAreaMap;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.MoonriseConstants;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemDistanceManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_tick_iteration.ChunkTickDistanceManager;
import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.TickingTracker;
import net.minecraft.util.ArraySetSorted;
import net.minecraft.util.MathHelper;
import net.minecraft.util.thread.TaskScheduler;
import net.minecraft.world.level.ChunkCoordIntPair;
import org.bukkit.plugin.Plugin;
import org.slf4j.Logger;

public abstract class ChunkMapDistance
implements ChunkSystemDistanceManager,
ChunkTickDistanceManager {
    static final Logger a = LogUtils.getLogger();
    static final int b = ChunkLevel.a(FullChunkStatus.d);
    private static final int c = 4;
    final Long2ObjectMap<ObjectSet<EntityPlayer>> d = new Long2ObjectOpenHashMap();
    private long n;
    private final PositionCountingAreaMap<EntityPlayer> spawnChunkTracker = new PositionCountingAreaMap();

    protected ChunkMapDistance(Executor dispatcher, Executor mainThreadExecutor) {
        TaskScheduler<Runnable> taskScheduler = TaskScheduler.a("player ticket throttler", mainThreadExecutor);
    }

    @Override
    public final ChunkHolderManager moonrise$getChunkHolderManager() {
        return this.moonrise$getChunkMap().t.moonrise$getChunkTaskScheduler().chunkHolderManager;
    }

    @Override
    public final void moonrise$addPlayer(EntityPlayer player, SectionPosition pos) {
        this.spawnChunkTracker.add(player, pos.a(), pos.c(), 8);
    }

    @Override
    public final void moonrise$removePlayer(EntityPlayer player, SectionPosition pos) {
        this.spawnChunkTracker.remove(player);
    }

    @Override
    public final void moonrise$updatePlayer(EntityPlayer player, SectionPosition oldPos, SectionPosition newPos, boolean oldIgnore, boolean newIgnore) {
        if (newIgnore) {
            this.spawnChunkTracker.remove(player);
        } else {
            this.spawnChunkTracker.addOrUpdate(player, newPos.a(), newPos.c(), 8);
        }
    }

    protected void a() {
        this.moonrise$getChunkHolderManager().tick();
    }

    private static int a(ArraySetSorted<Ticket<?>> tickets) {
        return !tickets.isEmpty() ? tickets.b().b() : ChunkLevel.b + 1;
    }

    protected abstract boolean a(long var1);

    @Nullable
    protected abstract PlayerChunk b(long var1);

    @Nullable
    protected abstract PlayerChunk a(long var1, int var3, @Nullable PlayerChunk var4, int var5);

    public boolean a(PlayerChunkMap chunkMap) {
        return this.moonrise$getChunkHolderManager().processTicketUpdates();
    }

    void a(long chunkPos, Ticket<?> ticket) {
        this.moonrise$getChunkHolderManager().addTicketAtLevel(ticket.a(), chunkPos, ticket.b(), ticket.c);
    }

    void b(long chunkPos, Ticket<?> ticket) {
        this.moonrise$getChunkHolderManager().removeTicketAtLevel(ticket.a(), chunkPos, ticket.b(), ticket.c);
    }

    public <T> void a(TicketType<T> type, ChunkCoordIntPair pos, int level, T value) {
        this.a(pos.a(), new Ticket<T>(type, level, value));
    }

    public <T> void b(TicketType<T> type, ChunkCoordIntPair pos, int level, T value) {
        Ticket<T> ticket = new Ticket<T>(type, level, value);
        this.b(pos.a(), ticket);
    }

    public <T> void c(TicketType<T> type, ChunkCoordIntPair pos, int distance, T value) {
        this.moonrise$getChunkHolderManager().addTicketAtLevel(type, pos, ChunkLevel.a(FullChunkStatus.b) - distance, value);
    }

    public <T> void d(TicketType<T> type, ChunkCoordIntPair pos, int distance, T value) {
        this.moonrise$getChunkHolderManager().removeTicketAtLevel(type, pos, ChunkLevel.a(FullChunkStatus.b) - distance, value);
    }

    public boolean addPluginRegionTicket(ChunkCoordIntPair pos, Plugin value) {
        return this.moonrise$getChunkHolderManager().addTicketAtLevel(TicketType.PLUGIN_TICKET, pos, ChunkLevel.a(FullChunkStatus.b) - 2, value);
    }

    public boolean removePluginRegionTicket(ChunkCoordIntPair pos, Plugin value) {
        return this.moonrise$getChunkHolderManager().removeTicketAtLevel(TicketType.PLUGIN_TICKET, pos, ChunkLevel.a(FullChunkStatus.b) - 2, value);
    }

    private ArraySetSorted<Ticket<?>> g(long chunkPos) {
        throw new UnsupportedOperationException();
    }

    protected void a(ChunkCoordIntPair pos, boolean add) {
        if (add) {
            this.moonrise$getChunkHolderManager().addTicketAtLevel(TicketType.d, pos, PlayerChunkMap.c, pos);
        } else {
            this.moonrise$getChunkHolderManager().removeTicketAtLevel(TicketType.d, pos, PlayerChunkMap.c, pos);
        }
    }

    public void a(SectionPosition sectionPos, EntityPlayer player) {
        ChunkCoordIntPair chunkPos = sectionPos.r();
        long packedChunkPos = chunkPos.a();
        ((ObjectSet)this.d.computeIfAbsent(packedChunkPos, l2 -> new ObjectOpenHashSet())).add((Object)player);
    }

    public void b(SectionPosition sectionPos, EntityPlayer player) {
        ChunkCoordIntPair chunkPos = sectionPos.r();
        long packedChunkPos = chunkPos.a();
        ObjectSet set = (ObjectSet)this.d.get(packedChunkPos);
        if (set != null) {
            set.remove((Object)player);
        }
        if (set == null || set.isEmpty()) {
            this.d.remove(packedChunkPos);
        }
    }

    private int i() {
        throw new UnsupportedOperationException();
    }

    public boolean c(long chunkPos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkHolderManager().getChunkHolder(chunkPos);
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    public boolean d(long chunkPos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkHolderManager().getChunkHolder(chunkPos);
        return chunkHolder != null && chunkHolder.isTickingReady();
    }

    protected String e(long chunkPos) {
        return this.moonrise$getChunkHolderManager().getTicketDebugString(chunkPos);
    }

    protected void a(int viewDistance) {
        this.moonrise$getChunkMap().a(viewDistance);
    }

    public void b(int simulationDistance) {
        int clamped = MathHelper.a(simulationDistance, 0, MoonriseConstants.MAX_VIEW_DISTANCE);
        this.moonrise$getChunkMap().t.moonrise$getPlayerChunkLoader().setTickDistance(clamped);
    }

    public int b() {
        return this.spawnChunkTracker.getTotalPositions();
    }

    public boolean f(long chunkPos) {
        return this.spawnChunkTracker.hasObjectsNear(CoordinateUtils.getChunkX(chunkPos), CoordinateUtils.getChunkZ(chunkPos));
    }

    public LongIterator c() {
        return this.spawnChunkTracker.getPositions().iterator();
    }

    public String d() {
        return "No DistanceManager stats available";
    }

    private void a(String filename) {
        throw new UnsupportedOperationException();
    }

    @VisibleForTesting
    TickingTracker e() {
        throw new UnsupportedOperationException();
    }

    public LongSet f() {
        throw new UnsupportedOperationException();
    }

    public void g() {
    }

    public boolean h() {
        throw new UnsupportedOperationException();
    }

    public <T> void removeAllTicketsFor(TicketType<T> ticketType, int ticketLevel, T ticketIdentifier) {
        this.moonrise$getChunkHolderManager().removeAllTicketsFor(ticketType, ticketLevel, ticketIdentifier);
    }

    class b
    extends ChunkMap {
        protected final Long2ByteMap a;
        protected final int b;

        protected b(int maxDistance) {
            super(maxDistance + 2, 16, 256);
            this.a = new Long2ByteOpenHashMap();
            this.b = maxDistance;
            this.a.defaultReturnValue((byte)(maxDistance + 2));
        }

        @Override
        protected int c(long sectionPos) {
            return this.a.get(sectionPos);
        }

        @Override
        protected void a(long sectionPos, int level) {
            byte b2 = level > this.b ? this.a.remove(sectionPos) : this.a.put(sectionPos, (byte)level);
            this.a(sectionPos, (int)b2, level);
        }

        protected void a(long chunkPos, int oldLevel, int newLevel) {
        }

        @Override
        protected int b(long pos) {
            return this.d(pos) ? 0 : Integer.MAX_VALUE;
        }

        private boolean d(long chunkPos) {
            ObjectSet set = (ObjectSet)ChunkMapDistance.this.d.get(chunkPos);
            return set != null && !set.isEmpty();
        }

        public void a() {
            this.b(Integer.MAX_VALUE);
        }

        private void a(String filename) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(new File(filename));){
                for (Long2ByteMap.Entry entry : this.a.long2ByteEntrySet()) {
                    ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(entry.getLongKey());
                    String string = Byte.toString(entry.getByteValue());
                    fileOutputStream.write((chunkPos.h + "\t" + chunkPos.i + "\t" + string + "\n").getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException var9) {
                a.error("Failed to dump chunks to {}", (Object)filename, (Object)var9);
            }
        }
    }
}

