/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.GeneratingChunkMap;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.Zone;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkDependencies;
import net.minecraft.world.level.chunk.status.ChunkPyramid;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public class ChunkGenerationTask {
    private final GeneratingChunkMap b;
    private final ChunkCoordIntPair c;
    @Nullable
    private ChunkStatus d = null;
    public final ChunkStatus a;
    private volatile boolean e;
    private final List<CompletableFuture<ChunkResult<IChunkAccess>>> f = new ArrayList<CompletableFuture<ChunkResult<IChunkAccess>>>();
    private final StaticCache2D<GenerationChunkHolder> g;
    private boolean h;

    private ChunkGenerationTask(GeneratingChunkMap chunkMap, ChunkStatus targetStatus, ChunkCoordIntPair pos, StaticCache2D<GenerationChunkHolder> cache) {
        this.b = chunkMap;
        this.a = targetStatus;
        this.c = pos;
        this.g = cache;
    }

    public static ChunkGenerationTask a(GeneratingChunkMap chunkMap, ChunkStatus targetStatus, ChunkCoordIntPair pos) {
        int accumulatedRadiusOf = ChunkPyramid.a.a(targetStatus).a(ChunkStatus.c);
        StaticCache2D<GenerationChunkHolder> staticCache2D = StaticCache2D.a(pos.h, pos.i, accumulatedRadiusOf, (x2, z2) -> chunkMap.d(ChunkCoordIntPair.c(x2, z2)));
        return new ChunkGenerationTask(chunkMap, targetStatus, pos, staticCache2D);
    }

    @Nullable
    public CompletableFuture<?> a() {
        CompletableFuture<?> completableFuture;
        while ((completableFuture = this.g()) == null) {
            if (this.e || this.d == this.a) {
                this.e();
                return null;
            }
            this.d();
        }
        return completableFuture;
    }

    private void d() {
        ChunkStatus chunkStatus;
        if (this.d == null) {
            chunkStatus = ChunkStatus.c;
        } else if (!this.h && this.d == ChunkStatus.c && !this.f()) {
            this.h = true;
            chunkStatus = ChunkStatus.c;
        } else {
            chunkStatus = ChunkStatus.a().get(this.d.b() + 1);
        }
        this.a(chunkStatus, this.h);
        this.d = chunkStatus;
    }

    public void b() {
        this.e = true;
    }

    private void e() {
        GenerationChunkHolder generationChunkHolder = this.g.a(this.c.h, this.c.i);
        generationChunkHolder.a(this);
        this.g.a(this.b::a);
    }

    private boolean f() {
        if (this.a == ChunkStatus.c) {
            return true;
        }
        ChunkStatus persistedStatus = this.g.a(this.c.h, this.c.i).q();
        if (persistedStatus != null && !persistedStatus.d(this.a)) {
            ChunkDependencies chunkDependencies = ChunkPyramid.b.a(this.a).c();
            int radius = chunkDependencies.c();
            for (int i2 = this.c.h - radius; i2 <= this.c.h + radius; ++i2) {
                for (int i1 = this.c.i - radius; i1 <= this.c.i + radius; ++i1) {
                    int chessboardDistance = this.c.e(i2, i1);
                    ChunkStatus chunkStatus = chunkDependencies.a(chessboardDistance);
                    ChunkStatus persistedStatus1 = this.g.a(i2, i1).q();
                    if (persistedStatus1 != null && !persistedStatus1.d(chunkStatus)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public GenerationChunkHolder c() {
        return this.g.a(this.c.h, this.c.i);
    }

    private void a(ChunkStatus status, boolean needsGeneration) {
        try (Zone zone = Profiler.a().d("scheduleLayer");){
            zone.a(status::f);
            int radiusForLayer = this.b(status, needsGeneration);
            for (int i2 = this.c.h - radiusForLayer; i2 <= this.c.h + radiusForLayer; ++i2) {
                for (int i1 = this.c.i - radiusForLayer; i1 <= this.c.i + radiusForLayer; ++i1) {
                    GenerationChunkHolder generationChunkHolder = this.g.a(i2, i1);
                    if (!this.e && this.a(status, needsGeneration, generationChunkHolder)) continue;
                    return;
                }
            }
        }
    }

    private int b(ChunkStatus status, boolean needsGeneration) {
        ChunkPyramid chunkPyramid = needsGeneration ? ChunkPyramid.a : ChunkPyramid.b;
        return chunkPyramid.a(this.a).a(status);
    }

    private boolean a(ChunkStatus status, boolean needsGeneration, GenerationChunkHolder chunk) {
        ChunkPyramid chunkPyramid;
        ChunkStatus persistedStatus = chunk.q();
        boolean flag = persistedStatus != null && status.b(persistedStatus);
        ChunkPyramid chunkPyramid2 = chunkPyramid = flag ? ChunkPyramid.a : ChunkPyramid.b;
        if (flag && !needsGeneration) {
            throw new IllegalStateException("Can't load chunk, but didn't expect to need to generate");
        }
        CompletableFuture<ChunkResult<IChunkAccess>> completableFuture = chunk.a(chunkPyramid.a(status), this.b, this.g);
        ChunkResult chunkResult = completableFuture.getNow(null);
        if (chunkResult == null) {
            this.f.add(completableFuture);
            return true;
        }
        if (chunkResult.a()) {
            return true;
        }
        this.b();
        return false;
    }

    @Nullable
    private CompletableFuture<?> g() {
        while (!this.f.isEmpty()) {
            CompletableFuture<ChunkResult<IChunkAccess>> completableFuture = this.f.getLast();
            ChunkResult chunkResult = completableFuture.getNow(null);
            if (chunkResult == null) {
                return completableFuture;
            }
            this.f.removeLast();
            if (chunkResult.a()) continue;
            this.b();
        }
        return null;
    }
}

