/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.base.MoreObjects;
import com.mojang.logging.LogUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.minecraft.core.IRegistryCustom;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class PropertyManager<T extends PropertyManager<T>> {
    private static final Logger a = LogUtils.getLogger();
    public final Properties ac;
    private static final boolean skipComments = Boolean.getBoolean("Paper.skipServerPropertiesComments");
    private OptionSet options = null;

    public PropertyManager(Properties properties, OptionSet options) {
        this.ac = properties;
        this.options = options;
    }

    private String getOverride(String name, String value) {
        if (this.options != null && this.options.has(name)) {
            return String.valueOf(this.options.valueOf(name));
        }
        return value;
    }

    public static Properties b(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return new Properties();
        }
        try {
            try {
                Properties var13;
                try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                    CharsetDecoder charsetDecoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                    Properties map = new Properties();
                    map.load(new InputStreamReader(inputStream, charsetDecoder));
                    var13 = map;
                }
                return var13;
            }
            catch (CharacterCodingException var9) {
                Properties var4;
                a.info("Failed to load properties as UTF-8 from file {}, trying ISO_8859_1", (Object)path);
                try (BufferedReader bufferedReader = Files.newBufferedReader(path, StandardCharsets.ISO_8859_1);){
                    Properties map = new Properties();
                    map.load(bufferedReader);
                    var4 = map;
                }
                return var4;
            }
        }
        catch (IOException var10) {
            a.error("Failed to load properties from file: {}", (Object)path, (Object)var10);
            return new Properties();
        }
    }

    public void c(Path path) {
        try {
            if (path.toFile().exists() && !path.toFile().canWrite()) {
                a.warn("Can not write to file {}, skipping.", (Object)path);
                return;
            }
            OutputStream outputstream = Files.newOutputStream(path, new OpenOption[0]);
            BufferedOutputStream bufferedOutputStream = !skipComments ? new BufferedOutputStream(outputstream) : new BufferedOutputStream(this, outputstream){
                private boolean isRightAfterNewline = true;
                private boolean isComment = false;

                @Override
                public void write(@NotNull byte[] b2) throws IOException {
                    this.write(b2, 0, b2.length);
                }

                @Override
                public void write(@NotNull byte[] bbuf, int off, int len) throws IOException {
                    int latest_offset = off;
                    for (int index = off; index < off + len; ++index) {
                        boolean isNewline;
                        byte c2 = bbuf[index];
                        boolean bl = isNewline = c2 == 10 || c2 == 13;
                        if (isNewline && this.isComment) {
                            this.isComment = false;
                            latest_offset = index + 1;
                        }
                        if (c2 == 35 && this.isRightAfterNewline) {
                            this.isComment = true;
                            if (index != latest_offset) {
                                super.write(bbuf, latest_offset, index - latest_offset);
                            }
                        }
                        this.isRightAfterNewline = isNewline;
                    }
                    if (latest_offset < off + len && !this.isComment) {
                        super.write(bbuf, latest_offset, off + len - latest_offset);
                    }
                }
            };
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)bufferedOutputStream, StandardCharsets.UTF_8.newEncoder()));
            this.ac.store(bufferedWriter, "Minecraft server properties");
        }
        catch (IOException var7) {
            a.error("Failed to store properties to file: {}", (Object)path);
        }
    }

    private static <V extends Number> Function<String, V> a(Function<String, V> parseFunc) {
        return string -> {
            try {
                return (Number)parseFunc.apply((String)string);
            }
            catch (NumberFormatException var3) {
                return null;
            }
        };
    }

    protected static <V> Function<String, V> a(IntFunction<V> byId, Function<String, V> byName) {
        return string -> {
            try {
                return byId.apply(Integer.parseInt(string));
            }
            catch (NumberFormatException var4) {
                return byName.apply((String)string);
            }
        };
    }

    @Nullable
    public String c(String key) {
        return this.getOverride(key, this.ac.getProperty(key));
    }

    @Nullable
    protected <V> V a(String key, Function<String, V> serializer) {
        String stringRaw = this.c(key);
        if (stringRaw == null) {
            return null;
        }
        this.ac.remove(key);
        return serializer.apply(stringRaw);
    }

    protected <V> V a(String key, Function<String, V> serializer, Function<V, String> deserializer, V defaultValue) {
        try {
            return this.get0(key, serializer, deserializer, defaultValue);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not load invalidly configured property '" + key + "'", ex);
        }
    }

    private <V> V get0(String key, Function<String, V> serializer, Function<V, String> deserializer, V defaultValue) {
        String stringRaw = this.c(key);
        Object object = MoreObjects.firstNonNull(stringRaw != null ? serializer.apply(stringRaw) : null, defaultValue);
        this.ac.put(key, deserializer.apply(object));
        return (V)object;
    }

    protected <V> EditableProperty<V> b(String key, Function<String, V> serializer, Function<V, String> deserializer, V defaultValue) {
        String stringRaw = this.c(key);
        Object object = MoreObjects.firstNonNull(stringRaw != null ? serializer.apply(stringRaw) : null, defaultValue);
        this.ac.put(key, deserializer.apply(object));
        return new EditableProperty<Object>(key, object, deserializer);
    }

    protected <V> V a(String key, Function<String, V> serializer, UnaryOperator<V> modifier, Function<V, String> deserializer, V defaultValue) {
        return (V)this.a(key, string -> {
            Object object = serializer.apply((String)string);
            return object != null ? modifier.apply(object) : null;
        }, deserializer, defaultValue);
    }

    protected <V> V a(String key, Function<String, V> mapper, V value) {
        return (V)this.a(key, mapper, Objects::toString, value);
    }

    protected <V> EditableProperty<V> b(String key, Function<String, V> serializer, V defaultValue) {
        return this.b(key, serializer, Objects::toString, defaultValue);
    }

    protected String a(String key, String defaultValue) {
        return this.a(key, Function.identity(), Function.identity(), defaultValue);
    }

    @Nullable
    protected String a(String key) {
        return (String)this.a(key, Function.identity());
    }

    protected int a(String key, int defaultValue) {
        return this.a(key, PropertyManager.a(Integer::parseInt), Integer.valueOf(defaultValue));
    }

    protected EditableProperty<Integer> b(String key, int defaultValue) {
        return this.b(key, PropertyManager.a(Integer::parseInt), defaultValue);
    }

    protected int a(String key, UnaryOperator<Integer> modifier, int defaultValue) {
        return this.a(key, PropertyManager.a(Integer::parseInt), modifier, Objects::toString, defaultValue);
    }

    protected long a(String key, long defaultValue) {
        return this.a(key, PropertyManager.a(Long::parseLong), defaultValue);
    }

    protected boolean a(String key, boolean defaultValue) {
        return this.a(key, Boolean::valueOf, defaultValue);
    }

    protected EditableProperty<Boolean> b(String key, boolean defaultValue) {
        return this.b(key, Boolean::valueOf, defaultValue);
    }

    @Nullable
    protected Boolean b(String key) {
        return this.a(key, Boolean::valueOf);
    }

    protected Properties a() {
        Properties map = new Properties();
        map.putAll((Map<?, ?>)this.ac);
        return map;
    }

    protected abstract T reload(IRegistryCustom var1, Properties var2, OptionSet var3);

    public class EditableProperty<V>
    implements Supplier<V> {
        private final String b;
        private final V c;
        private final Function<V, String> d;

        EditableProperty(String key, V value, Function<V, String> serializer) {
            this.b = key;
            this.c = value;
            this.d = serializer;
        }

        @Override
        public V get() {
            return this.c;
        }

        public T a(IRegistryCustom registryAccess, V newValue) {
            Properties map = PropertyManager.this.a();
            map.put(this.b, this.d.apply(newValue));
            return PropertyManager.this.reload(registryAccess, map, PropertyManager.this.options);
        }
    }
}

