/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.PropertyManager;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.flat.GeneratorSettingsFlat;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import org.slf4j.Logger;

public class DedicatedServerProperties
extends PropertyManager<DedicatedServerProperties> {
    static final Logger ad = LogUtils.getLogger();
    private static final Pattern ae = Pattern.compile("^[a-fA-F0-9]{40}$");
    private static final Splitter af = Splitter.on((char)',').trimResults();
    public final boolean debug = this.a("debug", false);
    public final boolean a = this.a("online-mode", true);
    public final boolean b = this.a("prevent-proxy-connections", false);
    public final String c = this.a("server-ip", "");
    public final boolean d = this.a("pvp", true);
    public final boolean e = this.a("allow-flight", false);
    public final String f = this.a("motd", "A Minecraft Server");
    public final String g = this.a("bug-report-link", "");
    public final boolean h = this.a("force-gamemode", false);
    public final boolean i = this.a("enforce-whitelist", false);
    public final EnumDifficulty j = this.a("difficulty", DedicatedServerProperties.a(EnumDifficulty::a, EnumDifficulty::a), EnumDifficulty::e, EnumDifficulty.b);
    public final EnumGamemode k = this.a("gamemode", DedicatedServerProperties.a(EnumGamemode::a, EnumGamemode::a), EnumGamemode::b, EnumGamemode.a);
    public final String l = this.a("level-name", "world");
    public final int m = this.a("server-port", 25565);
    @Nullable
    public final Boolean n = this.b("announce-player-achievements");
    public final boolean o = this.a("enable-query", false);
    public final int p = this.a("query.port", 25565);
    public final boolean q = this.a("enable-rcon", false);
    public final int r = this.a("rcon.port", 25575);
    public final String s = this.a("rcon.password", "");
    public final boolean t = this.a("hardcore", false);
    public final boolean u = this.a("allow-nether", true);
    public final boolean v = this.a("spawn-monsters", true);
    public final boolean w = this.a("use-native-transport", true);
    public final boolean x = this.a("enable-command-block", false);
    public final int y = this.a("spawn-protection", 16);
    public final int z = this.a("op-permission-level", 4);
    public final int A = this.a("function-permission-level", 2);
    public final long B = this.a("max-tick-time", TimeUnit.MINUTES.toMillis(1L));
    public final int C = this.a("max-chained-neighbor-updates", 1000000);
    public final int D = this.a("rate-limit", 0);
    public final int E = this.a("view-distance", 10);
    public final int F = this.a("simulation-distance", 10);
    public final int G = this.a("max-players", 20);
    public final int H = this.a("network-compression-threshold", 256);
    public final boolean I = this.a("broadcast-rcon-to-ops", true);
    public final boolean J = this.a("broadcast-console-to-ops", true);
    public final int K = this.a("max-world-size", property -> MathHelper.a((int)property, 1, 29999984), 29999984);
    public final boolean L = this.a("sync-chunk-writes", true) && Boolean.getBoolean("Paper.enable-sync-chunk-writes");
    public final String M = this.a("region-file-compression", "deflate");
    public final boolean N = this.a("enable-jmx-monitoring", false);
    public final boolean O = this.a("enable-status", true);
    public final boolean P = this.a("hide-online-players", false);
    public final int Q = this.a("entity-broadcast-range-percentage", property -> MathHelper.a((int)property, 10, 1000), 100);
    public final String R = this.a("text-filtering-config", "");
    public final int S = this.a("text-filtering-version", 0);
    public final Optional<MinecraftServer.ServerResourcePackInfo> T;
    public final DataPackConfiguration U;
    public final PropertyManager.EditableProperty<Integer> V = this.b("player-idle-timeout", 0);
    public final PropertyManager.EditableProperty<Boolean> W = this.b("white-list", false);
    public final boolean X = this.a("enforce-secure-profile", true);
    public final boolean Y = this.a("log-ips", true);
    public int Z = this.a("pause-when-empty-seconds", -1);
    private final WorldDimensionData ag;
    public final WorldOptions aa;
    public boolean ab = this.a("accepts-transfers", false);
    public final String rconIp;

    public DedicatedServerProperties(Properties properties, OptionSet optionset) {
        super(properties, optionset);
        String string = this.a("level-seed", "");
        boolean flag = this.a("generate-structures", true);
        long l2 = WorldOptions.a(string).orElse(WorldOptions.g());
        this.aa = new WorldOptions(l2, flag, false);
        this.ag = new WorldDimensionData(this.a("generator-settings", (String property) -> ChatDeserializer.a(!property.isEmpty() ? property : "{}"), new JsonObject()), this.a("level-type", (String property) -> property.toLowerCase(Locale.ROOT), WorldPresets.a.a().toString()));
        this.T = DedicatedServerProperties.a(this.a("resource-pack-id", ""), this.a("resource-pack", ""), this.a("resource-pack-sha1", ""), this.a("resource-pack-hash"), this.a("require-resource-pack", false), this.a("resource-pack-prompt", ""));
        this.U = DedicatedServerProperties.b(this.a("initial-enabled-packs", String.join((CharSequence)",", WorldDataConfiguration.c.a().a())), this.a("initial-disabled-packs", String.join((CharSequence)",", WorldDataConfiguration.c.a().b())));
        String rconIp = this.c("rcon.ip");
        this.rconIp = rconIp == null ? this.c : rconIp;
    }

    public static DedicatedServerProperties fromFile(Path path, OptionSet optionset) {
        return new DedicatedServerProperties(DedicatedServerProperties.b(path), optionset);
    }

    @Override
    public DedicatedServerProperties reload(IRegistryCustom registryAccess, Properties properties, OptionSet options) {
        return new DedicatedServerProperties(properties, options);
    }

    @Nullable
    private static IChatBaseComponent c(String json) {
        if (!Strings.isNullOrEmpty((String)json)) {
            try {
                return IChatBaseComponent.ChatSerializer.a(json, (HolderLookup.a)IRegistryCustom.b);
            }
            catch (Exception var2) {
                ad.warn("Failed to parse resource pack prompt '{}'", (Object)json, (Object)var2);
            }
        }
        return null;
    }

    private static Optional<MinecraftServer.ServerResourcePackInfo> a(String id, String url, String sha1, @Nullable String hash, boolean isRequired, String promptJson) {
        UUID uuid;
        String string;
        if (url.isEmpty()) {
            return Optional.empty();
        }
        if (!sha1.isEmpty()) {
            string = sha1;
            if (!Strings.isNullOrEmpty((String)hash)) {
                ad.warn("resource-pack-hash is deprecated and found along side resource-pack-sha1. resource-pack-hash will be ignored.");
            }
        } else if (!Strings.isNullOrEmpty((String)hash)) {
            ad.warn("resource-pack-hash is deprecated. Please use resource-pack-sha1 instead.");
            string = hash;
        } else {
            string = "";
        }
        if (string.isEmpty()) {
            ad.warn("You specified a resource pack without providing a sha1 hash. Pack will be updated on the client only if you change the name of the pack.");
        } else if (!ae.matcher(string).matches()) {
            ad.warn("Invalid sha1 for resource-pack-sha1");
        }
        IChatBaseComponent component = DedicatedServerProperties.c(promptJson);
        if (id.isEmpty()) {
            uuid = UUID.nameUUIDFromBytes(url.getBytes(StandardCharsets.UTF_8));
            ad.warn("resource-pack-id missing, using default of {}", (Object)uuid);
        } else {
            try {
                uuid = UUID.fromString(id);
            }
            catch (IllegalArgumentException var10) {
                ad.warn("Failed to parse '{}' into UUID", (Object)id);
                return Optional.empty();
            }
        }
        return Optional.of(new MinecraftServer.ServerResourcePackInfo(uuid, url, string, isRequired, component));
    }

    private static DataPackConfiguration b(String initalEnabledPacks, String initialDisabledPacks) {
        List parts = af.splitToList((CharSequence)initalEnabledPacks);
        List parts1 = af.splitToList((CharSequence)initialDisabledPacks);
        return new DataPackConfiguration(parts, parts1);
    }

    public WorldDimensions a(HolderLookup.a registries) {
        return this.ag.a(registries);
    }

    public record WorldDimensionData(JsonObject a, String b) {
        private static final Map<String, ResourceKey<WorldPreset>> c = Map.of("default", WorldPresets.a, "largebiomes", WorldPresets.c);

        public WorldDimensions a(HolderLookup.a registries) {
            HolderLookup.b<WorldPreset> holderLookup = registries.d(Registries.bb);
            Holder.c<WorldPreset> reference = holderLookup.a(WorldPresets.a).or(() -> holderLookup.c().findAny()).orElseThrow(() -> new IllegalStateException("Invalid datapack contents: can't find default preset"));
            Holder holder = Optional.ofNullable(MinecraftKey.c(this.b)).map(presetPath -> ResourceKey.a(Registries.bb, presetPath)).or(() -> Optional.ofNullable(c.get(this.b))).flatMap(holderLookup::a).orElseGet(() -> {
                ad.warn("Failed to parse level-type {}, defaulting to {}", (Object)this.b, (Object)reference.h().a());
                return reference;
            });
            WorldDimensions worldDimensions = ((WorldPreset)holder.a()).a();
            if (holder.a(WorldPresets.b)) {
                RegistryOps registryOps = registries.a(JsonOps.INSTANCE);
                Optional optional = GeneratorSettingsFlat.a.parse(new Dynamic<JsonObject>(registryOps, this.a())).resultOrPartial(arg_0 -> ((Logger)ad).error(arg_0));
                if (optional.isPresent()) {
                    return worldDimensions.a(registries, new ChunkProviderFlat((GeneratorSettingsFlat)optional.get()));
                }
            }
            return worldDimensions;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{WorldDimensionData.class, "generatorSettings;levelType", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{WorldDimensionData.class, "generatorSettings;levelType", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{WorldDimensionData.class, "generatorSettings;levelType", "a", "b"}, this, o2);
        }
    }
}

