/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import ca.spottedleaf.moonrise.common.util.JsonUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import com.destroystokyo.paper.Metrics;
import com.destroystokyo.paper.VersionHistoryManager;
import com.destroystokyo.paper.console.PaperConsole;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.unix.DomainSocketAddress;
import io.papermc.paper.command.PaperCommands;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.ObfHelper;
import io.papermc.paper.util.ServerEnvironment;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Handler;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.IMinecraftServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerCommand;
import net.minecraft.server.ServerLinks;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.gui.ServerGUI;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListenerFactory;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.ServerTextFilter;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.server.players.UserCache;
import net.minecraft.server.rcon.RemoteControlCommandListener;
import net.minecraft.server.rcon.thread.RemoteControlListener;
import net.minecraft.server.rcon.thread.RemoteStatusListener;
import net.minecraft.util.MathHelper;
import net.minecraft.util.debugchart.DebugSampleSubscriptionTracker;
import net.minecraft.util.debugchart.RemoteDebugSampleType;
import net.minecraft.util.debugchart.RemoteSampleLogger;
import net.minecraft.util.debugchart.SampleLogger;
import net.minecraft.util.debugchart.TpsDebugDimensions;
import net.minecraft.util.monitoring.jmx.MinecraftServerBeans;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.storage.Convertable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.io.IoBuilder;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.Main;
import org.bukkit.craftbukkit.v1_21_R3.util.ForwardLogHandler;
import org.bukkit.event.Event;
import org.bukkit.event.server.RemoteServerCommandEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;

public class DedicatedServer
extends MinecraftServer
implements IMinecraftServer {
    static final Logger l = LogUtils.getLogger();
    private static final int m = 5000;
    private static final int n = 2;
    private final Queue<ServerCommand> serverCommandQueue = new ConcurrentLinkedQueue<ServerCommand>();
    @Nullable
    private RemoteStatusListener p;
    @Nullable
    private RemoteControlListener r;
    public DedicatedServerSettings s;
    @Nullable
    private ServerGUI t;
    @Nullable
    private final ServerTextFilter u;
    @Nullable
    private RemoteSampleLogger v;
    @Nullable
    private DebugSampleSubscriptionTracker w;
    public ServerLinks x;
    private static final AtomicInteger ASYNC_DEBUG_CHUNKS_COUNT = new AtomicInteger();

    public DedicatedServer(OptionSet options, WorldLoader.a worldLoader, Thread serverThread, Convertable.ConversionSession storageSource, ResourcePackRepository packRepository, WorldStem worldStem, DedicatedServerSettings settings, DataFixer fixerUpper, Services services, WorldLoadListenerFactory progressListenerFactory) {
        super(options, worldLoader, serverThread, storageSource, packRepository, worldStem, Proxy.NO_PROXY, fixerUpper, services, progressListenerFactory);
        this.s = settings;
        this.u = ServerTextFilter.a(settings.a());
        this.x = DedicatedServer.a(settings);
    }

    @Override
    public boolean e() throws IOException {
        String proxyLink;
        Object bindAddress;
        Thread thread = new Thread("Server console handler"){

            @Override
            public void run() {
                if (!Main.useConsole) {
                    return;
                }
                new PaperConsole(DedicatedServer.this).start();
            }
        };
        java.util.logging.Logger global = java.util.logging.Logger.getLogger("");
        global.setUseParentHandlers(false);
        for (Handler handler : global.getHandlers()) {
            global.removeHandler(handler);
        }
        global.addHandler(new ForwardLogHandler());
        org.apache.logging.log4j.Logger logger = LogManager.getRootLogger();
        System.setOut(IoBuilder.forLogger((org.apache.logging.log4j.Logger)logger).setLevel(Level.INFO).buildPrintStream());
        System.setErr(IoBuilder.forLogger((org.apache.logging.log4j.Logger)logger).setLevel(Level.WARN).buildPrintStream());
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(l));
        l.info("Starting minecraft server version {}", (Object)SharedConstants.b().c());
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            l.warn("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        if (ServerEnvironment.userIsRootOrAdmin()) {
            l.warn("****************************");
            l.warn("YOU ARE RUNNING THIS SERVER AS AN ADMINISTRATIVE OR ROOT USER. THIS IS NOT ADVISED.");
            l.warn("YOU ARE OPENING YOURSELF UP TO POTENTIAL RISKS WHEN DOING THIS.");
            l.warn("FOR MORE INFORMATION, SEE https://madelinemiller.dev/blog/root-minecraft-server/");
            l.warn("****************************");
        }
        l.info("Loading properties");
        DedicatedServerProperties properties = this.s.a();
        if (this.U()) {
            this.a_("127.0.0.1");
        } else {
            this.d(properties.a);
            this.e(properties.b);
            this.a_(properties.c);
        }
        this.a(new DedicatedPlayerList(this, this.bb(), this.g));
        SpigotConfig.init((File)this.options.valueOf("spigot-settings"));
        SpigotConfig.registerCommands();
        ((Object)((Object)ObfHelper.INSTANCE)).getClass();
        this.paperConfigurations.initializeGlobalConfiguration(this.ba());
        this.paperConfigurations.initializeWorldDefaultsConfiguration(this.ba());
        this.server.spark.enableEarlyIfRequested();
        if (this.bu()) {
            this.at().save(false);
        }
        this.bs().loadAndSaveFiles();
        WatchdogThread.doStart(SpigotConfig.timeoutTime, SpigotConfig.restartOnCrash);
        thread.start();
        PaperCommands.registerCommands(this);
        this.server.spark.registerCommandBeforePlugins(this.server);
        Metrics.PaperMetrics.startMetrics();
        ((Object)((Object)VersionHistoryManager.INSTANCE)).getClass();
        this.f(properties.d);
        this.g(properties.e);
        this.d(properties.f);
        super.c(properties.V.get());
        this.h(properties.i);
        l.info("Default game type: {}", (Object)properties.k);
        if (this.w().startsWith("unix:")) {
            if (!Epoll.isAvailable()) {
                l.error("**** INVALID CONFIGURATION!");
                l.error("You are trying to use a Unix domain socket but you're not on a supported OS.");
                return false;
            }
            if (!GlobalConfiguration.get().proxies.velocity.enabled && !SpigotConfig.bungee) {
                l.error("**** INVALID CONFIGURATION!");
                l.error("Unix domain sockets require IPs to be forwarded from a proxy.");
                return false;
            }
            bindAddress = new DomainSocketAddress(this.w().substring("unix:".length()));
        } else {
            InetAddress inetAddress = null;
            if (!this.w().isEmpty()) {
                inetAddress = InetAddress.getByName(this.w());
            }
            if (this.S() < 0) {
                this.a(properties.m);
            }
            bindAddress = new InetSocketAddress(inetAddress, this.S());
        }
        this.V();
        l.info("Starting Minecraft server on {}:{}", (Object)(this.w().isEmpty() ? "*" : this.w()), (Object)this.S());
        try {
            this.ah().startTcpServerListener((SocketAddress)bindAddress);
        }
        catch (IOException var10) {
            l.warn("**** FAILED TO BIND TO PORT!");
            l.warn("The exception was: {}", (Object)var10.toString());
            l.warn("Perhaps a server is already running on that port?");
            throw new IllegalStateException("Failed to bind to port", var10);
        }
        this.server.loadPlugins();
        this.server.enablePlugins(PluginLoadOrder.STARTUP);
        boolean usingProxy = SpigotConfig.bungee || GlobalConfiguration.get().proxies.velocity.enabled;
        String proxyFlavor = GlobalConfiguration.get().proxies.velocity.enabled ? "Velocity" : "BungeeCord";
        String string = proxyLink = GlobalConfiguration.get().proxies.velocity.enabled ? "https://docs.papermc.io/velocity/security" : "http://www.spigotmc.org/wiki/firewall-guide/";
        if (!this.aa()) {
            l.warn("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            l.warn("The server will make no attempt to authenticate usernames. Beware.");
            if (usingProxy) {
                l.warn("Whilst this makes it possible to use {}, unless access to your server is properly restricted, it also opens up the ability for hackers to connect with any username they choose.", (Object)proxyFlavor);
                l.warn("Please see {} for further information.", (Object)proxyLink);
            } else {
                l.warn("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            }
            l.warn("To change this, set \"online-mode\" to \"true\" in the server.properties file.");
        }
        if (!NameReferencingFileConverter.e(this)) {
            return false;
        }
        this.w = new DebugSampleSubscriptionTracker(this.bs());
        this.v = new RemoteSampleLogger(TpsDebugDimensions.values().length, this.w, RemoteDebugSampleType.a);
        long nanos = SystemUtils.d();
        TileEntitySkull.a(this.i, this);
        UserCache.a(this.aa());
        l.info("Preparing level \"{}\"", (Object)this.j());
        this.loadLevel(this.f.f());
        long l2 = SystemUtils.d() - nanos;
        String string2 = String.format(Locale.ROOT, "%.3fs", (double)l2 / 1.0E9);
        l.info("Done preparing level \"{}\" ({})", (Object)this.j(), (Object)string2);
        if (properties.n != null) {
            this.aL().a(GameRules.B).set(properties.n, this.J());
        }
        if (properties.o) {
            l.info("Starting GS4 status listener");
            this.p = RemoteStatusListener.a(this);
        }
        if (properties.q) {
            l.info("Starting remote control listener");
            this.r = RemoteControlListener.a(this);
        }
        if (properties.N) {
            MinecraftServerBeans.a(this);
            l.info("JMX monitoring enabled");
        }
        return true;
    }

    public File getPluginsFolder() {
        return (File)this.options.valueOf("plugins");
    }

    @Override
    public boolean W() {
        return this.s.a().v && super.W();
    }

    @Override
    public DedicatedServerProperties a() {
        return this.s.a();
    }

    @Override
    public void t() {
    }

    @Override
    public SystemReport a(SystemReport report) {
        report.a("Is Modded", () -> this.Q().b());
        report.a("Type", () -> "Dedicated Server (map_server.txt)");
        return report;
    }

    @Override
    public void a(Path path) throws IOException {
        DedicatedServerProperties properties = this.a();
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedWriter.write(String.format(Locale.ROOT, "sync-chunk-writes=%s%n", properties.L));
            bufferedWriter.write(String.format(Locale.ROOT, "gamemode=%s%n", properties.k));
            bufferedWriter.write(String.format(Locale.ROOT, "spawn-monsters=%s%n", properties.v));
            bufferedWriter.write(String.format(Locale.ROOT, "entity-broadcast-range-percentage=%d%n", properties.Q));
            bufferedWriter.write(String.format(Locale.ROOT, "max-world-size=%d%n", properties.K));
            bufferedWriter.write(String.format(Locale.ROOT, "view-distance=%d%n", properties.E));
            bufferedWriter.write(String.format(Locale.ROOT, "simulation-distance=%d%n", properties.F));
            bufferedWriter.write(String.format(Locale.ROOT, "generate-structures=%s%n", properties.aa.d()));
            bufferedWriter.write(String.format(Locale.ROOT, "use-native=%s%n", properties.w));
            bufferedWriter.write(String.format(Locale.ROOT, "rate-limit=%d%n", properties.D));
        }
    }

    @Override
    public void i() {
        if (this.u != null) {
            this.u.close();
        }
        if (this.t != null) {
            this.t.b();
        }
        if (this.r != null) {
            this.r.stopNonBlocking();
        }
        if (this.p != null) {
            // empty if block
        }
        this.hasFullyShutdown = true;
        System.exit(this.abnormalExit ? 70 : 0);
    }

    @Override
    public void G() {
        super.G();
        this.br();
    }

    @Override
    public boolean a(World level) {
        return level.ai() != World.j || this.a().u;
    }

    public void a(String msg, CommandListenerWrapper source) {
        if (msg.equalsIgnoreCase("paper debug chunks --async")) {
            l.info("Scheduling async debug chunks");
            Runnable run = () -> {
                l.info("Async debug chunks executing");
                ChunkTaskScheduler.dumpAllChunkLoadInfo(this, false);
                ConsoleCommandSender sender = MinecraftServer.getServer().console;
                File file = ChunkTaskScheduler.getChunkDebugFile();
                sender.sendMessage((Component)Component.text((String)("Writing chunk information dump to " + String.valueOf(file)), (TextColor)NamedTextColor.GREEN));
                try {
                    JsonUtil.writeJson((JsonElement)ChunkTaskScheduler.debugAllWorlds(this), file);
                    sender.sendMessage((Component)Component.text((String)"Successfully written chunk information!", (TextColor)NamedTextColor.GREEN));
                }
                catch (Throwable thr) {
                    MinecraftServer.l.warn("Failed to dump chunk information to file " + file.toString(), thr);
                    sender.sendMessage((Component)Component.text((String)"Failed to dump chunk information, see console", (TextColor)NamedTextColor.RED));
                }
            };
            Thread t2 = new Thread(run);
            t2.setName("Async debug thread #" + ASYNC_DEBUG_CHUNKS_COUNT.getAndIncrement());
            t2.setDaemon(true);
            t2.start();
            return;
        }
        this.serverCommandQueue.add(new ServerCommand(msg, source));
    }

    public void br() {
        ServerCommand servercommand;
        while ((servercommand = this.serverCommandQueue.poll()) != null) {
            ServerCommandEvent event = new ServerCommandEvent((CommandSender)this.console, servercommand.a);
            this.server.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            servercommand = new ServerCommand(event.getCommand(), servercommand.b);
            this.server.dispatchServerCommand((CommandSender)this.console, servercommand);
        }
    }

    @Override
    public boolean n() {
        return true;
    }

    @Override
    public int o() {
        return this.a().D;
    }

    @Override
    public boolean p() {
        return this.a().w;
    }

    public DedicatedPlayerList bs() {
        return (DedicatedPlayerList)super.ag();
    }

    @Override
    public boolean r() {
        return true;
    }

    @Override
    public String b() {
        return this.w();
    }

    @Override
    public int d() {
        return this.S();
    }

    @Override
    public String h() {
        return this.ae();
    }

    public void bt() {
        if (this.t == null) {
            this.t = ServerGUI.a(this);
        }
    }

    @Override
    public boolean aj() {
        return this.t != null;
    }

    @Override
    public boolean q() {
        return this.a().x;
    }

    @Override
    public int al() {
        return this.a().y;
    }

    @Override
    public boolean a(WorldServer level, BlockPosition pos, EntityHuman player) {
        int abs1;
        if (level.ai() != World.i) {
            return false;
        }
        if (this.bs().k().c()) {
            return false;
        }
        if (this.bs().f(player.gh())) {
            return false;
        }
        if (this.al() <= 0) {
            return false;
        }
        BlockPosition sharedSpawnPos = level.Z();
        int abs = MathHelper.a(pos.u() - sharedSpawnPos.u());
        int max = Math.max(abs, abs1 = MathHelper.a(pos.w() - sharedSpawnPos.w()));
        return max <= this.al();
    }

    @Override
    public boolean am() {
        return this.a().O;
    }

    @Override
    public boolean an() {
        return this.a().P;
    }

    @Override
    public int k() {
        return this.a().z;
    }

    @Override
    public int l() {
        return this.a().A;
    }

    @Override
    public void c(int idleTimeout) {
        super.c(idleTimeout);
        this.s.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.V.a(this.ba(), idleTimeout));
    }

    @Override
    public boolean m() {
        return this.a().I;
    }

    @Override
    public boolean c() {
        return this.a().J;
    }

    @Override
    public int aw() {
        return this.a().K;
    }

    @Override
    public int az() {
        return this.a().H;
    }

    @Override
    public boolean aA() {
        DedicatedServerProperties properties = this.a();
        return properties.X && GlobalConfiguration.get().proxies.isProxyOnlineMode() && this.i.b();
    }

    @Override
    public boolean bl() {
        return this.a().Y;
    }

    protected boolean bu() {
        boolean flag = false;
        for (int i2 = 0; !flag && i2 <= 2; ++i2) {
            if (i2 > 0) {
                l.warn("Encountered a problem while converting the user banlist, retrying in a few seconds");
                this.bC();
            }
            flag = NameReferencingFileConverter.a((MinecraftServer)this);
        }
        boolean flag1 = false;
        for (int var7 = 0; !flag1 && var7 <= 2; ++var7) {
            if (var7 > 0) {
                l.warn("Encountered a problem while converting the ip banlist, retrying in a few seconds");
                this.bC();
            }
            flag1 = NameReferencingFileConverter.b(this);
        }
        boolean flag2 = false;
        for (int var8 = 0; !flag2 && var8 <= 2; ++var8) {
            if (var8 > 0) {
                l.warn("Encountered a problem while converting the op list, retrying in a few seconds");
                this.bC();
            }
            flag2 = NameReferencingFileConverter.c(this);
        }
        boolean flag3 = false;
        for (int var9 = 0; !flag3 && var9 <= 2; ++var9) {
            if (var9 > 0) {
                l.warn("Encountered a problem while converting the whitelist, retrying in a few seconds");
                this.bC();
            }
            flag3 = NameReferencingFileConverter.d(this);
        }
        boolean flag4 = false;
        for (int var10 = 0; !flag4 && var10 <= 2; ++var10) {
            if (var10 > 0) {
                l.warn("Encountered a problem while converting the player save files, retrying in a few seconds");
                this.bC();
            }
            flag4 = NameReferencingFileConverter.a(this);
        }
        return flag || flag1 || flag2 || flag3 || flag4;
    }

    private void bC() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public long bv() {
        return this.a().B;
    }

    @Override
    public int bj() {
        return this.a().C;
    }

    @Override
    public String s() {
        StringBuilder result = new StringBuilder();
        Plugin[] plugins = this.server.getPluginManager().getPlugins();
        result.append(this.server.getName());
        result.append(" on Bukkit ");
        result.append(this.server.getBukkitVersion());
        if (plugins.length > 0 && this.server.getQueryPlugins()) {
            result.append(": ");
            for (int i2 = 0; i2 < plugins.length; ++i2) {
                if (i2 > 0) {
                    result.append("; ");
                }
                result.append(plugins[i2].getDescription().getName());
                result.append(" ");
                result.append(plugins[i2].getDescription().getVersion().replaceAll(";", ","));
            }
        }
        return result.toString();
    }

    @Override
    public String a(String command) {
        throw new UnsupportedOperationException("Not supported - remote source required.");
    }

    public String runCommand(RemoteControlCommandListener rconConsoleSource, String s2) {
        if (s2.isBlank()) {
            return "";
        }
        rconConsoleSource.e();
        this.h(() -> {
            CommandListenerWrapper wrapper = rconConsoleSource.g();
            RemoteServerCommandEvent event = new RemoteServerCommandEvent(rconConsoleSource.getBukkitSender(wrapper), s2);
            this.server.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            ServerCommand serverCommand = new ServerCommand(event.getCommand(), wrapper);
            this.server.dispatchServerCommand(event.getSender(), serverCommand);
        });
        return rconConsoleSource.f();
    }

    public void i(boolean isStoreUsingWhiteList) {
        this.s.a(properties -> (DedicatedServerProperties)properties.W.a(this.ba(), isStoreUsingWhiteList));
    }

    @Override
    public void v() {
        super.v();
        TileEntitySkull.b();
    }

    @Override
    public boolean a(GameProfile profile) {
        return false;
    }

    @Override
    public int b(int trackingDistance) {
        return this.a().Q * trackingDistance / 100;
    }

    @Override
    public String j() {
        return this.f.f();
    }

    @Override
    public boolean aX() {
        return this.s.a().L;
    }

    @Override
    public ITextFilter a(EntityPlayer player) {
        return this.u != null ? this.u.a(player.gh()) : ITextFilter.e;
    }

    @Override
    @Nullable
    public EnumGamemode bd() {
        return this.s.a().h ? this.j.k() : null;
    }

    @Override
    public Optional<MinecraftServer.ServerResourcePackInfo> Y() {
        return this.s.a().T;
    }

    @Override
    public void aS() {
        super.aS();
        this.w.a(this.ak());
    }

    @Override
    public SampleLogger f() {
        return this.v;
    }

    @Override
    public boolean g() {
        return this.w.a(RemoteDebugSampleType.a);
    }

    @Override
    public void a(EntityPlayer player, RemoteDebugSampleType sampleType) {
        this.w.a(player, sampleType);
    }

    @Override
    public boolean bm() {
        return this.s.a().ab;
    }

    @Override
    public ServerLinks bp() {
        return this.x;
    }

    @Override
    public int bq() {
        return this.s.a().Z;
    }

    private static ServerLinks a(DedicatedServerSettings settings) {
        Optional<URI> optional = DedicatedServer.a(settings.a());
        return optional.map(uri -> new ServerLinks(List.of(ServerLinks.KnownLinkType.a.a((URI)uri)))).orElse(ServerLinks.a);
    }

    private static Optional<URI> a(DedicatedServerProperties properties) {
        String string = properties.g;
        if (string.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(SystemUtils.a(string));
        }
        catch (Exception var3) {
            l.warn("Failed to parse bug link {}", (Object)string, (Object)var3);
            return Optional.empty();
        }
    }

    @Override
    public boolean isDebugging() {
        return this.a().debug;
    }

    @Override
    public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
        return this.console;
    }
}

