/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentNBTBase;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.commands.arguments.ArgumentNBTTag;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.commands.data.CommandDataAccessor;
import net.minecraft.server.commands.data.CommandDataAccessorEntity;
import net.minecraft.server.commands.data.CommandDataAccessorTile;
import net.minecraft.server.commands.data.CommandDataStorage;
import net.minecraft.util.MathHelper;

public class CommandData {
    private static final SimpleCommandExceptionType d = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.data.merge.failed"));
    private static final DynamicCommandExceptionType e = new DynamicCommandExceptionType(nbtPath -> IChatBaseComponent.b("commands.data.get.invalid", nbtPath));
    private static final DynamicCommandExceptionType f = new DynamicCommandExceptionType(nbtPath -> IChatBaseComponent.b("commands.data.get.unknown", nbtPath));
    private static final SimpleCommandExceptionType g = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.data.get.multiple"));
    private static final DynamicCommandExceptionType h = new DynamicCommandExceptionType(unexpectedNbt -> IChatBaseComponent.b("commands.data.modify.expected_object", unexpectedNbt));
    private static final DynamicCommandExceptionType i = new DynamicCommandExceptionType(unexpectedNbt -> IChatBaseComponent.b("commands.data.modify.expected_value", unexpectedNbt));
    private static final Dynamic2CommandExceptionType j = new Dynamic2CommandExceptionType((startIndex, endIndex) -> IChatBaseComponent.b("commands.data.modify.invalid_substring", startIndex, endIndex));
    public static final List<Function<String, c>> a = ImmutableList.of(CommandDataAccessorEntity.a, CommandDataAccessorTile.a, CommandDataStorage.a);
    public static final List<c> b = (List)a.stream().map(dataProviderFactory -> (c)dataProviderFactory.apply("target")).collect(ImmutableList.toImmutableList());
    public static final List<c> c = (List)a.stream().map(dataProviderFactory -> (c)dataProviderFactory.apply("source")).collect(ImmutableList.toImmutableList());

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        LiteralArgumentBuilder literalArgumentBuilder = (LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("data").requires(source -> source.c(2));
        for (c dataProvider : b) {
            ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalArgumentBuilder.then(dataProvider.a((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("merge"), argumentBuilder -> argumentBuilder.then(net.minecraft.commands.CommandDispatcher.a("nbt", ArgumentNBTTag.a()).executes(context -> CommandData.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTTag.a(context, "nbt"))))))).then(dataProvider.a((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("get"), argumentBuilder -> ((ArgumentBuilder)argumentBuilder.executes(context -> CommandData.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context)))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("path", ArgumentNBTKey.a()).executes(context -> CommandData.b((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path")))).then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).executes(context -> CommandData.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path"), DoubleArgumentType.getDouble((CommandContext)context, (String)"scale")))))))).then(dataProvider.a((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("remove"), argumentBuilder -> argumentBuilder.then(net.minecraft.commands.CommandDispatcher.a("path", ArgumentNBTKey.a()).executes(context -> CommandData.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path"))))))).then(CommandData.a((ArgumentBuilder<CommandListenerWrapper, ?> argumentBuilder, b dataManipulatorDecorator) -> ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)argumentBuilder.then(net.minecraft.commands.CommandDispatcher.a("insert").then(net.minecraft.commands.CommandDispatcher.a("index", IntegerArgumentType.integer()).then(dataManipulatorDecorator.create((context, sourceCompoundTag, nbtPath, tags) -> nbtPath.a(IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), sourceCompoundTag, tags)))))).then(net.minecraft.commands.CommandDispatcher.a("prepend").then(dataManipulatorDecorator.create((context, sourceCompoundTag, nbtPath, tags) -> nbtPath.a(0, sourceCompoundTag, tags))))).then(net.minecraft.commands.CommandDispatcher.a("append").then(dataManipulatorDecorator.create((context, sourceCompoundTag, nbtPath, tags) -> nbtPath.a(-1, sourceCompoundTag, tags))))).then(net.minecraft.commands.CommandDispatcher.a("set").then(dataManipulatorDecorator.create((context, sourceCompoundTag, nbtPath, tags) -> nbtPath.a((NBTBase)sourceCompoundTag, (NBTBase)Iterables.getLast((Iterable)tags)))))).then(net.minecraft.commands.CommandDispatcher.a("merge").then(dataManipulatorDecorator.create((context, sourceCompoundTag, nbtPath, tags) -> {
                NBTTagCompound compoundTag = new NBTTagCompound();
                for (NBTBase tag : tags) {
                    if (ArgumentNBTKey.g.a(tag, 0)) {
                        throw ArgumentNBTKey.b.create();
                    }
                    if (!(tag instanceof NBTTagCompound)) {
                        throw h.create((Object)tag);
                    }
                    NBTTagCompound compoundTag1 = (NBTTagCompound)tag;
                    compoundTag.a(compoundTag1);
                }
                List<NBTBase> collection = nbtPath.a((NBTBase)sourceCompoundTag, NBTTagCompound::new);
                int i2 = 0;
                for (NBTBase tag1 : collection) {
                    if (!(tag1 instanceof NBTTagCompound)) {
                        throw h.create((Object)tag1);
                    }
                    NBTTagCompound compoundTag2 = (NBTTagCompound)tag1;
                    NBTTagCompound compoundTag3 = compoundTag2.i();
                    compoundTag2.a(compoundTag);
                    i2 += compoundTag3.equals(compoundTag2) ? 0 : 1;
                }
                return i2;
            })))));
        }
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)literalArgumentBuilder);
    }

    private static String a(NBTBase tag) throws CommandSyntaxException {
        if (tag.c().d()) {
            return tag.u_();
        }
        throw i.create((Object)tag);
    }

    private static List<NBTBase> a(List<NBTBase> tagList, d processor) throws CommandSyntaxException {
        ArrayList<NBTBase> list = new ArrayList<NBTBase>(tagList.size());
        for (NBTBase tag : tagList) {
            String asText = CommandData.a(tag);
            list.add(NBTTagString.a(processor.process(asText)));
        }
        return list;
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(BiConsumer<ArgumentBuilder<CommandListenerWrapper, ?>, b> decorator) {
        LiteralArgumentBuilder<CommandListenerWrapper> literalArgumentBuilder = net.minecraft.commands.CommandDispatcher.a("modify");
        for (c dataProvider : b) {
            dataProvider.a((ArgumentBuilder<CommandListenerWrapper, ?>)literalArgumentBuilder, argumentBuilder -> {
                RequiredArgumentBuilder<CommandListenerWrapper, ArgumentNBTKey.g> argumentBuilder1 = net.minecraft.commands.CommandDispatcher.a("targetPath", ArgumentNBTKey.a());
                for (c dataProvider1 : c) {
                    decorator.accept((ArgumentBuilder<CommandListenerWrapper, ?>)argumentBuilder1, dataManipulator -> dataProvider1.a((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("from"), subArgBuilder -> ((ArgumentBuilder)subArgBuilder.executes(context -> CommandData.a((CommandContext<CommandListenerWrapper>)context, dataProvider, dataManipulator, CommandData.a((CommandContext<CommandListenerWrapper>)context, dataProvider1)))).then(net.minecraft.commands.CommandDispatcher.a("sourcePath", ArgumentNBTKey.a()).executes(context -> CommandData.a((CommandContext<CommandListenerWrapper>)context, dataProvider, dataManipulator, CommandData.b((CommandContext<CommandListenerWrapper>)context, dataProvider1))))));
                    decorator.accept((ArgumentBuilder<CommandListenerWrapper, ?>)argumentBuilder1, dataManipulator -> dataProvider1.a((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("string"), subArgBuilder -> ((ArgumentBuilder)subArgBuilder.executes(context -> CommandData.a((CommandContext<CommandListenerWrapper>)context, dataProvider, dataManipulator, CommandData.a(CommandData.a((CommandContext<CommandListenerWrapper>)context, dataProvider1), (String tagString) -> tagString)))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("sourcePath", ArgumentNBTKey.a()).executes(context -> CommandData.a((CommandContext<CommandListenerWrapper>)context, dataProvider, dataManipulator, CommandData.a(CommandData.b((CommandContext<CommandListenerWrapper>)context, dataProvider1), (String tagString) -> tagString)))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("start", IntegerArgumentType.integer()).executes(context -> CommandData.a((CommandContext<CommandListenerWrapper>)context, dataProvider, dataManipulator, CommandData.a(CommandData.b((CommandContext<CommandListenerWrapper>)context, dataProvider1), (String tagString) -> CommandData.a(tagString, IntegerArgumentType.getInteger((CommandContext)context, (String)"start")))))).then(net.minecraft.commands.CommandDispatcher.a("end", IntegerArgumentType.integer()).executes(context -> CommandData.a((CommandContext<CommandListenerWrapper>)context, dataProvider, dataManipulator, CommandData.a(CommandData.b((CommandContext<CommandListenerWrapper>)context, dataProvider1), (String tagString) -> CommandData.b(tagString, IntegerArgumentType.getInteger((CommandContext)context, (String)"start"), IntegerArgumentType.getInteger((CommandContext)context, (String)"end"))))))))));
                }
                decorator.accept((ArgumentBuilder<CommandListenerWrapper, ?>)argumentBuilder1, dataManipulator -> net.minecraft.commands.CommandDispatcher.a("value").then(net.minecraft.commands.CommandDispatcher.a("value", ArgumentNBTBase.a()).executes(context -> {
                    List<NBTBase> list = Collections.singletonList(ArgumentNBTBase.a(context, "value"));
                    return CommandData.a((CommandContext<CommandListenerWrapper>)context, dataProvider, dataManipulator, list);
                })));
                return argumentBuilder.then(argumentBuilder1);
            });
        }
        return literalArgumentBuilder;
    }

    private static String a(String source, int start, int end) throws CommandSyntaxException {
        if (start >= 0 && end <= source.length() && start <= end) {
            return source.substring(start, end);
        }
        throw j.create((Object)start, (Object)end);
    }

    private static String b(String source, int start, int end) throws CommandSyntaxException {
        int len = source.length();
        int offset = CommandData.a(start, len);
        int offset1 = CommandData.a(end, len);
        return CommandData.a(source, offset, offset1);
    }

    private static String a(String source, int start) throws CommandSyntaxException {
        int len = source.length();
        return CommandData.a(source, CommandData.a(start, len), len);
    }

    private static int a(int index, int length) {
        return index >= 0 ? index : length + index;
    }

    private static List<NBTBase> a(CommandContext<CommandListenerWrapper> context, c dataProvider) throws CommandSyntaxException {
        CommandDataAccessor dataAccessor = dataProvider.a(context);
        return Collections.singletonList(dataAccessor.a());
    }

    private static List<NBTBase> b(CommandContext<CommandListenerWrapper> context, c dataProvider) throws CommandSyntaxException {
        CommandDataAccessor dataAccessor = dataProvider.a(context);
        ArgumentNBTKey.g path = ArgumentNBTKey.a(context, "sourcePath");
        return path.a(dataAccessor.a());
    }

    private static int a(CommandContext<CommandListenerWrapper> source, c dataProvider, a dataManipulator, List<NBTBase> tags) throws CommandSyntaxException {
        CommandDataAccessor dataAccessor = dataProvider.a(source);
        ArgumentNBTKey.g path = ArgumentNBTKey.a(source, "targetPath");
        NBTTagCompound data = dataAccessor.a();
        int i2 = dataManipulator.modify(source, data, path, tags);
        if (i2 == 0) {
            throw d.create();
        }
        dataAccessor.a(data);
        ((CommandListenerWrapper)source.getSource()).a(() -> dataAccessor.b(), true);
        return i2;
    }

    private static int a(CommandListenerWrapper source, CommandDataAccessor accessor, ArgumentNBTKey.g path) throws CommandSyntaxException {
        NBTTagCompound data = accessor.a();
        int i2 = path.c(data);
        if (i2 == 0) {
            throw d.create();
        }
        accessor.a(data);
        source.a(() -> accessor.b(), true);
        return i2;
    }

    public static NBTBase a(ArgumentNBTKey.g path, CommandDataAccessor accessor) throws CommandSyntaxException {
        List<NBTBase> collection = path.a(accessor.a());
        Iterator iterator = collection.iterator();
        NBTBase tag = (NBTBase)iterator.next();
        if (iterator.hasNext()) {
            throw g.create();
        }
        return tag;
    }

    private static int b(CommandListenerWrapper source, CommandDataAccessor accessor, ArgumentNBTKey.g path) throws CommandSyntaxException {
        int floor;
        NBTBase singleTag = CommandData.a(path, accessor);
        if (singleTag instanceof NBTNumber) {
            floor = MathHelper.a(((NBTNumber)singleTag).j());
        } else if (singleTag instanceof NBTList) {
            floor = ((NBTList)singleTag).size();
        } else if (singleTag instanceof NBTTagCompound) {
            floor = ((NBTTagCompound)singleTag).f();
        } else {
            if (!(singleTag instanceof NBTTagString)) {
                throw f.create((Object)path.toString());
            }
            floor = singleTag.u_().length();
        }
        source.a(() -> accessor.a(singleTag), false);
        return floor;
    }

    private static int a(CommandListenerWrapper source, CommandDataAccessor accessor, ArgumentNBTKey.g path, double scale) throws CommandSyntaxException {
        NBTBase singleTag = CommandData.a(path, accessor);
        if (!(singleTag instanceof NBTNumber)) {
            throw e.create((Object)path.toString());
        }
        int floor = MathHelper.a(((NBTNumber)singleTag).j() * scale);
        source.a(() -> accessor.a(path, scale, floor), false);
        return floor;
    }

    private static int a(CommandListenerWrapper source, CommandDataAccessor accessor) throws CommandSyntaxException {
        NBTTagCompound data = accessor.a();
        source.a(() -> accessor.a((NBTBase)data), false);
        return 1;
    }

    private static int a(CommandListenerWrapper source, CommandDataAccessor accessor, NBTTagCompound nbt) throws CommandSyntaxException {
        NBTTagCompound data = accessor.a();
        if (ArgumentNBTKey.g.a(nbt, 0)) {
            throw ArgumentNBTKey.b.create();
        }
        NBTTagCompound compoundTag = data.i().a(nbt);
        if (data.equals(compoundTag)) {
            throw d.create();
        }
        accessor.a(compoundTag);
        source.a(() -> accessor.b(), true);
        return 1;
    }

    public static interface c {
        public CommandDataAccessor a(CommandContext<CommandListenerWrapper> var1) throws CommandSyntaxException;

        public ArgumentBuilder<CommandListenerWrapper, ?> a(ArgumentBuilder<CommandListenerWrapper, ?> var1, Function<ArgumentBuilder<CommandListenerWrapper, ?>, ArgumentBuilder<CommandListenerWrapper, ?>> var2);
    }

    @FunctionalInterface
    static interface d {
        public String process(String var1) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface a {
        public int modify(CommandContext<CommandListenerWrapper> var1, NBTTagCompound var2, ArgumentNBTKey.g var3, List<NBTBase> var4) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface b {
        public ArgumentBuilder<CommandListenerWrapper, ?> create(a var1);
    }
}

