/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.item.equipment.trim.TrimPatterns;
import net.minecraft.world.level.World;

public class SpawnArmorTrimsCommand {
    private static final List<ResourceKey<TrimPattern>> a = List.of(TrimPatterns.a, TrimPatterns.b, TrimPatterns.c, TrimPatterns.d, TrimPatterns.e, TrimPatterns.f, TrimPatterns.g, TrimPatterns.h, TrimPatterns.i, TrimPatterns.j, TrimPatterns.k, TrimPatterns.l, TrimPatterns.m, TrimPatterns.n, TrimPatterns.o, TrimPatterns.p, TrimPatterns.q, TrimPatterns.r);
    private static final List<ResourceKey<TrimMaterial>> b = List.of(TrimMaterials.a, TrimMaterials.b, TrimMaterials.c, TrimMaterials.d, TrimMaterials.e, TrimMaterials.f, TrimMaterials.g, TrimMaterials.h, TrimMaterials.i, TrimMaterials.j, TrimMaterials.k);
    private static final ToIntFunction<ResourceKey<TrimPattern>> c = SystemUtils.g(a);
    private static final ToIntFunction<ResourceKey<TrimMaterial>> d = SystemUtils.g(b);

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("spawn_armor_trims").requires(commandSourceStack -> commandSourceStack.c(2))).executes(commandContext -> SpawnArmorTrimsCommand.a((CommandListenerWrapper)commandContext.getSource(), ((CommandListenerWrapper)commandContext.getSource()).h()))));
    }

    private static int a(CommandListenerWrapper source, EntityHuman player) {
        World level = player.dV();
        NonNullList<ArmorTrim> list = NonNullList.a();
        IRegistry<TrimPattern> registry = level.K_().e(Registries.ba);
        IRegistry<TrimMaterial> registry1 = level.K_().e(Registries.aZ);
        HolderLookup<Item> holderLookup = level.a(Registries.K);
        Map<ResourceKey, List<Item>> map = holderLookup.c().map(Holder.c::a).filter(item1 -> {
            Equippable equippable1 = item1.g().a(DataComponents.D);
            return equippable1 != null && equippable1.a().a() == EnumItemSlot.Function.b && equippable1.c().isPresent();
        }).collect(Collectors.groupingBy(item1 -> item1.g().a(DataComponents.D).c().get()));
        registry.s().sorted(Comparator.comparing(trimPattern -> c.applyAsInt(registry.d((TrimPattern)trimPattern).orElse(null)))).forEachOrdered(trimPattern -> registry1.s().sorted(Comparator.comparing(trimMaterial -> d.applyAsInt(registry1.d((TrimMaterial)trimMaterial).orElse(null)))).forEachOrdered(trimMaterial -> list.add(new ArmorTrim(registry1.e((TrimMaterial)trimMaterial), registry.e((TrimPattern)trimPattern)))));
        BlockPosition blockPos = player.dv().a(player.cO(), 5);
        int i2 = map.size() - 1;
        double d2 = 3.0;
        int i1 = 0;
        int i22 = 0;
        for (ArmorTrim armorTrim : list) {
            for (List<Item> list1 : map.values()) {
                double d1 = (double)blockPos.u() + 0.5 - (double)(i1 % registry1.d()) * 3.0;
                double d22 = (double)blockPos.v() + 0.5 + (double)(i22 % i2) * 3.0;
                double d3 = (double)blockPos.w() + 0.5 + (double)(i1 / registry1.d() * 10);
                EntityArmorStand armorStand = new EntityArmorStand(level, d1, d22, d3);
                armorStand.v(180.0f);
                armorStand.f(true);
                for (Item item : list1) {
                    Equippable equippable = Objects.requireNonNull(item.g().a(DataComponents.D));
                    ItemStack itemStack = new ItemStack(item);
                    itemStack.b(DataComponents.U, armorTrim);
                    armorStand.a(equippable.a(), itemStack);
                    if (itemStack.a(Items.oT)) {
                        armorStand.b(armorTrim.b().a().a(armorTrim.a()).f().f(" ").b(armorTrim.a().a().d()));
                        armorStand.p(true);
                        continue;
                    }
                    armorStand.k(true);
                }
                level.b(armorStand);
                ++i22;
            }
            ++i1;
        }
        source.a(() -> IChatBaseComponent.b("Armorstands with trimmed armor spawned around you"), true);
        return 1;
    }
}

