/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomSequences;

public class RandomCommand {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.random.error.range_too_large"));
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.random.error.range_too_small"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("random").then(RandomCommand.a("value", false))).then(RandomCommand.a("roll", true))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("reset").requires(commandSourceStack -> commandSourceStack.c(2))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("*").executes(commandContext -> RandomCommand.a((CommandListenerWrapper)commandContext.getSource()))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("seed", IntegerArgumentType.integer()).executes(commandContext -> RandomCommand.a((CommandListenerWrapper)commandContext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"seed"), true, true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("includeWorldSeed", BoolArgumentType.bool()).executes(commandContext -> RandomCommand.a((CommandListenerWrapper)commandContext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"seed"), BoolArgumentType.getBool((CommandContext)commandContext, (String)"includeWorldSeed"), true))).then(net.minecraft.commands.CommandDispatcher.a("includeSequenceId", BoolArgumentType.bool()).executes(commandContext -> RandomCommand.a((CommandListenerWrapper)commandContext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"seed"), BoolArgumentType.getBool((CommandContext)commandContext, (String)"includeWorldSeed"), BoolArgumentType.getBool((CommandContext)commandContext, (String)"includeSequenceId")))))))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("sequence", ArgumentMinecraftKeyRegistered.a()).suggests(RandomCommand::a).executes(commandContext -> RandomCommand.a((CommandListenerWrapper)commandContext.getSource(), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)commandContext, "sequence")))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("seed", IntegerArgumentType.integer()).executes(commandContext -> RandomCommand.a((CommandListenerWrapper)commandContext.getSource(), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)commandContext, "sequence"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"seed"), true, true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("includeWorldSeed", BoolArgumentType.bool()).executes(commandContext -> RandomCommand.a((CommandListenerWrapper)commandContext.getSource(), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)commandContext, "sequence"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"seed"), BoolArgumentType.getBool((CommandContext)commandContext, (String)"includeWorldSeed"), true))).then(net.minecraft.commands.CommandDispatcher.a("includeSequenceId", BoolArgumentType.bool()).executes(commandContext -> RandomCommand.a((CommandListenerWrapper)commandContext.getSource(), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)commandContext, "sequence"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"seed"), BoolArgumentType.getBool((CommandContext)commandContext, (String)"includeWorldSeed"), BoolArgumentType.getBool((CommandContext)commandContext, (String)"includeSequenceId"))))))))));
    }

    private static LiteralArgumentBuilder<CommandListenerWrapper> a(String subcommand, boolean displayResult) {
        return (LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a(subcommand).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("range", ArgumentCriterionValue.a()).executes(commandContext -> RandomCommand.a((CommandListenerWrapper)commandContext.getSource(), ArgumentCriterionValue.b.a((CommandContext<CommandListenerWrapper>)commandContext, "range"), null, displayResult))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("sequence", ArgumentMinecraftKeyRegistered.a()).suggests(RandomCommand::a).requires(commandSourceStack -> commandSourceStack.c(2))).executes(commandContext -> RandomCommand.a((CommandListenerWrapper)commandContext.getSource(), ArgumentCriterionValue.b.a((CommandContext<CommandListenerWrapper>)commandContext, "range"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)commandContext, "sequence"), displayResult))));
    }

    private static CompletableFuture<Suggestions> a(CommandContext<CommandListenerWrapper> context, SuggestionsBuilder suggestionsBuilder) {
        ArrayList list = Lists.newArrayList();
        ((CommandListenerWrapper)context.getSource()).e().N().a((resourceLocation, randomSequence) -> list.add(resourceLocation.toString()));
        return ICompletionProvider.b(list, suggestionsBuilder);
    }

    private static int a(CommandListenerWrapper source, CriterionConditionValue.IntegerRange range, @Nullable MinecraftKey sequence, boolean displayResult) throws CommandSyntaxException {
        RandomSource randomSequence = sequence != null ? source.e().a(sequence) : source.e().H_();
        int i2 = range.a().orElse(Integer.MIN_VALUE);
        int i1 = range.b().orElse(Integer.MAX_VALUE);
        long l2 = (long)i1 - (long)i2;
        if (l2 == 0L) {
            throw b.create();
        }
        if (l2 >= Integer.MAX_VALUE) {
            throw a.create();
        }
        int i22 = MathHelper.b(randomSequence, i2, i1);
        if (displayResult) {
            source.l().ag().a(IChatBaseComponent.a("commands.random.roll", source.b(), i22, i2, i1), false);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.random.sample.success", i22), false);
        }
        return i22;
    }

    private static int a(CommandListenerWrapper source, MinecraftKey sequence) throws CommandSyntaxException {
        source.e().N().b(sequence);
        source.a(() -> IChatBaseComponent.a("commands.random.reset.success", IChatBaseComponent.a(sequence)), false);
        return 1;
    }

    private static int a(CommandListenerWrapper source, MinecraftKey sequence, int seed, boolean includeWorldSeed, boolean includeSequenceId) throws CommandSyntaxException {
        source.e().N().a(sequence, seed, includeWorldSeed, includeSequenceId);
        source.a(() -> IChatBaseComponent.a("commands.random.reset.success", IChatBaseComponent.a(sequence)), false);
        return 1;
    }

    private static int a(CommandListenerWrapper source) {
        int i2 = source.e().N().a();
        source.a(() -> IChatBaseComponent.a("commands.random.reset.all.success", i2), false);
        return i2;
    }

    private static int a(CommandListenerWrapper source, int seed, boolean includeWorldSeed, boolean includeSequenceId) {
        RandomSequences randomSequences = source.e().N();
        randomSequences.a(seed, includeWorldSeed, includeSequenceId);
        int i2 = randomSequences.a();
        source.a(() -> IChatBaseComponent.a("commands.random.reset.all.success", i2), false);
        return i2;
    }
}

