/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentInventorySlot;
import net.minecraft.commands.arguments.ResourceOrIdArgument;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;

public class ItemCommands {
    static final Dynamic3CommandExceptionType a = new Dynamic3CommandExceptionType((x2, y2, z2) -> IChatBaseComponent.b("commands.item.target.not_a_container", x2, y2, z2));
    static final Dynamic3CommandExceptionType b = new Dynamic3CommandExceptionType((x2, y2, z2) -> IChatBaseComponent.b("commands.item.source.not_a_container", x2, y2, z2));
    static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(invalidSlot -> IChatBaseComponent.b("commands.item.target.no_such_slot", invalidSlot));
    private static final DynamicCommandExceptionType d = new DynamicCommandExceptionType(invalidSlot -> IChatBaseComponent.b("commands.item.source.no_such_slot", invalidSlot));
    private static final DynamicCommandExceptionType e = new DynamicCommandExceptionType(slot -> IChatBaseComponent.b("commands.item.target.no_changes", slot));
    private static final Dynamic2CommandExceptionType f = new Dynamic2CommandExceptionType((stackName, slot) -> IChatBaseComponent.b("commands.item.target.no_changed.known_item", stackName, slot));
    private static final SuggestionProvider<CommandListenerWrapper> g = (context, builder) -> {
        ReloadableServerRegistries.a holder = ((CommandListenerWrapper)context.getSource()).l().bc();
        return ICompletionProvider.a(holder.a(Registries.bh), builder);
    };

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("item").requires(source -> source.c(2))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("replace").then(net.minecraft.commands.CommandDispatcher.a("block").then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("slot", ArgumentInventorySlot.a()).then(net.minecraft.commands.CommandDispatcher.a("with").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("item", ArgumentItemStack.a(context)).executes(context1 -> ItemCommands.a((CommandListenerWrapper)context1.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "pos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context1, "slot"), ArgumentItemStack.a(context1, "item").a(1, false)))).then(net.minecraft.commands.CommandDispatcher.a("count", IntegerArgumentType.integer((int)1, (int)99)).executes(context1 -> ItemCommands.a((CommandListenerWrapper)context1.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "pos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context1, "slot"), ArgumentItemStack.a(context1, "item").a(IntegerArgumentType.getInteger((CommandContext)context1, (String)"count"), true))))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("from").then(net.minecraft.commands.CommandDispatcher.a("block").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentPosition.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("sourceSlot", ArgumentInventorySlot.a()).executes(context1 -> ItemCommands.a((CommandListenerWrapper)context1.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "source"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context1, "sourceSlot"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "pos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context1, "slot")))).then(net.minecraft.commands.CommandDispatcher.a("modifier", ResourceOrIdArgument.b(context)).suggests(g).executes(context1 -> ItemCommands.a((CommandListenerWrapper)context1.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "source"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context1, "sourceSlot"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "pos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context1, "slot"), ResourceOrIdArgument.b((CommandContext<CommandListenerWrapper>)context1, "modifier")))))))).then(net.minecraft.commands.CommandDispatcher.a("entity").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentEntity.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("sourceSlot", ArgumentInventorySlot.a()).executes(context1 -> ItemCommands.a((CommandListenerWrapper)context1.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context1, "source"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context1, "sourceSlot"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "pos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context1, "slot")))).then(net.minecraft.commands.CommandDispatcher.a("modifier", ResourceOrIdArgument.b(context)).suggests(g).executes(context1 -> ItemCommands.a((CommandListenerWrapper)context1.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context1, "source"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context1, "sourceSlot"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "pos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context1, "slot"), ResourceOrIdArgument.b((CommandContext<CommandListenerWrapper>)context1, "modifier")))))))))))).then(net.minecraft.commands.CommandDispatcher.a("entity").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("slot", ArgumentInventorySlot.a()).then(net.minecraft.commands.CommandDispatcher.a("with").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("item", ArgumentItemStack.a(context)).executes(context1 -> ItemCommands.a((CommandListenerWrapper)context1.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context1, "targets"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context1, "slot"), ArgumentItemStack.a(context1, "item").a(1, false)))).then(net.minecraft.commands.CommandDispatcher.a("count", IntegerArgumentType.integer((int)1, (int)99)).executes(context1 -> ItemCommands.a((CommandListenerWrapper)context1.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context1, "targets"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context1, "slot"), ArgumentItemStack.a(context1, "item").a(IntegerArgumentType.getInteger((CommandContext)context1, (String)"count"), true))))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("from").then(net.minecraft.commands.CommandDispatcher.a("block").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentPosition.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("sourceSlot", ArgumentInventorySlot.a()).executes(context1 -> ItemCommands.a((CommandListenerWrapper)context1.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "source"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context1, "sourceSlot"), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context1, "targets"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context1, "slot")))).then(net.minecraft.commands.CommandDispatcher.a("modifier", ResourceOrIdArgument.b(context)).suggests(g).executes(context1 -> ItemCommands.a((CommandListenerWrapper)context1.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "source"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context1, "sourceSlot"), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context1, "targets"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context1, "slot"), ResourceOrIdArgument.b((CommandContext<CommandListenerWrapper>)context1, "modifier")))))))).then(net.minecraft.commands.CommandDispatcher.a("entity").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentEntity.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("sourceSlot", ArgumentInventorySlot.a()).executes(context1 -> ItemCommands.a((CommandListenerWrapper)context1.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context1, "source"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context1, "sourceSlot"), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context1, "targets"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context1, "slot")))).then(net.minecraft.commands.CommandDispatcher.a("modifier", ResourceOrIdArgument.b(context)).suggests(g).executes(context1 -> ItemCommands.a((CommandListenerWrapper)context1.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context1, "source"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context1, "sourceSlot"), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context1, "targets"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context1, "slot"), ResourceOrIdArgument.b((CommandContext<CommandListenerWrapper>)context1, "modifier"))))))))))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("modify").then(net.minecraft.commands.CommandDispatcher.a("block").then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).then(net.minecraft.commands.CommandDispatcher.a("slot", ArgumentInventorySlot.a()).then(net.minecraft.commands.CommandDispatcher.a("modifier", ResourceOrIdArgument.b(context)).suggests(g).executes(context1 -> ItemCommands.a((CommandListenerWrapper)context1.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "pos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context1, "slot"), ResourceOrIdArgument.b((CommandContext<CommandListenerWrapper>)context1, "modifier")))))))).then(net.minecraft.commands.CommandDispatcher.a("entity").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).then(net.minecraft.commands.CommandDispatcher.a("slot", ArgumentInventorySlot.a()).then(net.minecraft.commands.CommandDispatcher.a("modifier", ResourceOrIdArgument.b(context)).suggests(g).executes(context1 -> ItemCommands.a((CommandListenerWrapper)context1.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context1, "targets"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context1, "slot"), ResourceOrIdArgument.b((CommandContext<CommandListenerWrapper>)context1, "modifier"))))))))));
    }

    private static int a(CommandListenerWrapper source, BlockPosition pos, int slot, Holder<LootItemFunction> modifier) throws CommandSyntaxException {
        IInventory container = ItemCommands.a(source, pos, a);
        if (slot >= 0 && slot < container.b()) {
            ItemStack itemStack = ItemCommands.a(source, modifier, container.a(slot));
            container.a(slot, itemStack);
            source.a(() -> IChatBaseComponent.a("commands.item.block.set.success", pos.u(), pos.v(), pos.w(), itemStack.K()), true);
            return 1;
        }
        throw c.create((Object)slot);
    }

    private static int a(CommandListenerWrapper source, Collection<? extends Entity> targets, int sourceSlot, Holder<LootItemFunction> modifer) throws CommandSyntaxException {
        HashMap map = Maps.newHashMapWithExpectedSize((int)targets.size());
        for (Entity entity : targets) {
            ItemStack itemStack;
            SlotAccess slot = entity.a_(sourceSlot);
            if (slot == SlotAccess.a || !slot.a(itemStack = ItemCommands.a(source, modifer, slot.a().v()))) continue;
            map.put(entity, itemStack);
            if (!(entity instanceof EntityPlayer)) continue;
            ((EntityPlayer)entity).cd.d();
        }
        if (map.isEmpty()) {
            throw e.create((Object)sourceSlot);
        }
        if (map.size() == 1) {
            Map.Entry entry = map.entrySet().iterator().next();
            source.a(() -> IChatBaseComponent.a("commands.item.entity.set.success.single", ((Entity)entry.getKey()).p_(), ((ItemStack)entry.getValue()).K()), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.item.entity.set.success.multiple", map.size()), true);
        }
        return map.size();
    }

    private static int a(CommandListenerWrapper source, BlockPosition pos, int slot, ItemStack item) throws CommandSyntaxException {
        IInventory container = ItemCommands.a(source, pos, a);
        if (slot >= 0 && slot < container.b()) {
            container.a(slot, item);
            source.a(() -> IChatBaseComponent.a("commands.item.block.set.success", pos.u(), pos.v(), pos.w(), item.K()), true);
            return 1;
        }
        throw c.create((Object)slot);
    }

    static IInventory a(CommandListenerWrapper source, BlockPosition pos, Dynamic3CommandExceptionType exception) throws CommandSyntaxException {
        TileEntity blockEntity = source.e().c_(pos);
        if (!(blockEntity instanceof IInventory)) {
            throw exception.create((Object)pos.u(), (Object)pos.v(), (Object)pos.w());
        }
        return (IInventory)((Object)blockEntity);
    }

    private static int a(CommandListenerWrapper source, Collection<? extends Entity> targets, int slot, ItemStack item) throws CommandSyntaxException {
        ArrayList list = Lists.newArrayListWithCapacity((int)targets.size());
        for (Entity entity : targets) {
            SlotAccess slot1 = entity.a_(slot);
            if (slot1 == SlotAccess.a || !slot1.a(item.v())) continue;
            list.add(entity);
            if (!(entity instanceof EntityPlayer)) continue;
            ((EntityPlayer)entity).cd.d();
        }
        if (list.isEmpty()) {
            throw f.create((Object)item.K(), (Object)slot);
        }
        if (list.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.item.entity.set.success.single", ((Entity)list.iterator().next()).p_(), item.K()), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.item.entity.set.success.multiple", list.size(), item.K()), true);
        }
        return list.size();
    }

    private static int a(CommandListenerWrapper source, BlockPosition pos, int sourceSlot, Collection<? extends Entity> targets, int slot) throws CommandSyntaxException {
        return ItemCommands.a(source, targets, slot, ItemCommands.a(source, pos, sourceSlot));
    }

    private static int a(CommandListenerWrapper source, BlockPosition pos, int sourceSlot, Collection<? extends Entity> targets, int slot, Holder<LootItemFunction> modifier) throws CommandSyntaxException {
        return ItemCommands.a(source, targets, slot, ItemCommands.a(source, modifier, ItemCommands.a(source, pos, sourceSlot)));
    }

    private static int a(CommandListenerWrapper source, BlockPosition sourcePos, int sourceSlot, BlockPosition pos, int slot) throws CommandSyntaxException {
        return ItemCommands.a(source, pos, slot, ItemCommands.a(source, sourcePos, sourceSlot));
    }

    private static int a(CommandListenerWrapper source, BlockPosition sourcePos, int sourceSlot, BlockPosition pos, int slot, Holder<LootItemFunction> modifier) throws CommandSyntaxException {
        return ItemCommands.a(source, pos, slot, ItemCommands.a(source, modifier, ItemCommands.a(source, sourcePos, sourceSlot)));
    }

    private static int a(CommandListenerWrapper source, Entity sourceEntity, int sourceSlot, BlockPosition pos, int slot) throws CommandSyntaxException {
        return ItemCommands.a(source, pos, slot, ItemCommands.a(sourceEntity, sourceSlot));
    }

    private static int a(CommandListenerWrapper source, Entity sourceEntity, int sourceSlot, BlockPosition pos, int slot, Holder<LootItemFunction> modifier) throws CommandSyntaxException {
        return ItemCommands.a(source, pos, slot, ItemCommands.a(source, modifier, ItemCommands.a(sourceEntity, sourceSlot)));
    }

    private static int a(CommandListenerWrapper source, Entity sourceEntity, int sourceSlot, Collection<? extends Entity> targets, int slot) throws CommandSyntaxException {
        return ItemCommands.a(source, targets, slot, ItemCommands.a(sourceEntity, sourceSlot));
    }

    private static int a(CommandListenerWrapper source, Entity sourceEntity, int sourceSlot, Collection<? extends Entity> targets, int slot, Holder<LootItemFunction> modifier) throws CommandSyntaxException {
        return ItemCommands.a(source, targets, slot, ItemCommands.a(source, modifier, ItemCommands.a(sourceEntity, sourceSlot)));
    }

    private static ItemStack a(CommandListenerWrapper source, Holder<LootItemFunction> modifier, ItemStack stack) {
        WorldServer level = source.e();
        LootParams lootParams = new LootParams.a(level).a(LootContextParameters.f, source.d()).b(LootContextParameters.a, source.f()).a(LootContextParameterSets.d);
        LootTableInfo lootContext = new LootTableInfo.Builder(lootParams).a(Optional.empty());
        lootContext.b(LootTableInfo.a(modifier.a()));
        ItemStack itemStack = (ItemStack)modifier.a().apply(stack, lootContext);
        itemStack.f(itemStack.k());
        return itemStack;
    }

    private static ItemStack a(Entity entity, int slot) throws CommandSyntaxException {
        SlotAccess slot1 = entity.a_(slot);
        if (slot1 == SlotAccess.a) {
            throw d.create((Object)slot);
        }
        return slot1.a().v();
    }

    private static ItemStack a(CommandListenerWrapper source, BlockPosition pos, int slot) throws CommandSyntaxException {
        IInventory container = ItemCommands.a(source, pos, b);
        if (slot >= 0 && slot < container.b()) {
            return container.a(slot).v();
        }
        throw d.create((Object)slot);
    }
}

