/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic4CommandExceptionType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.event.player.PlayerTeleportEvent;

public class CommandSpreadPlayers {
    private static final int a = 10000;
    private static final Dynamic4CommandExceptionType b = new Dynamic4CommandExceptionType((teamCount, x2, z2, suggestedSpread) -> IChatBaseComponent.b("commands.spreadplayers.failed.teams", teamCount, x2, z2, suggestedSpread));
    private static final Dynamic4CommandExceptionType c = new Dynamic4CommandExceptionType((entityCount, x2, z2, suggestedSpread) -> IChatBaseComponent.b("commands.spreadplayers.failed.entities", entityCount, x2, z2, suggestedSpread));
    private static final Dynamic2CommandExceptionType d = new Dynamic2CommandExceptionType((maxHeight, worldMin) -> IChatBaseComponent.b("commands.spreadplayers.failed.invalid.height", maxHeight, worldMin));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("spreadplayers").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("center", ArgumentVec2.a()).then(net.minecraft.commands.CommandDispatcher.a("spreadDistance", FloatArgumentType.floatArg((float)0.0f)).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("maxRange", FloatArgumentType.floatArg((float)1.0f)).then(net.minecraft.commands.CommandDispatcher.a("respectTeams", BoolArgumentType.bool()).then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).executes(context -> CommandSpreadPlayers.a((CommandListenerWrapper)context.getSource(), ArgumentVec2.a((CommandContext<CommandListenerWrapper>)context, "center"), FloatArgumentType.getFloat((CommandContext)context, (String)"spreadDistance"), FloatArgumentType.getFloat((CommandContext)context, (String)"maxRange"), ((CommandListenerWrapper)context.getSource()).e().an() + 1, BoolArgumentType.getBool((CommandContext)context, (String)"respectTeams"), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets")))))).then(net.minecraft.commands.CommandDispatcher.a("under").then(net.minecraft.commands.CommandDispatcher.a("maxHeight", IntegerArgumentType.integer()).then(net.minecraft.commands.CommandDispatcher.a("respectTeams", BoolArgumentType.bool()).then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).executes(context -> CommandSpreadPlayers.a((CommandListenerWrapper)context.getSource(), ArgumentVec2.a((CommandContext<CommandListenerWrapper>)context, "center"), FloatArgumentType.getFloat((CommandContext)context, (String)"spreadDistance"), FloatArgumentType.getFloat((CommandContext)context, (String)"maxRange"), IntegerArgumentType.getInteger((CommandContext)context, (String)"maxHeight"), BoolArgumentType.getBool((CommandContext)context, (String)"respectTeams"), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"))))))))))));
    }

    private static int a(CommandListenerWrapper source, Vec2F center, float spreadDistance, float maxRange, int maxHeight, boolean respectTeams, Collection<? extends Entity> targets) throws CommandSyntaxException {
        WorldServer level = source.e();
        int minY = level.L_();
        if (maxHeight < minY) {
            throw d.create((Object)maxHeight, (Object)minY);
        }
        RandomSource randomSource = RandomSource.a();
        double d2 = center.i - maxRange;
        double d1 = center.j - maxRange;
        double d22 = center.i + maxRange;
        double d3 = center.j + maxRange;
        a[] positions = CommandSpreadPlayers.a(randomSource, respectTeams ? CommandSpreadPlayers.a(targets) : targets.size(), d2, d1, d22, d3);
        CommandSpreadPlayers.a(center, spreadDistance, level, randomSource, d2, d1, d22, d3, maxHeight, positions, respectTeams);
        double d4 = CommandSpreadPlayers.a(targets, level, positions, maxHeight, respectTeams);
        source.a(() -> IChatBaseComponent.a("commands.spreadplayers.success." + (respectTeams ? "teams" : "entities"), positions.length, Float.valueOf(center.i), Float.valueOf(center.j), String.format(Locale.ROOT, "%.2f", d4)), true);
        return positions.length;
    }

    private static int a(Collection<? extends Entity> entities) {
        HashSet set = Sets.newHashSet();
        for (Entity entity : entities) {
            if (entity instanceof EntityHuman) {
                set.add(entity.cr());
                continue;
            }
            set.add(null);
        }
        return set.size();
    }

    private static void a(Vec2F center, double spreadDistance, WorldServer level, RandomSource random, double minX, double minZ, double maxX, double maxZ, int maxHeight, a[] positions, boolean respectTeams) throws CommandSyntaxException {
        int i2;
        boolean flag = true;
        double d2 = 3.4028234663852886E38;
        for (i2 = 0; i2 < 10000 && flag; ++i2) {
            flag = false;
            d2 = 3.4028234663852886E38;
            for (int i1 = 0; i1 < positions.length; ++i1) {
                a position = positions[i1];
                int i22 = 0;
                a position1 = new a();
                for (int i3 = 0; i3 < positions.length; ++i3) {
                    if (i1 == i3) continue;
                    a position2 = positions[i3];
                    double d1 = position.a(position2);
                    d2 = Math.min(d1, d2);
                    if (!(d1 < spreadDistance)) continue;
                    ++i22;
                    position1.a += position2.a - position.a;
                    position1.b += position2.b - position.b;
                }
                if (i22 > 0) {
                    position1.a /= (double)i22;
                    position1.b /= (double)i22;
                    double length = position1.b();
                    if (length > 0.0) {
                        position1.a();
                        position.b(position1);
                    } else {
                        position.a(random, minX, minZ, maxX, maxZ);
                    }
                    flag = true;
                }
                if (!position.a(minX, minZ, maxX, maxZ)) continue;
                flag = true;
            }
            if (flag) continue;
            for (a position1 : positions) {
                if (position1.b(level, maxHeight)) continue;
                position1.a(random, minX, minZ, maxX, maxZ);
                flag = true;
            }
        }
        if (d2 == 3.4028234663852886E38) {
            d2 = 0.0;
        }
        if (i2 >= 10000) {
            if (respectTeams) {
                throw b.create((Object)positions.length, (Object)Float.valueOf(center.i), (Object)Float.valueOf(center.j), (Object)String.format(Locale.ROOT, "%.2f", d2));
            }
            throw c.create((Object)positions.length, (Object)Float.valueOf(center.i), (Object)Float.valueOf(center.j), (Object)String.format(Locale.ROOT, "%.2f", d2));
        }
    }

    private static double a(Collection<? extends Entity> targets, WorldServer level, a[] positions, int maxHeight, boolean respectTeams) {
        double d2 = 0.0;
        int i2 = 0;
        HashMap map = Maps.newHashMap();
        for (Entity entity : targets) {
            a position;
            if (respectTeams) {
                ScoreboardTeam team;
                ScoreboardTeam scoreboardTeam = team = entity instanceof EntityHuman ? entity.cr() : null;
                if (!map.containsKey(team)) {
                    map.put(team, positions[i2++]);
                }
                position = (a)map.get(team);
            } else {
                position = positions[i2++];
            }
            entity.teleportTo(level, (double)MathHelper.a(position.a) + 0.5, position.a(level, maxHeight), (double)MathHelper.a(position.b) + 0.5, Set.of(), entity.dL(), entity.dN(), true, PlayerTeleportEvent.TeleportCause.COMMAND);
            double d1 = Double.MAX_VALUE;
            for (a position1 : positions) {
                if (position == position1) continue;
                double d22 = position.a(position1);
                d1 = Math.min(d22, d1);
            }
            d2 += d1;
        }
        return targets.size() < 2 ? 0.0 : d2 / (double)targets.size();
    }

    private static a[] a(RandomSource random, int count, double minX, double minZ, double maxX, double maxZ) {
        a[] positions = new a[count];
        for (int i2 = 0; i2 < positions.length; ++i2) {
            a position = new a();
            position.a(random, minX, minZ, maxX, maxZ);
            positions[i2] = position;
        }
        return positions;
    }

    static class a {
        double a;
        double b;

        a() {
        }

        double a(a other) {
            double d2 = this.a - other.a;
            double d1 = this.b - other.b;
            return Math.sqrt(d2 * d2 + d1 * d1);
        }

        void a() {
            double length = this.b();
            this.a /= length;
            this.b /= length;
        }

        double b() {
            return Math.sqrt(this.a * this.a + this.b * this.b);
        }

        public void b(a other) {
            this.a -= other.a;
            this.b -= other.b;
        }

        public boolean a(double minX, double minZ, double maxX, double maxZ) {
            boolean flag = false;
            if (this.a < minX) {
                this.a = minX;
                flag = true;
            } else if (this.a > maxX) {
                this.a = maxX;
                flag = true;
            }
            if (this.b < minZ) {
                this.b = minZ;
                flag = true;
            } else if (this.b > maxZ) {
                this.b = maxZ;
                flag = true;
            }
            return flag;
        }

        public int a(IBlockAccess level, int y2) {
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition(this.a, (double)(y2 + 1), this.b);
            boolean isAir = level.a_(mutableBlockPos).l();
            mutableBlockPos.c(EnumDirection.a);
            boolean isAir1 = level.a_(mutableBlockPos).l();
            while (mutableBlockPos.v() > level.L_()) {
                mutableBlockPos.c(EnumDirection.a);
                boolean isAir2 = level.a_(mutableBlockPos).l();
                if (!isAir2 && isAir1 && isAir) {
                    return mutableBlockPos.v() + 1;
                }
                isAir = isAir1;
                isAir1 = isAir2;
            }
            return y2 + 1;
        }

        public boolean b(IBlockAccess level, int y2) {
            BlockPosition blockPos = BlockPosition.a(this.a, (double)(this.a(level, y2) - 1), this.b);
            IBlockData blockState = level.a_(blockPos);
            return blockPos.v() < y2 && !blockState.n() && !blockState.a(TagsBlock.aN);
        }

        public void a(RandomSource random, double minX, double minZ, double maxX, double maxZ) {
            this.a = MathHelper.a(random, minX, maxX);
            this.b = MathHelper.a(random, minZ, maxZ);
        }
    }
}

