/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentMathOperation;
import net.minecraft.commands.arguments.ArgumentScoreboardCriteria;
import net.minecraft.commands.arguments.ArgumentScoreboardObjective;
import net.minecraft.commands.arguments.ArgumentScoreboardSlot;
import net.minecraft.commands.arguments.ArgumentScoreholder;
import net.minecraft.commands.arguments.StyleArgument;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.numbers.BlankFormat;
import net.minecraft.network.chat.numbers.FixedFormat;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.StyledFormat;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;

public class CommandScoreboard {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.scoreboard.objectives.add.duplicate"));
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.scoreboard.objectives.display.alreadyEmpty"));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.scoreboard.objectives.display.alreadySet"));
    private static final SimpleCommandExceptionType d = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.scoreboard.players.enable.failed"));
    private static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.scoreboard.players.enable.invalid"));
    private static final Dynamic2CommandExceptionType f = new Dynamic2CommandExceptionType((objective, target) -> IChatBaseComponent.b("commands.scoreboard.players.get.null", objective, target));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("scoreboard").requires(source -> source.c(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("objectives").then(net.minecraft.commands.CommandDispatcher.a("list").executes(context1 -> CommandScoreboard.b((CommandListenerWrapper)context1.getSource())))).then(net.minecraft.commands.CommandDispatcher.a("add").then(net.minecraft.commands.CommandDispatcher.a("objective", StringArgumentType.word()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("criteria", ArgumentScoreboardCriteria.a()).executes(context1 -> CommandScoreboard.a((CommandListenerWrapper)context1.getSource(), StringArgumentType.getString((CommandContext)context1, (String)"objective"), ArgumentScoreboardCriteria.a((CommandContext<CommandListenerWrapper>)context1, "criteria"), (IChatBaseComponent)IChatBaseComponent.b(StringArgumentType.getString((CommandContext)context1, (String)"objective"))))).then(net.minecraft.commands.CommandDispatcher.a("displayName", ArgumentChatComponent.a(context)).executes(context1 -> CommandScoreboard.a((CommandListenerWrapper)context1.getSource(), StringArgumentType.getString((CommandContext)context1, (String)"objective"), ArgumentScoreboardCriteria.a((CommandContext<CommandListenerWrapper>)context1, "criteria"), ArgumentChatComponent.a((CommandContext<CommandListenerWrapper>)context1, "displayName")))))))).then(net.minecraft.commands.CommandDispatcher.a("modify").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()).then(net.minecraft.commands.CommandDispatcher.a("displayname").then(net.minecraft.commands.CommandDispatcher.a("displayName", ArgumentChatComponent.a(context)).executes(context1 -> CommandScoreboard.a((CommandListenerWrapper)context1.getSource(), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)context1, "objective"), ArgumentChatComponent.a((CommandContext<CommandListenerWrapper>)context1, "displayName")))))).then(CommandScoreboard.a())).then(net.minecraft.commands.CommandDispatcher.a("displayautoupdate").then(net.minecraft.commands.CommandDispatcher.a("value", BoolArgumentType.bool()).executes(context1 -> CommandScoreboard.a((CommandListenerWrapper)context1.getSource(), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)context1, "objective"), BoolArgumentType.getBool((CommandContext)context1, (String)"value")))))).then(CommandScoreboard.a(context, net.minecraft.commands.CommandDispatcher.a("numberformat"), (CommandContext<CommandListenerWrapper> context1, NumberFormat format) -> CommandScoreboard.a((CommandListenerWrapper)context1.getSource(), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)context1, "objective"), format)))))).then(net.minecraft.commands.CommandDispatcher.a("remove").then(net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()).executes(context1 -> CommandScoreboard.a((CommandListenerWrapper)context1.getSource(), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)context1, "objective")))))).then(net.minecraft.commands.CommandDispatcher.a("setdisplay").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("slot", ArgumentScoreboardSlot.a()).executes(context1 -> CommandScoreboard.a((CommandListenerWrapper)context1.getSource(), ArgumentScoreboardSlot.a((CommandContext<CommandListenerWrapper>)context1, "slot")))).then(net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()).executes(context1 -> CommandScoreboard.a((CommandListenerWrapper)context1.getSource(), ArgumentScoreboardSlot.a((CommandContext<CommandListenerWrapper>)context1, "slot"), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)context1, "objective")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("players").then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("list").executes(context1 -> CommandScoreboard.a((CommandListenerWrapper)context1.getSource()))).then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).executes(context1 -> CommandScoreboard.a((CommandListenerWrapper)context1.getSource(), ArgumentScoreholder.a((CommandContext<CommandListenerWrapper>)context1, "target")))))).then(net.minecraft.commands.CommandDispatcher.a("set").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentScoreholder.b()).suggests(ArgumentScoreholder.a).then(net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()).then(net.minecraft.commands.CommandDispatcher.a("score", IntegerArgumentType.integer()).executes(context1 -> CommandScoreboard.a((CommandListenerWrapper)context1.getSource(), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)context1, "targets"), ArgumentScoreboardObjective.b((CommandContext<CommandListenerWrapper>)context1, "objective"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"score")))))))).then(net.minecraft.commands.CommandDispatcher.a("get").then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()).executes(context1 -> CommandScoreboard.a((CommandListenerWrapper)context1.getSource(), ArgumentScoreholder.a((CommandContext<CommandListenerWrapper>)context1, "target"), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)context1, "objective"))))))).then(net.minecraft.commands.CommandDispatcher.a("add").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentScoreholder.b()).suggests(ArgumentScoreholder.a).then(net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()).then(net.minecraft.commands.CommandDispatcher.a("score", IntegerArgumentType.integer((int)0)).executes(context1 -> CommandScoreboard.b((CommandListenerWrapper)context1.getSource(), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)context1, "targets"), ArgumentScoreboardObjective.b((CommandContext<CommandListenerWrapper>)context1, "objective"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"score")))))))).then(net.minecraft.commands.CommandDispatcher.a("remove").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentScoreholder.b()).suggests(ArgumentScoreholder.a).then(net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()).then(net.minecraft.commands.CommandDispatcher.a("score", IntegerArgumentType.integer((int)0)).executes(context1 -> CommandScoreboard.c((CommandListenerWrapper)context1.getSource(), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)context1, "targets"), ArgumentScoreboardObjective.b((CommandContext<CommandListenerWrapper>)context1, "objective"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"score")))))))).then(net.minecraft.commands.CommandDispatcher.a("reset").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targets", ArgumentScoreholder.b()).suggests(ArgumentScoreholder.a).executes(commandContext -> CommandScoreboard.a((CommandListenerWrapper)commandContext.getSource(), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)commandContext, "targets")))).then(net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()).executes(context1 -> CommandScoreboard.b((CommandListenerWrapper)context1.getSource(), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)context1, "targets"), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)context1, "objective"))))))).then(net.minecraft.commands.CommandDispatcher.a("enable").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentScoreholder.b()).suggests(ArgumentScoreholder.a).then(net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()).suggests((commandContext, suggestionsBuilder) -> CommandScoreboard.a((CommandListenerWrapper)commandContext.getSource(), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)commandContext, "targets"), suggestionsBuilder)).executes(commandContext -> CommandScoreboard.a((CommandListenerWrapper)commandContext.getSource(), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)commandContext, "targets"), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)commandContext, "objective"))))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("display").then(net.minecraft.commands.CommandDispatcher.a("name").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentScoreholder.b()).suggests(ArgumentScoreholder.a).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()).then(net.minecraft.commands.CommandDispatcher.a("name", ArgumentChatComponent.a(context)).executes(commandContext -> CommandScoreboard.a((CommandListenerWrapper)commandContext.getSource(), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)commandContext, "targets"), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)commandContext, "objective"), ArgumentChatComponent.a((CommandContext<CommandListenerWrapper>)commandContext, "name"))))).executes(commandContext -> CommandScoreboard.a((CommandListenerWrapper)commandContext.getSource(), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)commandContext, "targets"), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)commandContext, "objective"), null)))))).then(net.minecraft.commands.CommandDispatcher.a("numberformat").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentScoreholder.b()).suggests(ArgumentScoreholder.a).then(CommandScoreboard.a(context, net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()), (CommandContext<CommandListenerWrapper> context1, NumberFormat format) -> CommandScoreboard.a((CommandListenerWrapper)context1.getSource(), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)context1, "targets"), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)context1, "objective"), format))))))).then(net.minecraft.commands.CommandDispatcher.a("operation").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentScoreholder.b()).suggests(ArgumentScoreholder.a).then(net.minecraft.commands.CommandDispatcher.a("targetObjective", ArgumentScoreboardObjective.a()).then(net.minecraft.commands.CommandDispatcher.a("operation", ArgumentMathOperation.a()).then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.b()).suggests(ArgumentScoreholder.a).then(net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()).executes(commandContext -> CommandScoreboard.a((CommandListenerWrapper)commandContext.getSource(), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)commandContext, "targets"), ArgumentScoreboardObjective.b((CommandContext<CommandListenerWrapper>)commandContext, "targetObjective"), ArgumentMathOperation.a((CommandContext<CommandListenerWrapper>)commandContext, "operation"), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)commandContext, "source"), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)commandContext, "sourceObjective"))))))))))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandBuildContext context, ArgumentBuilder<CommandListenerWrapper, ?> argumentBuilder, a executor) {
        return ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)argumentBuilder.then(net.minecraft.commands.CommandDispatcher.a("blank").executes(commandContext -> executor.run((CommandContext<CommandListenerWrapper>)commandContext, BlankFormat.a)))).then(net.minecraft.commands.CommandDispatcher.a("fixed").then(net.minecraft.commands.CommandDispatcher.a("contents", ArgumentChatComponent.a(context)).executes(commandContext -> {
            IChatBaseComponent component = ArgumentChatComponent.a((CommandContext<CommandListenerWrapper>)commandContext, "contents");
            return executor.run((CommandContext<CommandListenerWrapper>)commandContext, new FixedFormat(component));
        })))).then(net.minecraft.commands.CommandDispatcher.a("styled").then(net.minecraft.commands.CommandDispatcher.a("style", StyleArgument.a(context)).executes(commandContext -> {
            ChatModifier style = StyleArgument.a((CommandContext<CommandListenerWrapper>)commandContext, "style");
            return executor.run((CommandContext<CommandListenerWrapper>)commandContext, new StyledFormat(style));
        })))).executes(commandContext -> executor.run((CommandContext<CommandListenerWrapper>)commandContext, null));
    }

    private static LiteralArgumentBuilder<CommandListenerWrapper> a() {
        LiteralArgumentBuilder<CommandListenerWrapper> literalArgumentBuilder = net.minecraft.commands.CommandDispatcher.a("rendertype");
        for (IScoreboardCriteria.EnumScoreboardHealthDisplay renderType : IScoreboardCriteria.EnumScoreboardHealthDisplay.values()) {
            literalArgumentBuilder.then(net.minecraft.commands.CommandDispatcher.a(renderType.a()).executes(commandContext -> CommandScoreboard.a((CommandListenerWrapper)commandContext.getSource(), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)commandContext, "objective"), renderType)));
        }
        return literalArgumentBuilder;
    }

    private static CompletableFuture<Suggestions> a(CommandListenerWrapper source, Collection<ScoreHolder> targets, SuggestionsBuilder suggestions) {
        ArrayList list = Lists.newArrayList();
        ScoreboardServer scoreboard = source.l().aJ();
        for (ScoreboardObjective objective : scoreboard.c()) {
            if (objective.c() != IScoreboardCriteria.c) continue;
            boolean flag = false;
            for (ScoreHolder scoreHolder : targets) {
                ReadOnlyScoreInfo playerScoreInfo = scoreboard.d(scoreHolder, objective);
                if (playerScoreInfo != null && !playerScoreInfo.b()) continue;
                flag = true;
                break;
            }
            if (!flag) continue;
            list.add(objective.b());
        }
        return ICompletionProvider.b(list, suggestions);
    }

    private static int a(CommandListenerWrapper source, ScoreHolder scoreHolder, ScoreboardObjective objective) throws CommandSyntaxException {
        ScoreboardServer scoreboard = source.l().aJ();
        ReadOnlyScoreInfo playerScoreInfo = scoreboard.d(scoreHolder, objective);
        if (playerScoreInfo == null) {
            throw f.create((Object)objective.b(), (Object)scoreHolder.hg());
        }
        source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.get.success", scoreHolder.hg(), playerScoreInfo.a(), objective.g()), false);
        return playerScoreInfo.a();
    }

    private static IChatBaseComponent a(Collection<ScoreHolder> scores) {
        return scores.iterator().next().hg();
    }

    private static int a(CommandListenerWrapper source, Collection<ScoreHolder> targets, ScoreboardObjective targetObjectives, ArgumentMathOperation.a operation, Collection<ScoreHolder> sourceEntities, ScoreboardObjective sourceObjective) throws CommandSyntaxException {
        ScoreboardServer scoreboard = source.l().aJ();
        int i2 = 0;
        for (ScoreHolder scoreHolder : targets) {
            ScoreAccess playerScore = scoreboard.c(scoreHolder, targetObjectives);
            for (ScoreHolder scoreHolder1 : sourceEntities) {
                ScoreAccess playerScore1 = scoreboard.c(scoreHolder1, sourceObjective);
                operation.apply(playerScore, playerScore1);
            }
            i2 += playerScore.a();
        }
        if (targets.size() == 1) {
            int i1 = i2;
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.operation.success.single", targetObjectives.g(), CommandScoreboard.a(targets), i1), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.operation.success.multiple", targetObjectives.g(), targets.size()), true);
        }
        return i2;
    }

    private static int a(CommandListenerWrapper source, Collection<ScoreHolder> targets, ScoreboardObjective objective) throws CommandSyntaxException {
        if (objective.c() != IScoreboardCriteria.c) {
            throw e.create();
        }
        ScoreboardServer scoreboard = source.l().aJ();
        int i2 = 0;
        for (ScoreHolder scoreHolder : targets) {
            ScoreAccess playerScore = scoreboard.c(scoreHolder, objective);
            if (!playerScore.d()) continue;
            playerScore.e();
            ++i2;
        }
        if (i2 == 0) {
            throw d.create();
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.enable.success.single", objective.g(), CommandScoreboard.a(targets)), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.enable.success.multiple", objective.g(), targets.size()), true);
        }
        return i2;
    }

    private static int a(CommandListenerWrapper source, Collection<ScoreHolder> targets) {
        ScoreboardServer scoreboard = source.l().aJ();
        for (ScoreHolder scoreHolder : targets) {
            scoreboard.b(scoreHolder);
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.reset.all.single", CommandScoreboard.a(targets)), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.reset.all.multiple", targets.size()), true);
        }
        return targets.size();
    }

    private static int b(CommandListenerWrapper source, Collection<ScoreHolder> targets, ScoreboardObjective objective) {
        ScoreboardServer scoreboard = source.l().aJ();
        for (ScoreHolder scoreHolder : targets) {
            scoreboard.e(scoreHolder, objective);
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.reset.specific.single", objective.g(), CommandScoreboard.a(targets)), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.reset.specific.multiple", objective.g(), targets.size()), true);
        }
        return targets.size();
    }

    private static int a(CommandListenerWrapper source, Collection<ScoreHolder> targets, ScoreboardObjective objective, int newValue) {
        ScoreboardServer scoreboard = source.l().aJ();
        for (ScoreHolder scoreHolder : targets) {
            scoreboard.c(scoreHolder, objective).a(newValue);
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.set.success.single", objective.g(), CommandScoreboard.a(targets), newValue), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.set.success.multiple", objective.g(), targets.size(), newValue), true);
        }
        return newValue * targets.size();
    }

    private static int a(CommandListenerWrapper source, Collection<ScoreHolder> targets, ScoreboardObjective objective, @Nullable IChatBaseComponent displayName) {
        ScoreboardServer scoreboard = source.l().aJ();
        for (ScoreHolder scoreHolder : targets) {
            scoreboard.c(scoreHolder, objective).a(displayName);
        }
        if (displayName == null) {
            if (targets.size() == 1) {
                source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.display.name.clear.success.single", CommandScoreboard.a(targets), objective.g()), true);
            } else {
                source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.display.name.clear.success.multiple", targets.size(), objective.g()), true);
            }
        } else if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.display.name.set.success.single", displayName, CommandScoreboard.a(targets), objective.g()), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.display.name.set.success.multiple", displayName, targets.size(), objective.g()), true);
        }
        return targets.size();
    }

    private static int a(CommandListenerWrapper source, Collection<ScoreHolder> targets, ScoreboardObjective objective, @Nullable NumberFormat numberFormat) {
        ScoreboardServer scoreboard = source.l().aJ();
        for (ScoreHolder scoreHolder : targets) {
            scoreboard.c(scoreHolder, objective).a(numberFormat);
        }
        if (numberFormat == null) {
            if (targets.size() == 1) {
                source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.display.numberFormat.clear.success.single", CommandScoreboard.a(targets), objective.g()), true);
            } else {
                source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.display.numberFormat.clear.success.multiple", targets.size(), objective.g()), true);
            }
        } else if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.display.numberFormat.set.success.single", CommandScoreboard.a(targets), objective.g()), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.display.numberFormat.set.success.multiple", targets.size(), objective.g()), true);
        }
        return targets.size();
    }

    private static int b(CommandListenerWrapper source, Collection<ScoreHolder> targets, ScoreboardObjective objective, int amount) {
        ScoreboardServer scoreboard = source.l().aJ();
        int i2 = 0;
        for (ScoreHolder scoreHolder : targets) {
            ScoreAccess playerScore = scoreboard.c(scoreHolder, objective);
            playerScore.a(playerScore.a() + amount);
            i2 += playerScore.a();
        }
        if (targets.size() == 1) {
            int i1 = i2;
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.add.success.single", amount, objective.g(), CommandScoreboard.a(targets), i1), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.add.success.multiple", amount, objective.g(), targets.size()), true);
        }
        return i2;
    }

    private static int c(CommandListenerWrapper source, Collection<ScoreHolder> targets, ScoreboardObjective objective, int amount) {
        ScoreboardServer scoreboard = source.l().aJ();
        int i2 = 0;
        for (ScoreHolder scoreHolder : targets) {
            ScoreAccess playerScore = scoreboard.c(scoreHolder, objective);
            playerScore.a(playerScore.a() - amount);
            i2 += playerScore.a();
        }
        if (targets.size() == 1) {
            int i1 = i2;
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.remove.success.single", amount, objective.g(), CommandScoreboard.a(targets), i1), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.remove.success.multiple", amount, objective.g(), targets.size()), true);
        }
        return i2;
    }

    private static int a(CommandListenerWrapper source) {
        Collection<ScoreHolder> trackedPlayers = source.l().aJ().e();
        if (trackedPlayers.isEmpty()) {
            source.a(() -> IChatBaseComponent.c("commands.scoreboard.players.list.empty"), false);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.list.success", trackedPlayers.size(), ChatComponentUtils.b(trackedPlayers, ScoreHolder::hg)), false);
        }
        return trackedPlayers.size();
    }

    private static int a(CommandListenerWrapper source, ScoreHolder score) {
        Object2IntMap<ScoreboardObjective> map = source.l().aJ().c(score);
        if (map.isEmpty()) {
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.list.entity.empty", score.hg()), false);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.list.entity.success", score.hg(), map.size()), false);
            Object2IntMaps.fastForEach(map, entry -> source.a(() -> IChatBaseComponent.a("commands.scoreboard.players.list.entity.entry", ((ScoreboardObjective)entry.getKey()).g(), entry.getIntValue()), false));
        }
        return map.size();
    }

    private static int a(CommandListenerWrapper source, DisplaySlot slot) throws CommandSyntaxException {
        ScoreboardServer scoreboard = source.l().aJ();
        if (scoreboard.a(slot) == null) {
            throw b.create();
        }
        ((Scoreboard)scoreboard).a(slot, null);
        source.a(() -> IChatBaseComponent.a("commands.scoreboard.objectives.display.cleared", new Object[]{slot.c()}), true);
        return 0;
    }

    private static int a(CommandListenerWrapper source, DisplaySlot slot, ScoreboardObjective objective) throws CommandSyntaxException {
        ScoreboardServer scoreboard = source.l().aJ();
        if (scoreboard.a(slot) == objective) {
            throw c.create();
        }
        ((Scoreboard)scoreboard).a(slot, objective);
        source.a(() -> IChatBaseComponent.a("commands.scoreboard.objectives.display.set", new Object[]{slot.c(), objective.d()}), true);
        return 0;
    }

    private static int a(CommandListenerWrapper source, ScoreboardObjective objective, IChatBaseComponent displayName) {
        if (!objective.d().equals(displayName)) {
            objective.a(displayName);
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.objectives.modify.displayname", new Object[]{objective.b(), objective.g()}), true);
        }
        return 0;
    }

    private static int a(CommandListenerWrapper source, ScoreboardObjective objective, boolean displayAutoUpdate) {
        if (objective.e() != displayAutoUpdate) {
            objective.a(displayAutoUpdate);
            if (displayAutoUpdate) {
                source.a(() -> IChatBaseComponent.a("commands.scoreboard.objectives.modify.displayAutoUpdate.enable", new Object[]{objective.b(), objective.g()}), true);
            } else {
                source.a(() -> IChatBaseComponent.a("commands.scoreboard.objectives.modify.displayAutoUpdate.disable", new Object[]{objective.b(), objective.g()}), true);
            }
        }
        return 0;
    }

    private static int a(CommandListenerWrapper source, ScoreboardObjective objective, @Nullable NumberFormat format) {
        objective.b(format);
        if (format != null) {
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.objectives.modify.objectiveFormat.set", new Object[]{objective.b()}), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.objectives.modify.objectiveFormat.clear", new Object[]{objective.b()}), true);
        }
        return 0;
    }

    private static int a(CommandListenerWrapper source, ScoreboardObjective objective, IScoreboardCriteria.EnumScoreboardHealthDisplay renderType) {
        if (objective.h() != renderType) {
            objective.a(renderType);
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.objectives.modify.rendertype", objective.g()), true);
        }
        return 0;
    }

    private static int a(CommandListenerWrapper source, ScoreboardObjective objective) {
        ScoreboardServer scoreboard = source.l().aJ();
        scoreboard.j(objective);
        source.a(() -> IChatBaseComponent.a("commands.scoreboard.objectives.remove.success", objective.g()), true);
        return scoreboard.c().size();
    }

    private static int a(CommandListenerWrapper source, String name, IScoreboardCriteria criteria, IChatBaseComponent displayName) throws CommandSyntaxException {
        ScoreboardServer scoreboard = source.l().aJ();
        if (scoreboard.a(name) != null) {
            throw a.create();
        }
        scoreboard.a(name, criteria, displayName, criteria.f(), false, null);
        ScoreboardObjective objective = scoreboard.a(name);
        source.a(() -> IChatBaseComponent.a("commands.scoreboard.objectives.add.success", objective.g()), true);
        return scoreboard.c().size();
    }

    private static int b(CommandListenerWrapper source) {
        Collection<ScoreboardObjective> objectives = source.l().aJ().c();
        if (objectives.isEmpty()) {
            source.a(() -> IChatBaseComponent.c("commands.scoreboard.objectives.list.empty"), false);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.scoreboard.objectives.list.success", objectives.size(), ChatComponentUtils.b(objectives, ScoreboardObjective::g)), false);
        }
        return objectives.size();
    }

    @FunctionalInterface
    public static interface a {
        public int run(CommandContext<CommandListenerWrapper> var1, @Nullable NumberFormat var2) throws CommandSyntaxException;
    }
}

