/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentInventorySlot;
import net.minecraft.commands.arguments.ResourceOrIdArgument;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;

public class CommandLoot {
    public static final SuggestionProvider<CommandListenerWrapper> a = (context, builder) -> {
        ReloadableServerRegistries.a holder = ((CommandListenerWrapper)context.getSource()).l().bc();
        return ICompletionProvider.a(holder.a(Registries.bg), builder);
    };
    private static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(target -> IChatBaseComponent.b("commands.drop.no_held_items", target));
    private static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(target -> IChatBaseComponent.b("commands.drop.no_loot_table.entity", target));
    private static final DynamicCommandExceptionType d = new DynamicCommandExceptionType(object -> IChatBaseComponent.b("commands.drop.no_loot_table.block", object));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)CommandLoot.a((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("loot").requires(commandSourceStack -> commandSourceStack.c(2)), (ArgumentBuilder<CommandListenerWrapper, ?> builder, b dropConsumer) -> ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)builder.then(net.minecraft.commands.CommandDispatcher.a("fish").then(net.minecraft.commands.CommandDispatcher.a("loot_table", ResourceOrIdArgument.a(context)).suggests(a).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).executes(context1 -> CommandLoot.a((CommandContext<CommandListenerWrapper>)context1, ResourceOrIdArgument.a((CommandContext<CommandListenerWrapper>)context1, "loot_table"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "pos"), ItemStack.j, dropConsumer))).then(net.minecraft.commands.CommandDispatcher.a("tool", ArgumentItemStack.a(context)).executes(context1 -> CommandLoot.a((CommandContext<CommandListenerWrapper>)context1, ResourceOrIdArgument.a((CommandContext<CommandListenerWrapper>)context1, "loot_table"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "pos"), ArgumentItemStack.a(context1, "tool").a(1, false), dropConsumer)))).then(net.minecraft.commands.CommandDispatcher.a("mainhand").executes(context1 -> CommandLoot.a((CommandContext<CommandListenerWrapper>)context1, ResourceOrIdArgument.a((CommandContext<CommandListenerWrapper>)context1, "loot_table"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "pos"), CommandLoot.a((CommandListenerWrapper)context1.getSource(), EnumItemSlot.a), dropConsumer)))).then(net.minecraft.commands.CommandDispatcher.a("offhand").executes(context1 -> CommandLoot.a((CommandContext<CommandListenerWrapper>)context1, ResourceOrIdArgument.a((CommandContext<CommandListenerWrapper>)context1, "loot_table"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "pos"), CommandLoot.a((CommandListenerWrapper)context1.getSource(), EnumItemSlot.b), dropConsumer))))))).then(net.minecraft.commands.CommandDispatcher.a("loot").then(net.minecraft.commands.CommandDispatcher.a("loot_table", ResourceOrIdArgument.a(context)).suggests(a).executes(context1 -> CommandLoot.a((CommandContext<CommandListenerWrapper>)context1, ResourceOrIdArgument.a((CommandContext<CommandListenerWrapper>)context1, "loot_table"), dropConsumer))))).then(net.minecraft.commands.CommandDispatcher.a("kill").then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentEntity.a()).executes(context1 -> CommandLoot.a((CommandContext<CommandListenerWrapper>)context1, ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context1, "target"), dropConsumer))))).then(net.minecraft.commands.CommandDispatcher.a("mine").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).executes(context1 -> CommandLoot.a((CommandContext<CommandListenerWrapper>)context1, ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "pos"), ItemStack.j, dropConsumer))).then(net.minecraft.commands.CommandDispatcher.a("tool", ArgumentItemStack.a(context)).executes(context1 -> CommandLoot.a((CommandContext<CommandListenerWrapper>)context1, ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "pos"), ArgumentItemStack.a(context1, "tool").a(1, false), dropConsumer)))).then(net.minecraft.commands.CommandDispatcher.a("mainhand").executes(context1 -> CommandLoot.a((CommandContext<CommandListenerWrapper>)context1, ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "pos"), CommandLoot.a((CommandListenerWrapper)context1.getSource(), EnumItemSlot.a), dropConsumer)))).then(net.minecraft.commands.CommandDispatcher.a("offhand").executes(commandContext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandContext, ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandContext, "pos"), CommandLoot.a((CommandListenerWrapper)commandContext.getSource(), EnumItemSlot.b), dropConsumer)))))));
    }

    private static <T extends ArgumentBuilder<CommandListenerWrapper, T>> T a(T builder, c tailProvider) {
        return ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)builder.then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("replace").then(net.minecraft.commands.CommandDispatcher.a("entity").then(net.minecraft.commands.CommandDispatcher.a("entities", ArgumentEntity.b()).then(tailProvider.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("slot", ArgumentInventorySlot.a()), (context, items, callback) -> CommandLoot.a(ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "entities"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "slot"), items.size(), items, callback)).then(tailProvider.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("count", IntegerArgumentType.integer((int)0)), (context, items, callback) -> CommandLoot.a(ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "entities"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "slot"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count"), items, callback))))))).then(net.minecraft.commands.CommandDispatcher.a("block").then(net.minecraft.commands.CommandDispatcher.a("targetPos", ArgumentPosition.a()).then(tailProvider.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("slot", ArgumentInventorySlot.a()), (context, items, callback) -> CommandLoot.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "targetPos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "slot"), items.size(), items, callback)).then(tailProvider.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("count", IntegerArgumentType.integer((int)0)), (context, items, callback) -> CommandLoot.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "targetPos"), IntegerArgumentType.getInteger((CommandContext)context, (String)"slot"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count"), items, callback)))))))).then(net.minecraft.commands.CommandDispatcher.a("insert").then(tailProvider.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("targetPos", ArgumentPosition.a()), (context, items, callback) -> CommandLoot.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "targetPos"), (List<ItemStack>)items, callback))))).then(net.minecraft.commands.CommandDispatcher.a("give").then(tailProvider.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("players", ArgumentEntity.d()), (context, items, callback) -> CommandLoot.a(ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "players"), (List<ItemStack>)items, callback))))).then(net.minecraft.commands.CommandDispatcher.a("spawn").then(tailProvider.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("targetPos", ArgumentVec3.a()), (context, items, callback) -> CommandLoot.a((CommandListenerWrapper)context.getSource(), ArgumentVec3.a((CommandContext<CommandListenerWrapper>)context, "targetPos"), (List<ItemStack>)items, callback))));
    }

    private static IInventory a(CommandListenerWrapper source, BlockPosition pos) throws CommandSyntaxException {
        TileEntity blockEntity = source.e().c_(pos);
        if (!(blockEntity instanceof IInventory)) {
            throw ItemCommands.a.create((Object)pos.u(), (Object)pos.v(), (Object)pos.w());
        }
        return (IInventory)((Object)blockEntity);
    }

    private static int a(CommandListenerWrapper source, BlockPosition pos, List<ItemStack> items, a callback) throws CommandSyntaxException {
        IInventory container = CommandLoot.a(source, pos);
        ArrayList list = Lists.newArrayListWithCapacity((int)items.size());
        for (ItemStack itemStack : items) {
            if (!CommandLoot.a(container, itemStack.v())) continue;
            container.e();
            list.add(itemStack);
        }
        callback.accept(list);
        return list.size();
    }

    private static boolean a(IInventory container, ItemStack item) {
        boolean flag = false;
        for (int i2 = 0; i2 < container.b() && !item.f(); ++i2) {
            ItemStack item1 = container.a(i2);
            if (!container.b(i2, item)) continue;
            if (item1.f()) {
                container.a(i2, item);
                flag = true;
                break;
            }
            if (!CommandLoot.a(item1, item)) continue;
            int i1 = item.k() - item1.M();
            int min = Math.min(item.M(), i1);
            item.h(min);
            item1.g(min);
            flag = true;
        }
        return flag;
    }

    private static int a(CommandListenerWrapper source, BlockPosition pos, int slot, int numSlots, List<ItemStack> items, a callback) throws CommandSyntaxException {
        IInventory container = CommandLoot.a(source, pos);
        int containerSize = container.b();
        if (slot >= 0 && slot < containerSize) {
            ArrayList list = Lists.newArrayListWithCapacity((int)items.size());
            for (int i2 = 0; i2 < numSlots; ++i2) {
                ItemStack itemStack;
                int i1 = slot + i2;
                ItemStack itemStack2 = itemStack = i2 < items.size() ? items.get(i2) : ItemStack.j;
                if (!container.b(i1, itemStack)) continue;
                container.a(i1, itemStack);
                list.add(itemStack);
            }
            callback.accept(list);
            return list.size();
        }
        throw ItemCommands.c.create((Object)slot);
    }

    private static boolean a(ItemStack first, ItemStack second) {
        return first.M() <= first.k() && ItemStack.c(first, second);
    }

    private static int a(Collection<EntityPlayer> targets, List<ItemStack> items, a callback) throws CommandSyntaxException {
        ArrayList list = Lists.newArrayListWithCapacity((int)items.size());
        for (ItemStack itemStack : items) {
            for (EntityPlayer serverPlayer : targets) {
                if (!serverPlayer.gi().f(itemStack.v())) continue;
                list.add(itemStack);
            }
        }
        callback.accept(list);
        return list.size();
    }

    private static void a(Entity target, List<ItemStack> items, int startSlot, int numSlots, List<ItemStack> setItems) {
        for (int i2 = 0; i2 < numSlots; ++i2) {
            ItemStack itemStack = i2 < items.size() ? items.get(i2) : ItemStack.j;
            SlotAccess slot = target.a_(startSlot + i2);
            if (slot == SlotAccess.a || !slot.a(itemStack.v())) continue;
            setItems.add(itemStack);
        }
    }

    private static int a(Collection<? extends Entity> targets, int startSlot, int numSlots, List<ItemStack> items, a callback) throws CommandSyntaxException {
        ArrayList list = Lists.newArrayListWithCapacity((int)items.size());
        for (Entity entity : targets) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)entity;
                CommandLoot.a(entity, items, startSlot, numSlots, list);
                serverPlayer.cd.d();
                continue;
            }
            CommandLoot.a(entity, items, startSlot, numSlots, list);
        }
        callback.accept(list);
        return list.size();
    }

    private static int a(CommandListenerWrapper source, Vec3D pos, List<ItemStack> items, a callback) throws CommandSyntaxException {
        WorldServer level = source.e();
        items.forEach(itemStack -> {
            EntityItem itemEntity = new EntityItem(level, pos.d, pos.e, pos.f, itemStack.v());
            itemEntity.s();
            level.b(itemEntity);
        });
        callback.accept(items);
        return items.size();
    }

    private static void a(CommandListenerWrapper source, List<ItemStack> items) {
        if (items.size() == 1) {
            ItemStack itemStack = items.get(0);
            source.a(() -> IChatBaseComponent.a("commands.drop.success.single", itemStack.M(), itemStack.K()), false);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.drop.success.multiple", items.size()), false);
        }
    }

    private static void a(CommandListenerWrapper source, List<ItemStack> items, ResourceKey<LootTable> lootTable) {
        if (items.size() == 1) {
            ItemStack itemStack = items.get(0);
            source.a(() -> IChatBaseComponent.a("commands.drop.success.single_with_table", itemStack.M(), itemStack.K(), IChatBaseComponent.a(lootTable.a())), false);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.drop.success.multiple_with_table", items.size(), IChatBaseComponent.a(lootTable.a())), false);
        }
    }

    private static ItemStack a(CommandListenerWrapper source, EnumItemSlot slot) throws CommandSyntaxException {
        Entity entityOrException = source.g();
        if (entityOrException instanceof EntityLiving) {
            return ((EntityLiving)entityOrException).a(slot);
        }
        throw b.create((Object)entityOrException.p_());
    }

    private static int a(CommandContext<CommandListenerWrapper> context, BlockPosition pos, ItemStack tool, b dropConsumer) throws CommandSyntaxException {
        CommandListenerWrapper commandSourceStack = (CommandListenerWrapper)context.getSource();
        WorldServer level = commandSourceStack.e();
        IBlockData blockState = level.a_(pos);
        TileEntity blockEntity = level.c_(pos);
        Optional<ResourceKey<LootTable>> lootTable = blockState.b().u();
        if (lootTable.isEmpty()) {
            throw d.create((Object)blockState.b().f());
        }
        LootParams.a builder = new LootParams.a(level).a(LootContextParameters.f, Vec3D.b(pos)).a(LootContextParameters.g, blockState).b(LootContextParameters.h, blockEntity).b(LootContextParameters.a, commandSourceStack.f()).a(LootContextParameters.i, tool);
        List<ItemStack> drops = blockState.a(builder);
        return dropConsumer.accept(context, drops, items -> CommandLoot.a(commandSourceStack, (List<ItemStack>)items, (ResourceKey)lootTable.get()));
    }

    private static int a(CommandContext<CommandListenerWrapper> context, Entity entity, b dropConsumer) throws CommandSyntaxException {
        Optional<ResourceKey<LootTable>> lootTable = entity.ea();
        if (lootTable.isEmpty()) {
            throw c.create((Object)entity.p_());
        }
        CommandListenerWrapper commandSourceStack = (CommandListenerWrapper)context.getSource();
        LootParams.a builder = new LootParams.a(commandSourceStack.e());
        Entity entity1 = commandSourceStack.f();
        if (entity1 instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity1;
            builder.a(LootContextParameters.b, player);
        }
        builder.a(LootContextParameters.c, entity.dW().q());
        builder.b(LootContextParameters.e, entity1);
        builder.b(LootContextParameters.d, entity1);
        builder.a(LootContextParameters.a, entity);
        builder.a(LootContextParameters.f, commandSourceStack.d());
        LootParams lootParams = builder.a(LootContextParameterSets.g);
        LootTable lootTable1 = commandSourceStack.l().bc().b(lootTable.get());
        ObjectArrayList<ItemStack> randomItems = lootTable1.a(lootParams);
        return dropConsumer.accept(context, (List<ItemStack>)randomItems, items -> CommandLoot.a(commandSourceStack, (List<ItemStack>)items, (ResourceKey)lootTable.get()));
    }

    private static int a(CommandContext<CommandListenerWrapper> context, Holder<LootTable> lootTable, b dropCOnsimer) throws CommandSyntaxException {
        CommandListenerWrapper commandSourceStack = (CommandListenerWrapper)context.getSource();
        LootParams lootParams = new LootParams.a(commandSourceStack.e()).b(LootContextParameters.a, commandSourceStack.f()).a(LootContextParameters.f, commandSourceStack.d()).a(LootContextParameterSets.c);
        return CommandLoot.a(context, lootTable, lootParams, dropCOnsimer);
    }

    private static int a(CommandContext<CommandListenerWrapper> context, Holder<LootTable> lootTable, BlockPosition pos, ItemStack tool, b dropConsumet) throws CommandSyntaxException {
        CommandListenerWrapper commandSourceStack = (CommandListenerWrapper)context.getSource();
        LootParams lootParams = new LootParams.a(commandSourceStack.e()).a(LootContextParameters.f, Vec3D.b(pos)).a(LootContextParameters.i, tool).b(LootContextParameters.a, commandSourceStack.f()).a(LootContextParameterSets.f);
        return CommandLoot.a(context, lootTable, lootParams, dropConsumet);
    }

    private static int a(CommandContext<CommandListenerWrapper> context, Holder<LootTable> lootTable, LootParams params, b dropConsumer) throws CommandSyntaxException {
        CommandListenerWrapper commandSourceStack = (CommandListenerWrapper)context.getSource();
        ObjectArrayList<ItemStack> randomItems = lootTable.a().a(params);
        return dropConsumer.accept(context, (List<ItemStack>)randomItems, items -> CommandLoot.a(commandSourceStack, items));
    }

    @FunctionalInterface
    static interface c {
        public ArgumentBuilder<CommandListenerWrapper, ?> construct(ArgumentBuilder<CommandListenerWrapper, ?> var1, b var2);
    }

    @FunctionalInterface
    static interface b {
        public int accept(CommandContext<CommandListenerWrapper> var1, List<ItemStack> var2, a var3) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface a {
        public void accept(List<ItemStack> var1) throws CommandSyntaxException;
    }
}

