/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.blocks.ArgumentTileLocation;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.commands.CommandSetBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.Clearable;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;

public class CommandFill {
    private static final Dynamic2CommandExceptionType a = new Dynamic2CommandExceptionType((maxBlocks, specifiedBlocks) -> IChatBaseComponent.b("commands.fill.toobig", maxBlocks, specifiedBlocks));
    static final ArgumentTileLocation b = new ArgumentTileLocation(Blocks.a.m(), Collections.emptySet(), null);
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.fill.failed"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("fill").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("from", ArgumentPosition.a()).then(net.minecraft.commands.CommandDispatcher.a("to", ArgumentPosition.a()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("block", ArgumentTile.a(context)).executes(context1 -> CommandFill.a((CommandListenerWrapper)context1.getSource(), StructureBoundingBox.a(ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "from"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "to")), ArgumentTile.a((CommandContext<CommandListenerWrapper>)context1, "block"), Mode.a, null))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("replace").executes(context1 -> CommandFill.a((CommandListenerWrapper)context1.getSource(), StructureBoundingBox.a(ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "from"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "to")), ArgumentTile.a((CommandContext<CommandListenerWrapper>)context1, "block"), Mode.a, null))).then(net.minecraft.commands.CommandDispatcher.a("filter", ArgumentBlockPredicate.a(context)).executes(context1 -> CommandFill.a((CommandListenerWrapper)context1.getSource(), StructureBoundingBox.a(ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "from"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "to")), ArgumentTile.a((CommandContext<CommandListenerWrapper>)context1, "block"), Mode.a, ArgumentBlockPredicate.a((CommandContext<CommandListenerWrapper>)context1, "filter")))))).then(net.minecraft.commands.CommandDispatcher.a("keep").executes(context1 -> CommandFill.a((CommandListenerWrapper)context1.getSource(), StructureBoundingBox.a(ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "from"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "to")), ArgumentTile.a((CommandContext<CommandListenerWrapper>)context1, "block"), Mode.a, blockInWorld -> blockInWorld.c().u(blockInWorld.d()))))).then(net.minecraft.commands.CommandDispatcher.a("outline").executes(context1 -> CommandFill.a((CommandListenerWrapper)context1.getSource(), StructureBoundingBox.a(ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "from"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "to")), ArgumentTile.a((CommandContext<CommandListenerWrapper>)context1, "block"), Mode.b, null)))).then(net.minecraft.commands.CommandDispatcher.a("hollow").executes(context1 -> CommandFill.a((CommandListenerWrapper)context1.getSource(), StructureBoundingBox.a(ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "from"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "to")), ArgumentTile.a((CommandContext<CommandListenerWrapper>)context1, "block"), Mode.c, null)))).then(net.minecraft.commands.CommandDispatcher.a("destroy").executes(context1 -> CommandFill.a((CommandListenerWrapper)context1.getSource(), StructureBoundingBox.a(ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "from"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "to")), ArgumentTile.a((CommandContext<CommandListenerWrapper>)context1, "block"), Mode.d, null))))))));
    }

    private static int a(CommandListenerWrapper source, StructureBoundingBox area, ArgumentTileLocation newBlock, Mode mode, @Nullable Predicate<ShapeDetectorBlock> replacingPredicate) throws CommandSyntaxException {
        int _int;
        int i2 = area.d() * area.e() * area.f();
        if (i2 > (_int = source.e().O().c(GameRules.A))) {
            throw a.create((Object)_int, (Object)i2);
        }
        ArrayList list = Lists.newArrayList();
        WorldServer level = source.e();
        int i1 = 0;
        for (BlockPosition blockPos : BlockPosition.b(area.h(), area.i(), area.j(), area.k(), area.l(), area.m())) {
            ArgumentTileLocation blockInput;
            if (replacingPredicate != null && !replacingPredicate.test(new ShapeDetectorBlock(level, blockPos, true)) || (blockInput = mode.e.filter(area, blockPos, newBlock, level)) == null) continue;
            TileEntity blockEntity = level.c_(blockPos);
            Clearable.a(blockEntity);
            if (!blockInput.a(level, blockPos, 2)) continue;
            list.add(blockPos.j());
            ++i1;
        }
        for (BlockPosition blockPosx : list) {
            Block block = level.a_(blockPosx).b();
            level.b(blockPosx, block);
        }
        if (i1 == 0) {
            throw c.create();
        }
        int i22 = i1;
        source.a(() -> IChatBaseComponent.a("commands.fill.success", i22), true);
        return i1;
    }

    static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode a = new Mode((area, blockPos, newBlock, level) -> newBlock);
        public static final /* enum */ Mode b = new Mode((area, blockPos, newBlock, level) -> blockPos.u() != area.h() && blockPos.u() != area.k() && blockPos.v() != area.i() && blockPos.v() != area.l() && blockPos.w() != area.j() && blockPos.w() != area.m() ? null : newBlock);
        public static final /* enum */ Mode c = new Mode((area, blockPos, newBlock, level) -> blockPos.u() != area.h() && blockPos.u() != area.k() && blockPos.v() != area.i() && blockPos.v() != area.l() && blockPos.w() != area.j() && blockPos.w() != area.m() ? b : newBlock);
        public static final /* enum */ Mode d = new Mode((area, blockPos, newBlock, level) -> {
            level.b(blockPos, true);
            return newBlock;
        });
        public final CommandSetBlock.Filter e;
        private static final /* synthetic */ Mode[] f;

        public static Mode[] values() {
            return (Mode[])f.clone();
        }

        public static Mode valueOf(String name) {
            return Enum.valueOf(Mode.class, name);
        }

        private Mode(CommandSetBlock.Filter filter) {
            this.e = filter;
        }

        private static /* synthetic */ Mode[] a() {
            return new Mode[]{a, b, c, d};
        }

        static {
            f = Mode.a();
        }
    }
}

