/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.commands.arguments.ArgumentScoreboardObjective;
import net.minecraft.commands.arguments.ArgumentScoreholder;
import net.minecraft.commands.arguments.HeightmapTypeArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceOrIdArgument;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.SlotsArgument;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentRotationAxis;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentItemPredicate;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.execution.ChainModifiers;
import net.minecraft.commands.execution.CustomModifierExecutor;
import net.minecraft.commands.execution.ExecutionControl;
import net.minecraft.commands.execution.tasks.CallFunction;
import net.minecraft.commands.execution.tasks.FallthroughTask;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.bossevents.BossBattleCustom;
import net.minecraft.server.commands.CommandBossBar;
import net.minecraft.server.commands.CommandFunction;
import net.minecraft.server.commands.CommandSummon;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.commands.data.CommandData;
import net.minecraft.server.commands.data.CommandDataAccessor;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.inventory.SlotRange;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardObjective;

public class CommandExecute {
    private static final int b = 32768;
    private static final Dynamic2CommandExceptionType c = new Dynamic2CommandExceptionType((maxBlocks, specifiedBlocks) -> IChatBaseComponent.b("commands.execute.blocks.toobig", maxBlocks, specifiedBlocks));
    private static final SimpleCommandExceptionType d = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.execute.conditional.fail"));
    private static final DynamicCommandExceptionType e = new DynamicCommandExceptionType(count -> IChatBaseComponent.b("commands.execute.conditional.fail_count", count));
    @VisibleForTesting
    public static final Dynamic2CommandExceptionType a = new Dynamic2CommandExceptionType((object, object1) -> IChatBaseComponent.b("commands.execute.function.instantiationFailure", object, object1));
    private static final SuggestionProvider<CommandListenerWrapper> f = (context, suggestions) -> {
        ReloadableServerRegistries.a holder = ((CommandListenerWrapper)context.getSource()).l().bc();
        return ICompletionProvider.a(holder.a(Registries.bi), suggestions);
    };

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext context) {
        LiteralCommandNode<CommandListenerWrapper> literalCommandNode = dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("execute").requires(commandSourceStack -> commandSourceStack.c(2))));
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("execute").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("run").redirect(dispatcher.getRoot()))).then(CommandExecute.a(literalCommandNode, net.minecraft.commands.CommandDispatcher.a("if"), true, context))).then(CommandExecute.a(literalCommandNode, net.minecraft.commands.CommandDispatcher.a("unless"), false, context))).then(net.minecraft.commands.CommandDispatcher.a("as").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).fork(literalCommandNode, context1 -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context1, "targets")) {
                list.add(((CommandListenerWrapper)context1.getSource()).a(entity));
            }
            return list;
        })))).then(net.minecraft.commands.CommandDispatcher.a("at").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).fork(literalCommandNode, context1 -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context1, "targets")) {
                list.add(((CommandListenerWrapper)context1.getSource()).a((WorldServer)entity.dV()).a(entity.dt()).a(entity.bU()));
            }
            return list;
        })))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("store").then(CommandExecute.a(literalCommandNode, net.minecraft.commands.CommandDispatcher.a("result"), true))).then(CommandExecute.a(literalCommandNode, net.minecraft.commands.CommandDispatcher.a("success"), false)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("positioned").then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentVec3.a()).redirect(literalCommandNode, commandContext -> ((CommandListenerWrapper)commandContext.getSource()).a(ArgumentVec3.a((CommandContext<CommandListenerWrapper>)commandContext, "pos")).a(ArgumentAnchor.Anchor.a)))).then(net.minecraft.commands.CommandDispatcher.a("as").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).fork(literalCommandNode, context1 -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context1, "targets")) {
                list.add(((CommandListenerWrapper)context1.getSource()).a(entity.dt()));
            }
            return list;
        })))).then(net.minecraft.commands.CommandDispatcher.a("over").then(net.minecraft.commands.CommandDispatcher.a("heightmap", HeightmapTypeArgument.a()).redirect(literalCommandNode, context1 -> {
            Vec3D position = ((CommandListenerWrapper)context1.getSource()).d();
            WorldServer level = ((CommandListenerWrapper)context1.getSource()).e();
            double x2 = position.a();
            double z2 = position.c();
            if (!level.b(SectionPosition.b(x2), SectionPosition.b(z2))) {
                throw ArgumentPosition.a.create();
            }
            int height = level.a(HeightmapTypeArgument.a((CommandContext<CommandListenerWrapper>)context1, "heightmap"), MathHelper.a(x2), MathHelper.a(z2));
            return ((CommandListenerWrapper)context1.getSource()).a(new Vec3D(x2, height, z2));
        }))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("rotated").then(net.minecraft.commands.CommandDispatcher.a("rot", ArgumentRotation.a()).redirect(literalCommandNode, context1 -> ((CommandListenerWrapper)context1.getSource()).a(ArgumentRotation.a((CommandContext<CommandListenerWrapper>)context1, "rot").b((CommandListenerWrapper)context1.getSource()))))).then(net.minecraft.commands.CommandDispatcher.a("as").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).fork(literalCommandNode, context1 -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context1, "targets")) {
                list.add(((CommandListenerWrapper)context1.getSource()).a(entity.bU()));
            }
            return list;
        }))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("facing").then(net.minecraft.commands.CommandDispatcher.a("entity").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).then(net.minecraft.commands.CommandDispatcher.a("anchor", ArgumentAnchor.a()).fork(literalCommandNode, context1 -> {
            ArrayList list = Lists.newArrayList();
            ArgumentAnchor.Anchor anchor = ArgumentAnchor.a((CommandContext<CommandListenerWrapper>)context1, "anchor");
            for (Entity entity : ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context1, "targets")) {
                list.add(((CommandListenerWrapper)context1.getSource()).a(entity, anchor));
            }
            return list;
        }))))).then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentVec3.a()).redirect(literalCommandNode, context1 -> ((CommandListenerWrapper)context1.getSource()).b(ArgumentVec3.a((CommandContext<CommandListenerWrapper>)context1, "pos")))))).then(net.minecraft.commands.CommandDispatcher.a("align").then(net.minecraft.commands.CommandDispatcher.a("axes", ArgumentRotationAxis.a()).redirect(literalCommandNode, context1 -> ((CommandListenerWrapper)context1.getSource()).a(((CommandListenerWrapper)context1.getSource()).d().a(ArgumentRotationAxis.a((CommandContext<CommandListenerWrapper>)context1, "axes"))))))).then(net.minecraft.commands.CommandDispatcher.a("anchored").then(net.minecraft.commands.CommandDispatcher.a("anchor", ArgumentAnchor.a()).redirect(literalCommandNode, context1 -> ((CommandListenerWrapper)context1.getSource()).a(ArgumentAnchor.a((CommandContext<CommandListenerWrapper>)context1, "anchor")))))).then(net.minecraft.commands.CommandDispatcher.a("in").then(net.minecraft.commands.CommandDispatcher.a("dimension", ArgumentDimension.a()).redirect(literalCommandNode, context1 -> ((CommandListenerWrapper)context1.getSource()).a(ArgumentDimension.a((CommandContext<CommandListenerWrapper>)context1, "dimension")))))).then(net.minecraft.commands.CommandDispatcher.a("summon").then(net.minecraft.commands.CommandDispatcher.a("entity", ResourceArgument.a(context, Registries.z)).suggests(CompletionProviders.c).redirect(literalCommandNode, context1 -> CommandExecute.a((CommandListenerWrapper)context1.getSource(), ResourceArgument.e((CommandContext<CommandListenerWrapper>)context1, "entity")))))).then(CommandExecute.a(literalCommandNode, net.minecraft.commands.CommandDispatcher.a("on")))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(LiteralCommandNode<CommandListenerWrapper> parent, LiteralArgumentBuilder<CommandListenerWrapper> literal, boolean storingResult) {
        literal.then(net.minecraft.commands.CommandDispatcher.a("score").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentScoreholder.b()).suggests(ArgumentScoreholder.a).then(net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()).redirect(parent, commandContext -> CommandExecute.a((CommandListenerWrapper)commandContext.getSource(), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)commandContext, "targets"), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)commandContext, "objective"), storingResult)))));
        literal.then(net.minecraft.commands.CommandDispatcher.a("bossbar").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("id", ArgumentMinecraftKeyRegistered.a()).suggests(CommandBossBar.a).then(net.minecraft.commands.CommandDispatcher.a("value").redirect(parent, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), true, storingResult)))).then(net.minecraft.commands.CommandDispatcher.a("max").redirect(parent, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), false, storingResult)))));
        for (CommandData.c dataProvider : CommandData.b) {
            dataProvider.a((ArgumentBuilder<CommandListenerWrapper, ?>)literal, argumentBuilder -> argumentBuilder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("path", ArgumentNBTKey.a()).then(net.minecraft.commands.CommandDispatcher.a("int").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)parent, commandContext -> CommandExecute.a((CommandListenerWrapper)commandContext.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)commandContext), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)commandContext, "path"), (int i2) -> NBTTagInt.a((int)((double)i2 * DoubleArgumentType.getDouble((CommandContext)commandContext, (String)"scale"))), storingResult))))).then(net.minecraft.commands.CommandDispatcher.a("float").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)parent, commandContext -> CommandExecute.a((CommandListenerWrapper)commandContext.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)commandContext), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)commandContext, "path"), (int i2) -> NBTTagFloat.a((float)((double)i2 * DoubleArgumentType.getDouble((CommandContext)commandContext, (String)"scale"))), storingResult))))).then(net.minecraft.commands.CommandDispatcher.a("short").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)parent, commandContext -> CommandExecute.a((CommandListenerWrapper)commandContext.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)commandContext), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)commandContext, "path"), (int i2) -> NBTTagShort.a((short)((double)i2 * DoubleArgumentType.getDouble((CommandContext)commandContext, (String)"scale"))), storingResult))))).then(net.minecraft.commands.CommandDispatcher.a("long").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)parent, commandContext -> CommandExecute.a((CommandListenerWrapper)commandContext.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)commandContext), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)commandContext, "path"), (int i2) -> NBTTagLong.a((long)((double)i2 * DoubleArgumentType.getDouble((CommandContext)commandContext, (String)"scale"))), storingResult))))).then(net.minecraft.commands.CommandDispatcher.a("double").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)parent, commandContext -> CommandExecute.a((CommandListenerWrapper)commandContext.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)commandContext), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)commandContext, "path"), (int i2) -> NBTTagDouble.a((double)i2 * DoubleArgumentType.getDouble((CommandContext)commandContext, (String)"scale")), storingResult))))).then(net.minecraft.commands.CommandDispatcher.a("byte").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)parent, commandContext -> CommandExecute.a((CommandListenerWrapper)commandContext.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)commandContext), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)commandContext, "path"), (int i2) -> NBTTagByte.a((byte)((double)i2 * DoubleArgumentType.getDouble((CommandContext)commandContext, (String)"scale"))), storingResult))))));
        }
        return literal;
    }

    private static CommandListenerWrapper a(CommandListenerWrapper source, Collection<ScoreHolder> targets, ScoreboardObjective objective, boolean storingResult) {
        ScoreboardServer scoreboard = source.l().aJ();
        return source.a((success, result) -> {
            for (ScoreHolder scoreHolder : targets) {
                ScoreAccess playerScore = scoreboard.c(scoreHolder, objective);
                int i2 = storingResult ? result : (success ? 1 : 0);
                playerScore.a(i2);
            }
        }, CommandResultCallback::chain);
    }

    private static CommandListenerWrapper a(CommandListenerWrapper source, BossBattleCustom bar, boolean storingValue, boolean storingResult) {
        return source.a((success, result) -> {
            int i2;
            int n2 = storingResult ? result : (i2 = success ? 1 : 0);
            if (storingValue) {
                bar.a(i2);
            } else {
                bar.b(i2);
            }
        }, CommandResultCallback::chain);
    }

    private static CommandListenerWrapper a(CommandListenerWrapper source, CommandDataAccessor accessor, ArgumentNBTKey.g path, IntFunction<NBTBase> tagConverter, boolean storingResult) {
        return source.a((success, result) -> {
            try {
                NBTTagCompound data = accessor.a();
                int i2 = storingResult ? result : (success ? 1 : 0);
                path.a((NBTBase)data, (NBTBase)tagConverter.apply(i2));
                accessor.a(data);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }, CommandResultCallback::chain);
    }

    private static boolean a(WorldServer level, BlockPosition pos) {
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(pos);
        Chunk chunkNow = level.m().a(chunkPos.h, chunkPos.i);
        return chunkNow != null && chunkNow.F() == FullChunkStatus.d && level.c(chunkPos.a());
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandNode<CommandListenerWrapper> parent, LiteralArgumentBuilder<CommandListenerWrapper> literal, boolean isIf, CommandBuildContext context) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)literal.then(net.minecraft.commands.CommandDispatcher.a("block").then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.a("block", ArgumentBlockPredicate.a(context)), isIf, (CommandContext<CommandListenerWrapper> context1) -> ArgumentBlockPredicate.a((CommandContext<CommandListenerWrapper>)context1, "block").test(new ShapeDetectorBlock(((CommandListenerWrapper)context1.getSource()).e(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "pos"), true))))))).then(net.minecraft.commands.CommandDispatcher.a("biome").then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.a("biome", ResourceOrTagArgument.a(context, Registries.aI)), isIf, (CommandContext<CommandListenerWrapper> context1) -> ResourceOrTagArgument.a((CommandContext<CommandListenerWrapper>)context1, "biome", Registries.aI).test(((CommandListenerWrapper)context1.getSource()).e().t(ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "pos")))))))).then(net.minecraft.commands.CommandDispatcher.a("loaded").then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()), isIf, (CommandContext<CommandListenerWrapper> context1) -> CommandExecute.a(((CommandListenerWrapper)context1.getSource()).e(), ArgumentPosition.b((CommandContext<CommandListenerWrapper>)context1, "pos")))))).then(net.minecraft.commands.CommandDispatcher.a("dimension").then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.a("dimension", ArgumentDimension.a()), isIf, (CommandContext<CommandListenerWrapper> context1) -> ArgumentDimension.a((CommandContext<CommandListenerWrapper>)context1, "dimension") == ((CommandListenerWrapper)context1.getSource()).e())))).then(net.minecraft.commands.CommandDispatcher.a("score").then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targetObjective", ArgumentScoreboardObjective.a()).then(net.minecraft.commands.CommandDispatcher.a("=").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()), isIf, (CommandContext<CommandListenerWrapper> context1) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context1, (int value1, int value2) -> value1 == value2)))))).then(net.minecraft.commands.CommandDispatcher.a("<").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()), isIf, (CommandContext<CommandListenerWrapper> context1) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context1, (int value1, int value2) -> value1 < value2)))))).then(net.minecraft.commands.CommandDispatcher.a("<=").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()), isIf, (CommandContext<CommandListenerWrapper> context1) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context1, (int value1, int value2) -> value1 <= value2)))))).then(net.minecraft.commands.CommandDispatcher.a(">").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()), isIf, (CommandContext<CommandListenerWrapper> context1) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context1, (int value1, int value2) -> value1 > value2)))))).then(net.minecraft.commands.CommandDispatcher.a(">=").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()), isIf, (CommandContext<CommandListenerWrapper> context1) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context1, (int value1, int value2) -> value1 >= value2)))))).then(net.minecraft.commands.CommandDispatcher.a("matches").then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.a("range", ArgumentCriterionValue.a()), isIf, (CommandContext<CommandListenerWrapper> context1) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context1, ArgumentCriterionValue.b.a((CommandContext<CommandListenerWrapper>)context1, "range"))))))))).then(net.minecraft.commands.CommandDispatcher.a("blocks").then(net.minecraft.commands.CommandDispatcher.a("start", ArgumentPosition.a()).then(net.minecraft.commands.CommandDispatcher.a("end", ArgumentPosition.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("destination", ArgumentPosition.a()).then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.a("all"), isIf, false))).then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.a("masked"), isIf, true))))))).then(net.minecraft.commands.CommandDispatcher.a("entity").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("entities", ArgumentEntity.b()).fork(parent, context1 -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context1, isIf, !ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context1, "entities").isEmpty()))).executes(CommandExecute.a(isIf, (CommandContext<CommandListenerWrapper> context1) -> ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context1, "entities").size()))))).then(net.minecraft.commands.CommandDispatcher.a("predicate").then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.a("predicate", ResourceOrIdArgument.c(context)).suggests(f), isIf, (CommandContext<CommandListenerWrapper> context1) -> CommandExecute.a((CommandListenerWrapper)context1.getSource(), ResourceOrIdArgument.c((CommandContext<CommandListenerWrapper>)context1, "predicate")))))).then(net.minecraft.commands.CommandDispatcher.a("function").then(net.minecraft.commands.CommandDispatcher.a("name", ArgumentTag.a()).suggests(CommandFunction.b).fork(parent, (RedirectModifier)new d(isIf))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("items").then(net.minecraft.commands.CommandDispatcher.a("entity").then(net.minecraft.commands.CommandDispatcher.a("entities", ArgumentEntity.b()).then(net.minecraft.commands.CommandDispatcher.a("slots", SlotsArgument.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("item_predicate", ArgumentItemPredicate.a(context)).fork(parent, commandContext -> CommandExecute.a((CommandContext<CommandListenerWrapper>)commandContext, isIf, CommandExecute.a(ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandContext, "entities"), SlotsArgument.a((CommandContext<CommandListenerWrapper>)commandContext, "slots"), ArgumentItemPredicate.a((CommandContext<CommandListenerWrapper>)commandContext, "item_predicate")) > 0))).executes(CommandExecute.a(isIf, (CommandContext<CommandListenerWrapper> context1) -> CommandExecute.a(ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context1, "entities"), SlotsArgument.a((CommandContext<CommandListenerWrapper>)context1, "slots"), ArgumentItemPredicate.a((CommandContext<CommandListenerWrapper>)context1, "item_predicate"))))))))).then(net.minecraft.commands.CommandDispatcher.a("block").then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).then(net.minecraft.commands.CommandDispatcher.a("slots", SlotsArgument.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("item_predicate", ArgumentItemPredicate.a(context)).fork(parent, commandContext -> CommandExecute.a((CommandContext<CommandListenerWrapper>)commandContext, isIf, CommandExecute.a((CommandListenerWrapper)commandContext.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandContext, "pos"), SlotsArgument.a((CommandContext<CommandListenerWrapper>)commandContext, "slots"), ArgumentItemPredicate.a((CommandContext<CommandListenerWrapper>)commandContext, "item_predicate")) > 0))).executes(CommandExecute.a(isIf, (CommandContext<CommandListenerWrapper> context1) -> CommandExecute.a((CommandListenerWrapper)context1.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "pos"), SlotsArgument.a((CommandContext<CommandListenerWrapper>)context1, "slots"), ArgumentItemPredicate.a((CommandContext<CommandListenerWrapper>)context1, "item_predicate")))))))));
        for (CommandData.c dataProvider : CommandData.c) {
            literal.then(dataProvider.a((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("data"), argumentBuilder -> argumentBuilder.then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("path", ArgumentNBTKey.a()).fork(parent, commandContext -> CommandExecute.a((CommandContext<CommandListenerWrapper>)commandContext, isIf, CommandExecute.a(dataProvider.a((CommandContext<CommandListenerWrapper>)commandContext), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)commandContext, "path")) > 0))).executes(CommandExecute.a(isIf, (CommandContext<CommandListenerWrapper> context1) -> CommandExecute.a(dataProvider.a((CommandContext<CommandListenerWrapper>)context1), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context1, "path")))))));
        }
        return literal;
    }

    private static int a(Iterable<? extends Entity> targets, SlotRange slotRange, Predicate<ItemStack> filter) {
        int i2 = 0;
        for (Entity entity : targets) {
            IntList list = slotRange.a();
            for (int i1 = 0; i1 < list.size(); ++i1) {
                int _int = list.getInt(i1);
                SlotAccess slot = entity.a_(_int);
                ItemStack itemStack = slot.a();
                if (!filter.test(itemStack)) continue;
                i2 += itemStack.M();
            }
        }
        return i2;
    }

    private static int a(CommandListenerWrapper source, BlockPosition pos, SlotRange slotRange, Predicate<ItemStack> filter) throws CommandSyntaxException {
        int i2 = 0;
        IInventory container = ItemCommands.a(source, pos, ItemCommands.b);
        int containerSize = container.b();
        IntList list = slotRange.a();
        for (int i1 = 0; i1 < list.size(); ++i1) {
            ItemStack item;
            int _int = list.getInt(i1);
            if (_int < 0 || _int >= containerSize || !filter.test(item = container.a(_int))) continue;
            i2 += item.M();
        }
        return i2;
    }

    private static Command<CommandListenerWrapper> a(boolean isIf, b predicate) {
        return isIf ? commandContext -> {
            int i2 = predicate.test((CommandContext<CommandListenerWrapper>)commandContext);
            if (i2 > 0) {
                ((CommandListenerWrapper)commandContext.getSource()).a(() -> IChatBaseComponent.a("commands.execute.conditional.pass_count", i2), false);
                return i2;
            }
            throw d.create();
        } : commandContext -> {
            int i2 = predicate.test((CommandContext<CommandListenerWrapper>)commandContext);
            if (i2 == 0) {
                ((CommandListenerWrapper)commandContext.getSource()).a(() -> IChatBaseComponent.c("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw e.create((Object)i2);
        };
    }

    private static int a(CommandDataAccessor accessor, ArgumentNBTKey.g path) throws CommandSyntaxException {
        return path.b(accessor.a());
    }

    private static boolean a(CommandContext<CommandListenerWrapper> source, e predicate) throws CommandSyntaxException {
        ScoreHolder name = ArgumentScoreholder.a(source, "target");
        ScoreboardObjective objective = ArgumentScoreboardObjective.a(source, "targetObjective");
        ScoreHolder name1 = ArgumentScoreholder.a(source, "source");
        ScoreboardObjective objective1 = ArgumentScoreboardObjective.a(source, "sourceObjective");
        ScoreboardServer scoreboard = ((CommandListenerWrapper)source.getSource()).l().aJ();
        ReadOnlyScoreInfo playerScoreInfo = scoreboard.d(name, objective);
        ReadOnlyScoreInfo playerScoreInfo1 = scoreboard.d(name1, objective1);
        return playerScoreInfo != null && playerScoreInfo1 != null && predicate.test(playerScoreInfo.a(), playerScoreInfo1.a());
    }

    private static boolean a(CommandContext<CommandListenerWrapper> context, CriterionConditionValue.IntegerRange bounds) throws CommandSyntaxException {
        ScoreHolder name = ArgumentScoreholder.a(context, "target");
        ScoreboardObjective objective = ArgumentScoreboardObjective.a(context, "targetObjective");
        ScoreboardServer scoreboard = ((CommandListenerWrapper)context.getSource()).l().aJ();
        ReadOnlyScoreInfo playerScoreInfo = scoreboard.d(name, objective);
        return playerScoreInfo != null && bounds.d(playerScoreInfo.a());
    }

    private static boolean a(CommandListenerWrapper source, Holder<LootItemCondition> condition) {
        WorldServer level = source.e();
        LootParams lootParams = new LootParams.a(level).a(LootContextParameters.f, source.d()).b(LootContextParameters.a, source.f()).a(LootContextParameterSets.d);
        LootTableInfo lootContext = new LootTableInfo.Builder(lootParams).a(Optional.empty());
        lootContext.b(LootTableInfo.a(condition.a()));
        return condition.a().test(lootContext);
    }

    private static Collection<CommandListenerWrapper> a(CommandContext<CommandListenerWrapper> context, boolean actual, boolean expected) {
        return expected == actual ? Collections.singleton((CommandListenerWrapper)context.getSource()) : Collections.emptyList();
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandNode<CommandListenerWrapper> commandNode, ArgumentBuilder<CommandListenerWrapper, ?> builder, boolean value, c test) {
        return ((ArgumentBuilder)builder.fork(commandNode, (RedirectModifier<CommandListenerWrapper>)((RedirectModifier)commandContext -> CommandExecute.a((CommandContext<CommandListenerWrapper>)commandContext, value, test.test((CommandContext<CommandListenerWrapper>)commandContext))))).executes(commandContext -> {
            if (value == test.test((CommandContext<CommandListenerWrapper>)commandContext)) {
                ((CommandListenerWrapper)commandContext.getSource()).a(() -> IChatBaseComponent.c("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw d.create();
        });
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandNode<CommandListenerWrapper> commandNode, ArgumentBuilder<CommandListenerWrapper, ?> literal, boolean isIf, boolean isMasked) {
        return ((ArgumentBuilder)literal.fork(commandNode, (RedirectModifier<CommandListenerWrapper>)((RedirectModifier)commandContext -> CommandExecute.a((CommandContext<CommandListenerWrapper>)commandContext, isIf, CommandExecute.c((CommandContext<CommandListenerWrapper>)commandContext, isMasked).isPresent())))).executes(isIf ? commandContext -> CommandExecute.a((CommandContext<CommandListenerWrapper>)commandContext, isMasked) : commandContext -> CommandExecute.b((CommandContext<CommandListenerWrapper>)commandContext, isMasked));
    }

    private static int a(CommandContext<CommandListenerWrapper> context, boolean isMasked) throws CommandSyntaxException {
        OptionalInt optionalInt = CommandExecute.c(context, isMasked);
        if (optionalInt.isPresent()) {
            ((CommandListenerWrapper)context.getSource()).a(() -> IChatBaseComponent.a("commands.execute.conditional.pass_count", optionalInt.getAsInt()), false);
            return optionalInt.getAsInt();
        }
        throw d.create();
    }

    private static int b(CommandContext<CommandListenerWrapper> context, boolean isMasked) throws CommandSyntaxException {
        OptionalInt optionalInt = CommandExecute.c(context, isMasked);
        if (optionalInt.isPresent()) {
            throw e.create((Object)optionalInt.getAsInt());
        }
        ((CommandListenerWrapper)context.getSource()).a(() -> IChatBaseComponent.c("commands.execute.conditional.pass"), false);
        return 1;
    }

    private static OptionalInt c(CommandContext<CommandListenerWrapper> context, boolean isMasked) throws CommandSyntaxException {
        return CommandExecute.a(((CommandListenerWrapper)context.getSource()).e(), ArgumentPosition.a(context, "start"), ArgumentPosition.a(context, "end"), ArgumentPosition.a(context, "destination"), isMasked);
    }

    private static OptionalInt a(WorldServer level, BlockPosition begin, BlockPosition end, BlockPosition destination, boolean isMasked) throws CommandSyntaxException {
        StructureBoundingBox boundingBox = StructureBoundingBox.a(begin, end);
        StructureBoundingBox boundingBox1 = StructureBoundingBox.a(destination, destination.a(boundingBox.c()));
        BlockPosition blockPos = new BlockPosition(boundingBox1.h() - boundingBox.h(), boundingBox1.i() - boundingBox.i(), boundingBox1.j() - boundingBox.j());
        int i2 = boundingBox.d() * boundingBox.e() * boundingBox.f();
        if (i2 > 32768) {
            throw c.create((Object)32768, (Object)i2);
        }
        IRegistryCustom registryAccess = level.K_();
        int i1 = 0;
        for (int z2 = boundingBox.j(); z2 <= boundingBox.m(); ++z2) {
            for (int y2 = boundingBox.i(); y2 <= boundingBox.l(); ++y2) {
                for (int x2 = boundingBox.h(); x2 <= boundingBox.k(); ++x2) {
                    BlockPosition blockPos1 = new BlockPosition(x2, y2, z2);
                    BlockPosition blockPos2 = blockPos1.a(blockPos);
                    IBlockData blockState = level.a_(blockPos1);
                    if (isMasked && blockState.a(Blocks.a)) continue;
                    if (blockState != level.a_(blockPos2)) {
                        return OptionalInt.empty();
                    }
                    TileEntity blockEntity = level.c_(blockPos1);
                    TileEntity blockEntity1 = level.c_(blockPos2);
                    if (blockEntity != null) {
                        NBTTagCompound compoundTag1;
                        if (blockEntity1 == null) {
                            return OptionalInt.empty();
                        }
                        if (blockEntity1.p() != blockEntity.p()) {
                            return OptionalInt.empty();
                        }
                        if (!blockEntity.r().equals(blockEntity1.r())) {
                            return OptionalInt.empty();
                        }
                        NBTTagCompound compoundTag = blockEntity.e(registryAccess);
                        if (!compoundTag.equals(compoundTag1 = blockEntity1.e(registryAccess))) {
                            return OptionalInt.empty();
                        }
                    }
                    ++i1;
                }
            }
        }
        return OptionalInt.of(i1);
    }

    private static RedirectModifier<CommandListenerWrapper> a(Function<Entity, Optional<Entity>> relation) {
        return commandContext -> {
            CommandListenerWrapper commandSourceStack = (CommandListenerWrapper)commandContext.getSource();
            Entity entity = commandSourceStack.f();
            return entity == null ? List.of() : (Collection)((Optional)relation.apply(entity)).filter(entity1 -> !entity1.dQ()).map(entity1 -> List.of(commandSourceStack.a((Entity)entity1))).orElse(List.of());
        };
    }

    private static RedirectModifier<CommandListenerWrapper> b(Function<Entity, Stream<Entity>> relation) {
        return commandContext -> {
            CommandListenerWrapper commandSourceStack = (CommandListenerWrapper)commandContext.getSource();
            Entity entity = commandSourceStack.f();
            return entity == null ? List.of() : ((Stream)relation.apply(entity)).filter(entity1 -> !entity1.dQ()).map(commandSourceStack::a).toList();
        };
    }

    private static LiteralArgumentBuilder<CommandListenerWrapper> a(CommandNode<CommandListenerWrapper> node, LiteralArgumentBuilder<CommandListenerWrapper> argumentBuilder) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)argumentBuilder.then(net.minecraft.commands.CommandDispatcher.a("owner").fork(node, CommandExecute.a((Entity entity) -> {
            Optional<Object> optional;
            if (entity instanceof OwnableEntity) {
                OwnableEntity ownableEntity = (OwnableEntity)((Object)entity);
                optional = Optional.ofNullable(ownableEntity.ag_());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.a("leasher").fork(node, CommandExecute.a((Entity entity) -> {
            Optional<Object> optional;
            if (entity instanceof Leashable) {
                Leashable leashable = (Leashable)((Object)entity);
                optional = Optional.ofNullable(leashable.D());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.a("target").fork(node, CommandExecute.a((Entity entity) -> {
            Optional<Object> optional;
            if (entity instanceof Targeting) {
                Targeting targeting = (Targeting)((Object)entity);
                optional = Optional.ofNullable(targeting.O_());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.a("attacker").fork(node, CommandExecute.a((Entity entity) -> {
            Optional<Object> optional;
            if (entity instanceof Attackable) {
                Attackable attackable = (Attackable)((Object)entity);
                optional = Optional.ofNullable(attackable.am());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.a("vehicle").fork(node, CommandExecute.a((Entity entity) -> Optional.ofNullable(entity.dk()))))).then(net.minecraft.commands.CommandDispatcher.a("controller").fork(node, CommandExecute.a((Entity entity) -> Optional.ofNullable(entity.cW()))))).then(net.minecraft.commands.CommandDispatcher.a("origin").fork(node, CommandExecute.a((Entity entity) -> {
            Optional<Object> optional;
            if (entity instanceof TraceableEntity) {
                TraceableEntity traceableEntity = (TraceableEntity)((Object)entity);
                optional = Optional.ofNullable(traceableEntity.p());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.a("passengers").fork(node, CommandExecute.b((Entity entity) -> entity.cY().stream())));
    }

    private static CommandListenerWrapper a(CommandListenerWrapper source, Holder.c<EntityTypes<?>> entityType) throws CommandSyntaxException {
        Entity entity = CommandSummon.a(source, entityType, source.d(), new NBTTagCompound(), true);
        return source.a(entity);
    }

    /*
     * Exception decompiling
     */
    public static <T extends ExecutionCommandSource<T>> void a(T originalSource, List<T> sources, Function<T, T> sourceModifier, IntPredicate successCheck, ContextChain<T> contextChain, @Nullable NBTTagCompound arguments, ExecutionControl<T> executionControl, a<T, Collection<net.minecraft.commands.functions.CommandFunction<T>>> functions, ChainModifiers chainModifiers) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ void a(List list1, ExecutionCommandSource executionCommandSource1, ExecutionControl executionControl1) {
        for (InstantiatedFunction instantiatedFunction : list1) {
            executionControl1.a(new CallFunction<ExecutionCommandSource>(instantiatedFunction, executionControl1.b().d(), true).bind(executionCommandSource1));
        }
        executionControl1.a(FallthroughTask.a());
    }

    private static /* synthetic */ void a(IntPredicate successCheck, List list, ExecutionCommandSource executionCommandSource, boolean success, int result) {
        if (successCheck.test(result)) {
            list.add(executionCommandSource);
        }
    }

    @FunctionalInterface
    static interface c {
        public boolean test(CommandContext<CommandListenerWrapper> var1) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface b {
        public int test(CommandContext<CommandListenerWrapper> var1) throws CommandSyntaxException;
    }

    static class d
    implements CustomModifierExecutor.a<CommandListenerWrapper> {
        private final IntPredicate a;

        d(boolean invert) {
            this.a = invert ? i2 -> i2 != 0 : i2 -> i2 == 0;
        }

        @Override
        public void a(CommandListenerWrapper originalSource, List<CommandListenerWrapper> soruces, ContextChain<CommandListenerWrapper> contextChain, ChainModifiers chainModifiers, ExecutionControl<CommandListenerWrapper> executionControl) {
            CommandExecute.a(originalSource, soruces, CommandFunction::a, this.a, contextChain, null, executionControl, context -> ArgumentTag.a((CommandContext<CommandListenerWrapper>)context, "name"), chainModifiers);
        }
    }

    @FunctionalInterface
    static interface e {
        public boolean test(int var1, int var2);
    }

    @FunctionalInterface
    public static interface a<T, R> {
        public R get(CommandContext<T> var1) throws CommandSyntaxException;
    }
}

