/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;

public class CommandEnchant {
    private static final DynamicCommandExceptionType a = new DynamicCommandExceptionType(entity -> IChatBaseComponent.b("commands.enchant.failed.entity", entity));
    private static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(entity -> IChatBaseComponent.b("commands.enchant.failed.itemless", entity));
    private static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(item -> IChatBaseComponent.b("commands.enchant.failed.incompatible", item));
    private static final Dynamic2CommandExceptionType d = new Dynamic2CommandExceptionType((requestedLevel, maxLevel) -> IChatBaseComponent.b("commands.enchant.failed.level", requestedLevel, maxLevel));
    private static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.enchant.failed"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("enchant").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("enchantment", ResourceArgument.a(context, Registries.aO)).executes(context1 -> CommandEnchant.a((CommandListenerWrapper)context1.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context1, "targets"), ResourceArgument.g((CommandContext<CommandListenerWrapper>)context1, "enchantment"), 1))).then(net.minecraft.commands.CommandDispatcher.a("level", IntegerArgumentType.integer((int)0)).executes(context1 -> CommandEnchant.a((CommandListenerWrapper)context1.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context1, "targets"), ResourceArgument.g((CommandContext<CommandListenerWrapper>)context1, "enchantment"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"level"))))))));
    }

    private static int a(CommandListenerWrapper source, Collection<? extends Entity> targets, Holder<Enchantment> enchantment, int level) throws CommandSyntaxException {
        Enchantment enchantment1 = enchantment.a();
        if (level > enchantment1.e()) {
            throw d.create((Object)level, (Object)enchantment1.e());
        }
        int i2 = 0;
        for (Entity entity : targets) {
            if (entity instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)entity;
                ItemStack mainHandItem = livingEntity.eZ();
                if (!mainHandItem.f()) {
                    if (enchantment1.c(mainHandItem) && EnchantmentManager.a(EnchantmentManager.b(mainHandItem).a(), enchantment)) {
                        mainHandItem.a(enchantment, level);
                        ++i2;
                        continue;
                    }
                    if (targets.size() != 1) continue;
                    throw c.create((Object)mainHandItem.y().getString());
                }
                if (targets.size() != 1) continue;
                throw b.create((Object)livingEntity.al().getString());
            }
            if (targets.size() != 1) continue;
            throw a.create((Object)entity.al().getString());
        }
        if (i2 == 0) {
            throw e.create();
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.enchant.success.single", Enchantment.a(enchantment, level), ((Entity)targets.iterator().next()).p_()), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.enchant.success.multiple", Enchantment.a(enchantment, level), targets.size()), true);
        }
        return i2;
    }
}

