/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.Clearable;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;

public class CommandClone {
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.clone.overlap"));
    private static final Dynamic2CommandExceptionType c = new Dynamic2CommandExceptionType((maxBlocks, specifiedBlocks) -> IChatBaseComponent.b("commands.clone.toobig", maxBlocks, specifiedBlocks));
    private static final SimpleCommandExceptionType d = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.clone.failed"));
    public static final Predicate<ShapeDetectorBlock> a = blockInWorld -> !blockInWorld.a().l();

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("clone").requires(source -> source.c(2))).then(CommandClone.a(context, (CommandContext<CommandListenerWrapper> context1) -> ((CommandListenerWrapper)context1.getSource()).e()))).then(net.minecraft.commands.CommandDispatcher.a("from").then(net.minecraft.commands.CommandDispatcher.a("sourceDimension", ArgumentDimension.a()).then(CommandClone.a(context, (CommandContext<CommandListenerWrapper> context1) -> ArgumentDimension.a((CommandContext<CommandListenerWrapper>)context1, "sourceDimension")))))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandBuildContext buildContext, c<CommandContext<CommandListenerWrapper>, WorldServer> levelGetter) {
        return net.minecraft.commands.CommandDispatcher.a("begin", ArgumentPosition.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("end", ArgumentPosition.a()).then(CommandClone.a(buildContext, levelGetter, (CommandContext<CommandListenerWrapper> context) -> ((CommandListenerWrapper)context.getSource()).e()))).then(net.minecraft.commands.CommandDispatcher.a("to").then(net.minecraft.commands.CommandDispatcher.a("targetDimension", ArgumentDimension.a()).then(CommandClone.a(buildContext, levelGetter, (CommandContext<CommandListenerWrapper> context) -> ArgumentDimension.a((CommandContext<CommandListenerWrapper>)context, "targetDimension"))))));
    }

    private static d a(CommandContext<CommandListenerWrapper> context, WorldServer level, String name) throws CommandSyntaxException {
        BlockPosition loadedBlockPos = ArgumentPosition.a(context, level, name);
        return new d(level, loadedBlockPos);
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandBuildContext buildContext, c<CommandContext<CommandListenerWrapper>, WorldServer> sourceLevelGetter, c<CommandContext<CommandListenerWrapper>, WorldServer> destinationLevelGetter) {
        c<CommandContext<CommandListenerWrapper>, d> commandFunction = context -> CommandClone.a((CommandContext<CommandListenerWrapper>)context, (WorldServer)sourceLevelGetter.apply((CommandContext<CommandListenerWrapper>)context), "begin");
        c<CommandContext<CommandListenerWrapper>, d> commandFunction1 = context -> CommandClone.a((CommandContext<CommandListenerWrapper>)context, (WorldServer)sourceLevelGetter.apply((CommandContext<CommandListenerWrapper>)context), "end");
        c<CommandContext<CommandListenerWrapper>, d> commandFunction2 = context -> CommandClone.a((CommandContext<CommandListenerWrapper>)context, (WorldServer)destinationLevelGetter.apply((CommandContext<CommandListenerWrapper>)context), "destination");
        return ((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("destination", ArgumentPosition.a()).executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), (d)commandFunction.apply(context), (d)commandFunction1.apply(context), (d)commandFunction2.apply(context), blockInWorld -> true, Mode.c))).then(CommandClone.a(commandFunction, commandFunction1, commandFunction2, (CommandContext<CommandListenerWrapper> context) -> blockInWorld -> true, net.minecraft.commands.CommandDispatcher.a("replace").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), (d)commandFunction.apply(context), (d)commandFunction1.apply(context), (d)commandFunction2.apply(context), blockInWorld -> true, Mode.c))))).then(CommandClone.a(commandFunction, commandFunction1, commandFunction2, (CommandContext<CommandListenerWrapper> context) -> a, net.minecraft.commands.CommandDispatcher.a("masked").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), (d)commandFunction.apply(context), (d)commandFunction1.apply(context), (d)commandFunction2.apply(context), a, Mode.c))))).then(net.minecraft.commands.CommandDispatcher.a("filtered").then(CommandClone.a(commandFunction, commandFunction1, commandFunction2, (CommandContext<CommandListenerWrapper> context) -> ArgumentBlockPredicate.a((CommandContext<CommandListenerWrapper>)context, "filter"), net.minecraft.commands.CommandDispatcher.a("filter", ArgumentBlockPredicate.a(buildContext)).executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), (d)commandFunction.apply(context), (d)commandFunction1.apply(context), (d)commandFunction2.apply(context), ArgumentBlockPredicate.a((CommandContext<CommandListenerWrapper>)context, "filter"), Mode.c)))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(c<CommandContext<CommandListenerWrapper>, d> beginGetter, c<CommandContext<CommandListenerWrapper>, d> endGetter, c<CommandContext<CommandListenerWrapper>, d> targetGetter, c<CommandContext<CommandListenerWrapper>, Predicate<ShapeDetectorBlock>> filterGetter, ArgumentBuilder<CommandListenerWrapper, ?> argumentBuilder) {
        return ((ArgumentBuilder)((ArgumentBuilder)argumentBuilder.then(net.minecraft.commands.CommandDispatcher.a("force").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), (d)beginGetter.apply(context), (d)endGetter.apply(context), (d)targetGetter.apply(context), (Predicate)filterGetter.apply(context), Mode.a)))).then(net.minecraft.commands.CommandDispatcher.a("move").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), (d)beginGetter.apply(context), (d)endGetter.apply(context), (d)targetGetter.apply(context), (Predicate)filterGetter.apply(context), Mode.b)))).then(net.minecraft.commands.CommandDispatcher.a("normal").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), (d)beginGetter.apply(context), (d)endGetter.apply(context), (d)targetGetter.apply(context), (Predicate)filterGetter.apply(context), Mode.c)));
    }

    private static int a(CommandListenerWrapper source, d begin, d end, d target, Predicate<ShapeDetectorBlock> filter, Mode mode) throws CommandSyntaxException {
        int _int;
        BlockPosition blockPos = begin.b();
        BlockPosition blockPos1 = end.b();
        StructureBoundingBox boundingBox = StructureBoundingBox.a(blockPos, blockPos1);
        BlockPosition blockPos2 = target.b();
        BlockPosition blockPos3 = blockPos2.a(boundingBox.c());
        StructureBoundingBox boundingBox1 = StructureBoundingBox.a(blockPos2, blockPos3);
        WorldServer serverLevel = begin.a();
        WorldServer serverLevel1 = target.a();
        if (!mode.a() && serverLevel == serverLevel1 && boundingBox1.a(boundingBox)) {
            throw b.create();
        }
        int i2 = boundingBox.d() * boundingBox.e() * boundingBox.f();
        if (i2 > (_int = source.e().O().c(GameRules.A))) {
            throw c.create((Object)_int, (Object)i2);
        }
        if (serverLevel.a(blockPos, blockPos1) && serverLevel1.a(blockPos2, blockPos3)) {
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            LinkedList list3 = Lists.newLinkedList();
            BlockPosition blockPos4 = new BlockPosition(boundingBox1.h() - boundingBox.h(), boundingBox1.i() - boundingBox.i(), boundingBox1.j() - boundingBox.j());
            for (int z2 = boundingBox.j(); z2 <= boundingBox.m(); ++z2) {
                for (int y2 = boundingBox.i(); y2 <= boundingBox.l(); ++y2) {
                    for (int x2 = boundingBox.h(); x2 <= boundingBox.k(); ++x2) {
                        BlockPosition blockPos5 = new BlockPosition(x2, y2, z2);
                        BlockPosition blockPos6 = blockPos5.a(blockPos4);
                        ShapeDetectorBlock blockInWorld = new ShapeDetectorBlock(serverLevel, blockPos5, false);
                        IBlockData state = blockInWorld.a();
                        if (!filter.test(blockInWorld)) continue;
                        TileEntity blockEntity = serverLevel.c_(blockPos5);
                        if (blockEntity != null) {
                            a cloneBlockEntityInfo = new a(blockEntity.e(source.u()), blockEntity.r());
                            list1.add(new CommandCloneStoredTileEntity(blockPos6, state, cloneBlockEntityInfo));
                            list3.addLast(blockPos5);
                            continue;
                        }
                        if (!state.s() && !state.m(serverLevel, blockPos5)) {
                            list2.add(new CommandCloneStoredTileEntity(blockPos6, state, null));
                            list3.addFirst(blockPos5);
                            continue;
                        }
                        list.add(new CommandCloneStoredTileEntity(blockPos6, state, null));
                        list3.addLast(blockPos5);
                    }
                }
            }
            if (mode == Mode.b) {
                for (BlockPosition blockPos7 : list3) {
                    TileEntity blockEntity1 = serverLevel.c_(blockPos7);
                    Clearable.a(blockEntity1);
                    serverLevel.a(blockPos7, Blocks.iu.m(), 2);
                }
                for (BlockPosition blockPos7 : list3) {
                    serverLevel.a(blockPos7, Blocks.a.m(), 3);
                }
            }
            ArrayList list4 = Lists.newArrayList();
            list4.addAll(list);
            list4.addAll(list1);
            list4.addAll(list2);
            List list5 = Lists.reverse((List)list4);
            for (Iterator cloneBlockInfo : list5) {
                TileEntity blockEntity2 = serverLevel1.c_(((CommandCloneStoredTileEntity)((Object)cloneBlockInfo)).a);
                Clearable.a(blockEntity2);
                serverLevel1.a(((CommandCloneStoredTileEntity)((Object)cloneBlockInfo)).a, Blocks.iu.m(), 2);
            }
            int xx = 0;
            for (CommandCloneStoredTileEntity cloneBlockInfo1 : list4) {
                if (!serverLevel1.a(cloneBlockInfo1.a, cloneBlockInfo1.b, 2)) continue;
                ++xx;
            }
            for (CommandCloneStoredTileEntity cloneBlockInfo1x : list1) {
                TileEntity blockEntity3 = serverLevel1.c_(cloneBlockInfo1x.a);
                if (cloneBlockInfo1x.c != null && blockEntity3 != null) {
                    blockEntity3.d(cloneBlockInfo1x.c.a, serverLevel1.K_());
                    blockEntity3.a(cloneBlockInfo1x.c.b);
                    blockEntity3.e();
                }
                serverLevel1.a(cloneBlockInfo1x.a, cloneBlockInfo1x.b, 2);
            }
            for (CommandCloneStoredTileEntity cloneBlockInfo1x : list5) {
                serverLevel1.b(cloneBlockInfo1x.a, cloneBlockInfo1x.b.b());
            }
            serverLevel1.n().a(serverLevel.n(), boundingBox, blockPos4);
            if (xx == 0) {
                throw d.create();
            }
            int i1 = xx;
            source.a(() -> IChatBaseComponent.a("commands.clone.success", i1), true);
            return xx;
        }
        throw ArgumentPosition.a.create();
    }

    @FunctionalInterface
    static interface c<T, R> {
        public R apply(T var1) throws CommandSyntaxException;
    }

    record d(WorldServer a, BlockPosition b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "dimension;position", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "dimension;position", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "dimension;position", "a", "b"}, this, o2);
        }
    }

    static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode a = new Mode(true);
        public static final /* enum */ Mode b = new Mode(true);
        public static final /* enum */ Mode c = new Mode(false);
        private final boolean d;
        private static final /* synthetic */ Mode[] e;

        public static Mode[] values() {
            return (Mode[])e.clone();
        }

        public static Mode valueOf(String name) {
            return Enum.valueOf(Mode.class, name);
        }

        private Mode(boolean canOverlap) {
            this.d = canOverlap;
        }

        public boolean a() {
            return this.d;
        }

        private static /* synthetic */ Mode[] b() {
            return new Mode[]{a, b, c};
        }

        static {
            e = Mode.b();
        }
    }

    record a(NBTTagCompound a, DataComponentMap b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "tag;components", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "tag;components", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "tag;components", "a", "b"}, this, o2);
        }
    }

    record CommandCloneStoredTileEntity(BlockPosition a, IBlockData b, @Nullable a c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{CommandCloneStoredTileEntity.class, "pos;state;blockEntityInfo", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CommandCloneStoredTileEntity.class, "pos;state;blockEntityInfo", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CommandCloneStoredTileEntity.class, "pos;state;blockEntityInfo", "a", "b", "c"}, this, o2);
        }
    }
}

