/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.stream.Stream;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class CommandAttribute {
    private static final DynamicCommandExceptionType a = new DynamicCommandExceptionType(entityName -> IChatBaseComponent.b("commands.attribute.failed.entity", entityName));
    private static final Dynamic2CommandExceptionType b = new Dynamic2CommandExceptionType((entityName, attributeName) -> IChatBaseComponent.b("commands.attribute.failed.no_attribute", entityName, attributeName));
    private static final Dynamic3CommandExceptionType c = new Dynamic3CommandExceptionType((entityName, attributeName, attributeUuid) -> IChatBaseComponent.b("commands.attribute.failed.no_modifier", attributeName, entityName, attributeUuid));
    private static final Dynamic3CommandExceptionType d = new Dynamic3CommandExceptionType((entityName, attributeName, attributeUuid) -> IChatBaseComponent.b("commands.attribute.failed.modifier_already_present", attributeUuid, attributeName, entityName));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("attribute").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentEntity.a()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("attribute", ResourceArgument.a(context, Registries.c)).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("get").executes(context1 -> CommandAttribute.a((CommandListenerWrapper)context1.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context1, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context1, "attribute"), 1.0))).then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).executes(context1 -> CommandAttribute.a((CommandListenerWrapper)context1.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context1, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context1, "attribute"), DoubleArgumentType.getDouble((CommandContext)context1, (String)"scale")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("base").then(net.minecraft.commands.CommandDispatcher.a("set").then(net.minecraft.commands.CommandDispatcher.a("value", DoubleArgumentType.doubleArg()).executes(context1 -> CommandAttribute.c((CommandListenerWrapper)context1.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context1, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context1, "attribute"), DoubleArgumentType.getDouble((CommandContext)context1, (String)"value")))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("get").executes(context1 -> CommandAttribute.b((CommandListenerWrapper)context1.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context1, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context1, "attribute"), 1.0))).then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).executes(context1 -> CommandAttribute.b((CommandListenerWrapper)context1.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context1, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context1, "attribute"), DoubleArgumentType.getDouble((CommandContext)context1, (String)"scale")))))).then(net.minecraft.commands.CommandDispatcher.a("reset").executes(context1 -> CommandAttribute.a((CommandListenerWrapper)context1.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context1, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context1, "attribute")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("modifier").then(net.minecraft.commands.CommandDispatcher.a("add").then(net.minecraft.commands.CommandDispatcher.a("id", ArgumentMinecraftKeyRegistered.a()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("value", DoubleArgumentType.doubleArg()).then(net.minecraft.commands.CommandDispatcher.a("add_value").executes(context1 -> CommandAttribute.a((CommandListenerWrapper)context1.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context1, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context1, "attribute"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context1, "id"), DoubleArgumentType.getDouble((CommandContext)context1, (String)"value"), AttributeModifier.Operation.a)))).then(net.minecraft.commands.CommandDispatcher.a("add_multiplied_base").executes(context1 -> CommandAttribute.a((CommandListenerWrapper)context1.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context1, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context1, "attribute"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context1, "id"), DoubleArgumentType.getDouble((CommandContext)context1, (String)"value"), AttributeModifier.Operation.b)))).then(net.minecraft.commands.CommandDispatcher.a("add_multiplied_total").executes(context1 -> CommandAttribute.a((CommandListenerWrapper)context1.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context1, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context1, "attribute"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context1, "id"), DoubleArgumentType.getDouble((CommandContext)context1, (String)"value"), AttributeModifier.Operation.c))))))).then(net.minecraft.commands.CommandDispatcher.a("remove").then(net.minecraft.commands.CommandDispatcher.a("id", ArgumentMinecraftKeyRegistered.a()).suggests((commandContext, suggestionsBuilder) -> ICompletionProvider.a(CommandAttribute.c(ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandContext, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)commandContext, "attribute")), suggestionsBuilder)).executes(context1 -> CommandAttribute.a((CommandListenerWrapper)context1.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context1, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context1, "attribute"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context1, "id")))))).then(net.minecraft.commands.CommandDispatcher.a("value").then(net.minecraft.commands.CommandDispatcher.a("get").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("id", ArgumentMinecraftKeyRegistered.a()).suggests((commandContext, suggestionsBuilder) -> ICompletionProvider.a(CommandAttribute.c(ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandContext, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)commandContext, "attribute")), suggestionsBuilder)).executes(commandContext -> CommandAttribute.a((CommandListenerWrapper)commandContext.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandContext, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)commandContext, "attribute"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)commandContext, "id"), 1.0))).then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).executes(commandContext -> CommandAttribute.a((CommandListenerWrapper)commandContext.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandContext, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)commandContext, "attribute"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)commandContext, "id"), DoubleArgumentType.getDouble((CommandContext)commandContext, (String)"scale"))))))))))));
    }

    private static AttributeModifiable a(Entity entity, Holder<AttributeBase> attribute) throws CommandSyntaxException {
        AttributeModifiable instance = CommandAttribute.a(entity).eY().a(attribute);
        if (instance == null) {
            throw b.create((Object)entity.al(), (Object)CommandAttribute.a(attribute));
        }
        return instance;
    }

    private static EntityLiving a(Entity target) throws CommandSyntaxException {
        if (!(target instanceof EntityLiving)) {
            throw a.create((Object)target.al());
        }
        return (EntityLiving)target;
    }

    private static EntityLiving b(Entity entity, Holder<AttributeBase> attribute) throws CommandSyntaxException {
        EntityLiving livingEntity = CommandAttribute.a(entity);
        if (!livingEntity.eY().b(attribute)) {
            throw b.create((Object)entity.al(), (Object)CommandAttribute.a(attribute));
        }
        return livingEntity;
    }

    private static int a(CommandListenerWrapper source, Entity entity, Holder<AttributeBase> attribute, double scale) throws CommandSyntaxException {
        EntityLiving entityWithAttribute = CommandAttribute.b(entity, attribute);
        double attributeValue = entityWithAttribute.h(attribute);
        source.a(() -> IChatBaseComponent.a("commands.attribute.value.get.success", CommandAttribute.a(attribute), entity.al(), attributeValue), false);
        return (int)(attributeValue * scale);
    }

    private static int b(CommandListenerWrapper source, Entity entity, Holder<AttributeBase> attribute, double scale) throws CommandSyntaxException {
        EntityLiving entityWithAttribute = CommandAttribute.b(entity, attribute);
        double attributeBaseValue = entityWithAttribute.i(attribute);
        source.a(() -> IChatBaseComponent.a("commands.attribute.base_value.get.success", CommandAttribute.a(attribute), entity.al(), attributeBaseValue), false);
        return (int)(attributeBaseValue * scale);
    }

    private static int a(CommandListenerWrapper source, Entity entity, Holder<AttributeBase> attribute, MinecraftKey id, double scale) throws CommandSyntaxException {
        EntityLiving entityWithAttribute = CommandAttribute.b(entity, attribute);
        AttributeMapBase attributes = entityWithAttribute.eY();
        if (!attributes.a(attribute, id)) {
            throw c.create((Object)entity.al(), (Object)CommandAttribute.a(attribute), (Object)id);
        }
        double modifierValue = attributes.b(attribute, id);
        source.a(() -> IChatBaseComponent.a("commands.attribute.modifier.value.get.success", IChatBaseComponent.a(id), CommandAttribute.a(attribute), entity.al(), modifierValue), false);
        return (int)(modifierValue * scale);
    }

    private static Stream<MinecraftKey> c(Entity entity, Holder<AttributeBase> attribute) throws CommandSyntaxException {
        AttributeModifiable attributeInstance = CommandAttribute.a(entity, attribute);
        return attributeInstance.c().stream().map(AttributeModifier::b);
    }

    private static int c(CommandListenerWrapper source, Entity entity, Holder<AttributeBase> attribute, double value) throws CommandSyntaxException {
        CommandAttribute.a(entity, attribute).a(value);
        source.a(() -> IChatBaseComponent.a("commands.attribute.base_value.set.success", CommandAttribute.a(attribute), entity.al(), value), false);
        return 1;
    }

    private static int a(CommandListenerWrapper source, Entity entity, Holder<AttributeBase> attribute) throws CommandSyntaxException {
        EntityLiving livingEntity = CommandAttribute.a(entity);
        if (!livingEntity.eY().e(attribute)) {
            throw b.create((Object)entity.al(), (Object)CommandAttribute.a(attribute));
        }
        double attributeBaseValue = livingEntity.i(attribute);
        source.a(() -> IChatBaseComponent.a("commands.attribute.base_value.reset.success", CommandAttribute.a(attribute), entity.al(), attributeBaseValue), false);
        return 1;
    }

    private static int a(CommandListenerWrapper source, Entity entity, Holder<AttributeBase> attribute, MinecraftKey id, double amount, AttributeModifier.Operation operation) throws CommandSyntaxException {
        AttributeModifiable attributeInstance = CommandAttribute.a(entity, attribute);
        AttributeModifier attributeModifier = new AttributeModifier(id, amount, operation);
        if (attributeInstance.b(id)) {
            throw d.create((Object)entity.al(), (Object)CommandAttribute.a(attribute), (Object)id);
        }
        attributeInstance.d(attributeModifier);
        source.a(() -> IChatBaseComponent.a("commands.attribute.modifier.add.success", IChatBaseComponent.a(id), CommandAttribute.a(attribute), entity.al()), false);
        return 1;
    }

    private static int a(CommandListenerWrapper source, Entity entity, Holder<AttributeBase> attribute, MinecraftKey id) throws CommandSyntaxException {
        AttributeModifiable attributeInstance = CommandAttribute.a(entity, attribute);
        if (attributeInstance.c(id)) {
            source.a(() -> IChatBaseComponent.a("commands.attribute.modifier.remove.success", IChatBaseComponent.a(id), CommandAttribute.a(attribute), entity.al()), false);
            return 1;
        }
        throw c.create((Object)entity.al(), (Object)CommandAttribute.a(attribute), (Object)id);
    }

    private static IChatBaseComponent a(Holder<AttributeBase> attribute) {
        return IChatBaseComponent.c(attribute.a().c());
    }
}

