/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundResetScorePacket;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardDisplayObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardScore;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.PersistentScoreboard;
import net.minecraft.world.scores.PlayerScoreEntry;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.ScoreboardTeam;

public class ScoreboardServer
extends Scoreboard {
    private final MinecraftServer b;
    private final Set<ScoreboardObjective> c = Sets.newHashSet();
    private final List<Runnable> d = Lists.newArrayList();

    public ScoreboardServer(MinecraftServer server) {
        this.b = server;
    }

    @Override
    protected void a(ScoreHolder scoreHolder, ScoreboardObjective objective, ScoreboardScore score) {
        super.a(scoreHolder, objective, score);
        if (this.c.contains(objective)) {
            this.broadcastAll(new PacketPlayOutScoreboardScore(scoreHolder.cI(), objective.b(), score.a(), Optional.ofNullable(score.d()), Optional.ofNullable(score.c())));
        }
        this.a();
    }

    @Override
    protected void a(ScoreHolder scoreHolder, ScoreboardObjective objective) {
        super.a(scoreHolder, objective);
        this.a();
    }

    @Override
    public void a(ScoreHolder scoreHolder) {
        super.a(scoreHolder);
        this.broadcastAll(new ClientboundResetScorePacket(scoreHolder.cI(), null));
        this.a();
    }

    @Override
    public void b(ScoreHolder scoreHolder, ScoreboardObjective objective) {
        super.b(scoreHolder, objective);
        if (this.c.contains(objective)) {
            this.broadcastAll(new ClientboundResetScorePacket(scoreHolder.cI(), objective.b()));
        }
        this.a();
    }

    @Override
    public void a(DisplaySlot slot, @Nullable ScoreboardObjective objective) {
        ScoreboardObjective displayObjective = this.a(slot);
        super.a(slot, objective);
        if (displayObjective != objective && displayObjective != null) {
            if (this.h(displayObjective) > 0) {
                this.broadcastAll(new PacketPlayOutScoreboardDisplayObjective(slot, objective));
            } else {
                this.g(displayObjective);
            }
        }
        if (objective != null) {
            if (this.c.contains(objective)) {
                this.broadcastAll(new PacketPlayOutScoreboardDisplayObjective(slot, objective));
            } else {
                this.e(objective);
            }
        }
        this.a();
    }

    @Override
    public boolean a(String playerName, ScoreboardTeam team) {
        if (super.a(playerName, team)) {
            this.broadcastAll(PacketPlayOutScoreboardTeam.a(team, playerName, PacketPlayOutScoreboardTeam.a.a));
            this.a();
            return true;
        }
        return false;
    }

    public boolean addPlayersToTeam(Collection<String> players, ScoreboardTeam team) {
        boolean anyAdded = false;
        for (String playerName : players) {
            if (!super.a(playerName, team)) continue;
            anyAdded = true;
        }
        if (anyAdded) {
            this.broadcastAll(PacketPlayOutScoreboardTeam.createMultiplePlayerPacket(team, players, PacketPlayOutScoreboardTeam.a.a));
            this.a();
            return true;
        }
        return false;
    }

    @Override
    public void b(String username, ScoreboardTeam playerTeam) {
        super.b(username, playerTeam);
        this.broadcastAll(PacketPlayOutScoreboardTeam.a(playerTeam, username, PacketPlayOutScoreboardTeam.a.b));
        this.a();
    }

    public void removePlayersFromTeam(Collection<String> players, ScoreboardTeam team) {
        for (String playerName : players) {
            super.b(playerName, team);
        }
        this.broadcastAll(PacketPlayOutScoreboardTeam.createMultiplePlayerPacket(team, players, PacketPlayOutScoreboardTeam.a.b));
        this.a();
    }

    @Override
    public void a(ScoreboardObjective objective) {
        super.a(objective);
        this.a();
    }

    @Override
    public void b(ScoreboardObjective objective) {
        super.b(objective);
        if (this.c.contains(objective)) {
            this.broadcastAll(new PacketPlayOutScoreboardObjective(objective, 2));
        }
        this.a();
    }

    @Override
    public void c(ScoreboardObjective objective) {
        super.c(objective);
        if (this.c.contains(objective)) {
            this.g(objective);
        }
        this.a();
    }

    @Override
    public void a(ScoreboardTeam playerTeam) {
        super.a(playerTeam);
        this.broadcastAll(PacketPlayOutScoreboardTeam.a(playerTeam, true));
        this.a();
    }

    @Override
    public void b(ScoreboardTeam playerTeam) {
        super.b(playerTeam);
        this.broadcastAll(PacketPlayOutScoreboardTeam.a(playerTeam, false));
        this.a();
    }

    @Override
    public void c(ScoreboardTeam playerTeam) {
        super.c(playerTeam);
        this.broadcastAll(PacketPlayOutScoreboardTeam.a(playerTeam));
        this.a();
    }

    public void a(Runnable runnable) {
        this.d.add(runnable);
    }

    protected void a() {
        for (Runnable runnable : this.d) {
            runnable.run();
        }
    }

    public List<Packet<?>> d(ScoreboardObjective objective) {
        ArrayList list = Lists.newArrayList();
        list.add(new PacketPlayOutScoreboardObjective(objective, 0));
        for (DisplaySlot displaySlot : DisplaySlot.values()) {
            if (this.a(displaySlot) != objective) continue;
            list.add(new PacketPlayOutScoreboardDisplayObjective(displaySlot, objective));
        }
        for (PlayerScoreEntry playerScoreEntry : this.i(objective)) {
            list.add(new PacketPlayOutScoreboardScore(playerScoreEntry.c(), objective.b(), playerScoreEntry.d(), Optional.ofNullable(playerScoreEntry.e()), Optional.ofNullable(playerScoreEntry.f())));
        }
        return list;
    }

    public void e(ScoreboardObjective objective) {
        List<Packet<?>> startTrackingPackets = this.d(objective);
        for (EntityPlayer serverPlayer : this.b.ag().t()) {
            if (serverPlayer.getBukkitEntity().getScoreboard().getHandle() != this) continue;
            for (Packet<?> packet : startTrackingPackets) {
                serverPlayer.f.b(packet);
            }
        }
        this.c.add(objective);
    }

    public List<Packet<?>> f(ScoreboardObjective objective) {
        ArrayList list = Lists.newArrayList();
        list.add(new PacketPlayOutScoreboardObjective(objective, 1));
        for (DisplaySlot displaySlot : DisplaySlot.values()) {
            if (this.a(displaySlot) != objective) continue;
            list.add(new PacketPlayOutScoreboardDisplayObjective(displaySlot, objective));
        }
        return list;
    }

    public void g(ScoreboardObjective objective) {
        List<Packet<?>> stopTrackingPackets = this.f(objective);
        for (EntityPlayer serverPlayer : this.b.ag().t()) {
            if (serverPlayer.getBukkitEntity().getScoreboard().getHandle() != this) continue;
            for (Packet<?> packet : stopTrackingPackets) {
                serverPlayer.f.b(packet);
            }
        }
        this.c.remove(objective);
    }

    public int h(ScoreboardObjective objective) {
        int i2 = 0;
        for (DisplaySlot displaySlot : DisplaySlot.values()) {
            if (this.a(displaySlot) != objective) continue;
            ++i2;
        }
        return i2;
    }

    public PersistentBase.a<PersistentScoreboard> b() {
        return new PersistentBase.a<PersistentScoreboard>(this::h, this::a, DataFixTypes.n);
    }

    private PersistentScoreboard h() {
        PersistentScoreboard scoreboardSaveData = new PersistentScoreboard(this);
        this.a(scoreboardSaveData::c);
        return scoreboardSaveData;
    }

    private PersistentScoreboard a(NBTTagCompound tag, HolderLookup.a registries) {
        return this.h().b(tag, registries);
    }

    private void broadcastAll(Packet<?> packet) {
        for (EntityPlayer serverPlayer : this.b.ag().l) {
            if (serverPlayer.getBukkitEntity().getScoreboard().getHandle() != this) continue;
            serverPlayer.f.b(packet);
        }
    }

    public static final class Action
    extends Enum<Action> {
        public static final /* enum */ Action a = new Action();
        public static final /* enum */ Action b = new Action();
        private static final /* synthetic */ Action[] c;

        public static Action[] values() {
            return (Action[])c.clone();
        }

        public static Action valueOf(String name) {
            return Enum.valueOf(Action.class, name);
        }

        private static /* synthetic */ Action[] a() {
            return new Action[]{a, b};
        }

        static {
            c = Action.a();
        }
    }
}

