/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import io.papermc.paper.registry.PaperRegistryAccess;
import io.papermc.paper.registry.PaperRegistryListenerManager;
import io.papermc.paper.registry.data.util.Conversions;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.tags.TagDataPack;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.slf4j.Logger;

public class ReloadableServerRegistries {
    private static final Logger a = LogUtils.getLogger();
    private static final RegistrationInfo b = new RegistrationInfo(Optional.empty(), Lifecycle.experimental());

    public static CompletableFuture<b> a(LayeredRegistryAccess<RegistryLayer> registryAccess, List<IRegistry.a<?>> postponedTags, IResourceManager resourceManager, Executor backgroundExecutor) {
        List<HolderLookup.b<?>> list = TagDataPack.a(registryAccess.b(RegistryLayer.d), postponedTags);
        HolderLookup.a provider = HolderLookup.a.a(list.stream());
        RegistryOps registryOps = provider.a(JsonOps.INSTANCE);
        Conversions conversions = new Conversions(registryOps.b);
        List<CompletableFuture> list1 = LootDataType.a().map(lootDataType -> ReloadableServerRegistries.scheduleRegistryLoad(lootDataType, registryOps, resourceManager, backgroundExecutor, conversions)).toList();
        CompletableFuture completableFuture = SystemUtils.d(list1);
        return completableFuture.thenApplyAsync(list2 -> ReloadableServerRegistries.a(registryAccess, provider, list2), backgroundExecutor);
    }

    private static <T> CompletableFuture<IRegistryWritable<?>> scheduleRegistryLoad(LootDataType<T> lootDataType, RegistryOps<JsonElement> ops, IResourceManager resourceManager, Executor backgroundExecutor, Conversions conversions) {
        return CompletableFuture.supplyAsync(() -> {
            RegistryMaterials writableRegistry = new RegistryMaterials(lootDataType.b(), Lifecycle.experimental());
            PaperRegistryAccess.instance().registerReloadableRegistry(lootDataType.b(), writableRegistry);
            HashMap<MinecraftKey, Object> map = new HashMap<MinecraftKey, Object>();
            ResourceDataJson.a(resourceManager, lootDataType.b(), (DynamicOps<JsonElement>)ops, lootDataType.c(), map);
            map.forEach((resourceLocation, object) -> PaperRegistryListenerManager.INSTANCE.registerWithListeners(writableRegistry, ResourceKey.a(lootDataType.b(), resourceLocation), object, b, conversions));
            TagDataPack.loadTagsForRegistry(resourceManager, writableRegistry, ReloadableRegistrarEvent.Cause.RELOAD);
            return writableRegistry;
        }, backgroundExecutor);
    }

    private static b a(LayeredRegistryAccess<RegistryLayer> registryAccess, HolderLookup.a provider, List<IRegistryWritable<?>> registries) {
        LayeredRegistryAccess<RegistryLayer> layeredRegistryAccess = ReloadableServerRegistries.a(registryAccess, registries);
        HolderLookup.a provider1 = ReloadableServerRegistries.a(provider, layeredRegistryAccess.a(RegistryLayer.d));
        ReloadableServerRegistries.a(provider1);
        return new b(layeredRegistryAccess, provider1);
    }

    private static HolderLookup.a a(HolderLookup.a lookup1, HolderLookup.a lookup2) {
        return HolderLookup.a.a(Stream.concat(lookup1.c(), lookup2.c()));
    }

    private static void a(HolderLookup.a registries) {
        ProblemReporter.a collector = new ProblemReporter.a();
        LootCollector validationContext = new LootCollector(collector, LootContextParameterSets.q, registries);
        LootDataType.a().forEach(lootDataType -> ReloadableServerRegistries.a(validationContext, lootDataType, registries));
        collector.a().forEach((string, string1) -> a.warn("Found loot table element validation problem in {}: {}", string, string1));
    }

    private static LayeredRegistryAccess<RegistryLayer> a(LayeredRegistryAccess<RegistryLayer> registryAccess, List<IRegistryWritable<?>> registries) {
        return registryAccess.a(RegistryLayer.d, new IRegistryCustom.c(registries).e());
    }

    private static <T> void a(LootCollector context, LootDataType<T> lootDataType, HolderLookup.a registries) {
        HolderLookup.b<T> holderLookup = registries.d(lootDataType.b());
        holderLookup.c().forEach(reference -> lootDataType.a(context, reference.h(), reference.a()));
    }

    public record b(LayeredRegistryAccess<RegistryLayer> a, HolderLookup.a b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "layers;lookupWithUpdatedTags", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "layers;lookupWithUpdatedTags", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "layers;lookupWithUpdatedTags", "a", "b"}, this, o2);
        }
    }

    public static class a {
        private final HolderLookup.a a;

        public a(HolderLookup.a registries) {
            this.a = registries;
        }

        public HolderGetter.a a() {
            return this.a;
        }

        public Collection<MinecraftKey> a(ResourceKey<? extends IRegistry<?>> registryKey) {
            return this.a.d(registryKey).c_().map(ResourceKey::a).toList();
        }

        public LootTable b(ResourceKey<LootTable> lootTableKey) {
            return this.a.a(Registries.bg).flatMap(registryLookup -> registryLookup.a(lootTableKey)).map(Holder::a).orElse(LootTable.a);
        }
    }
}

