/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.moonrise.common.util.MoonriseCommon;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.server.ChunkSystemMinecraftServer;
import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.destroystokyo.paper.event.server.ServerTickStartEvent;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import com.mojang.jtracy.DiscontinuousFrame;
import com.mojang.jtracy.TracyClient;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import io.papermc.paper.ServerBuildInfo;
import io.papermc.paper.adventure.ImprovedChatDecorator;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.adventure.providers.ClickCallbackProviderImpl;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.command.brigadier.PaperBrigadier;
import io.papermc.paper.command.brigadier.PaperCommands;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.configuration.PaperConfigurations;
import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.event.server.ServerResourcesReloadedEvent;
import io.papermc.paper.log.CustomLogManager;
import io.papermc.paper.plugin.PluginInitializerManager;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventRunner;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import io.papermc.paper.plugin.manager.PaperPluginManagerImpl;
import io.papermc.paper.threadedregions.scheduler.FoliaGlobalRegionScheduler;
import io.papermc.paper.util.LogManagerShutdownThread;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.ServerStopRejectedExecutionException;
import io.papermc.paper.util.TraceUtil;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.runtime.ObjectMethods;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.Proxy;
import java.nio.file.FileStore;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import joptsimple.OptionSet;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.FileUtils;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.DataPackResources;
import net.minecraft.server.Main;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.ServerInfo;
import net.minecraft.server.ServerLinks;
import net.minecraft.server.ServerTickRateManager;
import net.minecraft.server.Services;
import net.minecraft.server.SuppressedExceptionCollector;
import net.minecraft.server.TickTask;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.bossevents.BossBattleCustomData;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.DemoPlayerInteractManager;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.WorldProviderNormal;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.level.progress.WorldLoadListenerFactory;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.ServerConnection;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.UserCache;
import net.minecraft.server.players.WhiteList;
import net.minecraft.tags.TagDataPack;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.util.ModCheck;
import net.minecraft.util.NativeModuleLister;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.TimeRange;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.debugchart.RemoteDebugSampleType;
import net.minecraft.util.debugchart.SampleLogger;
import net.minecraft.util.debugchart.TpsDebugDimensions;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.GameProfilerTick;
import net.minecraft.util.profiling.MethodProfilerResults;
import net.minecraft.util.profiling.MethodProfilerResultsEmpty;
import net.minecraft.util.profiling.MethodProfilerResultsField;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.util.profiling.metrics.profiling.ActiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.InactiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.MetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.ServerMetricsSamplersProvider;
import net.minecraft.util.profiling.metrics.storage.MetricsPersister;
import net.minecraft.util.thread.IAsyncTaskHandlerReentrant;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.npc.MobSpawnerCat;
import net.minecraft.world.entity.npc.MobSpawnerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.ForcedChunk;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.MobSpawnerPatrol;
import net.minecraft.world.level.levelgen.MobSpawnerPhantom;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.PersistentCommandStorage;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldInfo;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecrell.terminalconsole.TerminalConsoleAppender;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.v1_21_R3.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R3.CraftServer;
import org.bukkit.craftbukkit.v1_21_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R3.generator.CraftWorldInfo;
import org.bukkit.craftbukkit.v1_21_R3.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_21_R3.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.v1_21_R3.util.ServerShutdownThread;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;

public abstract class MinecraftServer
extends IAsyncTaskHandlerReentrant<TickTask>
implements ServerInfo,
ChunkIOErrorReporter,
ICommandListener,
ChunkSystemMinecraftServer {
    private static MinecraftServer SERVER;
    public static final Logger l;
    public static final ComponentLogger COMPONENT_LOGGER;
    public static final String b = "vanilla";
    private static final float m = 0.8f;
    private static final int n = 100;
    private static final long o;
    private static final int p = 20;
    private static final long q;
    private static final int r = 100;
    private static final long s;
    private static final long t;
    private static final int u = 12;
    private static final int v = 5;
    private static final int w = 6000;
    private static final int x = 100;
    private static final int y = 3;
    public static final int c = 29999984;
    public static final WorldSettings d;
    public static final GameProfile e;
    public Convertable.ConversionSession f;
    public final WorldNBTStorage g;
    private final List<Runnable> z = Lists.newArrayList();
    private MetricsRecorder A = InactiveMetricsRecorder.a;
    private Consumer<MethodProfilerResults> B = results -> this.aU();
    private Consumer<Path> C = path -> {};
    private boolean D;
    @Nullable
    private TimeProfiler E;
    private boolean F;
    private ServerConnection G;
    public final WorldLoadListenerFactory H;
    @Nullable
    private ServerPing I;
    @Nullable
    private ServerPing.a J;
    private final RandomSource K = RandomSource.a();
    public final DataFixer L;
    private String M;
    private int N = -1;
    private final LayeredRegistryAccess<RegistryLayer> O;
    private Map<ResourceKey<net.minecraft.world.level.World>, WorldServer> P = Maps.newLinkedHashMap();
    private PlayerList Q;
    private volatile boolean R = true;
    private volatile boolean isRestarting = false;
    private boolean S;
    private int T;
    private int U = 6000;
    protected final Proxy h;
    private boolean V;
    private boolean W;
    private boolean X;
    private boolean Y;
    private Component motd;
    private int aa;
    private final long[] ab = new long[100];
    private long ac = 0L;
    public final TickTimes tickTimes5s = new TickTimes(100);
    public final TickTimes tickTimes10s = new TickTimes(200);
    public final TickTimes tickTimes60s = new TickTimes(1200);
    @Nullable
    private KeyPair ad;
    @Nullable
    private GameProfile ae;
    private boolean af;
    private volatile boolean ag;
    private long ah;
    protected final Services i;
    private long ai;
    public final Thread aj;
    private long ak = SystemUtils.d();
    private long al = SystemUtils.d();
    private long am;
    private long an = SystemUtils.d();
    private boolean ao = false;
    private long ap;
    private boolean aq;
    private final ResourcePackRepository ar;
    private final ScoreboardServer as = new ScoreboardServer(this);
    @Nullable
    private PersistentCommandStorage at;
    private final BossBattleCustomData au = new BossBattleCustomData();
    private final CustomFunctionData av;
    private boolean aw;
    private float ax;
    public final Executor ay;
    @Nullable
    private String az;
    public ReloadableResources aA;
    private final StructureTemplateManager aB;
    private final ServerTickRateManager aC;
    protected SaveData j;
    public PotionBrewer aD;
    private FuelValues aE;
    private int aF;
    private volatile boolean aG;
    private static final AtomicReference<RuntimeException> aH;
    private final SuppressedExceptionCollector aI = new SuppressedExceptionCollector();
    private final DiscontinuousFrame aJ;
    public final WorldLoader.a worldLoader;
    public CraftServer server;
    public OptionSet options;
    public ConsoleCommandSender console;
    public static int currentTick;
    public Queue<Runnable> processQueue = new ConcurrentLinkedQueue<Runnable>();
    public int autosavePeriod;
    public boolean forceTicks;
    public static final int TPS = 20;
    public static final int TICK_TIME = 50000000;
    private static final int SAMPLE_INTERVAL = 20;
    @Deprecated(forRemoval=true)
    public final double[] recentTps = new double[3];
    public volatile boolean hasFullyShutdown;
    public volatile boolean abnormalExit;
    public volatile Thread shutdownThread;
    public final PaperConfigurations paperConfigurations;
    public boolean isIteratingOverLevels = false;
    private final Set<String> pluginsBlockingSleep = new HashSet<String>();
    public static final long SERVER_INIT;
    private volatile Throwable chunkSystemCrash;
    private static final long CHUNK_TASK_QUEUE_BACKOFF_MIN_TIME = 25000L;
    private static final long MAX_CHUNK_EXEC_TIME = 1000L;
    private static final long TASK_EXECUTION_FAILURE_BACKOFF = 5000L;
    private long lastMidTickExecute;
    private long lastMidTickExecuteFailure;
    private boolean hasStopped = false;
    private boolean hasLoggedStop = false;
    private final Object stopLock = new Object();
    private static final long SEC_IN_NANO = 1000000000L;
    private static final long MAX_CATCHUP_BUFFER = 60000000000L;
    private long lastTick = 0L;
    private long catchupTime = 0L;
    public final RollingAverage tps1 = new RollingAverage(60);
    public final RollingAverage tps5 = new RollingAverage(300);
    public final RollingAverage tps15 = new RollingAverage(900);
    private static final BigDecimal TPS_BASE;
    public final ExecutorService chatExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Async Chat Thread - #%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(l)).build());
    public final ChatDecorator improvedChatDecorator = new ImprovedChatDecorator(this);

    public static <S extends MinecraftServer> S a(Function<Thread, S> threadFunction) {
        MCTypeRegistry.init();
        AtomicReference<MinecraftServer> atomicReference = new AtomicReference<MinecraftServer>();
        TickThread thread = new TickThread(() -> ((MinecraftServer)atomicReference.get()).y(), "Server thread");
        thread.setUncaughtExceptionHandler((thread1, exception) -> l.error("Uncaught exception in server thread", exception));
        thread.setPriority(7);
        if (Runtime.getRuntime().availableProcessors() > 4) {
            thread.setPriority(8);
        }
        MinecraftServer minecraftServer = (MinecraftServer)threadFunction.apply(thread);
        atomicReference.set(minecraftServer);
        thread.start();
        return (S)minecraftServer;
    }

    @Override
    public final void moonrise$setChunkSystemCrash(Throwable throwable) {
        this.chunkSystemCrash = throwable;
    }

    private boolean tickMidTickTasks() {
        boolean executed = false;
        for (WorldServer world : this.L()) {
            long currTime = System.nanoTime();
            if (currTime - world.moonrise$getLastMidTickFailure() <= 5000L) continue;
            if (!world.m().d()) {
                world.moonrise$setLastMidTickFailure(currTime);
                continue;
            }
            executed = true;
        }
        return executed;
    }

    @Override
    public final void moonrise$executeMidTickTasks() {
        long overuse;
        long currTime;
        long diff;
        boolean moreTasks;
        long startTime = System.nanoTime();
        if (startTime - this.lastMidTickExecute <= 25000L || startTime - this.lastMidTickExecuteFailure <= 5000L) {
            return;
        }
        do {
            moreTasks = this.tickMidTickTasks();
            currTime = System.nanoTime();
            diff = currTime - startTime;
        } while (moreTasks && diff < 1000L);
        if (!moreTasks) {
            this.lastMidTickExecuteFailure = currTime;
        }
        if ((overuse = diff - 1000L) >= 10000000L) {
            overuse = 10000000L;
        }
        double overuseCount = (double)overuse / 1000.0;
        long extraSleep = Math.round(overuseCount * 25000.0);
        this.lastMidTickExecute = currTime + extraSleep;
    }

    public MinecraftServer(OptionSet options, WorldLoader.a worldLoader, Thread serverThread, Convertable.ConversionSession storageSource, ResourcePackRepository packRepository, WorldStem worldStem, Proxy proxy, DataFixer fixerUpper, Services services, WorldLoadListenerFactory progressListenerFactory) {
        super("Server");
        SERVER = this;
        this.O = worldStem.c();
        this.j = worldStem.d();
        this.h = proxy;
        this.ar = packRepository;
        this.aA = new ReloadableResources(worldStem.a(), worldStem.b());
        this.i = services;
        if (services.f() != null) {
            services.f().a(this);
        }
        this.aC = new ServerTickRateManager(this);
        this.H = progressListenerFactory;
        this.f = storageSource;
        this.g = storageSource.g();
        this.L = fixerUpper;
        this.av = new CustomFunctionData(this, this.aA.b.a());
        HolderLookup.b holderGetter = this.O.a().e(Registries.f).a(this.j.K());
        this.aB = new StructureTemplateManager(worldStem.a(), storageSource, fixerUpper, holderGetter);
        this.aj = serverThread;
        this.ay = SystemUtils.h();
        this.aD = PotionBrewer.a(this.j.K());
        this.aA.b.c().a(this.j.K());
        this.aE = FuelValues.a(this.O.a(), this.j.K());
        this.aJ = TracyClient.createDiscontinuousFrame((String)"Server Tick");
        this.options = options;
        this.worldLoader = worldLoader;
        LogManagerShutdownThread.unhook();
        Runtime.getRuntime().addShutdownHook(new ServerShutdownThread(this));
        this.paperConfigurations = services.paperConfigurations();
    }

    private void a(WorldPersistentData dataStorage) {
        dataStorage.a(this.aJ().b(), "scoreboard");
    }

    protected abstract boolean e() throws IOException;

    protected void loadLevel(String levelId) {
        if (!JvmProfiler.f.c()) {
            // empty if block
        }
        boolean flag = false;
        ProfiledDuration profiledDuration = JvmProfiler.f.e();
        this.loadWorld0(levelId);
        if (profiledDuration != null) {
            profiledDuration.finish(true);
        }
        if (flag) {
            try {
                JvmProfiler.f.b();
            }
            catch (Throwable var5) {
                l.warn("Failed to stop JFR profiling", var5);
            }
        }
    }

    protected void t() {
    }

    private void loadWorld0(String levelId) {
        Convertable.ConversionSession levelStorageAccess = this.f;
        IRegistryCustom.Dimension registryAccess = this.O.a();
        IRegistry<WorldDimension> levelStemRegistry = registryAccess.e(Registries.bf);
        for (WorldDimension levelStem : levelStemRegistry) {
            WorldServer serverLevel;
            WorldDataServer primaryLevelData;
            Dynamic<?> dataTag;
            String name;
            ResourceKey<WorldDimension> levelStemKey = levelStemRegistry.d(levelStem).get();
            int dimension = 0;
            if (levelStemKey == WorldDimension.c) {
                if (!this.server.getAllowNether()) continue;
                dimension = -1;
            } else if (levelStemKey == WorldDimension.d) {
                if (!this.server.getAllowEnd()) continue;
                dimension = 1;
            } else if (levelStemKey != WorldDimension.b) {
                dimension = -999;
            }
            String worldType = dimension == -999 ? levelStemKey.a().b() + "_" + levelStemKey.a().a() : World.Environment.getEnvironment((int)dimension).toString().toLowerCase(Locale.ROOT);
            String string = name = levelStemKey == WorldDimension.b ? levelId : levelId + "_" + worldType;
            if (dimension != 0) {
                File newWorld = Convertable.getStorageFolder(new File(name).toPath(), levelStemKey).toFile();
                File oldWorld = Convertable.getStorageFolder(new File(levelId).toPath(), levelStemKey).toFile();
                File oldLevelDat = new File(new File(levelId), "level.dat");
                if (!newWorld.isDirectory() && oldWorld.isDirectory() && oldLevelDat.isFile()) {
                    l.info("---- Migration of old " + worldType + " folder required ----");
                    l.info("Unfortunately due to the way that Minecraft implemented multiworld support in 1.6, Bukkit requires that you move your " + worldType + " folder to a new location in order to operate correctly.");
                    l.info("We will move this folder for you, but it will mean that you need to move it back should you wish to stop using Bukkit in the future.");
                    l.info("Attempting to move " + String.valueOf(oldWorld) + " to " + String.valueOf(newWorld) + "...");
                    if (newWorld.exists()) {
                        l.warn("A file or folder already exists at " + String.valueOf(newWorld) + "!");
                        l.info("---- Migration of old " + worldType + " folder failed ----");
                    } else if (newWorld.getParentFile().mkdirs()) {
                        if (oldWorld.renameTo(newWorld)) {
                            l.info("Success! To restore " + worldType + " in the future, simply move " + String.valueOf(newWorld) + " to " + String.valueOf(oldWorld));
                            try {
                                Files.copy((File)oldLevelDat, (File)new File(new File(name), "level.dat"));
                                org.apache.commons.io.FileUtils.copyDirectory((File)new File(new File(levelId), "data"), (File)new File(new File(name), "data"));
                            }
                            catch (IOException exception) {
                                l.warn("Unable to migrate world data.");
                            }
                            l.info("---- Migration of old " + worldType + " folder complete ----");
                        } else {
                            l.warn("Could not move folder " + String.valueOf(oldWorld) + " to " + String.valueOf(newWorld) + "!");
                            l.info("---- Migration of old " + worldType + " folder failed ----");
                        }
                    } else {
                        l.warn("Could not create path for " + String.valueOf(newWorld) + "!");
                        l.info("---- Migration of old " + worldType + " folder failed ----");
                    }
                }
                try {
                    levelStorageAccess = Convertable.b(this.server.getWorldContainer().toPath()).validateAndCreateAccess(name, levelStemKey);
                }
                catch (IOException | ContentValidationException ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (levelStorageAccess.m()) {
                WorldInfo summary;
                try {
                    dataTag = levelStorageAccess.h();
                    summary = levelStorageAccess.a(dataTag);
                }
                catch (IOException | NbtException | ReportedNbtException e2) {
                    Convertable.b levelDirectory = levelStorageAccess.e();
                    l.warn("Failed to load world data from {}", (Object)levelDirectory.b(), (Object)e2);
                    l.info("Attempting to use fallback");
                    try {
                        dataTag = levelStorageAccess.i();
                        summary = levelStorageAccess.a(dataTag);
                    }
                    catch (IOException | NbtException | ReportedNbtException e1) {
                        l.error("Failed to load world data from {}", (Object)levelDirectory.c(), (Object)e1);
                        l.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)levelDirectory.b(), (Object)levelDirectory.c());
                        return;
                    }
                    levelStorageAccess.n();
                }
                if (summary.d()) {
                    l.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!summary.r()) {
                    l.info("This world was created by an incompatible version.");
                    return;
                }
            } else {
                dataTag = null;
            }
            ChunkGenerator chunkGenerator = this.server.getGenerator(name);
            BiomeProvider biomeProvider = this.server.getBiomeProvider(name);
            WorldLoader.a context = this.worldLoader;
            IRegistry<WorldDimension> contextLevelStemRegistry = context.d().e(Registries.bf);
            if (dataTag != null) {
                LevelDataAndDimensions levelDataAndDimensions = Convertable.a(dataTag, context.b(), contextLevelStemRegistry, context.c());
                primaryLevelData = (WorldDataServer)levelDataAndDimensions.a();
            } else {
                WorldDimensions worldDimensions;
                WorldOptions worldOptions;
                WorldSettings levelSettings;
                if (this.X()) {
                    levelSettings = d;
                    worldOptions = WorldOptions.b;
                    worldDimensions = WorldPresets.a(context.c());
                } else {
                    DedicatedServerProperties properties = ((DedicatedServer)this).a();
                    levelSettings = new WorldSettings(properties.l, properties.k, properties.t, properties.j, false, new GameRules(context.b().b()), context.b());
                    worldOptions = this.options.has("bonusChest") ? properties.aa.a(true) : properties.aa;
                    worldDimensions = properties.a(context.c());
                }
                WorldDimensions.b complete = worldDimensions.a(contextLevelStemRegistry);
                Lifecycle lifecycle = complete.a().add(context.c().d());
                primaryLevelData = new WorldDataServer(levelSettings, worldOptions, complete.d(), lifecycle);
            }
            primaryLevelData.checkName(name);
            if (this.options.has("forceUpgrade")) {
                Main.a(levelStorageAccess, DataConverterRegistry.a(), this.options.has("eraseCache"), () -> true, registryAccess, this.options.has("recreateRegionFiles"));
            }
            WorldDataServer serverLevelData = primaryLevelData;
            boolean isDebugWorld = primaryLevelData.A();
            WorldOptions worldOptions = primaryLevelData.y();
            long seed = worldOptions.c();
            long l2 = BiomeManager.a(seed);
            ImmutableList list = ImmutableList.of((Object)new MobSpawnerPhantom(), (Object)new MobSpawnerPatrol(), (Object)new MobSpawnerCat(), (Object)new VillageSiege(), (Object)new MobSpawnerTrader(serverLevelData));
            WorldDimension customStem = levelStemRegistry.c(levelStemKey);
            CraftWorldInfo worldInfo = new CraftWorldInfo(serverLevelData, levelStorageAccess, World.Environment.getEnvironment((int)dimension), customStem.a().a(), customStem.b(), this.ba());
            if (biomeProvider == null && chunkGenerator != null) {
                biomeProvider = chunkGenerator.getDefaultBiomeProvider((org.bukkit.generator.WorldInfo)worldInfo);
            }
            ResourceKey<net.minecraft.world.level.World> dimensionKey = ResourceKey.a(Registries.be, levelStemKey.a());
            if (levelStemKey == WorldDimension.b) {
                this.j = primaryLevelData;
                this.j.a(((DedicatedServer)this).a().k);
                listener = this.H.create(this.j.o().c(GameRules.ab));
                serverLevel = new WorldServer(this, this.ay, levelStorageAccess, serverLevelData, dimensionKey, customStem, listener, isDebugWorld, l2, (List<MobSpawner>)list, true, null, World.Environment.getEnvironment((int)dimension), chunkGenerator, biomeProvider);
                WorldPersistentData dataStorage = serverLevel.w();
                this.a(dataStorage);
                this.at = new PersistentCommandStorage(dataStorage);
                this.server.scoreboardManager = new CraftScoreboardManager(this, serverLevel.g());
            } else {
                listener = this.H.create(this.j.o().c(GameRules.ab));
                ImmutableList spawners = GlobalConfiguration.get().misc.useDimensionTypeForCustomSpawners && this.ba().e(Registries.aN).d(customStem.a().a()).orElseThrow() == BuiltinDimensionTypes.a ? list : Collections.emptyList();
                serverLevel = new WorldServer(this, this.ay, levelStorageAccess, serverLevelData, dimensionKey, customStem, listener, isDebugWorld, l2, (List<MobSpawner>)spawners, true, this.J().N(), World.Environment.getEnvironment((int)dimension), chunkGenerator, biomeProvider);
            }
            primaryLevelData.a(this.getServerModName(), this.Q().a());
            this.addLevel(serverLevel);
            this.initWorld(serverLevel, primaryLevelData, this.j, worldOptions);
            this.ag().a(serverLevel);
            if (primaryLevelData.E() == null) continue;
            this.aM().a(primaryLevelData.E(), this.ba());
        }
        this.t();
        for (WorldServer serverLevel : this.L()) {
            this.prepareLevels(serverLevel.m().a.E, serverLevel);
            this.server.getPluginManager().callEvent((Event)new WorldLoadEvent((World)serverLevel.getWorld()));
        }
        ScoreboardServer scoreboard = this.aJ();
        Collection toRemove = scoreboard.g().stream().filter(team -> team.b().startsWith("collideRule_")).map(ScoreboardTeam::b).collect(Collectors.toList());
        for (String teamName : toRemove) {
            scoreboard.d(scoreboard.b(teamName));
        }
        if (!GlobalConfiguration.get().collisions.enablePlayerCollisions) {
            this.ag().collideRuleTeamName = StringUtils.left((String)("collideRule_" + ThreadLocalRandom.current().nextInt()), (int)16);
            ScoreboardTeam collideTeam = scoreboard.c(this.ag().collideRuleTeamName);
            collideTeam.b(false);
        }
        this.server.enablePlugins(PluginLoadOrder.POSTWORLD);
        this.server.spark.registerCommandBeforePlugins(this.server);
        this.server.spark.enableAfterPlugins(this.server);
        if (PluginInitializerManager.instance().pluginRemapper != null) {
            PluginInitializerManager.instance().pluginRemapper.pluginsEnabled();
        }
        PaperCommands.INSTANCE.setValid();
        LifecycleEventRunner.INSTANCE.callReloadableRegistrarEvent(LifecycleEvents.COMMANDS, PaperCommands.INSTANCE, Plugin.class, ReloadableRegistrarEvent.Cause.INITIAL);
        ((SimpleHelpMap)this.server.getHelpMap()).initializeCommands();
        this.server.getPluginManager().callEvent((Event)new ServerLoadEvent(ServerLoadEvent.LoadType.STARTUP));
        this.G.acceptConnections();
    }

    public void initWorld(WorldServer serverLevel, IWorldDataServer serverLevelData, SaveData saveData, WorldOptions worldOptions) {
        boolean isDebugWorld = saveData.A();
        if (serverLevel.generator != null) {
            serverLevel.getWorld().getPopulators().addAll(serverLevel.generator.getDefaultPopulators((World)serverLevel.getWorld()));
        }
        WorldBorder worldborder = serverLevel.F_();
        worldborder.a(serverLevelData.p());
        this.server.getPluginManager().callEvent((Event)new WorldInitEvent((World)serverLevel.getWorld()));
        if (!serverLevelData.n()) {
            try {
                MinecraftServer.a(serverLevel, serverLevelData, worldOptions.e(), isDebugWorld);
                serverLevelData.c(true);
                if (isDebugWorld) {
                    this.a(this.j);
                }
            }
            catch (Throwable var23) {
                CrashReport crashReport = CrashReport.a(var23, "Exception initializing level");
                try {
                    serverLevel.a(crashReport);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new ReportedException(crashReport);
            }
            serverLevelData.c(true);
        }
    }

    private static void a(WorldServer level, IWorldDataServer levelData, boolean generateBonusChest, boolean debug) {
        if (debug) {
            levelData.a(BlockPosition.c.b(80), 0.0f);
        } else {
            ChunkProviderServer chunkSource = level.m();
            if (level.generator != null) {
                Random rand = new Random(level.E());
                Location spawn = level.generator.getFixedSpawnLocation((World)level.getWorld(), rand);
                if (spawn != null) {
                    if (spawn.getWorld() != level.getWorld()) {
                        throw new IllegalStateException("Cannot set spawn point for " + levelData.e() + " to be in another world (" + spawn.getWorld().getName() + ")");
                    }
                    levelData.a(new BlockPosition(spawn.getBlockX(), spawn.getBlockY(), spawn.getBlockZ()), spawn.getYaw());
                    return;
                }
            }
            ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(chunkSource.i().b().a());
            int spawnHeight = chunkSource.g().a(level);
            if (spawnHeight < level.L_()) {
                BlockPosition worldPosition = chunkPos.l();
                spawnHeight = level.a(HeightMap.Type.b, worldPosition.u() + 8, worldPosition.w() + 8);
            }
            levelData.a(chunkPos.l().b(8, spawnHeight, 8), 0.0f);
            int i2 = 0;
            int i1 = 0;
            int i22 = 0;
            int i3 = -1;
            for (int i4 = 0; i4 < MathHelper.h(11); ++i4) {
                BlockPosition spawnPosInChunk;
                if (i2 >= -5 && i2 <= 5 && i1 >= -5 && i1 <= 5 && (spawnPosInChunk = WorldProviderNormal.a(level, new ChunkCoordIntPair(chunkPos.h + i2, chunkPos.i + i1))) != null) {
                    levelData.a(spawnPosInChunk, 0.0f);
                    break;
                }
                if (i2 == i1 || i2 < 0 && i2 == -i1 || i2 > 0 && i2 == 1 - i1) {
                    int i5 = i22;
                    i22 = -i3;
                    i3 = i5;
                }
                i2 += i22;
                i1 += i3;
            }
            if (generateBonusChest) {
                level.K_().a(Registries.aL).flatMap(registry -> registry.a(MiscOverworldFeatures.m)).ifPresent(holder -> ((WorldGenFeatureConfigured)holder.a()).a(level, chunkSource.g(), level.A, levelData.a()));
            }
        }
    }

    private void a(SaveData worldData) {
        worldData.a(EnumDifficulty.a);
        worldData.d(true);
        IWorldDataServer serverLevelData = worldData.I();
        serverLevelData.b(false);
        serverLevelData.a(false);
        serverLevelData.a(1000000000);
        serverLevelData.b(6000L);
        serverLevelData.a(EnumGamemode.d);
    }

    public void prepareLevels(WorldLoadListener listener, WorldServer serverLevel) {
        int i2;
        this.forceTicks = true;
        l.info("Preparing start region for dimension {}", (Object)serverLevel.ai().a());
        BlockPosition sharedSpawnPos = serverLevel.Z();
        listener.a(new ChunkCoordIntPair(sharedSpawnPos));
        ChunkProviderServer chunkSource = serverLevel.m();
        this.an = SystemUtils.d();
        serverLevel.a(sharedSpawnPos, serverLevel.aa());
        int _int = serverLevel.O().c(GameRules.ab);
        int n2 = i2 = _int > 0 ? MathHelper.h(WorldLoadListener.a(_int)) : 0;
        while (chunkSource.b() < i2) {
            this.executeModerately();
        }
        this.executeModerately();
        WorldServer serverLevel1 = serverLevel;
        ForcedChunk forcedChunksSavedData = serverLevel1.w().b(ForcedChunk.a(), "chunks");
        if (forcedChunksSavedData != null) {
            LongIterator longIterator = forcedChunksSavedData.b().iterator();
            while (longIterator.hasNext()) {
                long l2 = longIterator.nextLong();
                ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(l2);
                serverLevel1.m().a(chunkPos, true);
            }
        }
        this.executeModerately();
        listener.b();
        serverLevel.a(serverLevel.L.q() != EnumDifficulty.a && ((DedicatedServer)this).s.a().v);
        this.forceTicks = false;
    }

    public EnumGamemode u() {
        return this.j.k();
    }

    public boolean w_() {
        return this.j.l();
    }

    public abstract int k();

    public abstract int l();

    public abstract boolean m();

    public boolean a(boolean suppressLog, boolean flush, boolean forced) {
        return this.saveAllChunks(suppressLog, flush, forced, false);
    }

    public boolean saveAllChunks(boolean suppressLog, boolean flush, boolean forced, boolean close) {
        boolean flag = false;
        for (WorldServer serverLevel : this.L()) {
            if (!suppressLog) {
                l.info("Saving chunks for level '{}'/{}", (Object)serverLevel, (Object)serverLevel.ai().a());
            }
            serverLevel.save(null, flush, serverLevel.e && !forced, close);
            flag = true;
        }
        if (flush) {
            for (WorldServer serverLevel2 : this.L()) {
                l.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)serverLevel2.m().a.n());
            }
            l.info("ThreadedAnvilChunkStorage: All dimensions are saved");
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean b(boolean suppressLog, boolean flush, boolean forced) {
        boolean var4;
        try {
            this.aG = true;
            this.ag().h();
            var4 = this.a(suppressLog, flush, forced);
        }
        finally {
            this.aG = false;
        }
        return var4;
    }

    @Override
    public void close() {
        this.v();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasStopped() {
        Object object = this.stopLock;
        synchronized (object) {
            return this.hasStopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void v() {
        Iterator<WorldServer> iterator = this.stopLock;
        synchronized (iterator) {
            if (this.hasStopped) {
                return;
            }
            this.hasStopped = true;
        }
        if (!this.hasLoggedStop && this.isDebugging()) {
            TraceUtil.dumpTraceForThread("Server stopped");
        }
        this.shutdownThread = Thread.currentThread();
        WatchdogThread.doStop();
        if (this.A.e()) {
            this.aW();
        }
        l.info("Stopping server");
        CommandDispatcher.COMMAND_SENDING_POOL.shutdownNow();
        if (this.server != null) {
            this.server.spark.disable();
            this.server.disablePlugins();
            this.server.waitForAsyncTasksShutdown();
        }
        if (PluginInitializerManager.instance().pluginRemapper != null) {
            PluginInitializerManager.instance().pluginRemapper.shutdown();
        }
        this.ah().b();
        this.aG = true;
        if (this.Q != null) {
            l.info("Saving players");
            this.Q.h();
            this.Q.removeAll(this.isRestarting);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        l.info("Saving worlds");
        for (WorldServer serverLevel : this.L()) {
            if (serverLevel == null) continue;
            serverLevel.e = false;
        }
        this.saveAllChunks(false, true, false, true);
        this.aG = false;
        this.aA.close();
        try {
            this.f.close();
        }
        catch (IOException var4) {
            l.error("Failed to unlock level {}", (Object)this.f.f(), (Object)var4);
        }
        MCUtil.ASYNC_EXECUTOR.shutdown();
        try {
            MCUtil.ASYNC_EXECUTOR.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (SpigotConfig.saveUserCacheOnStopOnly) {
            l.info("Saving usercache.json");
            this.at().save(false);
        }
        l.info("Waiting for I/O tasks to complete...");
        MoonriseRegionFileIO.flush(this);
        l.info("All I/O tasks to complete");
        if (this instanceof DedicatedServer) {
            MoonriseCommon.haltExecutors();
        }
        SystemUtils.k();
        try {
            TerminalConsoleAppender.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        CustomLogManager.forceReset();
        this.i();
    }

    public String w() {
        return this.M;
    }

    @Override
    public void a_(String localIp) {
        this.M = localIp;
    }

    public boolean x() {
        return this.R;
    }

    public void a(boolean waitForServer) {
        this.safeShutdown(waitForServer, false);
    }

    public void safeShutdown(boolean waitForServer, boolean isRestarting) {
        this.isRestarting = isRestarting;
        this.hasLoggedStop = true;
        if (this.isDebugging()) {
            TraceUtil.dumpTraceForThread("Server stopped");
        }
        this.R = false;
        if (waitForServer) {
            try {
                this.aj.join();
            }
            catch (InterruptedException var3) {
                l.error("Error while shutting down", (Throwable)var3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void y() {
        try {
            if (!this.e()) {
                throw new IllegalStateException("Failed to initialize server");
            }
            this.an = SystemUtils.d();
            this.J = this.bC().orElse(null);
            this.I = this.bF();
            this.server.spark.enableBeforePlugins();
            l.info("Running delayed init tasks");
            this.server.getScheduler().mainThreadHeartbeat();
            long actualDoneTimeMs = System.currentTimeMillis() - org.bukkit.craftbukkit.Main.BOOT_TIME.toEpochMilli();
            l.info("Done ({})! For help, type \"help\"", (Object)String.format(Locale.ROOT, "%.3fs", (double)actualDoneTimeMs / 1000.0));
            WatchdogThread.tick();
            WatchdogThread.hasStarted = true;
            Arrays.fill(this.recentTps, 20.0);
            long tickSection = SystemUtils.d();
            if (GlobalConfiguration.isFirstStart) {
                l.info("*************************************************************************************");
                l.info("This is the first time you're starting this server.");
                l.info("It's recommended you read our 'Getting Started' documentation for guidance.");
                l.info("View this and more helpful information here: https://docs.papermc.io/paper/next-steps");
                l.info("*************************************************************************************");
            }
            while (this.R) {
                boolean flag;
                long l2;
                if (!this.E() && this.aC.a() && this.aC.d()) {
                    l2 = 0L;
                    this.ah = this.an = SystemUtils.d();
                } else {
                    l2 = this.aC.h();
                    long l1 = SystemUtils.d() - this.an;
                    if (l1 > o + 20L * l2 && this.an - this.ah >= q + 100L * l2) {
                        long l22 = l1 / l2;
                        if (this.server.getWarnOnOverload()) {
                            l.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)(l1 / TimeRange.b), (Object)l22);
                        }
                        this.an += l22 * l2;
                        this.ah = this.an;
                    }
                }
                long currentTime = SystemUtils.d();
                if (++currentTick % 20 == 0) {
                    long diff = currentTime - tickSection;
                    BigDecimal currentTps = TPS_BASE.divide(new BigDecimal(diff), 30, RoundingMode.HALF_UP);
                    this.tps1.add(currentTps, diff);
                    this.tps5.add(currentTps, diff);
                    this.tps15.add(currentTps, diff);
                    this.recentTps[0] = this.tps1.getAverage();
                    this.recentTps[1] = this.tps5.getAverage();
                    this.recentTps[2] = this.tps15.getAverage();
                    tickSection = currentTime;
                }
                boolean bl = flag = l2 == 0L;
                if (this.F) {
                    this.F = false;
                    this.E = new TimeProfiler(SystemUtils.d(), this.T);
                }
                this.lastTick = currentTime;
                this.an += l2;
                try (Profiler.a scope = Profiler.a(this.bI());){
                    GameProfilerFiller profilerFiller = Profiler.a();
                    profilerFiller.a("tick");
                    this.aJ.start();
                    this.a(flag ? () -> false : this::bu);
                    Throwable crash = this.chunkSystemCrash;
                    if (crash != null) {
                        this.chunkSystemCrash = null;
                        throw new RuntimeException("Chunk system crash propagated to tick()", crash);
                    }
                    this.aJ.end();
                    profilerFiller.b("nextTickWait");
                    this.aq = true;
                    this.ap = Math.max(SystemUtils.d() + l2, this.an);
                    this.bs();
                    this.x_();
                    this.bt();
                    if (flag) {
                        this.aC.e();
                    }
                    profilerFiller.c();
                    this.br();
                }
                finally {
                    this.aS();
                }
                this.ag = true;
                JvmProfiler.f.a(this.ax);
            }
            return;
        }
        catch (Throwable var69) {
            l.error("Encountered an unexpected exception", var69);
            CrashReport crashReport = MinecraftServer.b(var69);
            this.b(crashReport.f());
            Path path = this.D().resolve("crash-reports").resolve("crash-" + SystemUtils.f() + "-server.txt");
            if (crashReport.a(path, ReportType.a)) {
                l.error("This crash report has been saved to: {}", (Object)path.toAbsolutePath());
            } else {
                l.error("We were unable to save this crash report to disk.");
            }
            this.a(crashReport);
            return;
        }
        finally {
            try {
                this.S = true;
                this.v();
            }
            catch (Throwable var64) {
                l.error("Exception stopping the server", var64);
            }
            finally {
                if (this.i.f() != null) {
                    this.i.f().a();
                }
            }
        }
    }

    private void br() {
        long nanos = SystemUtils.d();
        if (this.g()) {
            this.f().a(nanos - this.ak);
        }
        this.ak = nanos;
    }

    private void bs() {
        if (this.g()) {
            this.al = SystemUtils.d();
            this.am = 0L;
        }
    }

    private void bt() {
        if (this.g()) {
            SampleLogger tickTimeLogger = this.f();
            tickTimeLogger.a(SystemUtils.d() - this.al - this.am, TpsDebugDimensions.c.ordinal());
            tickTimeLogger.a(this.am, TpsDebugDimensions.d.ordinal());
        }
    }

    private static CrashReport b(Throwable cause) {
        CrashReport report;
        ReportedException reportedException = null;
        for (Throwable throwable = cause; throwable != null; throwable = throwable.getCause()) {
            ReportedException reportedException1;
            if (!(throwable instanceof ReportedException)) continue;
            reportedException = reportedException1 = (ReportedException)throwable;
        }
        if (reportedException != null) {
            report = reportedException.a();
            if (reportedException != cause) {
                report.a("Wrapped in").a("Wrapping exception", cause);
            }
        } else {
            report = new CrashReport("Exception in server tick loop", cause);
        }
        return report;
    }

    private boolean bu() {
        return this.forceTicks || this.bB() || SystemUtils.d() < (this.aq ? this.ap : this.an);
    }

    private void executeModerately() {
        this.bA();
        LockSupport.parkNanos("executing tasks", 1000L);
    }

    public static boolean z() {
        RuntimeException runtimeException = aH.get();
        if (runtimeException != null) {
            throw runtimeException;
        }
        return true;
    }

    public static void a(RuntimeException fatalException) {
        aH.compareAndSet(null, fatalException);
    }

    @Override
    public void b(BooleanSupplier isDone) {
        super.b(() -> MinecraftServer.z() && isDone.getAsBoolean());
    }

    protected void x_() {
        this.bA();
        this.ao = true;
        try {
            this.b(() -> !this.bu());
        }
        finally {
            this.ao = false;
        }
    }

    @Override
    public void A() {
        boolean isTickTimeLoggingEnabled = this.g();
        long l2 = isTickTimeLoggingEnabled ? SystemUtils.d() : 0L;
        long l1 = this.ao ? this.an - SystemUtils.d() : 100000L;
        LockSupport.parkNanos("waiting for tasks", l1);
        if (isTickTimeLoggingEnabled) {
            this.am += SystemUtils.d() - l2;
        }
    }

    public TickTask a(Runnable runnable) {
        if (this.hasStopped && Thread.currentThread().equals(this.shutdownThread)) {
            runnable.run();
            runnable = () -> {};
        }
        return new TickTask(this.T, runnable);
    }

    protected boolean a(TickTask runnable) {
        return runnable.a() + 3 < this.T || this.bu();
    }

    @Override
    public boolean B() {
        boolean flag;
        this.aq = flag = this.bv();
        return flag;
    }

    private boolean bv() {
        if (super.B()) {
            this.moonrise$executeMidTickTasks();
            return true;
        }
        boolean ret = false;
        if (this.aC.a() || this.bu()) {
            for (WorldServer serverLevel : this.L()) {
                if (!serverLevel.m().d()) continue;
                ret = true;
            }
        }
        return ret;
    }

    public void b(TickTask task) {
        Profiler.a().f("runTask");
        super.d(task);
    }

    private Optional<ServerPing.a> bC() {
        Optional<Path> optional = Optional.of(this.c("server-icon.png")).filter(path -> java.nio.file.Files.isRegularFile(path, new LinkOption[0])).or(() -> this.f.j().filter(path -> java.nio.file.Files.isRegularFile(path, new LinkOption[0])));
        return optional.flatMap(path -> {
            try {
                BufferedImage bufferedImage = ImageIO.read(path.toFile());
                Preconditions.checkState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels wide");
                Preconditions.checkState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels high");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "PNG", byteArrayOutputStream);
                return Optional.of(new ServerPing.a(byteArrayOutputStream.toByteArray()));
            }
            catch (Exception var3) {
                l.error("Couldn't load server icon", (Throwable)var3);
                return Optional.empty();
            }
        });
    }

    public Optional<Path> C() {
        return this.f.j();
    }

    public Path D() {
        return Path.of("", new String[0]);
    }

    public void a(CrashReport report) {
    }

    public void i() {
    }

    public boolean E() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(BooleanSupplier hasTimeLeft) {
        WatchdogThread.tick();
        long nanos = SystemUtils.d();
        int i2 = this.bq() * 20;
        this.removeDisabledPluginsBlockingSleep();
        if (i2 > 0) {
            this.aF = this.Q.m() == 0 && !this.aC.a() && this.pluginsBlockingSleep.isEmpty() ? ++this.aF : 0;
            if (this.aF >= i2) {
                Runnable task;
                this.server.spark.tickStart();
                if (this.aF == i2) {
                    l.info("Server empty for {} seconds, pausing", (Object)this.bq());
                    this.bD();
                }
                this.server.getScheduler().mainThreadHeartbeat();
                while ((task = this.processQueue.poll()) != null) {
                    task.run();
                }
                for (WorldServer level : this.P.values()) {
                    level.m().a(() -> true, false);
                }
                this.server.spark.executeMainThreadTasks();
                this.G();
                this.server.spark.tickEnd((double)(System.nanoTime() - this.lastTick) / 1000000.0);
                return;
            }
        }
        this.server.spark.tickStart();
        new ServerTickStartEvent(this.T + 1).callEvent();
        ++this.T;
        this.aC.m();
        this.c(hasTimeLeft);
        if (nanos - this.ai >= s) {
            this.ai = nanos;
            this.I = this.bF();
        }
        --this.U;
        GameProfilerFiller profiler = Profiler.a();
        int playerSaveInterval = GlobalConfiguration.get().playerAutoSave.rate;
        if (playerSaveInterval < 0) {
            playerSaveInterval = this.autosavePeriod;
        }
        profiler.a("save");
        boolean fullSave = this.autosavePeriod > 0 && this.T % this.autosavePeriod == 0;
        try {
            this.aG = true;
            if (playerSaveInterval > 0) {
                this.Q.saveAll(playerSaveInterval);
            }
            for (WorldServer level : this.L()) {
                if (level.paperConfig().chunks.autoSaveInterval.value() <= 0) continue;
                level.saveIncrementally(fullSave);
            }
        }
        finally {
            this.aG = false;
        }
        profiler.c();
        GameProfilerFiller profilerFiller = Profiler.a();
        this.bA();
        this.server.spark.executeMainThreadTasks();
        long endTime = System.nanoTime();
        long remaining = 50000000L - (endTime - this.lastTick) - this.catchupTime;
        new ServerTickEndEvent(this.T, (double)(endTime - this.lastTick) / 1000000.0, remaining).callEvent();
        this.server.spark.tickEnd((double)(endTime - this.lastTick) / 1000000.0);
        profilerFiller.a("tallying");
        long l2 = SystemUtils.d() - nanos;
        int i1 = this.T % 100;
        this.ac -= this.ab[i1];
        this.ac += l2;
        this.ab[i1] = l2;
        this.ax = this.ax * 0.8f + (float)l2 / (float)TimeRange.b * 0.19999999f;
        this.tickTimes5s.add(this.T, l2);
        this.tickTimes10s.add(this.T, l2);
        this.tickTimes60s.add(this.T, l2);
        this.a(nanos);
        profilerFiller.c();
    }

    private void bD() {
        this.U = this.autosavePeriod;
        l.debug("Autosave started");
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("save");
        this.b(true, false, false);
        profilerFiller.c();
        l.debug("Autosave finished");
    }

    private void a(long startTime) {
        if (this.g()) {
            this.f().a(SystemUtils.d() - startTime, TpsDebugDimensions.b.ordinal());
        }
    }

    private int bE() {
        float f2;
        if (this.aC.a()) {
            long l2 = this.aQ() + 1L;
            f2 = (float)TimeRange.a / (float)l2;
        } else {
            f2 = this.aC.f();
        }
        int i2 = 300;
        return Math.max(100, (int)(f2 * 300.0f));
    }

    public void F() {
        int i2 = this.bE();
        if (i2 < this.U) {
            this.U = i2;
        }
    }

    protected abstract SampleLogger f();

    public abstract boolean g();

    private ServerPing bF() {
        ServerPing.ServerPingPlayerSample players = this.bG();
        return new ServerPing(PaperAdventure.asVanilla(this.motd), Optional.of(players), Optional.of(ServerPing.ServerData.a()), Optional.ofNullable(this.J), this.aA());
    }

    private ServerPing.ServerPingPlayerSample bG() {
        List<EntityPlayer> players = this.Q.t();
        int maxPlayers = this.O();
        if (this.an()) {
            return new ServerPing.ServerPingPlayerSample(maxPlayers, players.size(), List.of());
        }
        int min = Math.min(players.size(), SpigotConfig.playerSample);
        ObjectArrayList list = new ObjectArrayList(min);
        int randomInt = MathHelper.a(this.K, 0, players.size() - min);
        for (int i2 = 0; i2 < min; ++i2) {
            EntityPlayer serverPlayer = players.get(randomInt + i2);
            list.add((Object)(serverPlayer.ab() ? serverPlayer.gh() : e));
        }
        SystemUtils.c(list, this.K);
        return new ServerPing.ServerPingPlayerSample(maxPlayers, players.size(), (List<GameProfile>)list);
    }

    protected void c(BooleanSupplier hasTimeLeft) {
        GameProfilerFiller profilerFiller = Profiler.a();
        this.ag().t().forEach(serverPlayer1 -> serverPlayer1.f.f());
        this.server.getScheduler().mainThreadHeartbeat();
        ((FoliaGlobalRegionScheduler)Bukkit.getGlobalRegionScheduler()).tick();
        this.L().forEach(level -> {
            for (Entity entity : level.H().a()) {
                CraftEntity bukkit;
                if (entity.dQ() || (bukkit = entity.getBukkitEntityRaw()) == null) continue;
                bukkit.taskScheduler.executeTick();
            }
        });
        ClickCallbackProviderImpl.CALLBACK_MANAGER.handleQueue(this.T);
        profilerFiller.a("commandFunctions");
        this.aE().b();
        profilerFiller.b("levels");
        while (!this.processQueue.isEmpty()) {
            this.processQueue.remove().run();
        }
        for (WorldServer level2 : this.L()) {
            boolean doDaylight = level2.O().b(GameRules.l);
            long dayTime = level2.ae();
            long worldTime = level2.ad();
            PacketPlayOutUpdateTime worldPacket = new PacketPlayOutUpdateTime(worldTime, dayTime, doDaylight);
            for (EntityHuman entityHuman : level2.z()) {
                if (!(entityHuman instanceof EntityPlayer) || (this.T + entityHuman.ar()) % 20 != 0) continue;
                EntityPlayer entityplayer = (EntityPlayer)entityHuman;
                long playerTime = entityplayer.getPlayerTime();
                boolean relativeTime = entityplayer.relativeTime;
                PacketPlayOutUpdateTime packet = (relativeTime || !doDaylight) && playerTime == dayTime ? worldPacket : new PacketPlayOutUpdateTime(worldTime, playerTime, relativeTime && doDaylight);
                entityplayer.f.b(packet);
            }
        }
        this.isIteratingOverLevels = true;
        for (WorldServer serverLevel : this.L()) {
            serverLevel.hasPhysicsEvent = BlockPhysicsEvent.getHandlerList().getRegisteredListeners().length > 0;
            serverLevel.hasEntityMoveEvent = EntityMoveEvent.getHandlerList().getRegisteredListeners().length > 0;
            serverLevel.updateLagCompensationTick();
            TileEntityHopper.skipHopperEvents = serverLevel.paperConfig().hopper.disableMoveEvent || InventoryMoveItemEvent.getHandlerList().getRegisteredListeners().length == 0;
            profilerFiller.a(() -> String.valueOf(serverLevel) + " " + String.valueOf(serverLevel.ai().a()));
            profilerFiller.a("tick");
            try {
                serverLevel.a(hasTimeLeft);
            }
            catch (Throwable var7) {
                CrashReport crashReport = CrashReport.a(var7, "Exception ticking world");
                serverLevel.a(crashReport);
                throw new ReportedException(crashReport);
            }
            profilerFiller.c();
            profilerFiller.c();
            serverLevel.explosionDensityCache.clear();
        }
        this.isIteratingOverLevels = false;
        profilerFiller.b("connection");
        this.G();
        profilerFiller.b("players");
        this.Q.d();
        if (SharedConstants.aU && this.aC.i()) {
            GameTestHarnessTicker.a.b();
        }
        profilerFiller.b("server gui refresh");
        for (int i2 = 0; i2 < this.z.size(); ++i2) {
            this.z.get(i2).run();
        }
        profilerFiller.b("send chunks");
        for (EntityPlayer serverPlayer : this.Q.t()) {
            serverPlayer.f.g.a(serverPlayer);
            serverPlayer.f.g();
        }
        profilerFiller.c();
    }

    public void G() {
        this.ah().c();
    }

    private void b(WorldServer level) {
        this.Q.a(new PacketPlayOutUpdateTime(level.ad(), level.ae(), level.O().b(GameRules.l)), level.ai());
    }

    public void H() {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("timeSync");
        for (WorldServer serverLevel : this.L()) {
            this.b(serverLevel);
        }
        profilerFiller.c();
    }

    public boolean a(net.minecraft.world.level.World level) {
        return true;
    }

    public void b(Runnable tickable) {
        this.z.add(tickable);
    }

    protected void b(String serverId) {
        this.az = serverId;
    }

    public boolean I() {
        return !this.aj.isAlive();
    }

    public Path c(String path) {
        return this.D().resolve(path);
    }

    public final WorldServer J() {
        return this.P.get(net.minecraft.world.level.World.i);
    }

    @Nullable
    public WorldServer a(ResourceKey<net.minecraft.world.level.World> dimension) {
        return this.P.get(dimension);
    }

    public void addLevel(WorldServer level) {
        Map<ResourceKey<net.minecraft.world.level.World>, WorldServer> oldLevels = this.P;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.put(level.ai(), level);
        this.P = Collections.unmodifiableMap(newLevels);
    }

    public void removeLevel(WorldServer level) {
        Map<ResourceKey<net.minecraft.world.level.World>, WorldServer> oldLevels = this.P;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.remove(level.ai());
        this.P = Collections.unmodifiableMap(newLevels);
    }

    public Set<ResourceKey<net.minecraft.world.level.World>> K() {
        return this.P.keySet();
    }

    public Iterable<WorldServer> L() {
        return this.P.values();
    }

    @Override
    public String M() {
        return SharedConstants.b().c();
    }

    @Override
    public int N() {
        return this.Q.m();
    }

    @Override
    public int O() {
        return this.Q.n();
    }

    public String[] P() {
        return this.Q.e();
    }

    @DontObfuscate
    public String getServerModName() {
        return ServerBuildInfo.buildInfo().brandName();
    }

    public SystemReport b(SystemReport systemReport) {
        systemReport.a("Server Running", () -> Boolean.toString(this.R));
        if (this.Q != null) {
            systemReport.a("Player Count", () -> this.Q.m() + " / " + this.Q.n() + "; " + String.valueOf(this.Q.t()));
        }
        systemReport.a("Active Data Packs", () -> ResourcePackRepository.a(this.ar.g()));
        systemReport.a("Available Data Packs", () -> ResourcePackRepository.a(this.ar.d()));
        systemReport.a("Enabled Feature Flags", () -> FeatureFlags.e.b(this.j.K()).stream().map(MinecraftKey::toString).collect(Collectors.joining(", ")));
        systemReport.a("World Generation", () -> this.j.B().toString());
        systemReport.a("World Seed", () -> String.valueOf(this.j.y().c()));
        systemReport.a("Suppressed Exceptions", this.aI::a);
        if (this.az != null) {
            systemReport.a("Server Id", () -> this.az);
        }
        return this.a(systemReport);
    }

    public abstract SystemReport a(SystemReport var1);

    public ModCheck Q() {
        return ModCheck.a(b, this::getServerModName, "Server", MinecraftServer.class);
    }

    @Override
    public void a(IChatBaseComponent component) {
        l.info((String)PaperAdventure.ANSI_SERIALIZER.serialize(PaperAdventure.asAdventure(component)));
    }

    public KeyPair R() {
        return this.ad;
    }

    public int S() {
        return this.N;
    }

    public void a(int port) {
        this.N = port;
    }

    @Nullable
    public GameProfile T() {
        return this.ae;
    }

    public void b(@Nullable GameProfile singleplayerProfile) {
        this.ae = singleplayerProfile;
    }

    public boolean U() {
        return this.ae != null;
    }

    protected void V() {
        l.info("Generating keypair");
        try {
            this.ad = MinecraftEncryption.b();
        }
        catch (CryptographyException var2) {
            throw new IllegalStateException("Failed to generate key pair", var2);
        }
    }

    public void setDifficulty(WorldServer level, EnumDifficulty difficulty, boolean forceUpdate) {
        WorldDataServer worldData = level.L;
        if (forceUpdate || !worldData.r()) {
            worldData.a(worldData.l() ? EnumDifficulty.d : difficulty);
            level.a(worldData.q() != EnumDifficulty.a && ((DedicatedServer)this).s.a().v);
        }
    }

    public int b(int trackingDistance) {
        return trackingDistance;
    }

    private void bH() {
        for (WorldServer serverLevel : this.L()) {
            serverLevel.a(serverLevel.L.q() != EnumDifficulty.a && ((DedicatedServer)this).s.a().v);
        }
    }

    public void b(boolean locked) {
        this.j.d(locked);
        this.ag().t().forEach(this::c);
    }

    private void c(EntityPlayer player) {
        WorldData levelData = player.dV().D_();
        player.f.b(new PacketPlayOutServerDifficulty(levelData.q(), levelData.r()));
    }

    public boolean W() {
        return this.j.q() != EnumDifficulty.a;
    }

    public boolean X() {
        return this.af;
    }

    public void c(boolean demo) {
        this.af = demo;
    }

    public Optional<ServerResourcePackInfo> Y() {
        return Optional.empty();
    }

    public boolean Z() {
        return this.Y().filter(ServerResourcePackInfo::d).isPresent();
    }

    public abstract boolean n();

    public abstract int o();

    public boolean aa() {
        return this.V;
    }

    @Override
    public void d(boolean online) {
        this.V = online;
    }

    public boolean ab() {
        return this.W;
    }

    public void e(boolean preventProxyConnections) {
        this.W = preventProxyConnections;
    }

    public abstract boolean p();

    public boolean ac() {
        return this.X;
    }

    public void f(boolean allowPvp) {
        this.X = allowPvp;
    }

    public boolean ad() {
        return this.Y;
    }

    public void g(boolean allow) {
        this.Y = allow;
    }

    public abstract boolean q();

    @Override
    public String ae() {
        return LegacyComponentSerializer.legacySection().serialize(this.motd);
    }

    @Override
    public void d(String motd) {
        this.motd = LegacyComponentSerializer.legacySection().deserializeOr((Object)motd, (Component)Component.empty());
    }

    public Component motd() {
        return this.motd;
    }

    public void motd(Component motd) {
        this.motd = motd;
    }

    public boolean af() {
        return this.S;
    }

    public PlayerList ag() {
        return this.Q;
    }

    public void a(PlayerList list) {
        this.Q = list;
    }

    public abstract boolean r();

    public void a(EnumGamemode gameMode) {
        this.j.a(gameMode);
    }

    public ServerConnection ah() {
        return this.G == null ? (this.G = new ServerConnection(this)) : this.G;
    }

    public boolean ai() {
        return this.ag;
    }

    public boolean aj() {
        return false;
    }

    public boolean a(@Nullable EnumGamemode gameMode, boolean commands, int port) {
        return false;
    }

    public int ak() {
        return this.T;
    }

    public int al() {
        return 16;
    }

    public boolean a(WorldServer level, BlockPosition pos, EntityHuman player) {
        return false;
    }

    public boolean am() {
        return true;
    }

    public boolean an() {
        return false;
    }

    public Proxy ao() {
        return this.h;
    }

    public int ap() {
        return this.aa;
    }

    public void c(int idleTimeout) {
        this.aa = idleTimeout;
    }

    public MinecraftSessionService aq() {
        return this.i.c();
    }

    @Nullable
    public SignatureValidator ar() {
        return this.i.a();
    }

    public GameProfileRepository as() {
        return this.i.e();
    }

    @Nullable
    public UserCache at() {
        return this.i.f();
    }

    @Nullable
    public ServerPing au() {
        return this.I;
    }

    public void av() {
        this.ai = 0L;
    }

    public int aw() {
        return 29999984;
    }

    @Override
    public boolean ax() {
        return super.ax() && !this.af();
    }

    @Override
    public void c(Runnable task) {
        if (this.af()) {
            throw new ServerStopRejectedExecutionException("Server already shutting down");
        }
        super.c(task);
    }

    @Override
    public Thread ay() {
        return this.aj;
    }

    public int az() {
        return 256;
    }

    public boolean aA() {
        return false;
    }

    public long aB() {
        return this.an;
    }

    public DataFixer aC() {
        return this.L;
    }

    public int a(@Nullable WorldServer level) {
        return level != null ? level.O().c(GameRules.s) : 10;
    }

    public AdvancementDataWorld aD() {
        return this.aA.b.e();
    }

    public CustomFunctionData aE() {
        return this.av;
    }

    @Override
    @Deprecated
    @DoNotUse
    public CompletableFuture<Void> a(Collection<String> selectedIds) {
        return this.reloadResources(selectedIds, ServerResourcesReloadedEvent.Cause.PLUGIN);
    }

    public CompletableFuture<Void> reloadResources(Collection<String> selectedIds, ServerResourcesReloadedEvent.Cause cause) {
        CompletionStage completableFuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> (ImmutableList)selectedIds.stream().map(this.ar::c).filter(Objects::nonNull).map(ResourcePackLoader::f).collect(ImmutableList.toImmutableList()), this).thenCompose(list -> {
            ResourceManager closeableResourceManager = new ResourceManager(EnumResourcePackType.b, (List<IResourcePack>)list);
            List<IRegistry.a<?>> list1 = TagDataPack.loadTagsForExistingRegistries(closeableResourceManager, this.O.a(), ReloadableRegistrarEvent.Cause.RELOAD);
            return ((CompletableFuture)DataPackResources.a(closeableResourceManager, this.O, list1, this.j.K(), this.n() ? CommandDispatcher.ServerType.b : CommandDispatcher.ServerType.c, this.l(), this.ay, this).whenComplete((reloadableServerResources, throwable) -> {
                if (throwable != null) {
                    closeableResourceManager.close();
                }
            })).thenApply(reloadableServerResources -> new ReloadableResources(closeableResourceManager, (DataPackResources)reloadableServerResources));
        })).thenAcceptAsync(reloadableResources -> {
            PaperBrigadier.moveBukkitCommands(this.aA.b().d(), reloadableResources.b().d);
            this.aA.close();
            this.aA = reloadableResources;
            this.ar.setSelected(selectedIds, false);
            WorldDataConfiguration worldDataConfiguration = new WorldDataConfiguration(MinecraftServer.a(this.ar, true), this.j.K());
            this.j.a(worldDataConfiguration);
            this.aA.b.g();
            this.aA.b.c().a(this.j.K());
            this.aD = this.aD.reload(this.j.K());
            if (Thread.currentThread() != this.aj) {
                return;
            }
            for (EntityPlayer player : this.ag().t()) {
                player.S().b();
            }
            this.ag().u();
            this.av.a(this.aA.b.a());
            this.aB.a(this.aA.a);
            this.aE = FuelValues.a(this.O.a(), this.j.K());
            CraftBlockData.reloadCache();
            PaperCommands.INSTANCE.setValid();
            LifecycleEventRunner.INSTANCE.callReloadableRegistrarEvent(LifecycleEvents.COMMANDS, PaperCommands.INSTANCE, Plugin.class, ReloadableRegistrarEvent.Cause.RELOAD);
            SimpleHelpMap helpMap = (SimpleHelpMap)this.server.getHelpMap();
            helpMap.clear();
            helpMap.initializeGeneralTopics();
            helpMap.initializeCommands();
            this.server.syncCommands();
            new ServerResourcesReloadedEvent(cause).callEvent();
        }, (Executor)this);
        if (this.bx()) {
            this.b(((CompletableFuture)completableFuture)::isDone);
        }
        return completableFuture;
    }

    public static WorldDataConfiguration a(ResourcePackRepository packRepository, WorldDataConfiguration initialDataConfig, boolean initMode, boolean safeMode) {
        DataPackConfiguration dataPackConfig = initialDataConfig.a();
        FeatureFlagSet featureFlagSet = initMode ? FeatureFlagSet.a() : initialDataConfig.b();
        FeatureFlagSet featureFlagSet1 = initMode ? FeatureFlags.e.a() : initialDataConfig.b();
        packRepository.reload(true);
        if (safeMode) {
            return MinecraftServer.a(packRepository, List.of(b), featureFlagSet, false);
        }
        LinkedHashSet set = Sets.newLinkedHashSet();
        for (String string : dataPackConfig.a()) {
            if (packRepository.d(string)) {
                set.add(string);
                continue;
            }
            l.warn("Missing data pack {}", (Object)string);
        }
        for (ResourcePackLoader pack : packRepository.d()) {
            String id = pack.g();
            if (dataPackConfig.b().contains(id)) continue;
            FeatureFlagSet requestedFeatures = pack.e();
            boolean flag = set.contains(id);
            if (!flag && pack.l().a()) {
                if (requestedFeatures.a(featureFlagSet1)) {
                    l.info("Found new data pack {}, loading it automatically", (Object)id);
                    set.add(id);
                } else {
                    l.info("Found new data pack {}, but can't load it due to missing features {}", (Object)id, (Object)FeatureFlags.a(featureFlagSet1, requestedFeatures));
                }
            }
            if (!flag || requestedFeatures.a(featureFlagSet1)) continue;
            l.warn("Pack {} requires features {} that are not enabled for this world, disabling pack.", (Object)id, (Object)FeatureFlags.a(featureFlagSet1, requestedFeatures));
            set.remove(id);
        }
        if (set.isEmpty()) {
            l.info("No datapacks selected, forcing vanilla");
            set.add(b);
        }
        return MinecraftServer.a(packRepository, set, featureFlagSet, true);
    }

    private static WorldDataConfiguration a(ResourcePackRepository packRepository, Collection<String> selectedPacks, FeatureFlagSet enabledFeatures, boolean safeMode) {
        packRepository.setSelected(selectedPacks, true);
        MinecraftServer.a(packRepository, enabledFeatures);
        DataPackConfiguration selectedPacks1 = MinecraftServer.a(packRepository, safeMode);
        FeatureFlagSet featureFlagSet = packRepository.f().c(enabledFeatures);
        return new WorldDataConfiguration(selectedPacks1, featureFlagSet);
    }

    private static void a(ResourcePackRepository packRepository, FeatureFlagSet enabledFeatures) {
        FeatureFlagSet requestedFeatureFlags = packRepository.f();
        FeatureFlagSet featureFlagSet = enabledFeatures.d(requestedFeatureFlags);
        if (!featureFlagSet.b()) {
            ObjectArraySet set = new ObjectArraySet(packRepository.e());
            for (ResourcePackLoader pack : packRepository.d()) {
                if (featureFlagSet.b()) break;
                if (pack.l() != PackSource.d) continue;
                String id = pack.g();
                FeatureFlagSet requestedFeatures = pack.e();
                if (requestedFeatures.b() || !requestedFeatures.b(featureFlagSet) || !requestedFeatures.a(enabledFeatures)) continue;
                if (!set.add(id)) {
                    throw new IllegalStateException("Tried to force '" + id + "', but it was already enabled");
                }
                l.info("Found feature pack ('{}') for requested feature, forcing to enabled", (Object)id);
                featureFlagSet = featureFlagSet.d(requestedFeatures);
            }
            packRepository.setSelected((Collection<String>)set, true);
        }
    }

    private static DataPackConfiguration a(ResourcePackRepository packRepository, boolean safeMode) {
        Collection<String> selectedIds = packRepository.e();
        ImmutableList list = ImmutableList.copyOf(selectedIds);
        List<String> list1 = safeMode ? packRepository.c().stream().filter(packId -> !selectedIds.contains(packId)).toList() : List.of();
        return new DataPackConfiguration((List<String>)list, list1);
    }

    public void a(CommandListenerWrapper commandSource) {
        if (this.aN()) {
            PlayerList playerList = commandSource.l().ag();
            if (!playerList.o()) {
                return;
            }
            WhiteList whiteList = playerList.i();
            for (EntityPlayer serverPlayer : Lists.newArrayList(playerList.t())) {
                if (whiteList.a(serverPlayer.gh()) || this.ag().f(serverPlayer.gh())) continue;
                serverPlayer.f.disconnect((Component)Component.text((String)SpigotConfig.whitelistMessage), PlayerKickEvent.Cause.WHITELIST);
            }
        }
    }

    public ResourcePackRepository aF() {
        return this.ar;
    }

    public CommandDispatcher aG() {
        return this.aA.b.d();
    }

    public CommandListenerWrapper aH() {
        WorldServer serverLevel = this.J();
        return new CommandListenerWrapper(this, serverLevel == null ? Vec3D.c : Vec3D.a(serverLevel.Z()), Vec2F.a, serverLevel, 4, "Server", IChatBaseComponent.b("Server"), this, null);
    }

    @Override
    public boolean y_() {
        return true;
    }

    @Override
    public boolean z_() {
        return true;
    }

    @Override
    public abstract boolean c();

    public CraftingManager aI() {
        return this.aA.b.c();
    }

    public ScoreboardServer aJ() {
        return this.as;
    }

    public PersistentCommandStorage aK() {
        if (this.at == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.at;
    }

    public GameRules aL() {
        return this.J().O();
    }

    public BossBattleCustomData aM() {
        return this.au;
    }

    public boolean aN() {
        return this.aw;
    }

    public void h(boolean whitelistEnabled) {
        this.aw = whitelistEnabled;
    }

    public float aO() {
        return this.ax;
    }

    public ServerTickRateManager aP() {
        return this.aC;
    }

    public long aQ() {
        return this.ac / (long)Math.min(100, Math.max(this.T, 1));
    }

    public long[] aR() {
        return this.ab;
    }

    public int c(GameProfile profile) {
        if (this.ag().f(profile)) {
            OpListEntry serverOpListEntry = (OpListEntry)this.ag().k().b(profile);
            if (serverOpListEntry != null) {
                return serverOpListEntry.a();
            }
            if (this.a(profile)) {
                return 4;
            }
            if (this.U()) {
                return this.ag().v() ? 4 : 0;
            }
            return this.k();
        }
        return 0;
    }

    public abstract boolean a(GameProfile var1);

    public void a(Path path) throws IOException {
    }

    private void b(Path path) {
        Path path1 = path.resolve("levels");
        try {
            for (Map.Entry<ResourceKey<net.minecraft.world.level.World>, WorldServer> entry : this.P.entrySet()) {
                MinecraftKey resourceLocation = entry.getKey().a();
                Path path2 = path1.resolve(resourceLocation.b()).resolve(resourceLocation.a());
                java.nio.file.Files.createDirectories(path2, new FileAttribute[0]);
                entry.getValue().a(path2);
            }
            this.d(path.resolve("gamerules.txt"));
            this.e(path.resolve("classpath.txt"));
            this.c(path.resolve("stats.txt"));
            this.f(path.resolve("threads.txt"));
            this.a(path.resolve("server.properties.txt"));
            this.g(path.resolve("modules.txt"));
        }
        catch (IOException var7) {
            l.warn("Failed to save debug report", (Throwable)var7);
        }
    }

    private void c(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedWriter.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.by()));
            bufferedWriter.write(String.format(Locale.ROOT, "average_tick_time: %f\n", Float.valueOf(this.aO())));
            bufferedWriter.write(String.format(Locale.ROOT, "tick_times: %s\n", Arrays.toString(this.ab)));
            bufferedWriter.write(String.format(Locale.ROOT, "queue: %s\n", SystemUtils.h()));
        }
    }

    @Override
    private void d(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            final ArrayList list = Lists.newArrayList();
            final GameRules gameRules = this.aL();
            gameRules.a(new GameRules.GameRuleVisitor(){

                @Override
                public <T extends GameRules.GameRuleValue<T>> void a(GameRules.GameRuleKey<T> key, GameRules.GameRuleDefinition<T> type) {
                    list.add(String.format(Locale.ROOT, "%s=%s\n", key.a(), gameRules.a(key)));
                }
            });
            for (String string : list) {
                bufferedWriter.write(string);
            }
        }
    }

    private void e(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            String property = System.getProperty("java.class.path");
            String property1 = System.getProperty("path.separator");
            for (String string : Splitter.on((String)property1).split((CharSequence)property)) {
                bufferedWriter.write(string);
                bufferedWriter.write("\n");
            }
        }
    }

    private void f(Path path) throws IOException {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfos = threadMxBean.dumpAllThreads(true, true);
        Arrays.sort(threadInfos, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter bufferedWriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            for (ThreadInfo threadInfo : threadInfos) {
                bufferedWriter.write(threadInfo.toString());
                ((Writer)bufferedWriter).write(10);
            }
        }
    }

    private void g(Path path) throws IOException {
        BufferedWriter bufferedWriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);
        try {
            ArrayList list;
            try {
                list = Lists.newArrayList(NativeModuleLister.a());
            }
            catch (Throwable var7) {
                l.warn("Failed to list native modules", var7);
                if (bufferedWriter != null) {
                    ((Writer)bufferedWriter).close();
                }
                return;
            }
            list.sort(Comparator.comparing(nativeModuleInfo1 -> nativeModuleInfo1.a));
            for (NativeModuleLister.a nativeModuleInfo : list) {
                bufferedWriter.write(nativeModuleInfo.toString());
                ((Writer)bufferedWriter).write(10);
            }
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    ((Writer)bufferedWriter).close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    @Override
    public boolean bx() {
        return TickThread.isTickThread();
    }

    public boolean isDebugging() {
        return false;
    }

    public static MinecraftServer getServer() {
        return SERVER;
    }

    @Deprecated
    public static IRegistryCustom getDefaultRegistryAccess() {
        return CraftRegistry.getMinecraftRegistry();
    }

    private GameProfilerFiller bI() {
        if (this.D) {
            this.A = ActiveMetricsRecorder.a(new ServerMetricsSamplersProvider(SystemUtils.c, this.n()), SystemUtils.c, SystemUtils.i(), new MetricsPersister("server"), this.B, path -> {
                this.h(() -> this.b(path.resolve("server")));
                this.C.accept((Path)path);
            });
            this.D = false;
        }
        this.A.c();
        return GameProfilerTick.a(this.A.f(), GameProfilerTick.a("Server"));
    }

    public void aS() {
        this.A.d();
    }

    public boolean aT() {
        return this.A.e();
    }

    public void a(Consumer<MethodProfilerResults> output, Consumer<Path> onMetricsRecordingFinished) {
        this.B = profileResults -> {
            this.aU();
            output.accept((MethodProfilerResults)profileResults);
        };
        this.C = onMetricsRecordingFinished;
        this.D = true;
    }

    public void aU() {
        this.A = InactiveMetricsRecorder.a;
    }

    public void aV() {
        this.A.a();
    }

    public void aW() {
        this.A.b();
    }

    public Path a(SavedFile levelResource) {
        return this.f.a(levelResource);
    }

    public boolean aX() {
        return true;
    }

    public StructureTemplateManager aY() {
        return this.aB;
    }

    public SaveData aZ() {
        return this.j;
    }

    public IRegistryCustom.Dimension ba() {
        return this.O.a();
    }

    public LayeredRegistryAccess<RegistryLayer> bb() {
        return this.O;
    }

    public ReloadableServerRegistries.a bc() {
        return this.aA.b.b();
    }

    public ITextFilter a(EntityPlayer player) {
        return ITextFilter.e;
    }

    public PlayerInteractManager b(EntityPlayer player) {
        return this.X() ? new DemoPlayerInteractManager(player) : new PlayerInteractManager(player);
    }

    @Nullable
    public EnumGamemode bd() {
        return null;
    }

    public IResourceManager be() {
        return this.aA.a;
    }

    public boolean bf() {
        return this.aG;
    }

    public boolean bg() {
        return this.F || this.E != null;
    }

    public void bh() {
        this.F = true;
    }

    public MethodProfilerResults bi() {
        if (this.E == null) {
            return MethodProfilerResultsEmpty.a;
        }
        MethodProfilerResults profileResults = this.E.a(SystemUtils.d(), this.T);
        this.E = null;
        return profileResults;
    }

    public int bj() {
        return 1000000;
    }

    public void a(IChatBaseComponent content, ChatMessageType.a boundChatType, @Nullable String header) {
        Component string = PaperAdventure.asAdventure(boundChatType.a(content));
        if (header != null) {
            COMPONENT_LOGGER.info("[{}] {}", (Object)header, (Object)string);
        } else {
            COMPONENT_LOGGER.info("{}", (Object)string);
        }
    }

    public ChatDecorator bk() {
        return this.improvedChatDecorator;
    }

    public boolean bl() {
        return true;
    }

    public void a(EntityPlayer player, RemoteDebugSampleType sampleType) {
    }

    public boolean bm() {
        return false;
    }

    private void a(CrashReport crashReport, ChunkCoordIntPair chunkPos, RegionStorageInfo regionStorageInfo) {
        SystemUtils.i().execute(() -> {
            try {
                Path file = this.c("debug");
                FileUtils.c(file);
                String string = FileUtils.a(regionStorageInfo.a());
                Path path = file.resolve("chunk-" + string + "-" + SystemUtils.f() + "-server.txt");
                FileStore fileStore = java.nio.file.Files.getFileStore(file);
                long usableSpace = fileStore.getUsableSpace();
                if (usableSpace < 8192L) {
                    l.warn("Not storing chunk IO report due to low space on drive {}", (Object)fileStore.name());
                    return;
                }
                CrashReportSystemDetails crashReportCategory = crashReport.a("Chunk Info");
                crashReportCategory.a("Level", regionStorageInfo::a);
                crashReportCategory.a("Dimension", () -> regionStorageInfo.b().a().toString());
                crashReportCategory.a("Storage", regionStorageInfo::c);
                crashReportCategory.a("Position", chunkPos::toString);
                crashReport.a(path, ReportType.e);
                l.info("Saved details to {}", (Object)crashReport.e());
            }
            catch (Exception var11) {
                l.warn("Failed to store chunk IO exception", (Throwable)var11);
            }
        });
    }

    @Override
    public void a(Throwable throwable, RegionStorageInfo regionStorageInfo, ChunkCoordIntPair chunkPos) {
        l.error("Failed to load chunk {},{}", new Object[]{chunkPos.h, chunkPos.i, throwable});
        this.aI.a("chunk/load", throwable);
        this.a(CrashReport.a(throwable, "Chunk load failure"), chunkPos, regionStorageInfo);
    }

    @Override
    public void b(Throwable throwable, RegionStorageInfo regionStorageInfo, ChunkCoordIntPair chunkPos) {
        l.error("Failed to save chunk {},{}", new Object[]{chunkPos.h, chunkPos.i, throwable});
        this.aI.a("chunk/save", throwable);
        this.a(CrashReport.a(throwable, "Chunk save failure"), chunkPos, regionStorageInfo);
    }

    public void a(Throwable throwable, PacketType<?> packetType) {
        this.aI.a("packet/" + packetType.toString(), throwable);
    }

    public PotionBrewer bn() {
        return this.aD;
    }

    public FuelValues bo() {
        return this.aE;
    }

    public ServerLinks bp() {
        return ServerLinks.a;
    }

    protected int bq() {
        return 0;
    }

    public boolean isTickPaused() {
        return this.aF > 0 && this.aF >= this.bq() * 20;
    }

    public void addPluginAllowingSleep(String pluginName, boolean value) {
        if (!value) {
            this.pluginsBlockingSleep.add(pluginName);
        } else {
            this.pluginsBlockingSleep.remove(pluginName);
        }
    }

    private void removeDisabledPluginsBlockingSleep() {
        if (this.pluginsBlockingSleep.isEmpty()) {
            return;
        }
        this.pluginsBlockingSleep.removeIf(plugin -> !PaperPluginManagerImpl.getInstance().isPluginEnabled((String)plugin));
    }

    private static /* synthetic */ boolean lambda$stopServer$9() {
        return true;
    }

    private static /* synthetic */ boolean lambda$stopServer$8(WorldServer level) {
        return level.m().a.e();
    }

    static {
        l = LogUtils.getLogger();
        COMPONENT_LOGGER = ComponentLogger.logger((String)l.getName());
        o = 30L * TimeRange.a / 20L;
        q = 10L * TimeRange.a;
        s = 5L * TimeRange.a;
        t = 10L * TimeRange.b;
        d = new WorldSettings("Demo World", EnumGamemode.a, false, EnumDifficulty.c, false, new GameRules(FeatureFlags.h), WorldDataConfiguration.c);
        e = new GameProfile(SystemUtils.e, "Anonymous Player");
        aH = new AtomicReference();
        SERVER_INIT = System.nanoTime();
        TPS_BASE = new BigDecimal(1.0E9).multiply(new BigDecimal(20));
    }

    public static class TickTimes {
        private final long[] times;

        public TickTimes(int length) {
            this.times = new long[length];
        }

        void add(int index, long time) {
            this.times[index % this.times.length] = time;
        }

        public long[] getTimes() {
            return (long[])this.times.clone();
        }

        public double getAverage() {
            long total = 0L;
            for (long value : this.times) {
                total += value;
            }
            return (double)total / (double)this.times.length * 1.0E-6;
        }
    }

    public static class RollingAverage {
        private final int size;
        private long time;
        private BigDecimal total;
        private int index = 0;
        private final BigDecimal[] samples;
        private final long[] times;

        RollingAverage(int size) {
            this.size = size;
            this.time = (long)size * 1000000000L;
            this.total = RollingAverage.dec(20L).multiply(RollingAverage.dec(1000000000L)).multiply(RollingAverage.dec(size));
            this.samples = new BigDecimal[size];
            this.times = new long[size];
            for (int i2 = 0; i2 < size; ++i2) {
                this.samples[i2] = RollingAverage.dec(20L);
                this.times[i2] = 1000000000L;
            }
        }

        private static BigDecimal dec(long t2) {
            return new BigDecimal(t2);
        }

        public void add(BigDecimal x2, long t2) {
            this.time -= this.times[this.index];
            this.total = this.total.subtract(this.samples[this.index].multiply(RollingAverage.dec(this.times[this.index])));
            this.samples[this.index] = x2;
            this.times[this.index] = t2;
            this.time += t2;
            this.total = this.total.add(x2.multiply(RollingAverage.dec(t2)));
            if (++this.index == this.size) {
                this.index = 0;
            }
        }

        public double getAverage() {
            return this.total.divide(RollingAverage.dec(this.time), 30, RoundingMode.HALF_UP).doubleValue();
        }
    }

    public record ReloadableResources(IReloadableResourceManager a, DataPackResources b) implements AutoCloseable
    {
        @Override
        public void close() {
            this.a.close();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "a", "b"}, this, o2);
        }
    }

    static class TimeProfiler {
        final long a;
        final int b;

        TimeProfiler(long startNanos, int startTick) {
            this.a = startNanos;
            this.b = startTick;
        }

        MethodProfilerResults a(final long endTimeNano, final int endTimeTicks) {
            return new MethodProfilerResults(){

                @Override
                public List<MethodProfilerResultsField> a(String sectionPath) {
                    return Collections.emptyList();
                }

                @Override
                public boolean a(Path path) {
                    return false;
                }

                @Override
                public long a() {
                    return a;
                }

                @Override
                public int b() {
                    return b;
                }

                @Override
                public long c() {
                    return endTimeNano;
                }

                @Override
                public int d() {
                    return endTimeTicks;
                }

                @Override
                public String e() {
                    return "";
                }
            };
        }
    }

    public record ServerResourcePackInfo(UUID a, String b, String c, boolean d, @Nullable IChatBaseComponent e) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ServerResourcePackInfo.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ServerResourcePackInfo.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ServerResourcePackInfo.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this, o2);
        }
    }
}

