/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import io.papermc.paper.registry.PaperRegistryAccess;
import io.papermc.paper.registry.PaperRegistryListenerManager;
import io.papermc.paper.registry.data.util.Conversions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.tags.TagDataPack;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import org.slf4j.Logger;

public class RegistryDataLoader {
    private static final Logger d = LogUtils.getLogger();
    private static final Comparator<ResourceKey<?>> e = Comparator.comparing(ResourceKey::b).thenComparing(ResourceKey::a);
    private static final RegistrationInfo f = new RegistrationInfo(Optional.empty(), Lifecycle.experimental());
    private static final Function<Optional<KnownPack>, RegistrationInfo> g = SystemUtils.b((T optional) -> {
        Lifecycle lifecycle = optional.map(KnownPack::a).map(_boolean -> Lifecycle.stable()).orElse(Lifecycle.experimental());
        return new RegistrationInfo((Optional<KnownPack>)optional, lifecycle);
    });
    public static final List<d<?>> a = List.of(new d<DimensionManager>(Registries.aN, DimensionManager.h), new d<BiomeBase>(Registries.aI, BiomeBase.a), new d<ChatMessageType>(Registries.aJ, ChatMessageType.a), new d(Registries.aK, WorldGenCarverWrapper.a), new d(Registries.aL, WorldGenFeatureConfigured.a), new d<PlacedFeature>(Registries.aT, PlacedFeature.a), new d<Structure>(Registries.aU, Structure.a), new d<StructureSet>(Registries.aW, StructureSet.a), new d<ProcessorList>(Registries.aV, DefinedStructureStructureProcessorType.c), new d<WorldGenFeatureDefinedStructurePoolTemplate>(Registries.aX, WorldGenFeatureDefinedStructurePoolTemplate.a), new d<GeneratorSettingBase>(Registries.aR, GeneratorSettingBase.a), new d<NoiseGeneratorNormal.a>(Registries.aS, NoiseGeneratorNormal.a.a), new d<DensityFunction>(Registries.aM, DensityFunction.b), new d<WorldPreset>(Registries.bb, WorldPreset.a), new d<FlatLevelGeneratorPreset>(Registries.aQ, FlatLevelGeneratorPreset.a), new d<TrimPattern>(Registries.ba, TrimPattern.a), new d<TrimMaterial>(Registries.aZ, TrimMaterial.a), new d<TrialSpawnerConfig>(Registries.bd, TrialSpawnerConfig.b), new d<WolfVariant>(Registries.m, WolfVariant.a, true), new d<PaintingVariant>(Registries.X, PaintingVariant.a, true), new d<DamageType>(Registries.s, DamageType.a), new d<MultiNoiseBiomeSourceParameterList>(Registries.bc, MultiNoiseBiomeSourceParameterList.a), new d<EnumBannerPatternType>(Registries.d, EnumBannerPatternType.a), new d<Enchantment>(Registries.aO, Enchantment.b), new d<EnchantmentProvider>(Registries.aP, EnchantmentProvider.a), new d<JukeboxSong>(Registries.L, JukeboxSong.a), new d<Instrument>(Registries.I, Instrument.a));
    public static final List<d<?>> b = List.of(new d<WorldDimension>(Registries.bf, WorldDimension.a));
    public static final List<d<?>> c = List.of(new d<BiomeBase>(Registries.aI, BiomeBase.b), new d<ChatMessageType>(Registries.aJ, ChatMessageType.a), new d<TrimPattern>(Registries.ba, TrimPattern.a), new d<TrimMaterial>(Registries.aZ, TrimMaterial.a), new d<WolfVariant>(Registries.m, WolfVariant.a, true), new d<PaintingVariant>(Registries.X, PaintingVariant.a, true), new d<DimensionManager>(Registries.aN, DimensionManager.h), new d<DamageType>(Registries.s, DamageType.a), new d<EnumBannerPatternType>(Registries.d, EnumBannerPatternType.a), new d<Enchantment>(Registries.aO, Enchantment.b), new d<JukeboxSong>(Registries.L, JukeboxSong.a), new d<Instrument>(Registries.I, Instrument.a));

    public static IRegistryCustom.Dimension a(IResourceManager resourceManager, List<HolderLookup.b<?>> registryLookups, List<d<?>> registryData) {
        return RegistryDataLoader.a((a<?> loader, RegistryOps.c infoLookup) -> loader.a(resourceManager, infoLookup), registryLookups, registryData);
    }

    public static IRegistryCustom.Dimension a(Map<ResourceKey<? extends IRegistry<?>>, c> elements, ResourceProvider resourceProvider, List<HolderLookup.b<?>> registryLookups, List<d<?>> registryData) {
        return RegistryDataLoader.a((a<?> loader, RegistryOps.c infoLookup) -> loader.a(elements, resourceProvider, infoLookup), registryLookups, registryData);
    }

    private static IRegistryCustom.Dimension a(b loadingFunction, List<HolderLookup.b<?>> registryLookups, List<d<?>> registryData) {
        HashMap map = new HashMap();
        List<a<?>> list = registryData.stream().map(registryData1 -> registryData1.a(Lifecycle.stable(), map)).collect(Collectors.toUnmodifiableList());
        RegistryOps.c registryInfoLookup = RegistryDataLoader.a(registryLookups, list);
        list.forEach(loader -> loadingFunction.apply((a<?>)loader, registryInfoLookup));
        list.forEach(loader -> {
            IRegistryWritable registry = loader.b();
            try {
                registry.n();
            }
            catch (Exception var4x) {
                map.put(registry.g(), var4x);
            }
            if (loader.a.c && registry.d() == 0) {
                map.put(registry.g(), new IllegalStateException("Registry must be non-empty"));
            }
        });
        if (!map.isEmpty()) {
            throw RegistryDataLoader.a(map);
        }
        return new IRegistryCustom.c(list.stream().map(a::b).toList()).e();
    }

    private static RegistryOps.c a(List<HolderLookup.b<?>> registryLookups, List<a<?>> loaders) {
        final HashMap map = new HashMap();
        registryLookups.forEach(registryLookup -> map.put(registryLookup.g(), RegistryDataLoader.a(registryLookup)));
        loaders.forEach(loader -> map.put(loader.b.g(), RegistryDataLoader.a(loader.b)));
        return new RegistryOps.c(){

            @Override
            public <T> Optional<RegistryOps.b<T>> a(ResourceKey<? extends IRegistry<? extends T>> registryKey) {
                return Optional.ofNullable((RegistryOps.b)map.get(registryKey));
            }
        };
    }

    private static <T> RegistryOps.b<T> a(IRegistryWritable<T> registry) {
        return new RegistryOps.b<T>(registry, registry.p(), registry.h());
    }

    private static <T> RegistryOps.b<T> a(HolderLookup.b<T> registryLookup) {
        return new RegistryOps.b<T>(registryLookup, registryLookup, registryLookup.h());
    }

    private static ReportedException a(Map<ResourceKey<?>, Exception> errors) {
        RegistryDataLoader.b(errors);
        return RegistryDataLoader.c(errors);
    }

    private static void b(Map<ResourceKey<?>, Exception> errors) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Map<MinecraftKey, Map<MinecraftKey, Exception>> map = errors.entrySet().stream().collect(Collectors.groupingBy(entry -> ((ResourceKey)entry.getKey()).b(), Collectors.toMap(entry -> ((ResourceKey)entry.getKey()).a(), Map.Entry::getValue)));
        map.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            printWriter.printf("> Errors in registry %s:%n", entry.getKey());
            ((Map)entry.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry1 -> {
                printWriter.printf(">> Errors in element %s:%n", entry1.getKey());
                ((Exception)entry1.getValue()).printStackTrace(printWriter);
            });
        });
        printWriter.flush();
        d.error("Registry loading errors:\n{}", (Object)stringWriter);
    }

    private static ReportedException c(Map<ResourceKey<?>, Exception> errors) {
        CrashReport crashReport = CrashReport.a(new IllegalStateException("Failed to load registries due to errors"), "Registry Loading");
        CrashReportSystemDetails crashReportCategory = crashReport.a("Loading info");
        crashReportCategory.a("Errors", () -> {
            StringBuilder stringBuilder = new StringBuilder();
            errors.entrySet().stream().sorted(Map.Entry.comparingByKey(e)).forEach(entry -> stringBuilder.append("\n\t\t").append(((ResourceKey)entry.getKey()).b()).append("/").append(((ResourceKey)entry.getKey()).a()).append(": ").append(((Exception)entry.getValue()).getMessage()));
            return stringBuilder.toString();
        });
        return new ReportedException(crashReport);
    }

    private static <E> void loadElementFromResource(IRegistryWritable<E> registry, Decoder<E> codec, RegistryOps<JsonElement> ops, ResourceKey<E> resourceKey, IResource resource, RegistrationInfo registrationInfo, Conversions conversions) throws IOException {
        try (BufferedReader reader = resource.e();){
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            DataResult dataResult = codec.parse(ops, (Object)jsonElement);
            Object orThrow = dataResult.getOrThrow();
            PaperRegistryListenerManager.INSTANCE.registerWithListeners(registry, resourceKey, orThrow, registrationInfo, conversions);
        }
    }

    static <E> void a(IResourceManager resourceManager, RegistryOps.c registryInfoLookup, IRegistryWritable<E> registry, Decoder<E> codec, Map<ResourceKey<?>, Exception> loadingErrors) {
        FileToIdConverter fileToIdConverter = FileToIdConverter.a(registry.g());
        RegistryOps<JsonElement> registryOps = RegistryOps.a(JsonOps.INSTANCE, registryInfoLookup);
        Conversions conversions = new Conversions(registryInfoLookup);
        for (Map.Entry<MinecraftKey, IResource> entry : fileToIdConverter.a(resourceManager).entrySet()) {
            MinecraftKey resourceLocation = entry.getKey();
            ResourceKey resourceKey = ResourceKey.a(registry.g(), fileToIdConverter.b(resourceLocation));
            IResource resource = entry.getValue();
            RegistrationInfo registrationInfo = g.apply(resource.c());
            try {
                RegistryDataLoader.loadElementFromResource(registry, codec, registryOps, resourceKey, resource, registrationInfo, conversions);
            }
            catch (Exception var14) {
                loadingErrors.put(resourceKey, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse %s from pack %s", resourceLocation, resource.b()), var14));
            }
        }
        PaperRegistryAccess.instance().lockReferenceHolders(registry.g());
        PaperRegistryListenerManager.INSTANCE.runFreezeListeners(registry.g(), conversions);
        TagDataPack.loadTagsForRegistry(resourceManager, registry, ReloadableRegistrarEvent.Cause.INITIAL);
    }

    static <E> void a(Map<ResourceKey<? extends IRegistry<?>>, c> elements, ResourceProvider resourceProvider, RegistryOps.c registryInfoLookup, IRegistryWritable<E> registry, Decoder<E> codec, Map<ResourceKey<?>, Exception> loadingErrors) {
        c networkedRegistryData = elements.get(registry.g());
        if (networkedRegistryData != null) {
            RegistryOps<NBTBase> registryOps = RegistryOps.a(DynamicOpsNBT.a, registryInfoLookup);
            RegistryOps<JsonElement> registryOps1 = RegistryOps.a(JsonOps.INSTANCE, registryInfoLookup);
            FileToIdConverter fileToIdConverter = FileToIdConverter.a(registry.g());
            Conversions conversions = new Conversions(registryInfoLookup);
            for (RegistrySynchronization.a packedRegistryEntry : networkedRegistryData.a) {
                ResourceKey resourceKey = ResourceKey.a(registry.g(), packedRegistryEntry.a());
                Optional<NBTBase> optional = packedRegistryEntry.b();
                if (optional.isPresent()) {
                    try {
                        DataResult dataResult = codec.parse(registryOps, (Object)optional.get());
                        Object orThrow = dataResult.getOrThrow();
                        registry.a(resourceKey, orThrow, f);
                    }
                    catch (Exception var16) {
                        loadingErrors.put(resourceKey, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse value %s from server", optional.get()), var16));
                    }
                    continue;
                }
                MinecraftKey resourceLocation = fileToIdConverter.a(packedRegistryEntry.a());
                try {
                    IResource resourceOrThrow = resourceProvider.getResourceOrThrow(resourceLocation);
                    RegistryDataLoader.loadElementFromResource(registry, codec, registryOps1, resourceKey, resourceOrThrow, f, conversions);
                }
                catch (Exception var17) {
                    loadingErrors.put(resourceKey, new IllegalStateException("Failed to parse local data", var17));
                }
            }
            TagDataPack.a(networkedRegistryData.b, registry);
        }
    }

    @FunctionalInterface
    static interface b {
        public void apply(a<?> var1, RegistryOps.c var2);
    }

    public record c(List<RegistrySynchronization.a> a, TagNetworkSerialization.a b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "elements;tags", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "elements;tags", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "elements;tags", "a", "b"}, this, o2);
        }
    }

    record a<T>(d<T> a, IRegistryWritable<T> b, Map<ResourceKey<?>, Exception> c) {
        public void a(IResourceManager resouceManager, RegistryOps.c registryInfoLookup) {
            RegistryDataLoader.a(resouceManager, registryInfoLookup, this.b, this.a.b, this.c);
        }

        public void a(Map<ResourceKey<? extends IRegistry<?>>, c> elements, ResourceProvider resourceProvider, RegistryOps.c registryInfoLookup) {
            RegistryDataLoader.a(elements, resourceProvider, registryInfoLookup, this.b, this.a.b, this.c);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "data;registry;loadingErrors", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "data;registry;loadingErrors", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "data;registry;loadingErrors", "a", "b", "c"}, this, o2);
        }
    }

    public record d<T>(ResourceKey<? extends IRegistry<T>> a, Codec<T> b, boolean c) {
        d(ResourceKey<? extends IRegistry<T>> key, Codec<T> elementCodec) {
            this(key, elementCodec, false);
        }

        a<T> a(Lifecycle registryLifecycle, Map<ResourceKey<?>, Exception> loadingErrors) {
            RegistryMaterials writableRegistry = new RegistryMaterials(this.a, registryLifecycle);
            PaperRegistryAccess.instance().registerRegistry(this.a, writableRegistry);
            return new a(this, writableRegistry, loadingErrors);
        }

        public void a(BiConsumer<ResourceKey<? extends IRegistry<T>>, Codec<T>> runner) {
            runner.accept(this.a, this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "key;elementCodec;requiredNonEmpty", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "key;elementCodec;requiredNonEmpty", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "key;elementCodec;requiredNonEmpty", "a", "b", "c"}, this, o2);
        }
    }
}

