/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;

public class HolderSetCodec<E>
implements Codec<HolderSet<E>> {
    private final ResourceKey<? extends IRegistry<E>> a;
    private final Codec<Holder<E>> b;
    private final Codec<List<Holder<E>>> c;
    private final Codec<Either<TagKey<E>, List<Holder<E>>>> d;

    private static <E> Codec<List<Holder<E>>> a(Codec<Holder<E>> holderCodec, boolean disallowInline) {
        Codec<List<Holder<E>>> codec = holderCodec.listOf().validate(ExtraCodecs.b(Holder::f));
        return disallowInline ? codec : ExtraCodecs.c(holderCodec, codec);
    }

    public static <E> Codec<HolderSet<E>> a(ResourceKey<? extends IRegistry<E>> registryKey, Codec<Holder<E>> holderCodec, boolean disallowInline) {
        return new HolderSetCodec<E>(registryKey, holderCodec, disallowInline);
    }

    private HolderSetCodec(ResourceKey<? extends IRegistry<E>> registryKey, Codec<Holder<E>> elementCodec, boolean disallowInline) {
        this.a = registryKey;
        this.b = elementCodec;
        this.c = HolderSetCodec.a(elementCodec, disallowInline);
        this.d = Codec.either(TagKey.b(registryKey), this.c);
    }

    public <T> DataResult<Pair<HolderSet<E>, T>> decode(DynamicOps<T> ops, T input) {
        RegistryOps registryOps;
        Optional optional;
        if (ops instanceof RegistryOps && (optional = (registryOps = (RegistryOps)ops).b(this.a)).isPresent()) {
            HolderGetter holderGetter = optional.get();
            return this.d.decode(ops, input).flatMap(pair -> {
                DataResult dataResult = ((Either)pair.getFirst()).map(tagKey -> HolderSetCodec.a(holderGetter, tagKey), list -> DataResult.success(HolderSet.a(list)));
                return dataResult.map(holderSet -> Pair.of((Object)holderSet, (Object)pair.getSecond()));
            });
        }
        return this.a(ops, input);
    }

    private static <E> DataResult<HolderSet<E>> a(HolderGetter<E> input, TagKey<E> tagKey) {
        return input.a(tagKey).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Missing tag: '" + String.valueOf(tagKey.b()) + "' in '" + String.valueOf(tagKey.a().a()) + "'"));
    }

    public <T> DataResult<T> a(HolderSet<E> input, DynamicOps<T> ops, T prefix) {
        RegistryOps registryOps;
        Optional optional;
        if (ops instanceof RegistryOps && (optional = (registryOps = (RegistryOps)ops).a(this.a)).isPresent()) {
            if (!input.a(optional.get())) {
                return DataResult.error(() -> "HolderSet " + String.valueOf(input) + " is not valid in current registry set");
            }
            return this.d.encode(input.d().mapRight(List::copyOf), ops, prefix);
        }
        return this.b(input, ops, prefix);
    }

    private <T> DataResult<Pair<HolderSet<E>, T>> a(DynamicOps<T> ops, T input) {
        return this.b.listOf().decode(ops, input).flatMap(pair -> {
            ArrayList<Holder.a> list = new ArrayList<Holder.a>();
            for (Holder holder : (List)pair.getFirst()) {
                if (!(holder instanceof Holder.a)) {
                    return DataResult.error(() -> "Can't decode element " + String.valueOf(holder) + " without registry");
                }
                Holder.a direct = (Holder.a)holder;
                list.add(direct);
            }
            return DataResult.success((Object)new Pair(HolderSet.a(list), pair.getSecond()));
        });
    }

    private <T> DataResult<T> b(HolderSet<E> input, DynamicOps<T> ops, T prefix) {
        return this.c.encode(input.a().toList(), ops, prefix);
    }
}

