/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.syncher;

import com.mojang.logging.LogUtils;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.network.syncher.SyncedDataHolder;
import net.minecraft.util.ClassTreeIdRegistry;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;

public class DataWatcher {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 254;
    static final ClassTreeIdRegistry c = new ClassTreeIdRegistry();
    private final SyncedDataHolder d;
    private final Item<?>[] e;
    private boolean f;

    DataWatcher(SyncedDataHolder entity, Item<?>[] itemsById) {
        this.d = entity;
        this.e = itemsById;
    }

    public static <T> DataWatcherObject<T> a(Class<? extends SyncedDataHolder> clazz, DataWatcherSerializer<T> serializer) {
        int i2;
        if (a.isDebugEnabled()) {
            try {
                Class<?> clazz1 = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
                if (!clazz1.equals(clazz)) {
                    a.debug("defineId called for: {} from {}", new Object[]{clazz, clazz1, new RuntimeException()});
                }
            }
            catch (ClassNotFoundException clazz1) {
                // empty catch block
            }
        }
        if ((i2 = c.c(clazz)) > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + i2 + "! (Max is 254)");
        }
        return serializer.a(i2);
    }

    public <T> Item<T> b(DataWatcherObject<T> key) {
        return this.e[key.a()];
    }

    public <T> T a(DataWatcherObject<T> key) {
        return this.b(key).b();
    }

    public <T> void a(DataWatcherObject<T> key, T value) {
        this.a(key, value, false);
    }

    public <T> void a(DataWatcherObject<T> key, T value, boolean force) {
        Item<T> item = this.b(key);
        if (force || ObjectUtils.notEqual(value, item.b())) {
            item.a(value);
            this.d.a(key);
            item.a(true);
            this.f = true;
        }
    }

    public <T> void markDirty(DataWatcherObject<T> entityDataAccessor) {
        this.b(entityDataAccessor).a(true);
        this.f = true;
    }

    public boolean a() {
        return this.f;
    }

    @Nullable
    public List<c<?>> b() {
        if (!this.f) {
            return null;
        }
        this.f = false;
        ArrayList list = new ArrayList();
        for (Item<?> dataItem : this.e) {
            if (!dataItem.c()) continue;
            dataItem.a(false);
            list.add(dataItem.e());
        }
        return list;
    }

    @Nullable
    public List<c<?>> c() {
        ArrayList list = null;
        for (Item<?> dataItem : this.e) {
            if (dataItem.d()) continue;
            if (list == null) {
                list = new ArrayList();
            }
            list.add(dataItem.e());
        }
        return list;
    }

    public void a(List<c<?>> entries) {
        for (c<?> dataValue : entries) {
            Item<?> dataItem = this.e[dataValue.a];
            this.a(dataItem, dataValue);
            this.d.a(dataItem.a());
        }
        this.d.a(entries);
    }

    private <T> void a(Item<T> target, c<?> entry) {
        if (!Objects.equals(entry.b(), target.a.b())) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Invalid entity data item type for field %d on entity %s: old=%s(%s), new=%s(%s)", target.a.a(), this.d, target.b, target.b.getClass(), entry.c, entry.c.getClass()));
        }
        target.a(entry.c);
    }

    public List<c<?>> packAll() {
        ArrayList list = new ArrayList(this.e.length);
        for (Item<?> dataItem : this.e) {
            list.add(dataItem.e());
        }
        return list;
    }

    public static class Item<T> {
        final DataWatcherObject<T> a;
        T b;
        private final T c;
        private boolean d;

        public Item(DataWatcherObject<T> accessor, T value) {
            this.a = accessor;
            this.c = value;
            this.b = value;
        }

        public DataWatcherObject<T> a() {
            return this.a;
        }

        public void a(T value) {
            this.b = value;
        }

        public T b() {
            return this.b;
        }

        public boolean c() {
            return this.d;
        }

        public void a(boolean dirty) {
            this.d = dirty;
        }

        public boolean d() {
            return this.c.equals(this.b);
        }

        public c<T> e() {
            return net.minecraft.network.syncher.DataWatcher$c.a(this.a, this.b);
        }
    }

    public record c<T>(int a, DataWatcherSerializer<T> b, T c) {
        public static <T> c<T> a(DataWatcherObject<T> dataAccessor, T value) {
            DataWatcherSerializer<T> entityDataSerializer = dataAccessor.b();
            return new c<T>(dataAccessor.a(), entityDataSerializer, entityDataSerializer.copy(value));
        }

        public void a(RegistryFriendlyByteBuf buffer) {
            int serializedId = DataWatcherRegistry.b(this.b);
            if (serializedId < 0) {
                throw new EncoderException("Unknown serializer type " + String.valueOf(this.b));
            }
            buffer.l(this.a);
            buffer.c(serializedId);
            this.b.codec().encode(buffer, this.c);
        }

        public static c<?> a(RegistryFriendlyByteBuf buffer, int id) {
            int varInt = buffer.l();
            DataWatcherSerializer<?> serializer = DataWatcherRegistry.a(varInt);
            if (serializer == null) {
                throw new DecoderException("Unknown serializer type " + varInt);
            }
            return net.minecraft.network.syncher.DataWatcher$c.a(buffer, id, serializer);
        }

        private static <T> c<T> a(RegistryFriendlyByteBuf buffer, int id, DataWatcherSerializer<T> serializer) {
            return new c<T>(id, serializer, serializer.codec().decode(buffer));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "id;serializer;value", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "id;serializer;value", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "id;serializer;value", "a", "b", "c"}, this, o2);
        }
    }

    public static class a {
        private final SyncedDataHolder a;
        private final Item<?>[] b;

        public a(SyncedDataHolder entity) {
            this.a = entity;
            this.b = new Item[c.b(entity.getClass())];
        }

        public <T> a a(DataWatcherObject<T> accessor, T value) {
            int id = accessor.a();
            if (id > this.b.length) {
                throw new IllegalArgumentException("Data value id is too big with " + id + "! (Max is " + this.b.length + ")");
            }
            if (this.b[id] != null) {
                throw new IllegalArgumentException("Duplicate id value for " + id + "!");
            }
            if (DataWatcherRegistry.b(accessor.b()) < 0) {
                throw new IllegalArgumentException("Unregistered serializer " + String.valueOf(accessor.b()) + " for " + id + "!");
            }
            this.b[accessor.a()] = new Item<T>(accessor, value);
            return this;
        }

        public DataWatcher a() {
            for (int i2 = 0; i2 < this.b.length; ++i2) {
                if (this.b[i2] != null) continue;
                throw new IllegalStateException("Entity " + String.valueOf(this.a.getClass()) + " has not defined synched data value " + i2);
            }
            return new DataWatcher(this.a, this.b);
        }
    }
}

