/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.antixray.ChunkPacketInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.levelgen.HeightMap;

public class ClientboundLevelChunkPacketData {
    private static final int a = 0x200000;
    private final NBTTagCompound b;
    private final byte[] c;
    private final List<a> d;
    private final List<Packet<?>> extraPackets = new ArrayList();
    private static final int BLOCK_ENTITY_LIMIT = Integer.getInteger("Paper.excessiveTELimit", 750);

    public List<Packet<?>> getExtraPackets() {
        return this.extraPackets;
    }

    @Deprecated
    @DoNotUse
    public ClientboundLevelChunkPacketData(Chunk levelChunk) {
        this(levelChunk, null);
    }

    public ClientboundLevelChunkPacketData(Chunk levelChunk, ChunkPacketInfo<IBlockData> chunkPacketInfo) {
        this.b = new NBTTagCompound();
        for (Map.Entry<HeightMap.Type, HeightMap> entry : levelChunk.e()) {
            if (!entry.getKey().b()) continue;
            this.b.a(entry.getKey().a(), new NBTTagLongArray(entry.getValue().a()));
        }
        this.c = new byte[ClientboundLevelChunkPacketData.a(levelChunk)];
        if (chunkPacketInfo != null) {
            chunkPacketInfo.setBuffer(this.c);
        }
        ClientboundLevelChunkPacketData.extractChunkData(new PacketDataSerializer(this.c()), levelChunk, chunkPacketInfo);
        this.d = Lists.newArrayList();
        int totalTileEntities = 0;
        for (Map.Entry<BlockPosition, TileEntity> entryx : levelChunk.I().entrySet()) {
            Packet<PacketListenerPlayOut> packet;
            if (++totalTileEntities > BLOCK_ENTITY_LIMIT && (packet = entryx.getValue().ax_()) != null) {
                this.extraPackets.add(packet);
                continue;
            }
            this.d.add(net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData$a.a(entryx.getValue()));
        }
    }

    public ClientboundLevelChunkPacketData(RegistryFriendlyByteBuf buffer, int x2, int z2) {
        this.b = buffer.o();
        if (this.b == null) {
            throw new RuntimeException("Can't read heightmap in packet for [" + x2 + ", " + z2 + "]");
        }
        int varInt = buffer.l();
        if (varInt > 0x200000) {
            throw new RuntimeException("Chunk Packet trying to allocate too much memory on read.");
        }
        this.c = new byte[varInt];
        buffer.b(this.c);
        this.d = (List)net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData$a.b.decode(buffer);
    }

    public void a(RegistryFriendlyByteBuf buffer) {
        buffer.a(this.b);
        buffer.c(this.c.length);
        buffer.c(this.c);
        net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData$a.b.encode(buffer, this.d);
    }

    private static int a(Chunk chunk) {
        int i2 = 0;
        for (ChunkSection levelChunkSection : chunk.d()) {
            i2 += levelChunkSection.j();
        }
        return i2;
    }

    private ByteBuf c() {
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.c);
        byteBuf.writerIndex(0);
        return byteBuf;
    }

    @Deprecated
    @DoNotUse
    public static void a(PacketDataSerializer buffer, Chunk chunk) {
        ClientboundLevelChunkPacketData.extractChunkData(buffer, chunk, null);
    }

    public static void extractChunkData(PacketDataSerializer buffer, Chunk chunk, ChunkPacketInfo<IBlockData> chunkPacketInfo) {
        int chunkSectionIndex = 0;
        for (ChunkSection levelChunkSection : chunk.d()) {
            levelChunkSection.write(buffer, chunkPacketInfo, chunkSectionIndex);
            ++chunkSectionIndex;
        }
    }

    public Consumer<b> a(int chunkX, int chunkZ) {
        return blockEntityTagOutput -> this.a((b)blockEntityTagOutput, chunkX, chunkZ);
    }

    private void a(b output, int chunkX, int chunkZ) {
        int i2 = 16 * chunkX;
        int i1 = 16 * chunkZ;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (a blockEntityInfo : this.d) {
            int i22 = i2 + SectionPosition.b(blockEntityInfo.c >> 4);
            int i3 = i1 + SectionPosition.b(blockEntityInfo.c);
            mutableBlockPos.d(i22, blockEntityInfo.d, i3);
            output.accept(mutableBlockPos, blockEntityInfo.e, blockEntityInfo.f);
        }
    }

    public PacketDataSerializer a() {
        return new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])this.c));
    }

    public NBTTagCompound b() {
        return this.b;
    }

    static class a {
        public static final StreamCodec<RegistryFriendlyByteBuf, a> a = StreamCodec.a(a::a, a::new);
        public static final StreamCodec<RegistryFriendlyByteBuf, List<a>> b = a.a(ByteBufCodecs.a());
        final int c;
        final int d;
        final TileEntityTypes<?> e;
        @Nullable
        final NBTTagCompound f;

        private a(int packedXZ, int y2, TileEntityTypes<?> type, @Nullable NBTTagCompound tag) {
            this.c = packedXZ;
            this.d = y2;
            this.e = type;
            this.f = tag;
        }

        private a(RegistryFriendlyByteBuf buffer) {
            this.c = buffer.readByte();
            this.d = buffer.readShort();
            this.e = (TileEntityTypes)ByteBufCodecs.a(Registries.h).decode(buffer);
            this.f = buffer.o();
        }

        private void a(RegistryFriendlyByteBuf buffer) {
            buffer.l(this.c);
            buffer.m(this.d);
            ByteBufCodecs.a(Registries.h).encode(buffer, this.e);
            buffer.a(this.f);
        }

        static a a(TileEntity blockEntity) {
            NBTTagCompound updateTag = blockEntity.a(blockEntity.i().K_());
            BlockPosition blockPos = blockEntity.aA_();
            int i2 = SectionPosition.b(blockPos.u()) << 4 | SectionPosition.b(blockPos.w());
            blockEntity.sanitizeSentNbt(updateTag);
            return new a(i2, blockPos.v(), blockEntity.p(), updateTag.g() ? null : updateTag);
        }
    }

    @FunctionalInterface
    public static interface b {
        public void accept(BlockPosition var1, TileEntityTypes<?> var2, @Nullable NBTTagCompound var3);
    }
}

