/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.ClientboundPacketListener;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.ServerboundPacketListener;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.BundleDelimiterPacket;
import net.minecraft.network.protocol.BundlePacket;
import net.minecraft.network.protocol.BundlerInfo;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.ProtocolCodecBuilder;

public class ProtocolInfoBuilder<T extends PacketListener, B extends ByteBuf> {
    final EnumProtocol a;
    final EnumProtocolDirection b;
    private final List<a<T, ?, B>> c = new ArrayList();
    @Nullable
    private BundlerInfo d;

    public ProtocolInfoBuilder(EnumProtocol protocol, EnumProtocolDirection flow) {
        this.a = protocol;
        this.b = flow;
    }

    public <P extends Packet<? super T>> ProtocolInfoBuilder<T, B> a(PacketType<P> type, StreamCodec<? super B, P> serializer) {
        this.c.add(new a(type, serializer));
        return this;
    }

    public <P extends BundlePacket<? super T>, D extends BundleDelimiterPacket<? super T>> ProtocolInfoBuilder<T, B> a(PacketType<P> type, Function<Iterable<Packet<? super T>>, P> bundler, D packet) {
        StreamCodec streamCodec = StreamCodec.a(packet);
        PacketType<BundleDelimiterPacket<? super T>> packetType = packet.a();
        this.c.add(new a(packetType, streamCodec));
        this.d = BundlerInfo.a(type, bundler, packet);
        return this;
    }

    StreamCodec<ByteBuf, Packet<? super T>> a(Function<ByteBuf, B> bufferFactory, List<a<T, ?, B>> codecs) {
        ProtocolCodecBuilder protocolCodecBuilder = new ProtocolCodecBuilder(this.b);
        for (a a2 : codecs) {
            a2.a(protocolCodecBuilder, bufferFactory);
        }
        return protocolCodecBuilder.a();
    }

    public ProtocolInfo<T> a(Function<ByteBuf, B> bufferFactory) {
        return new b(this.a, this.b, this.a(bufferFactory, this.c), this.d);
    }

    public ProtocolInfo.a<T, B> a() {
        final List<a<T, ?, B>> list = List.copyOf(this.c);
        final BundlerInfo bundlerInfo = this.d;
        return new ProtocolInfo.a<T, B>(){

            @Override
            public ProtocolInfo<T> a(Function<ByteBuf, B> bufferFactory) {
                return new b(ProtocolInfoBuilder.this.a, ProtocolInfoBuilder.this.b, ProtocolInfoBuilder.this.a(bufferFactory, list), bundlerInfo);
            }

            @Override
            public EnumProtocol a() {
                return ProtocolInfoBuilder.this.a;
            }

            @Override
            public EnumProtocolDirection b() {
                return ProtocolInfoBuilder.this.b;
            }

            @Override
            public void a(ProtocolInfo.a.a visitor) {
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    a codecEntry = (a)list.get(i2);
                    visitor.accept(codecEntry.a, i2);
                }
            }
        };
    }

    private static <L extends PacketListener, B extends ByteBuf> ProtocolInfo.a<L, B> a(EnumProtocol protocol, EnumProtocolDirection flow, Consumer<ProtocolInfoBuilder<L, B>> setup) {
        ProtocolInfoBuilder protocolInfoBuilder = new ProtocolInfoBuilder(protocol, flow);
        setup.accept(protocolInfoBuilder);
        return protocolInfoBuilder.a();
    }

    public static <T extends ServerboundPacketListener, B extends ByteBuf> ProtocolInfo.a<T, B> a(EnumProtocol protocol, Consumer<ProtocolInfoBuilder<T, B>> setup) {
        return ProtocolInfoBuilder.a(protocol, EnumProtocolDirection.a, setup);
    }

    public static <T extends ClientboundPacketListener, B extends ByteBuf> ProtocolInfo.a<T, B> b(EnumProtocol protocol, Consumer<ProtocolInfoBuilder<T, B>> setup) {
        return ProtocolInfoBuilder.a(protocol, EnumProtocolDirection.b, setup);
    }

    record a<T extends PacketListener, P extends Packet<? super T>, B extends ByteBuf>(PacketType<P> a, StreamCodec<? super B, P> b) {
        public void a(ProtocolCodecBuilder<ByteBuf, T> codecBuilder, Function<ByteBuf, B> bufferFactory) {
            StreamCodec<ByteBuf, P> streamCodec = this.b.b(bufferFactory);
            codecBuilder.a(this.a, streamCodec);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "type;serializer", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "type;serializer", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "type;serializer", "a", "b"}, this, o2);
        }
    }

    record b<L extends PacketListener>(EnumProtocol a, EnumProtocolDirection b, StreamCodec<ByteBuf, Packet<? super L>> c, @Nullable BundlerInfo d) implements ProtocolInfo<L>
    {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "id;flow;codec;bundlerInfo", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "id;flow;codec;bundlerInfo", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "id;flow;codec;bundlerInfo", "a", "b", "c", "d"}, this, o2);
        }
    }
}

