/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.CancelledPacketHandleException;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.util.thread.IAsyncTaskHandler;
import org.slf4j.Logger;

public class PlayerConnectionUtils {
    private static final Logger a = LogUtils.getLogger();
    public static final ConcurrentLinkedDeque<PacketListener> packetProcessing = new ConcurrentLinkedDeque();
    static final AtomicLong totalMainThreadPacketsProcessed = new AtomicLong();

    public static <T extends PacketListener> void a(Packet<T> packet, T processor, WorldServer level) throws CancelledPacketHandleException {
        PlayerConnectionUtils.a(packet, processor, level.p());
    }

    public static <T extends PacketListener> void a(Packet<T> packet, T processor, IAsyncTaskHandler<?> executor) throws CancelledPacketHandleException {
        if (!executor.bx()) {
            executor.c(() -> {
                packetProcessing.push(processor);
                try {
                    if (processor instanceof ServerCommonPacketListenerImpl) {
                        ServerCommonPacketListenerImpl serverCommonPacketListener = (ServerCommonPacketListenerImpl)processor;
                        if (serverCommonPacketListener.processedDisconnect) {
                            return;
                        }
                    }
                    if (processor.a(packet)) {
                        try {
                            packet.a(processor);
                        }
                        catch (Exception var4) {
                            ReportedException reportedException;
                            if (var4 instanceof ReportedException && (reportedException = (ReportedException)var4).getCause() instanceof OutOfMemoryError) {
                                throw PlayerConnectionUtils.a(var4, packet, processor);
                            }
                            processor.a(packet, var4);
                        }
                    } else {
                        a.debug("Ignoring packet due to disconnection: {}", (Object)packet);
                    }
                }
                finally {
                    totalMainThreadPacketsProcessed.getAndIncrement();
                    packetProcessing.pop();
                }
            });
            throw CancelledPacketHandleException.a;
        }
    }

    public static <T extends PacketListener> ReportedException a(Exception exception, Packet<T> packet, T packetListener) {
        if (exception instanceof ReportedException) {
            ReportedException reportedException = (ReportedException)exception;
            PlayerConnectionUtils.a(reportedException.a(), packetListener, packet);
            return reportedException;
        }
        CrashReport crashReport = CrashReport.a(exception, "Main thread packet handler");
        PlayerConnectionUtils.a(crashReport, packetListener, packet);
        return new ReportedException(crashReport);
    }

    public static <T extends PacketListener> void a(CrashReport crashReport, T packetListener, @Nullable Packet<T> packet) {
        if (packet != null) {
            CrashReportSystemDetails crashReportCategory = crashReport.a("Incoming Packet");
            crashReportCategory.a("Type", () -> packet.a().toString());
            crashReportCategory.a("Is Terminal", () -> Boolean.toString(packet.d()));
            crashReportCategory.a("Is Skippable", () -> Boolean.toString(packet.c()));
        }
        packetListener.a(crashReport);
    }

    public static long getTotalProcessedPackets() {
        return totalMainThreadPacketsProcessed.get();
    }

    public static List<PacketListener> getCurrentPacketProcessors() {
        ArrayList<PacketListener> listeners = new ArrayList<PacketListener>(4);
        for (PacketListener listener : packetProcessing) {
            listeners.add(listener);
        }
        return listeners;
    }
}

