/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.codec;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Function5;
import com.mojang.datafixers.util.Function6;
import com.mojang.datafixers.util.Function7;
import com.mojang.datafixers.util.Function8;
import io.netty.buffer.ByteBuf;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.network.codec.StreamMemberEncoder;

public interface StreamCodec<B, V>
extends StreamDecoder<B, V>,
StreamEncoder<B, V> {
    public static <B, V> StreamCodec<B, V> a(final StreamEncoder<B, V> encoder, final StreamDecoder<B, V> decoder) {
        return new StreamCodec<B, V>(){

            @Override
            public V decode(B buffer) {
                return decoder.decode(buffer);
            }

            @Override
            public void encode(B buffer, V value) {
                encoder.encode(buffer, value);
            }
        };
    }

    public static <B, V> StreamCodec<B, V> a(final StreamMemberEncoder<B, V> encoder, final StreamDecoder<B, V> decoder) {
        return new StreamCodec<B, V>(){

            @Override
            public V decode(B buffer) {
                return decoder.decode(buffer);
            }

            @Override
            public void encode(B buffer, V value) {
                encoder.encode(value, buffer);
            }
        };
    }

    public static <B, V> StreamCodec<B, V> a(final V expectedValue) {
        return new StreamCodec<B, V>(){

            @Override
            public V decode(B buffer) {
                return expectedValue;
            }

            @Override
            public void encode(B buffer, V value) {
                if (!value.equals(expectedValue)) {
                    throw new IllegalStateException("Can't encode '" + String.valueOf(value) + "', expected '" + String.valueOf(expectedValue) + "'");
                }
            }
        };
    }

    default public <O> StreamCodec<B, O> a(a<B, V, O> operation) {
        return operation.apply(this);
    }

    default public <O> StreamCodec<B, O> a(final Function<? super V, ? extends O> factory, final Function<? super O, ? extends V> getter) {
        return new StreamCodec<B, O>(){

            @Override
            public O decode(B buffer) {
                return factory.apply(StreamCodec.this.decode(buffer));
            }

            @Override
            public void encode(B buffer, O value) {
                StreamCodec.this.encode(buffer, getter.apply(value));
            }
        };
    }

    default public <O extends ByteBuf> StreamCodec<O, V> b(final Function<O, ? extends B> bufferFactory) {
        return new StreamCodec<O, V>(){

            public V a(O buffer) {
                Object object = bufferFactory.apply(buffer);
                return StreamCodec.this.decode(object);
            }

            public void a(O buffer, V value) {
                Object object = bufferFactory.apply(buffer);
                StreamCodec.this.encode(object, value);
            }
        };
    }

    default public <U> StreamCodec<B, U> b(final Function<? super U, ? extends V> keyGetter, final Function<? super V, ? extends StreamCodec<? super B, ? extends U>> codecGetter) {
        return new StreamCodec<B, U>(){

            @Override
            public U decode(B buffer) {
                Object object = StreamCodec.this.decode(buffer);
                StreamCodec streamCodec = (StreamCodec)codecGetter.apply(object);
                return streamCodec.decode(buffer);
            }

            @Override
            public void encode(B buffer, U value) {
                Object object = keyGetter.apply(value);
                StreamCodec streamCodec = (StreamCodec)codecGetter.apply(object);
                StreamCodec.this.encode(buffer, object);
                streamCodec.encode(buffer, value);
            }
        };
    }

    public static <B, C, T1> StreamCodec<B, C> a(final StreamCodec<? super B, T1> codec, final Function<C, T1> getter, final Function<T1, C> factory) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B buffer) {
                Object object = codec.decode(buffer);
                return factory.apply(object);
            }

            @Override
            public void encode(B buffer, C value) {
                codec.encode(buffer, getter.apply(value));
            }
        };
    }

    public static <B, C, T1, T2> StreamCodec<B, C> a(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final BiFunction<T1, T2, C> factory) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B buffer) {
                Object object = codec1.decode(buffer);
                Object object1 = codec2.decode(buffer);
                return factory.apply(object, object1);
            }

            @Override
            public void encode(B buffer, C value) {
                codec1.encode(buffer, getter1.apply(value));
                codec2.encode(buffer, getter2.apply(value));
            }
        };
    }

    public static <B, C, T1, T2, T3> StreamCodec<B, C> a(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> getter3, final Function3<T1, T2, T3, C> factory) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B buffer) {
                Object object = codec1.decode(buffer);
                Object object1 = codec2.decode(buffer);
                Object object2 = codec3.decode(buffer);
                return factory.apply(object, object1, object2);
            }

            @Override
            public void encode(B buffer, C value) {
                codec1.encode(buffer, getter1.apply(value));
                codec2.encode(buffer, getter2.apply(value));
                codec3.encode(buffer, getter3.apply(value));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4> StreamCodec<B, C> a(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> getter3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> getter4, final Function4<T1, T2, T3, T4, C> factory) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B buffer) {
                Object object = codec1.decode(buffer);
                Object object1 = codec2.decode(buffer);
                Object object2 = codec3.decode(buffer);
                Object object3 = codec4.decode(buffer);
                return factory.apply(object, object1, object2, object3);
            }

            @Override
            public void encode(B buffer, C value) {
                codec1.encode(buffer, getter1.apply(value));
                codec2.encode(buffer, getter2.apply(value));
                codec3.encode(buffer, getter3.apply(value));
                codec4.encode(buffer, getter4.apply(value));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5> StreamCodec<B, C> a(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> getter3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> getter4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> getter5, final Function5<T1, T2, T3, T4, T5, C> factory) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B buffer) {
                Object object = codec1.decode(buffer);
                Object object1 = codec2.decode(buffer);
                Object object2 = codec3.decode(buffer);
                Object object3 = codec4.decode(buffer);
                Object object4 = codec5.decode(buffer);
                return factory.apply(object, object1, object2, object3, object4);
            }

            @Override
            public void encode(B buffer, C value) {
                codec1.encode(buffer, getter1.apply(value));
                codec2.encode(buffer, getter2.apply(value));
                codec3.encode(buffer, getter3.apply(value));
                codec4.encode(buffer, getter4.apply(value));
                codec5.encode(buffer, getter5.apply(value));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5, T6> StreamCodec<B, C> a(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> getter3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> getter4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> getter5, final StreamCodec<? super B, T6> codec6, final Function<C, T6> getter6, final Function6<T1, T2, T3, T4, T5, T6, C> factory) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B buffer) {
                Object object = codec1.decode(buffer);
                Object object1 = codec2.decode(buffer);
                Object object2 = codec3.decode(buffer);
                Object object3 = codec4.decode(buffer);
                Object object4 = codec5.decode(buffer);
                Object object5 = codec6.decode(buffer);
                return factory.apply(object, object1, object2, object3, object4, object5);
            }

            @Override
            public void encode(B buffer, C value) {
                codec1.encode(buffer, getter1.apply(value));
                codec2.encode(buffer, getter2.apply(value));
                codec3.encode(buffer, getter3.apply(value));
                codec4.encode(buffer, getter4.apply(value));
                codec5.encode(buffer, getter5.apply(value));
                codec6.encode(buffer, getter6.apply(value));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5, T6, T7> StreamCodec<B, C> a(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> getter3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> getter4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> getter5, final StreamCodec<? super B, T6> codec6, final Function<C, T6> getter6, final StreamCodec<? super B, T7> codec7, final Function<C, T7> getter7, final Function7<T1, T2, T3, T4, T5, T6, T7, C> factory) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B buffer) {
                Object object = codec1.decode(buffer);
                Object object1 = codec2.decode(buffer);
                Object object2 = codec3.decode(buffer);
                Object object3 = codec4.decode(buffer);
                Object object4 = codec5.decode(buffer);
                Object object5 = codec6.decode(buffer);
                Object object6 = codec7.decode(buffer);
                return factory.apply(object, object1, object2, object3, object4, object5, object6);
            }

            @Override
            public void encode(B buffer, C value) {
                codec1.encode(buffer, getter1.apply(value));
                codec2.encode(buffer, getter2.apply(value));
                codec3.encode(buffer, getter3.apply(value));
                codec4.encode(buffer, getter4.apply(value));
                codec5.encode(buffer, getter5.apply(value));
                codec6.encode(buffer, getter6.apply(value));
                codec7.encode(buffer, getter7.apply(value));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5, T6, T7, T8> StreamCodec<B, C> a(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> getter3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> getter4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> getter5, final StreamCodec<? super B, T6> codec6, final Function<C, T6> getter6, final StreamCodec<? super B, T7> codec7, final Function<C, T7> getter7, final StreamCodec<? super B, T8> codec8, final Function<C, T8> getter8, final Function8<T1, T2, T3, T4, T5, T6, T7, T8, C> factory) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B buffer) {
                Object object = codec1.decode(buffer);
                Object object1 = codec2.decode(buffer);
                Object object2 = codec3.decode(buffer);
                Object object3 = codec4.decode(buffer);
                Object object4 = codec5.decode(buffer);
                Object object5 = codec6.decode(buffer);
                Object object6 = codec7.decode(buffer);
                Object object7 = codec8.decode(buffer);
                return factory.apply(object, object1, object2, object3, object4, object5, object6, object7);
            }

            @Override
            public void encode(B buffer, C value) {
                codec1.encode(buffer, getter1.apply(value));
                codec2.encode(buffer, getter2.apply(value));
                codec3.encode(buffer, getter3.apply(value));
                codec4.encode(buffer, getter4.apply(value));
                codec5.encode(buffer, getter5.apply(value));
                codec6.encode(buffer, getter6.apply(value));
                codec7.encode(buffer, getter7.apply(value));
                codec8.encode(buffer, getter8.apply(value));
            }
        };
    }

    public static <B, T> StreamCodec<B, T> a(final UnaryOperator<StreamCodec<B, T>> modifier) {
        return new StreamCodec<B, T>(){
            private final Supplier<StreamCodec<B, T>> b = Suppliers.memoize(() -> (StreamCodec)modifier.apply(this));

            @Override
            public T decode(B buffer) {
                return this.b.get().decode(buffer);
            }

            @Override
            public void encode(B buffer, T value) {
                this.b.get().encode(buffer, value);
            }
        };
    }

    default public <S extends B> StreamCodec<S, V> a() {
        return this;
    }

    @FunctionalInterface
    public static interface a<B, S, T> {
        public StreamCodec<B, T> apply(StreamCodec<B, S> var1);
    }
}

