/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.selector.SelectorPattern;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.numbers.StyledFormat;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardObjective;

public final class ScoreContents
extends Record
implements ComponentContents {
    private final Either<SelectorPattern, String> d;
    private final String e;
    public static final MapCodec<ScoreContents> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.either(SelectorPattern.a, (Codec)Codec.STRING).fieldOf("name").forGetter(ScoreContents::b), (App)Codec.STRING.fieldOf("objective").forGetter(ScoreContents::c)).apply((Applicative)instance, ScoreContents::new));
    public static final MapCodec<ScoreContents> b = a.fieldOf("score");
    public static final ComponentContents.a<ScoreContents> c = new ComponentContents.a<ScoreContents>(b, "score");

    public ScoreContents(Either<SelectorPattern, String> name, String objective) {
        this.d = name;
        this.e = objective;
    }

    @Override
    public ComponentContents.a<?> a() {
        return c;
    }

    private ScoreHolder a(CommandListenerWrapper source) throws CommandSyntaxException {
        Optional<SelectorPattern> optional = this.d.left();
        if (optional.isPresent()) {
            List<? extends Entity> list = optional.get().b().b(source);
            if (!list.isEmpty()) {
                if (list.size() != 1) {
                    throw ArgumentEntity.a.create();
                }
                return list.getFirst();
            }
            return ScoreHolder.c(optional.get().a());
        }
        return ScoreHolder.c(this.d.right().orElseThrow());
    }

    private IChatMutableComponent a(ScoreHolder scoreHolder, CommandListenerWrapper source) {
        ReadOnlyScoreInfo playerScoreInfo;
        ScoreboardServer scoreboard;
        ScoreboardObjective objective;
        MinecraftServer server = source.l();
        if (server != null && (objective = (scoreboard = server.aJ()).a(this.e)) != null && (playerScoreInfo = scoreboard.d(scoreHolder, objective)) != null) {
            return playerScoreInfo.a(objective.a(StyledFormat.b));
        }
        return IChatBaseComponent.i();
    }

    @Override
    public IChatMutableComponent a(@Nullable CommandListenerWrapper nbtPathPattern, @Nullable Entity entity, int recursionDepth) throws CommandSyntaxException {
        if (nbtPathPattern == null) {
            return IChatBaseComponent.i();
        }
        ScoreHolder scoreHolder = this.a(nbtPathPattern);
        ScoreHolder scoreHolder1 = entity != null && scoreHolder.equals(ScoreHolder.cB) ? entity : scoreHolder;
        return this.a(scoreHolder1, nbtPathPattern);
    }

    @Override
    public String toString() {
        return "score{name='" + String.valueOf(this.d) + "', objective='" + this.e + "'}";
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ScoreContents.class, "name;objective", "d", "e"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ScoreContents.class, "name;objective", "d", "e"}, this, o2);
    }

    public Either<SelectorPattern, String> b() {
        return this.d;
    }

    public String c() {
        return this.e;
    }
}

