/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.world.entity.Entity;
import org.slf4j.Logger;

public class NbtContents
implements ComponentContents {
    private static final Logger d = LogUtils.getLogger();
    public static final MapCodec<NbtContents> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("nbt").forGetter(NbtContents::b), (App)Codec.BOOL.lenientOptionalFieldOf("interpret", (Object)false).forGetter(NbtContents::c), (App)ComponentSerialization.a.lenientOptionalFieldOf("separator").forGetter(NbtContents::d), (App)DataSource.c.forGetter(NbtContents::e)).apply((Applicative)instance, NbtContents::new));
    public static final ComponentContents.a<NbtContents> b = new ComponentContents.a<NbtContents>(a, "nbt");
    private final boolean e;
    private final Optional<IChatBaseComponent> f;
    private final String g;
    private final DataSource h;
    @Nullable
    protected final ArgumentNBTKey.g c;

    public NbtContents(String nbtPathPattern, boolean interpreting, Optional<IChatBaseComponent> separator, DataSource dataSource) {
        this(nbtPathPattern, NbtContents.a(nbtPathPattern), interpreting, separator, dataSource);
    }

    private NbtContents(String nbtPathPattern, @Nullable ArgumentNBTKey.g compiledNbtPath, boolean interpreting, Optional<IChatBaseComponent> separator, DataSource dataSource) {
        this.g = nbtPathPattern;
        this.c = compiledNbtPath;
        this.e = interpreting;
        this.f = separator;
        this.h = dataSource;
    }

    @Nullable
    private static ArgumentNBTKey.g a(String nbtPathPattern) {
        try {
            return new ArgumentNBTKey().a(new StringReader(nbtPathPattern));
        }
        catch (CommandSyntaxException var2) {
            return null;
        }
    }

    public String b() {
        return this.g;
    }

    public boolean c() {
        return this.e;
    }

    public Optional<IChatBaseComponent> d() {
        return this.f;
    }

    public DataSource e() {
        return this.h;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof NbtContents)) return false;
        NbtContents nbtContents = (NbtContents)other;
        if (!this.h.equals(nbtContents.h)) return false;
        if (!this.f.equals(nbtContents.f)) return false;
        if (this.e != nbtContents.e) return false;
        if (!this.g.equals(nbtContents.g)) return false;
        return true;
    }

    public int hashCode() {
        int i2 = this.e ? 1 : 0;
        i2 = 31 * i2 + this.f.hashCode();
        i2 = 31 * i2 + this.g.hashCode();
        return 31 * i2 + this.h.hashCode();
    }

    public String toString() {
        return "nbt{" + String.valueOf(this.h) + ", interpreting=" + this.e + ", separator=" + String.valueOf(this.f) + "}";
    }

    @Override
    public IChatMutableComponent a(@Nullable CommandListenerWrapper nbtPathPattern, @Nullable Entity entity, int recursionDepth) throws CommandSyntaxException {
        if (nbtPathPattern != null && this.c != null) {
            Stream<String> stream = this.h.a(nbtPathPattern).flatMap(tag -> {
                try {
                    return this.c.a((NBTBase)tag).stream();
                }
                catch (CommandSyntaxException var3x) {
                    return Stream.empty();
                }
            }).map(NBTBase::u_);
            if (this.e) {
                IChatBaseComponent component = (IChatBaseComponent)DataFixUtils.orElse(ChatComponentUtils.updateSeparatorForEntity(nbtPathPattern, this.f, entity, recursionDepth), (Object)ChatComponentUtils.c);
                return stream.flatMap(text -> {
                    try {
                        IChatMutableComponent mutableComponent = IChatBaseComponent.ChatSerializer.a(text, (HolderLookup.a)nbtPathPattern.u());
                        return Stream.of(ChatComponentUtils.a(nbtPathPattern, mutableComponent, entity, recursionDepth));
                    }
                    catch (Exception var5x) {
                        d.warn("Failed to parse component: {}", text, (Object)var5x);
                        return Stream.of(new IChatMutableComponent[0]);
                    }
                }).reduce((mutableComponent, component1) -> mutableComponent.b(component).b((IChatBaseComponent)component1)).orElseGet(IChatBaseComponent::i);
            }
            return ChatComponentUtils.updateSeparatorForEntity(nbtPathPattern, this.f, entity, recursionDepth).map(mutableComponent -> stream.map(IChatBaseComponent::b).reduce((mutableComponent1, otherMutableComponent) -> mutableComponent1.b((IChatBaseComponent)mutableComponent).b((IChatBaseComponent)otherMutableComponent)).orElseGet(IChatBaseComponent::i)).orElseGet(() -> IChatBaseComponent.b(stream.collect(Collectors.joining(", "))));
        }
        return IChatBaseComponent.i();
    }

    @Override
    public ComponentContents.a<?> a() {
        return b;
    }
}

