/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionNBT;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.world.entity.Entity;

public final class EntityDataSource
extends Record
implements DataSource {
    private final String d;
    @Nullable
    private final EntitySelector e;
    public static final MapCodec<EntityDataSource> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("entity").forGetter(EntityDataSource::b)).apply((Applicative)instance, EntityDataSource::new));
    public static final DataSource.a<EntityDataSource> b = new DataSource.a<EntityDataSource>(a, "entity");

    public EntityDataSource(String selectorPattern) {
        this(selectorPattern, EntityDataSource.a(selectorPattern));
    }

    public EntityDataSource(String selectorPattern, @Nullable EntitySelector compiledSelector) {
        this.d = selectorPattern;
        this.e = compiledSelector;
    }

    @Nullable
    private static EntitySelector a(String selectorPattern) {
        try {
            ArgumentParserSelector entitySelectorParser = new ArgumentParserSelector(new StringReader(selectorPattern), true);
            return entitySelectorParser.t();
        }
        catch (CommandSyntaxException var2) {
            return null;
        }
    }

    @Override
    public Stream<NBTTagCompound> a(CommandListenerWrapper source) throws CommandSyntaxException {
        if (this.e != null) {
            List<? extends Entity> list = this.e.b(source);
            return list.stream().map(CriterionConditionNBT::b);
        }
        return Stream.empty();
    }

    @Override
    public DataSource.a<?> a() {
        return b;
    }

    @Override
    public String toString() {
        return "entity=" + this.d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof EntityDataSource)) return false;
        EntityDataSource entityDataSource = (EntityDataSource)other;
        if (!this.d.equals(entityDataSource.d)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.d.hashCode();
    }

    public String b() {
        return this.d;
    }

    @Nullable
    public EntitySelector c() {
        return this.e;
    }
}

