/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.block.entity.TileEntity;

public final class BlockDataSource
extends Record
implements DataSource {
    private final String d;
    @Nullable
    private final IVectorPosition e;
    public static final MapCodec<BlockDataSource> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("block").forGetter(BlockDataSource::b)).apply((Applicative)instance, BlockDataSource::new));
    public static final DataSource.a<BlockDataSource> b = new DataSource.a<BlockDataSource>(a, "block");

    public BlockDataSource(String posPattern) {
        this(posPattern, BlockDataSource.a(posPattern));
    }

    public BlockDataSource(String posPattern, @Nullable IVectorPosition compiledPos) {
        this.d = posPattern;
        this.e = compiledPos;
    }

    @Nullable
    private static IVectorPosition a(String posPattern) {
        try {
            return ArgumentPosition.a().a(new StringReader(posPattern));
        }
        catch (CommandSyntaxException var2) {
            return null;
        }
    }

    @Override
    public Stream<NBTTagCompound> a(CommandListenerWrapper source) {
        TileEntity blockEntity;
        BlockPosition blockPos;
        WorldServer level;
        if (this.e != null && (level = source.e()).p(blockPos = this.e.c(source)) && (blockEntity = level.c_(blockPos)) != null) {
            return Stream.of(blockEntity.b(source.u()));
        }
        return Stream.empty();
    }

    @Override
    public DataSource.a<?> a() {
        return b;
    }

    @Override
    public String toString() {
        return "block=" + this.d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof BlockDataSource)) return false;
        BlockDataSource blockDataSource = (BlockDataSource)other;
        if (!this.d.equals(blockDataSource.d)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.d.hashCode();
    }

    public String b() {
        return this.d;
    }

    @Nullable
    public IVectorPosition c() {
        return this.e;
    }
}

