/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.util.FormattedString;
import net.minecraft.util.StringDecomposer;

public class SubStringSource {
    private final String a;
    private final List<ChatModifier> b;
    private final Int2IntFunction c;

    private SubStringSource(String plainText, List<ChatModifier> charStyles, Int2IntFunction reverseCharModifier) {
        this.a = plainText;
        this.b = ImmutableList.copyOf(charStyles);
        this.c = reverseCharModifier;
    }

    public String a() {
        return this.a;
    }

    public List<FormattedString> a(int fromIndex, int toIndex, boolean reversed) {
        if (toIndex == 0) {
            return ImmutableList.of();
        }
        ArrayList list = Lists.newArrayList();
        ChatModifier style = this.b.get(fromIndex);
        int i2 = fromIndex;
        for (int i1 = 1; i1 < toIndex; ++i1) {
            int i22 = fromIndex + i1;
            ChatModifier style1 = this.b.get(i22);
            if (style1.equals(style)) continue;
            String sub = this.a.substring(i2, i22);
            list.add(reversed ? FormattedString.backward(sub, style, this.c) : FormattedString.forward(sub, style));
            style = style1;
            i2 = i22;
        }
        if (i2 < fromIndex + toIndex) {
            String sub1 = this.a.substring(i2, fromIndex + toIndex);
            list.add(reversed ? FormattedString.backward(sub1, style, this.c) : FormattedString.forward(sub1, style));
        }
        return reversed ? Lists.reverse((List)list) : list;
    }

    public static SubStringSource a(IChatFormatted formattedText) {
        return SubStringSource.a(formattedText, modifier -> modifier, text -> text);
    }

    public static SubStringSource a(IChatFormatted formattedText, Int2IntFunction reverseCharModifier, UnaryOperator<String> textTransformer) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList list = Lists.newArrayList();
        formattedText.a((style, content) -> {
            StringDecomposer.c(content, style, (positionInCurrentSequence, style1, codePoint) -> {
                stringBuilder.appendCodePoint(codePoint);
                int i2 = Character.charCount(codePoint);
                for (int i1 = 0; i1 < i2; ++i1) {
                    list.add(style1);
                }
                return true;
            });
            return Optional.empty();
        }, ChatModifier.a);
        return new SubStringSource((String)textTransformer.apply(stringBuilder.toString()), list, reverseCharModifier);
    }
}

