/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.gson.JsonParser;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.INamable;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ChatHoverable {
    public static final Codec<ChatHoverable> a = Codec.withAlternative((Codec)e.a.codec(), (Codec)e.b.codec()).xmap(ChatHoverable::new, hoverEvent -> hoverEvent.b);
    private final e<?> b;

    public <T> ChatHoverable(EnumHoverAction<T> action, T value) {
        this(new e<T>(action, value));
    }

    private ChatHoverable(e<?> event) {
        this.b = event;
    }

    public EnumHoverAction<?> a() {
        return this.b.c;
    }

    @Nullable
    public <T> T a(EnumHoverAction<T> actionType) {
        return this.b.c == actionType ? (T)actionType.a(this.b.d) : null;
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && ((ChatHoverable)other).b.equals(this.b);
    }

    public String toString() {
        return this.b.toString();
    }

    public int hashCode() {
        return this.b.hashCode();
    }

    static final class e<T>
    extends Record {
        private final EnumHoverAction<T> c;
        private final T d;
        public static final MapCodec<e<?>> a = EnumHoverAction.e.dispatchMap("action", e::a, hoverEvent -> hoverEvent.h);
        public static final MapCodec<e<?>> b = EnumHoverAction.e.dispatchMap("action", e::a, hoverEvent -> hoverEvent.i);

        e(EnumHoverAction<T> action, T value) {
            this.c = action;
            this.d = value;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "action;value", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "action;value", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "action;value", "c", "d"}, this, o2);
        }

        public EnumHoverAction<T> a() {
            return this.c;
        }

        public T b() {
            return this.d;
        }
    }

    public static class EnumHoverAction<T>
    implements INamable {
        public static final EnumHoverAction<IChatBaseComponent> a = new EnumHoverAction<IChatBaseComponent>("show_text", true, ComponentSerialization.a, (name, ops) -> DataResult.success((Object)name));
        public static final EnumHoverAction<c> b = new EnumHoverAction<c>("show_item", true, net.minecraft.network.chat.ChatHoverable$c.b, c::a);
        public static final EnumHoverAction<b> c = new EnumHoverAction<b>("show_entity", true, net.minecraft.network.chat.ChatHoverable$b.a, b::a);
        public static final Codec<EnumHoverAction<?>> d = INamable.b(() -> new EnumHoverAction[]{a, b, c});
        public static final Codec<EnumHoverAction<?>> e = d.validate(EnumHoverAction::a);
        private final String f;
        private final boolean g;
        final MapCodec<e<T>> h;
        final MapCodec<e<T>> i;

        public EnumHoverAction(String name, boolean allowFromServer, Codec<T> codec, final d<T> legacyConverter) {
            this.f = name;
            this.g = allowFromServer;
            this.h = codec.xmap(object -> new e<Object>(this, object), typedHoverEvent -> typedHoverEvent.d).fieldOf("contents");
            this.i = new Codec<e<T>>(){

                public <D> DataResult<Pair<e<T>, D>> decode(DynamicOps<D> dynamicOps, D object) {
                    return ComponentSerialization.a.decode(dynamicOps, object).flatMap(pair -> {
                        DataResult dataResult;
                        if (dynamicOps instanceof RegistryOps) {
                            RegistryOps registryOps = (RegistryOps)dynamicOps;
                            dataResult = legacyConverter.parse((IChatBaseComponent)pair.getFirst(), registryOps);
                        } else {
                            dataResult = legacyConverter.parse((IChatBaseComponent)pair.getFirst(), null);
                        }
                        return dataResult.map(object1 -> Pair.of(new e<Object>(this, object1), (Object)pair.getSecond()));
                    });
                }

                public <D> DataResult<D> a(e<T> typedHoverEvent, DynamicOps<D> dynamicOps, D object) {
                    return DataResult.error(() -> "Can't encode in legacy format");
                }
            }.fieldOf("value");
        }

        public boolean a() {
            return this.g;
        }

        @Override
        public String c() {
            return this.f;
        }

        T a(Object parameter) {
            return (T)parameter;
        }

        public String toString() {
            return "<action " + this.f + ">";
        }

        private static DataResult<EnumHoverAction<?>> a(@Nullable EnumHoverAction<?> action) {
            if (action == null) {
                return DataResult.error(() -> "Unknown action");
            }
            return !action.a() ? DataResult.error(() -> "Action not allowed: " + String.valueOf(action)) : DataResult.success(action, (Lifecycle)Lifecycle.stable());
        }
    }

    public static interface d<T> {
        public DataResult<T> parse(IChatBaseComponent var1, @Nullable RegistryOps<?> var2);
    }

    public static class c {
        public static final Codec<c> a = ItemStack.a.xmap(c::new, c::a);
        private static final Codec<c> c = ItemStack.f.xmap(c::new, c::a);
        public static final Codec<c> b = Codec.withAlternative(a, c);
        public final Holder<Item> d;
        public final int e;
        public final DataComponentPatch f;
        @Nullable
        private ItemStack g;

        c(Holder<Item> item, int count, DataComponentPatch components) {
            this.d = item;
            this.e = count;
            this.f = components;
        }

        public c(ItemStack stack) {
            this(stack.i(), stack.M(), stack.d());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other != null && this.getClass() == other.getClass()) {
                c itemStackInfo = (c)other;
                return this.e == itemStackInfo.e && this.d.equals(itemStackInfo.d) && this.f.equals(itemStackInfo.f);
            }
            return false;
        }

        public int hashCode() {
            int hashCode = this.d.hashCode();
            hashCode = 31 * hashCode + this.e;
            return 31 * hashCode + this.f.hashCode();
        }

        public ItemStack a() {
            if (this.g == null) {
                this.g = new ItemStack(this.d, this.e, this.f);
            }
            return this.g;
        }

        private static DataResult<c> a(IChatBaseComponent name, @Nullable RegistryOps<?> ops) {
            try {
                NBTTagCompound compoundTag = MojangsonParser.a(name.getString());
                DynamicOpsNBT dynamicOps = ops != null ? ops.a(DynamicOpsNBT.a) : DynamicOpsNBT.a;
                return ItemStack.a.parse((DynamicOps)dynamicOps, (Object)compoundTag).map(c::new);
            }
            catch (CommandSyntaxException var4) {
                return DataResult.error(() -> "Failed to parse item tag: " + var4.getMessage());
            }
        }
    }

    public static class b {
        public static final Codec<b> a = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f.q().fieldOf("type").forGetter(info -> info.b), (App)UUIDUtil.f.fieldOf("id").forGetter(info -> info.c), (App)ComponentSerialization.a.lenientOptionalFieldOf("name").forGetter(info -> info.d)).apply((Applicative)instance, b::new));
        public final EntityTypes<?> b;
        public final UUID c;
        public final Optional<IChatBaseComponent> d;
        @Nullable
        private List<IChatBaseComponent> e;

        public b(EntityTypes<?> type, UUID id, @Nullable IChatBaseComponent name) {
            this(type, id, Optional.ofNullable(name));
        }

        public b(EntityTypes<?> type, UUID id, Optional<IChatBaseComponent> name) {
            this.b = type;
            this.c = id;
            this.d = name;
        }

        public static DataResult<b> a(IChatBaseComponent name, @Nullable RegistryOps<?> ops) {
            try {
                NBTTagCompound compoundTag = MojangsonParser.a(name.getString());
                JsonOps dynamicOps = ops != null ? ops.a(JsonOps.INSTANCE) : JsonOps.INSTANCE;
                DataResult dataResult = ComponentSerialization.a.parse((DynamicOps)dynamicOps, (Object)JsonParser.parseString((String)compoundTag.l("name")));
                EntityTypes<?> entityType = BuiltInRegistries.f.a(MinecraftKey.a(compoundTag.l("type")));
                UUID uuid = UUID.fromString(compoundTag.l("id"));
                return dataResult.map(component -> new b(entityType, uuid, (IChatBaseComponent)component));
            }
            catch (Exception var7) {
                return DataResult.error(() -> "Failed to parse tooltip: " + var7.getMessage());
            }
        }

        public List<IChatBaseComponent> a() {
            if (this.e == null) {
                this.e = new ArrayList<IChatBaseComponent>();
                this.d.ifPresent(this.e::add);
                this.e.add(IChatBaseComponent.a("gui.entity_tooltip.type", this.b.h()));
                this.e.add(IChatBaseComponent.b(this.c.toString()));
            }
            return this.e;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other != null && this.getClass() == other.getClass()) {
                b entityTooltipInfo = (b)other;
                return this.b.equals(entityTooltipInfo.b) && this.c.equals(entityTooltipInfo.c) && this.d.equals(entityTooltipInfo.d);
            }
            return false;
        }

        public int hashCode() {
            int hashCode = this.b.hashCode();
            hashCode = 31 * hashCode + this.c.hashCode();
            return 31 * hashCode + this.d.hashCode();
        }
    }
}

