/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.velocitypowered.natives.Native;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.util.MoreByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import io.papermc.paper.annotation.DoNotUse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.minecraft.network.VarInt;

public class PacketDecompressor
extends ByteToMessageDecoder {
    public static final int a = 0x200000;
    public static final int b = 0x800000;
    private VelocityCompressor compressor;
    private Inflater c;
    private int d;
    private boolean e;

    @DoNotUse
    public PacketDecompressor(int threshold, boolean validateDecompressed) {
        this(null, threshold, validateDecompressed);
    }

    public PacketDecompressor(VelocityCompressor compressor, int threshold, boolean validateDecompressed) {
        this.d = threshold;
        this.e = validateDecompressed;
        this.c = compressor == null ? new Inflater() : null;
        this.compressor = compressor;
    }

    protected void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() != 0) {
            int i2 = VarInt.a(in);
            if (i2 == 0) {
                out.add(in.readBytes(in.readableBytes()));
            } else {
                if (this.e) {
                    if (i2 < this.d) {
                        throw new DecoderException("Badly compressed packet - size of " + i2 + " is below server threshold of " + this.d);
                    }
                    if (i2 > 0x800000) {
                        throw new DecoderException("Badly compressed packet - size of " + i2 + " is larger than protocol maximum of 8388608");
                    }
                }
                if (this.c != null) {
                    this.a(in);
                    ByteBuf byteBuf = this.a(context, i2);
                    this.c.reset();
                    out.add(byteBuf);
                    return;
                }
                int claimedUncompressedSize = i2;
                ByteBuf compatibleIn = MoreByteBufUtils.ensureCompatible((ByteBufAllocator)context.alloc(), (Native)this.compressor, (ByteBuf)in);
                ByteBuf uncompressed = MoreByteBufUtils.preferredBuffer((ByteBufAllocator)context.alloc(), (Native)this.compressor, (int)claimedUncompressedSize);
                try {
                    this.compressor.inflate(compatibleIn, uncompressed, claimedUncompressedSize);
                    out.add(uncompressed);
                    in.clear();
                }
                catch (Exception e2) {
                    uncompressed.release();
                    throw e2;
                }
                finally {
                    compatibleIn.release();
                }
            }
        }
    }

    public void handlerRemoved0(ChannelHandlerContext ctx) {
        if (this.compressor != null) {
            this.compressor.close();
        }
    }

    private void a(ByteBuf buffer) {
        ByteBuffer byteBuffer;
        if (buffer.nioBufferCount() > 0) {
            byteBuffer = buffer.nioBuffer();
            buffer.skipBytes(buffer.readableBytes());
        } else {
            byteBuffer = ByteBuffer.allocateDirect(buffer.readableBytes());
            buffer.readBytes(byteBuffer);
            byteBuffer.flip();
        }
        this.c.setInput(byteBuffer);
    }

    private ByteBuf a(ChannelHandlerContext context, int size) throws DataFormatException {
        ByteBuf byteBuf = context.alloc().directBuffer(size);
        try {
            ByteBuffer byteBuffer = byteBuf.internalNioBuffer(0, size);
            int position = byteBuffer.position();
            this.c.inflate(byteBuffer);
            int i2 = byteBuffer.position() - position;
            if (i2 != size) {
                throw new DecoderException("Badly compressed packet - actual length of uncompressed payload " + i2 + " is does not match declared size " + size);
            }
            byteBuf.writerIndex(byteBuf.writerIndex() + i2);
            return byteBuf;
        }
        catch (Exception var7) {
            byteBuf.release();
            throw var7;
        }
    }

    public void setThreshold(VelocityCompressor compressor, int threshold, boolean validateDecompressed) {
        if (this.compressor == null && compressor != null) {
            this.compressor = compressor;
            this.c = null;
        }
        this.d = threshold;
        this.e = validateDecompressed;
    }
}

