/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.IOException;
import java.util.List;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.ProtocolSwapHandler;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import org.slf4j.Logger;

public class PacketDecoder<T extends PacketListener>
extends ByteToMessageDecoder
implements ProtocolSwapHandler {
    private static final Logger a = LogUtils.getLogger();
    private final ProtocolInfo<T> b;

    public PacketDecoder(ProtocolInfo<T> protocolInfo) {
        this.b = protocolInfo;
    }

    protected void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out) throws Exception {
        int i2 = in.readableBytes();
        if (i2 != 0) {
            Packet packet = (Packet)this.b.c().decode(in);
            PacketType packetType = packet.a();
            JvmProfiler.f.a(this.b.a(), packetType, context.channel().remoteAddress(), i2);
            if (in.readableBytes() > 0) {
                throw new IOException("Packet " + this.b.a().a() + "/" + String.valueOf(packetType) + " (" + packet.getClass().getSimpleName() + ") was larger than I expected, found " + in.readableBytes() + " bytes extra whilst reading packet " + String.valueOf(packetType));
            }
            out.add(packet);
            if (a.isDebugEnabled()) {
                a.debug(NetworkManager.c, " IN: [{}:{}] {} -> {} bytes", new Object[]{this.b.a().a(), packetType, packet.getClass().getName(), i2});
            }
            ProtocolSwapHandler.a(context, packet);
        }
    }
}

