/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ByteProcessor;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.security.PublicKey;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.IRegistry;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.Utf8String;
import net.minecraft.network.VarInt;
import net.minecraft.network.VarLong;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PacketDataSerializer
extends ByteBuf {
    public static final int a = 0x200000;
    private final ByteBuf d;
    @Nullable
    public final Locale adventure$locale = PacketEncoder.ADVENTURE_LOCALE.get();
    public static final short b = Short.MAX_VALUE;
    public static final int c = 262144;
    private static final int e = 256;
    private static final int f = 256;
    private static final int g = 512;
    private static final Gson h = new Gson();
    public boolean trackCodecDepth;
    public byte codecDepth;

    public PacketDataSerializer(ByteBuf source) {
        this.d = source;
    }

    @Deprecated
    public <T> T a(DynamicOps<NBTBase> ops, Codec<T> codec) {
        return this.a(ops, codec, NBTReadLimiter.a());
    }

    @Deprecated
    public <T> T a(DynamicOps<NBTBase> ops, Codec<T> codec, NBTReadLimiter nbtAccounter) {
        NBTBase nbt = this.a(nbtAccounter);
        return (T)codec.parse(ops, (Object)nbt).getOrThrow(exception -> new DecoderException("Failed to decode: " + exception + " " + String.valueOf(nbt)));
    }

    @Deprecated
    public <T> PacketDataSerializer a(DynamicOps<NBTBase> ops, Codec<T> codec, T value) {
        NBTBase tag = (NBTBase)codec.encodeStart(ops, value).getOrThrow(exception -> new EncoderException("Failed to encode: " + exception + " " + String.valueOf(value)));
        this.a(tag);
        return this;
    }

    public <T> T a(Codec<T> codec) {
        JsonElement jsonElement = ChatDeserializer.a(h, this.p(), JsonElement.class);
        DataResult dataResult = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement);
        return (T)dataResult.getOrThrow(exception -> new DecoderException("Failed to decode json: " + exception));
    }

    public <T> void a(Codec<T> codec, T value) {
        this.writeJsonWithCodec(codec, value, Short.MAX_VALUE);
    }

    public <T> void writeJsonWithCodec(Codec<T> codec, T value, int maxLength) {
        DataResult dataResult = codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value);
        this.a(h.toJson((JsonElement)dataResult.getOrThrow(exception -> new EncoderException("Failed to encode: " + exception + " " + String.valueOf(value)))), maxLength);
    }

    public static <T> IntFunction<T> a(IntFunction<T> function, int limit) {
        return value -> {
            if (value > limit) {
                throw new DecoderException("Value " + value + " is larger than limit " + limit);
            }
            return function.apply(value);
        };
    }

    public <T, C extends Collection<T>> C a(IntFunction<C> collectionFactory, StreamDecoder<? super PacketDataSerializer, T> elementReader) {
        int varInt = this.l();
        Collection collection = (Collection)collectionFactory.apply(varInt);
        for (int i2 = 0; i2 < varInt; ++i2) {
            collection.add(elementReader.decode(this));
        }
        return (C)collection;
    }

    public <T> void a(Collection<T> collection, StreamEncoder<? super PacketDataSerializer, T> elementWriter) {
        this.c(collection.size());
        for (T object : collection) {
            elementWriter.encode(this, object);
        }
    }

    public <T> List<T> a(StreamDecoder<? super PacketDataSerializer, T> elementReader) {
        return (List)this.a((ByteBuf)((IntFunction<ArrayList>)Lists::newArrayListWithCapacity), (StreamDecoder)elementReader);
    }

    public IntList a() {
        int varInt = this.l();
        IntArrayList list = new IntArrayList();
        for (int i2 = 0; i2 < varInt; ++i2) {
            list.add(this.l());
        }
        return list;
    }

    public void a(IntList itIdList) {
        this.c(itIdList.size());
        itIdList.forEach(this::c);
    }

    public <K, V, M extends Map<K, V>> M a(IntFunction<M> mapFactory, StreamDecoder<? super PacketDataSerializer, K> keyReader, StreamDecoder<? super PacketDataSerializer, V> valueReader) {
        int varInt = this.l();
        Map map = (Map)mapFactory.apply(varInt);
        for (int i2 = 0; i2 < varInt; ++i2) {
            K object = keyReader.decode(this);
            V object1 = valueReader.decode(this);
            map.put(object, object1);
        }
        return (M)map;
    }

    public <K, V> Map<K, V> a(StreamDecoder<? super PacketDataSerializer, K> keyReader, StreamDecoder<? super PacketDataSerializer, V> valueReader) {
        return this.a(Maps::newHashMapWithExpectedSize, keyReader, valueReader);
    }

    public <K, V> void a(Map<K, V> map, StreamEncoder<? super PacketDataSerializer, K> keyWriter, StreamEncoder<? super PacketDataSerializer, V> valueWriter) {
        this.c(map.size());
        map.forEach((key, value) -> {
            keyWriter.encode(this, key);
            valueWriter.encode(this, value);
        });
    }

    public void a(Consumer<PacketDataSerializer> reader) {
        int varInt = this.l();
        for (int i2 = 0; i2 < varInt; ++i2) {
            reader.accept(this);
        }
    }

    public <E extends Enum<E>> void a(EnumSet<E> enumSet, Class<E> enumClass) {
        Enum[] enums = (Enum[])enumClass.getEnumConstants();
        BitSet bitSet = new BitSet(enums.length);
        for (int i2 = 0; i2 < enums.length; ++i2) {
            bitSet.set(i2, enumSet.contains(enums[i2]));
        }
        this.a(bitSet, enums.length);
    }

    public <E extends Enum<E>> EnumSet<E> a(Class<E> enumClass) {
        Enum[] enums = (Enum[])enumClass.getEnumConstants();
        BitSet fixedBitSet = this.e(enums.length);
        EnumSet<Enum> set = EnumSet.noneOf(enumClass);
        for (int i2 = 0; i2 < enums.length; ++i2) {
            if (!fixedBitSet.get(i2)) continue;
            set.add(enums[i2]);
        }
        return set;
    }

    public <T> void a(Optional<T> optional, StreamEncoder<? super PacketDataSerializer, T> writer) {
        if (optional.isPresent()) {
            this.a(true);
            writer.encode(this, optional.get());
        } else {
            this.a(false);
        }
    }

    public <T> Optional<T> b(StreamDecoder<? super PacketDataSerializer, T> reader) {
        return this.readBoolean() ? Optional.of(reader.decode(this)) : Optional.empty();
    }

    @Nullable
    public <T> T c(StreamDecoder<? super PacketDataSerializer, T> reader) {
        return PacketDataSerializer.a(this, reader);
    }

    @Nullable
    public static <T, B extends ByteBuf> T a(B buffer, StreamDecoder<? super B, T> reader) {
        return buffer.readBoolean() ? (T)reader.decode((B)buffer) : null;
    }

    public <T> void a(@Nullable T value, StreamEncoder<? super PacketDataSerializer, T> writer) {
        PacketDataSerializer.a(this, value, writer);
    }

    public static <T, B extends ByteBuf> void a(B buffer, @Nullable T value, StreamEncoder<? super B, T> writer) {
        if (value != null) {
            buffer.writeBoolean(true);
            writer.encode(buffer, value);
        } else {
            buffer.writeBoolean(false);
        }
    }

    public byte[] b() {
        return PacketDataSerializer.a(this);
    }

    public static byte[] a(ByteBuf buffer) {
        return PacketDataSerializer.a(buffer, buffer.readableBytes());
    }

    public PacketDataSerializer a(byte[] array) {
        PacketDataSerializer.a((ByteBuf)this, array);
        return this;
    }

    public static void a(ByteBuf buffer, byte[] array) {
        VarInt.a(buffer, array.length);
        buffer.writeBytes(array);
    }

    public byte[] a(int maxLength) {
        return PacketDataSerializer.a((ByteBuf)this, maxLength);
    }

    public static byte[] a(ByteBuf buffer, int maxSize) {
        int i2 = VarInt.a(buffer);
        if (i2 > maxSize) {
            throw new DecoderException("ByteArray with size " + i2 + " is bigger than allowed " + maxSize);
        }
        byte[] bytes = new byte[i2];
        buffer.readBytes(bytes);
        return bytes;
    }

    public PacketDataSerializer a(int[] array) {
        this.c(array.length);
        for (int i2 : array) {
            this.c(i2);
        }
        return this;
    }

    public int[] c() {
        return this.b(this.readableBytes());
    }

    public int[] b(int maxLength) {
        int varInt = this.l();
        if (varInt > maxLength) {
            throw new DecoderException("VarIntArray with size " + varInt + " is bigger than allowed " + maxLength);
        }
        int[] ints = new int[varInt];
        for (int i2 = 0; i2 < ints.length; ++i2) {
            ints[i2] = this.l();
        }
        return ints;
    }

    public PacketDataSerializer a(long[] array) {
        this.c(array.length);
        for (long l2 : array) {
            this.b(l2);
        }
        return this;
    }

    public long[] d() {
        return this.b((long[])null);
    }

    public long[] b(@Nullable long[] array) {
        return this.a(array, this.readableBytes() / 8);
    }

    public long[] a(@Nullable long[] array, int maxLength) {
        int varInt = this.l();
        if (array == null || array.length != varInt) {
            if (varInt > maxLength) {
                throw new DecoderException("LongArray with size " + varInt + " is bigger than allowed " + maxLength);
            }
            array = new long[varInt];
        }
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = this.readLong();
        }
        return array;
    }

    public BlockPosition e() {
        return PacketDataSerializer.b(this);
    }

    public static BlockPosition b(ByteBuf buffer) {
        return BlockPosition.d(buffer.readLong());
    }

    public PacketDataSerializer a(BlockPosition pos) {
        PacketDataSerializer.a((ByteBuf)this, pos);
        return this;
    }

    public static void a(ByteBuf buffer, BlockPosition pos) {
        buffer.writeLong(pos.a());
    }

    public ChunkCoordIntPair f() {
        return new ChunkCoordIntPair(this.readLong());
    }

    public PacketDataSerializer a(ChunkCoordIntPair chunkPos) {
        this.b(chunkPos.a());
        return this;
    }

    public static ChunkCoordIntPair c(ByteBuf buffer) {
        return new ChunkCoordIntPair(buffer.readLong());
    }

    public static void a(ByteBuf buffer, ChunkCoordIntPair chunkPos) {
        buffer.writeLong(chunkPos.a());
    }

    public SectionPosition g() {
        return SectionPosition.a(this.readLong());
    }

    public PacketDataSerializer a(SectionPosition sectionPos) {
        this.b(sectionPos.s());
        return this;
    }

    public GlobalPos h() {
        ResourceKey<World> resourceKey = this.a(Registries.be);
        BlockPosition blockPos = this.e();
        return GlobalPos.a(resourceKey, blockPos);
    }

    public void a(GlobalPos pos) {
        this.b(pos.a());
        this.a(pos.b());
    }

    public Vector3f i() {
        return PacketDataSerializer.d(this);
    }

    public static Vector3f d(ByteBuf buffer) {
        return new Vector3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
    }

    public void a(Vector3f vector3f) {
        PacketDataSerializer.a((ByteBuf)this, vector3f);
    }

    public static void a(ByteBuf buffer, Vector3f vector3f) {
        buffer.writeFloat(vector3f.x());
        buffer.writeFloat(vector3f.y());
        buffer.writeFloat(vector3f.z());
    }

    public Quaternionf j() {
        return PacketDataSerializer.e(this);
    }

    public static Quaternionf e(ByteBuf buffer) {
        return new Quaternionf(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
    }

    public void a(Quaternionf quaternion) {
        PacketDataSerializer.a((ByteBuf)this, quaternion);
    }

    public static void a(ByteBuf buffer, Quaternionf quaternion) {
        buffer.writeFloat(quaternion.x);
        buffer.writeFloat(quaternion.y);
        buffer.writeFloat(quaternion.z);
        buffer.writeFloat(quaternion.w);
    }

    public static Vec3D f(ByteBuf buffer) {
        return new Vec3D(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
    }

    public Vec3D k() {
        return PacketDataSerializer.f(this);
    }

    public static void a(ByteBuf buffer, Vec3D vec3) {
        buffer.writeDouble(vec3.a());
        buffer.writeDouble(vec3.b());
        buffer.writeDouble(vec3.c());
    }

    public void a(Vec3D vec3) {
        PacketDataSerializer.a((ByteBuf)this, vec3);
    }

    public <T extends Enum<T>> T b(Class<T> enumClass) {
        return (T)((Enum[])enumClass.getEnumConstants())[this.l()];
    }

    public PacketDataSerializer a(Enum<?> value) {
        return this.c(value.ordinal());
    }

    public <T> T a(IntFunction<T> idLookuo) {
        int varInt = this.l();
        return idLookuo.apply(varInt);
    }

    public <T> PacketDataSerializer a(ToIntFunction<T> idGetter, T value) {
        int i2 = idGetter.applyAsInt(value);
        return this.c(i2);
    }

    public int l() {
        return VarInt.a(this.d);
    }

    public long m() {
        return VarLong.a(this.d);
    }

    public PacketDataSerializer a(UUID uuid) {
        PacketDataSerializer.a((ByteBuf)this, uuid);
        return this;
    }

    public static void a(ByteBuf buffer, UUID id) {
        buffer.writeLong(id.getMostSignificantBits());
        buffer.writeLong(id.getLeastSignificantBits());
    }

    public UUID n() {
        return PacketDataSerializer.g(this);
    }

    public static UUID g(ByteBuf buffer) {
        return new UUID(buffer.readLong(), buffer.readLong());
    }

    public PacketDataSerializer c(int input) {
        VarInt.a(this.d, input);
        return this;
    }

    public PacketDataSerializer a(long value) {
        VarLong.a(this.d, value);
        return this;
    }

    public PacketDataSerializer a(@Nullable NBTBase tag) {
        PacketDataSerializer.a((ByteBuf)this, tag);
        return this;
    }

    public static void a(ByteBuf buffer, @Nullable NBTBase nbt) {
        if (nbt == null) {
            nbt = NBTTagEnd.b;
        }
        try {
            NBTCompressedStreamTools.a(nbt, (DataOutput)new ByteBufOutputStream(buffer));
        }
        catch (Exception var3) {
            throw new EncoderException((Throwable)var3);
        }
    }

    @Nullable
    public NBTTagCompound o() {
        return PacketDataSerializer.h(this);
    }

    @Nullable
    public static NBTTagCompound h(ByteBuf buffer) {
        NBTBase nbt = PacketDataSerializer.a(buffer, NBTReadLimiter.a(0x200000L));
        if (nbt != null && !(nbt instanceof NBTTagCompound)) {
            throw new DecoderException("Not a compound tag: " + String.valueOf(nbt));
        }
        return (NBTTagCompound)nbt;
    }

    @Nullable
    public static NBTBase a(ByteBuf buffer, NBTReadLimiter nbtAccounter) {
        try {
            NBTBase anyTag = NBTCompressedStreamTools.b((DataInput)new ByteBufInputStream(buffer), nbtAccounter);
            return anyTag.b() == 0 ? null : anyTag;
        }
        catch (IOException var3) {
            throw new EncoderException((Throwable)var3);
        }
    }

    @Nullable
    public NBTBase a(NBTReadLimiter nbtAccounter) {
        return PacketDataSerializer.a((ByteBuf)this, nbtAccounter);
    }

    public String p() {
        return this.d(Short.MAX_VALUE);
    }

    public String d(int maxLength) {
        return Utf8String.a(this.d, maxLength);
    }

    public PacketDataSerializer a(String string) {
        return this.a(string, Short.MAX_VALUE);
    }

    public PacketDataSerializer a(String string, int maxLength) {
        Utf8String.a(this.d, string, maxLength);
        return this;
    }

    public MinecraftKey q() {
        return MinecraftKey.a(this.d(Short.MAX_VALUE));
    }

    public PacketDataSerializer a(MinecraftKey resourceLocation) {
        this.a(resourceLocation.toString());
        return this;
    }

    public <T> ResourceKey<T> a(ResourceKey<? extends IRegistry<T>> registryKey) {
        MinecraftKey resourceLocation = this.q();
        return ResourceKey.a(registryKey, resourceLocation);
    }

    public void b(ResourceKey<?> resourceKey) {
        this.a(resourceKey.a());
    }

    public <T> ResourceKey<? extends IRegistry<T>> r() {
        MinecraftKey resourceLocation = this.q();
        return ResourceKey.a(resourceLocation);
    }

    public Date s() {
        return new Date(this.readLong());
    }

    public PacketDataSerializer a(Date time) {
        this.b(time.getTime());
        return this;
    }

    public Instant t() {
        return Instant.ofEpochMilli(this.readLong());
    }

    public void a(Instant instant) {
        this.b(instant.toEpochMilli());
    }

    public PublicKey u() {
        try {
            return MinecraftEncryption.a(this.a(512));
        }
        catch (CryptographyException var2) {
            throw new DecoderException("Malformed public key bytes", (Throwable)var2);
        }
    }

    public PacketDataSerializer a(PublicKey publicKey) {
        this.a(publicKey.getEncoded());
        return this;
    }

    public MovingObjectPositionBlock v() {
        BlockPosition blockPos = this.e();
        EnumDirection direction = this.b(EnumDirection.class);
        float _float = this.readFloat();
        float _float1 = this.readFloat();
        float _float2 = this.readFloat();
        boolean _boolean = this.readBoolean();
        boolean _boolean1 = this.readBoolean();
        return new MovingObjectPositionBlock(new Vec3D((double)blockPos.u() + (double)_float, (double)blockPos.v() + (double)_float1, (double)blockPos.w() + (double)_float2), direction, blockPos, _boolean, _boolean1);
    }

    public void a(MovingObjectPositionBlock result) {
        BlockPosition blockPos = result.b();
        this.a(blockPos);
        this.a(result.c());
        Vec3D location = result.g();
        this.a((float)(location.d - (double)blockPos.u()));
        this.a((float)(location.e - (double)blockPos.v()));
        this.a((float)(location.f - (double)blockPos.w()));
        this.a(result.e());
        this.a(result.f());
    }

    public BitSet w() {
        return BitSet.valueOf(this.d());
    }

    public void a(BitSet bitSet) {
        this.a(bitSet.toLongArray());
    }

    public BitSet e(int size) {
        byte[] bytes = new byte[MathHelper.e(size, 8)];
        this.b(bytes);
        return BitSet.valueOf(bytes);
    }

    public void a(BitSet bitSet, int size) {
        if (bitSet.length() > size) {
            throw new EncoderException("BitSet is larger than expected size (" + bitSet.length() + ">" + size + ")");
        }
        byte[] bytes = bitSet.toByteArray();
        this.c(Arrays.copyOf(bytes, MathHelper.e(size, 8)));
    }

    public static int i(ByteBuf buffer) {
        return VarInt.a(buffer);
    }

    public int x() {
        return PacketDataSerializer.i(this.d);
    }

    public static void b(ByteBuf buffer, int containerId) {
        VarInt.a(buffer, containerId);
    }

    public void f(int containerId) {
        PacketDataSerializer.b(this.d, containerId);
    }

    public boolean isContiguous() {
        return this.d.isContiguous();
    }

    public int maxFastWritableBytes() {
        return this.d.maxFastWritableBytes();
    }

    public int capacity() {
        return this.d.capacity();
    }

    public PacketDataSerializer g(int newCapacity) {
        this.d.capacity(newCapacity);
        return this;
    }

    public int maxCapacity() {
        return this.d.maxCapacity();
    }

    public ByteBufAllocator alloc() {
        return this.d.alloc();
    }

    public ByteOrder order() {
        return this.d.order();
    }

    public ByteBuf order(ByteOrder endianness) {
        return this.d.order(endianness);
    }

    public ByteBuf unwrap() {
        return this.d;
    }

    public boolean isDirect() {
        return this.d.isDirect();
    }

    public boolean isReadOnly() {
        return this.d.isReadOnly();
    }

    public ByteBuf asReadOnly() {
        return this.d.asReadOnly();
    }

    public int readerIndex() {
        return this.d.readerIndex();
    }

    public PacketDataSerializer h(int readerIndex) {
        this.d.readerIndex(readerIndex);
        return this;
    }

    public int writerIndex() {
        return this.d.writerIndex();
    }

    public PacketDataSerializer i(int writerIndex) {
        this.d.writerIndex(writerIndex);
        return this;
    }

    public PacketDataSerializer a(int readerIndex, int writerIndex) {
        this.d.setIndex(readerIndex, writerIndex);
        return this;
    }

    public int readableBytes() {
        return this.d.readableBytes();
    }

    public int writableBytes() {
        return this.d.writableBytes();
    }

    public int maxWritableBytes() {
        return this.d.maxWritableBytes();
    }

    public boolean isReadable() {
        return this.d.isReadable();
    }

    public boolean isReadable(int size) {
        return this.d.isReadable(size);
    }

    public boolean isWritable() {
        return this.d.isWritable();
    }

    public boolean isWritable(int size) {
        return this.d.isWritable(size);
    }

    public PacketDataSerializer y() {
        this.d.clear();
        return this;
    }

    public PacketDataSerializer z() {
        this.d.markReaderIndex();
        return this;
    }

    public PacketDataSerializer A() {
        this.d.resetReaderIndex();
        return this;
    }

    public PacketDataSerializer B() {
        this.d.markWriterIndex();
        return this;
    }

    public PacketDataSerializer C() {
        this.d.resetWriterIndex();
        return this;
    }

    public PacketDataSerializer D() {
        this.d.discardReadBytes();
        return this;
    }

    public PacketDataSerializer E() {
        this.d.discardSomeReadBytes();
        return this;
    }

    public PacketDataSerializer j(int size) {
        this.d.ensureWritable(size);
        return this;
    }

    public int ensureWritable(int size, boolean force) {
        return this.d.ensureWritable(size, force);
    }

    public boolean getBoolean(int index) {
        return this.d.getBoolean(index);
    }

    public byte getByte(int index) {
        return this.d.getByte(index);
    }

    public short getUnsignedByte(int index) {
        return this.d.getUnsignedByte(index);
    }

    public short getShort(int index) {
        return this.d.getShort(index);
    }

    public short getShortLE(int index) {
        return this.d.getShortLE(index);
    }

    public int getUnsignedShort(int index) {
        return this.d.getUnsignedShort(index);
    }

    public int getUnsignedShortLE(int index) {
        return this.d.getUnsignedShortLE(index);
    }

    public int getMedium(int index) {
        return this.d.getMedium(index);
    }

    public int getMediumLE(int index) {
        return this.d.getMediumLE(index);
    }

    public int getUnsignedMedium(int index) {
        return this.d.getUnsignedMedium(index);
    }

    public int getUnsignedMediumLE(int index) {
        return this.d.getUnsignedMediumLE(index);
    }

    public int getInt(int index) {
        return this.d.getInt(index);
    }

    public int getIntLE(int index) {
        return this.d.getIntLE(index);
    }

    public long getUnsignedInt(int index) {
        return this.d.getUnsignedInt(index);
    }

    public long getUnsignedIntLE(int index) {
        return this.d.getUnsignedIntLE(index);
    }

    public long getLong(int index) {
        return this.d.getLong(index);
    }

    public long getLongLE(int index) {
        return this.d.getLongLE(index);
    }

    public char getChar(int index) {
        return this.d.getChar(index);
    }

    public float getFloat(int index) {
        return this.d.getFloat(index);
    }

    public double getDouble(int index) {
        return this.d.getDouble(index);
    }

    public PacketDataSerializer a(int index, ByteBuf destination) {
        this.d.getBytes(index, destination);
        return this;
    }

    public PacketDataSerializer a(int index, ByteBuf destination, int length) {
        this.d.getBytes(index, destination, length);
        return this;
    }

    public PacketDataSerializer a(int index, ByteBuf destination, int destinationIndex, int length) {
        this.d.getBytes(index, destination, destinationIndex, length);
        return this;
    }

    public PacketDataSerializer a(int index, byte[] destination) {
        this.d.getBytes(index, destination);
        return this;
    }

    public PacketDataSerializer a(int index, byte[] destination, int destinationIndex, int length) {
        this.d.getBytes(index, destination, destinationIndex, length);
        return this;
    }

    public PacketDataSerializer a(int index, ByteBuffer destination) {
        this.d.getBytes(index, destination);
        return this;
    }

    public PacketDataSerializer a(int index, OutputStream out, int length) throws IOException {
        this.d.getBytes(index, out, length);
        return this;
    }

    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        return this.d.getBytes(index, out, length);
    }

    public int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        return this.d.getBytes(index, out, position, length);
    }

    public CharSequence getCharSequence(int index, int length, Charset charset) {
        return this.d.getCharSequence(index, length, charset);
    }

    public PacketDataSerializer a(int index, boolean value) {
        this.d.setBoolean(index, value);
        return this;
    }

    public PacketDataSerializer b(int index, int value) {
        this.d.setByte(index, value);
        return this;
    }

    public PacketDataSerializer c(int index, int value) {
        this.d.setShort(index, value);
        return this;
    }

    public PacketDataSerializer d(int index, int value) {
        this.d.setShortLE(index, value);
        return this;
    }

    public PacketDataSerializer e(int index, int value) {
        this.d.setMedium(index, value);
        return this;
    }

    public PacketDataSerializer f(int index, int value) {
        this.d.setMediumLE(index, value);
        return this;
    }

    public PacketDataSerializer g(int index, int value) {
        this.d.setInt(index, value);
        return this;
    }

    public PacketDataSerializer h(int index, int value) {
        this.d.setIntLE(index, value);
        return this;
    }

    public PacketDataSerializer a(int index, long value) {
        this.d.setLong(index, value);
        return this;
    }

    public PacketDataSerializer b(int index, long value) {
        this.d.setLongLE(index, value);
        return this;
    }

    public PacketDataSerializer i(int index, int value) {
        this.d.setChar(index, value);
        return this;
    }

    public PacketDataSerializer a(int index, float value) {
        this.d.setFloat(index, value);
        return this;
    }

    public PacketDataSerializer a(int index, double value) {
        this.d.setDouble(index, value);
        return this;
    }

    public PacketDataSerializer b(int index, ByteBuf source) {
        this.d.setBytes(index, source);
        return this;
    }

    public PacketDataSerializer b(int index, ByteBuf source, int length) {
        this.d.setBytes(index, source, length);
        return this;
    }

    public PacketDataSerializer b(int index, ByteBuf source, int sourceIndex, int length) {
        this.d.setBytes(index, source, sourceIndex, length);
        return this;
    }

    public PacketDataSerializer b(int index, byte[] source) {
        this.d.setBytes(index, source);
        return this;
    }

    public PacketDataSerializer b(int index, byte[] source, int sourceIndex, int length) {
        this.d.setBytes(index, source, sourceIndex, length);
        return this;
    }

    public PacketDataSerializer b(int index, ByteBuffer source) {
        this.d.setBytes(index, source);
        return this;
    }

    public int setBytes(int index, InputStream in, int length) throws IOException {
        return this.d.setBytes(index, in, length);
    }

    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        return this.d.setBytes(index, in, length);
    }

    public int setBytes(int index, FileChannel in, long position, int length) throws IOException {
        return this.d.setBytes(index, in, position, length);
    }

    public PacketDataSerializer j(int index, int length) {
        this.d.setZero(index, length);
        return this;
    }

    public int setCharSequence(int index, CharSequence charSequence, Charset charset) {
        return this.d.setCharSequence(index, charSequence, charset);
    }

    public boolean readBoolean() {
        return this.d.readBoolean();
    }

    public byte readByte() {
        return this.d.readByte();
    }

    public short readUnsignedByte() {
        return this.d.readUnsignedByte();
    }

    public short readShort() {
        return this.d.readShort();
    }

    public short readShortLE() {
        return this.d.readShortLE();
    }

    public int readUnsignedShort() {
        return this.d.readUnsignedShort();
    }

    public int readUnsignedShortLE() {
        return this.d.readUnsignedShortLE();
    }

    public int readMedium() {
        return this.d.readMedium();
    }

    public int readMediumLE() {
        return this.d.readMediumLE();
    }

    public int readUnsignedMedium() {
        return this.d.readUnsignedMedium();
    }

    public int readUnsignedMediumLE() {
        return this.d.readUnsignedMediumLE();
    }

    public int readInt() {
        return this.d.readInt();
    }

    public int readIntLE() {
        return this.d.readIntLE();
    }

    public long readUnsignedInt() {
        return this.d.readUnsignedInt();
    }

    public long readUnsignedIntLE() {
        return this.d.readUnsignedIntLE();
    }

    public long readLong() {
        return this.d.readLong();
    }

    public long readLongLE() {
        return this.d.readLongLE();
    }

    public char readChar() {
        return this.d.readChar();
    }

    public float readFloat() {
        return this.d.readFloat();
    }

    public double readDouble() {
        return this.d.readDouble();
    }

    public ByteBuf readBytes(int length) {
        return this.d.readBytes(length);
    }

    public ByteBuf readSlice(int length) {
        return this.d.readSlice(length);
    }

    public ByteBuf readRetainedSlice(int length) {
        return this.d.readRetainedSlice(length);
    }

    public PacketDataSerializer j(ByteBuf destination) {
        this.d.readBytes(destination);
        return this;
    }

    public PacketDataSerializer c(ByteBuf destination, int length) {
        this.d.readBytes(destination, length);
        return this;
    }

    public PacketDataSerializer a(ByteBuf destination, int destinationIndex, int length) {
        this.d.readBytes(destination, destinationIndex, length);
        return this;
    }

    public PacketDataSerializer b(byte[] destination) {
        this.d.readBytes(destination);
        return this;
    }

    public PacketDataSerializer a(byte[] destination, int destinationIndex, int length) {
        this.d.readBytes(destination, destinationIndex, length);
        return this;
    }

    public PacketDataSerializer a(ByteBuffer destination) {
        this.d.readBytes(destination);
        return this;
    }

    public PacketDataSerializer a(OutputStream out, int length) throws IOException {
        this.d.readBytes(out, length);
        return this;
    }

    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        return this.d.readBytes(out, length);
    }

    public CharSequence readCharSequence(int length, Charset charset) {
        return this.d.readCharSequence(length, charset);
    }

    public int readBytes(FileChannel out, long position, int length) throws IOException {
        return this.d.readBytes(out, position, length);
    }

    public PacketDataSerializer k(int length) {
        this.d.skipBytes(length);
        return this;
    }

    public PacketDataSerializer a(boolean value) {
        this.d.writeBoolean(value);
        return this;
    }

    public PacketDataSerializer l(int value) {
        this.d.writeByte(value);
        return this;
    }

    public PacketDataSerializer m(int value) {
        this.d.writeShort(value);
        return this;
    }

    public PacketDataSerializer n(int value) {
        this.d.writeShortLE(value);
        return this;
    }

    public PacketDataSerializer o(int value) {
        this.d.writeMedium(value);
        return this;
    }

    public PacketDataSerializer p(int value) {
        this.d.writeMediumLE(value);
        return this;
    }

    public PacketDataSerializer q(int value) {
        this.d.writeInt(value);
        return this;
    }

    public PacketDataSerializer r(int value) {
        this.d.writeIntLE(value);
        return this;
    }

    public PacketDataSerializer b(long value) {
        this.d.writeLong(value);
        return this;
    }

    public PacketDataSerializer c(long value) {
        this.d.writeLongLE(value);
        return this;
    }

    public PacketDataSerializer s(int value) {
        this.d.writeChar(value);
        return this;
    }

    public PacketDataSerializer a(float value) {
        this.d.writeFloat(value);
        return this;
    }

    public PacketDataSerializer a(double value) {
        this.d.writeDouble(value);
        return this;
    }

    public PacketDataSerializer k(ByteBuf source) {
        this.d.writeBytes(source);
        return this;
    }

    public PacketDataSerializer d(ByteBuf source, int length) {
        this.d.writeBytes(source, length);
        return this;
    }

    public PacketDataSerializer b(ByteBuf source, int sourceIndex, int length) {
        this.d.writeBytes(source, sourceIndex, length);
        return this;
    }

    public PacketDataSerializer c(byte[] source) {
        this.d.writeBytes(source);
        return this;
    }

    public PacketDataSerializer b(byte[] source, int sourceIndex, int length) {
        this.d.writeBytes(source, sourceIndex, length);
        return this;
    }

    public PacketDataSerializer b(ByteBuffer source) {
        this.d.writeBytes(source);
        return this;
    }

    public int writeBytes(InputStream in, int length) throws IOException {
        return this.d.writeBytes(in, length);
    }

    public int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        return this.d.writeBytes(in, length);
    }

    public int writeBytes(FileChannel in, long position, int length) throws IOException {
        return this.d.writeBytes(in, position, length);
    }

    public PacketDataSerializer t(int length) {
        this.d.writeZero(length);
        return this;
    }

    public int writeCharSequence(CharSequence charSequence, Charset charset) {
        return this.d.writeCharSequence(charSequence, charset);
    }

    public int indexOf(int fromIndex, int toIndex, byte value) {
        return this.d.indexOf(fromIndex, toIndex, value);
    }

    public int bytesBefore(byte value) {
        return this.d.bytesBefore(value);
    }

    public int bytesBefore(int length, byte value) {
        return this.d.bytesBefore(length, value);
    }

    public int bytesBefore(int index, int length, byte value) {
        return this.d.bytesBefore(index, length, value);
    }

    public int forEachByte(ByteProcessor processor) {
        return this.d.forEachByte(processor);
    }

    public int forEachByte(int index, int length, ByteProcessor processor) {
        return this.d.forEachByte(index, length, processor);
    }

    public int forEachByteDesc(ByteProcessor processor) {
        return this.d.forEachByteDesc(processor);
    }

    public int forEachByteDesc(int index, int length, ByteProcessor processor) {
        return this.d.forEachByteDesc(index, length, processor);
    }

    public ByteBuf copy() {
        return this.d.copy();
    }

    public ByteBuf copy(int index, int length) {
        return this.d.copy(index, length);
    }

    public ByteBuf slice() {
        return this.d.slice();
    }

    public ByteBuf retainedSlice() {
        return this.d.retainedSlice();
    }

    public ByteBuf slice(int index, int length) {
        return this.d.slice(index, length);
    }

    public ByteBuf retainedSlice(int index, int length) {
        return this.d.retainedSlice(index, length);
    }

    public ByteBuf duplicate() {
        return this.d.duplicate();
    }

    public ByteBuf retainedDuplicate() {
        return this.d.retainedDuplicate();
    }

    public int nioBufferCount() {
        return this.d.nioBufferCount();
    }

    public ByteBuffer nioBuffer() {
        return this.d.nioBuffer();
    }

    public ByteBuffer nioBuffer(int index, int length) {
        return this.d.nioBuffer(index, length);
    }

    public ByteBuffer internalNioBuffer(int index, int length) {
        return this.d.internalNioBuffer(index, length);
    }

    public ByteBuffer[] nioBuffers() {
        return this.d.nioBuffers();
    }

    public ByteBuffer[] nioBuffers(int index, int length) {
        return this.d.nioBuffers(index, length);
    }

    public boolean hasArray() {
        return this.d.hasArray();
    }

    public byte[] array() {
        return this.d.array();
    }

    public int arrayOffset() {
        return this.d.arrayOffset();
    }

    public boolean hasMemoryAddress() {
        return this.d.hasMemoryAddress();
    }

    public long memoryAddress() {
        return this.d.memoryAddress();
    }

    public String toString(Charset charset) {
        return this.d.toString(charset);
    }

    public String toString(int index, int length, Charset charset) {
        return this.d.toString(index, length, charset);
    }

    public int hashCode() {
        return this.d.hashCode();
    }

    public boolean equals(Object other) {
        return this.d.equals(other);
    }

    public int compareTo(ByteBuf other) {
        return this.d.compareTo(other);
    }

    public String toString() {
        return this.d.toString();
    }

    public PacketDataSerializer u(int increment) {
        this.d.retain(increment);
        return this;
    }

    public PacketDataSerializer F() {
        this.d.retain();
        return this;
    }

    public PacketDataSerializer G() {
        this.d.touch();
        return this;
    }

    public PacketDataSerializer a(Object hint) {
        this.d.touch(hint);
        return this;
    }

    public int refCnt() {
        return this.d.refCnt();
    }

    public boolean release() {
        return this.d.release();
    }

    public boolean release(int decrement) {
        return this.d.release(decrement);
    }
}

