/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.destroystokyo.paper.event.player.PlayerConnectionCloseEvent;
import com.google.common.base.Suppliers;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.logging.LogUtils;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.compression.VelocityCompressorFactory;
import com.velocitypowered.natives.encryption.VelocityCipher;
import com.velocitypowered.natives.encryption.VelocityCipherFactory;
import com.velocitypowered.natives.util.Natives;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.TimeoutException;
import io.netty.util.concurrent.GenericFutureListener;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.network.ConnectionEvent;
import io.papermc.paper.util.IntervalledCounter;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.ObfHelper;
import io.papermc.paper.util.ServerStopRejectedExecutionException;
import io.papermc.paper.util.TraceUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.network.BandwidthDebugMonitor;
import net.minecraft.network.ClientboundPacketListener;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.LocalFrameDecoder;
import net.minecraft.network.LocalFrameEncoder;
import net.minecraft.network.MonitoredLocalFrameDecoder;
import net.minecraft.network.PacketBundlePacker;
import net.minecraft.network.PacketBundleUnpacker;
import net.minecraft.network.PacketCompressor;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketDecompressor;
import net.minecraft.network.PacketDecrypter;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.PacketEncrypter;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketPrepender;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.PacketSplitter;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.ProtocolSwapHandler;
import net.minecraft.network.ServerboundPacketListener;
import net.minecraft.network.SkipEncodeException;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.UnconfiguredPipelineHandler;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.BundlerInfo;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundKeepAlivePacket;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketPlayOutBoss;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutStopSound;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.network.protocol.handshake.ClientIntent;
import net.minecraft.network.protocol.handshake.HandshakeProtocols;
import net.minecraft.network.protocol.handshake.PacketHandshakingInListener;
import net.minecraft.network.protocol.handshake.PacketHandshakingInSetProtocol;
import net.minecraft.network.protocol.login.LoginProtocols;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.login.PacketLoginOutListener;
import net.minecraft.network.protocol.status.PacketStatusOutListener;
import net.minecraft.network.protocol.status.StatusProtocols;
import net.minecraft.server.CancelledPacketHandleException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.LoginListener;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MathHelper;
import net.minecraft.util.debugchart.LocalSampleLogger;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.event.player.PlayerQuitEvent;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class NetworkManager
extends SimpleChannelInboundHandler<Packet<?>> {
    private static final float h = 0.75f;
    private static final Logger i = LogUtils.getLogger();
    public static final Marker a = MarkerFactory.getMarker((String)"NETWORK");
    public static final Marker b = SystemUtils.a(MarkerFactory.getMarker((String)"NETWORK_PACKETS"), (? super T marker) -> marker.add(a));
    public static final Marker c = SystemUtils.a(MarkerFactory.getMarker((String)"PACKET_RECEIVED"), (? super T marker) -> marker.add(b));
    public static final Marker d = SystemUtils.a(MarkerFactory.getMarker((String)"PACKET_SENT"), (? super T marker) -> marker.add(b));
    public static final Supplier<NioEventLoopGroup> e = Suppliers.memoize(() -> new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Client IO #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(i)).build()));
    public static final Supplier<EpollEventLoopGroup> f = Suppliers.memoize(() -> new EpollEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Epoll Client IO #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(i)).build()));
    public static final Supplier<DefaultEventLoopGroup> g = Suppliers.memoize(() -> new DefaultEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Local Client IO #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(i)).build()));
    private static final ProtocolInfo<PacketHandshakingInListener> j = HandshakeProtocols.b;
    private final EnumProtocolDirection k;
    private volatile boolean l = true;
    private final Queue<WrappedConsumer> m = Queues.newConcurrentLinkedQueue();
    public Channel n;
    public SocketAddress o;
    public UUID spoofedUUID;
    public Property[] spoofedProfile;
    public boolean preparing = true;
    @Nullable
    private volatile PacketListener p;
    @Nullable
    private volatile PacketListener q;
    @Nullable
    private DisconnectionDetails r;
    private boolean s;
    private boolean t;
    private int u;
    private int v;
    private float w;
    private float x;
    private int y;
    private boolean z;
    @Nullable
    private volatile DisconnectionDetails A;
    @Nullable
    BandwidthDebugMonitor B;
    public String hostname = "";
    public int protocolVersion;
    public InetSocketAddress virtualHost;
    private static boolean enableExplicitFlush = Boolean.getBoolean("paper.explicit-flush");
    protected final Object PACKET_LIMIT_LOCK = new Object();
    @Nullable
    protected final IntervalledCounter allPacketCounts;
    protected final Map<Class<? extends Packet<?>>, IntervalledCounter> packetSpecificLimits;
    private boolean stopReadingPackets;
    @Nullable
    public SocketAddress haProxyAddress;
    public boolean isPending;
    public boolean queueImmunity;
    private static final int MAX_PER_TICK = GlobalConfiguration.get().misc.maxJoinsPerTick;
    private static int joinAttemptsThisTick;
    private static int currTick;

    public final EntityPlayer getPlayer() {
        PacketListener packetListener = this.q;
        if (packetListener instanceof PlayerConnection) {
            PlayerConnection impl = (PlayerConnection)packetListener;
            return impl.f;
        }
        packetListener = this.q;
        if (packetListener instanceof ServerCommonPacketListenerImpl) {
            ServerCommonPacketListenerImpl impl = (ServerCommonPacketListenerImpl)packetListener;
            CraftPlayer player = impl.getCraftPlayer();
            return player == null ? null : player.getHandle();
        }
        return null;
    }

    private void killForPacketSpam() {
        this.b(new ClientboundDisconnectPacket(PaperAdventure.asVanilla(GlobalConfiguration.get().packetLimiter.kickMessage)), PacketSendListener.a(() -> this.a(PaperAdventure.asVanilla(GlobalConfiguration.get().packetLimiter.kickMessage))), true);
        this.m();
        this.stopReadingPackets = true;
    }

    public NetworkManager(EnumProtocolDirection receiving) {
        this.allPacketCounts = GlobalConfiguration.get().packetLimiter.allPackets.isEnabled() ? new IntervalledCounter((long)(GlobalConfiguration.get().packetLimiter.allPackets.interval() * 1.0E9)) : null;
        this.packetSpecificLimits = new HashMap();
        this.isPending = true;
        this.k = receiving;
    }

    public void channelActive(ChannelHandlerContext context) throws Exception {
        super.channelActive(context);
        this.n = context.channel();
        this.o = this.n.remoteAddress();
        this.preparing = false;
        if (this.A != null) {
            this.a(this.A);
        }
    }

    public void channelInactive(ChannelHandlerContext context) {
        this.a(IChatBaseComponent.c("disconnect.endOfStream"));
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable exception) {
        Throwable throwable;
        if (exception instanceof EncoderException && (throwable = exception.getCause()) instanceof PacketEncoder.PacketTooLargeException) {
            PacketEncoder.PacketTooLargeException packetTooLargeException = (PacketEncoder.PacketTooLargeException)throwable;
            Packet<?> packet = packetTooLargeException.getPacket();
            if (packet.packetTooLarge(this)) {
                ProtocolSwapHandler.b(context, packet);
                return;
            }
            if (packet.c()) {
                i.debug("Skipping packet due to errors", exception.getCause());
                ProtocolSwapHandler.b(context, packet);
                return;
            }
            exception = exception.getCause();
        }
        if (exception instanceof SkipEncodeException) {
            i.debug("Skipping packet due to errors", exception.getCause());
        } else {
            boolean flag = !this.z;
            this.z = true;
            if (this.n.isOpen()) {
                EntityPlayer player = this.getPlayer();
                if (exception instanceof TimeoutException) {
                    i.debug("Timeout", exception);
                    if (player != null) {
                        player.quitReason = PlayerQuitEvent.QuitReason.TIMED_OUT;
                    }
                    this.a(IChatBaseComponent.c("disconnect.timeout"));
                } else {
                    IChatMutableComponent component = IChatBaseComponent.a("disconnect.genericReason", new Object[]{"Internal Exception: " + String.valueOf(exception)});
                    PacketListener packetListener = this.q;
                    DisconnectionDetails disconnectionDetails = packetListener != null ? packetListener.a(component, exception) : new DisconnectionDetails(component);
                    if (player != null) {
                        player.quitReason = PlayerQuitEvent.QuitReason.ERRONEOUS_STATE;
                    }
                    if (flag) {
                        boolean doesDisconnectExist;
                        i.debug("Failed to sent packet", exception);
                        boolean bl = doesDisconnectExist = this.q.b() != EnumProtocol.c && this.q.b() != EnumProtocol.a;
                        if (this.g() == EnumProtocolDirection.b && doesDisconnectExist) {
                            Packet<PacketLoginOutListener> packet = this.l ? new PacketLoginOutDisconnect(component) : new ClientboundDisconnectPacket(component);
                            this.a(packet, PacketSendListener.a(() -> this.a(disconnectionDetails)));
                        } else {
                            this.a(disconnectionDetails);
                        }
                        this.m();
                    } else {
                        i.debug("Double fault", exception);
                        this.a(disconnectionDetails);
                    }
                }
            }
        }
        if (MinecraftServer.getServer().isDebugging()) {
            TraceUtil.printStackTrace(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void a(ChannelHandlerContext context, Packet<?> packet) {
        if (this.n.isOpen()) {
            PacketListener packetListener = this.q;
            if (packetListener == null) {
                throw new IllegalStateException("Received a packet before the packet listener was initialized");
            }
            if (this.stopReadingPackets) {
                return;
            }
            if (this.allPacketCounts != null || GlobalConfiguration.get().packetLimiter.overrides.containsKey(packet.getClass())) {
                long time = System.nanoTime();
                Object object = this.PACKET_LIMIT_LOCK;
                synchronized (object) {
                    if (this.allPacketCounts != null) {
                        this.allPacketCounts.updateAndAdd(1L, time);
                        if (this.allPacketCounts.getRate() >= GlobalConfiguration.get().packetLimiter.allPackets.maxPacketRate()) {
                            this.killForPacketSpam();
                            return;
                        }
                    }
                    for (Class<?> check = packet.getClass(); check != Object.class; check = check.getSuperclass()) {
                        GlobalConfiguration.PacketLimiter.PacketLimit packetSpecificLimit = GlobalConfiguration.get().packetLimiter.overrides.get(check);
                        if (packetSpecificLimit == null || !packetSpecificLimit.isEnabled()) continue;
                        IntervalledCounter counter = this.packetSpecificLimits.computeIfAbsent(check, clazz -> new IntervalledCounter((long)(packetSpecificLimit.interval() * 1.0E9)));
                        counter.updateAndAdd(1L, time);
                        if (!(counter.getRate() >= packetSpecificLimit.maxPacketRate())) continue;
                        switch (packetSpecificLimit.action()) {
                            case DROP: {
                                return;
                            }
                            case KICK: {
                                String playerName;
                                String deobfedPacketName = ObfHelper.INSTANCE.deobfClassName(check.getName());
                                PacketListener packetListener2 = this.q;
                                if (packetListener2 instanceof ServerCommonPacketListenerImpl) {
                                    ServerCommonPacketListenerImpl impl = (ServerCommonPacketListenerImpl)packetListener2;
                                    playerName = impl.j().getName();
                                } else {
                                    playerName = this.a(MinecraftServer.getServer().bl());
                                }
                                i.warn("{} kicked for packet spamming: {}", (Object)playerName, (Object)deobfedPacketName.substring(deobfedPacketName.lastIndexOf(".") + 1));
                                this.killForPacketSpam();
                                return;
                            }
                        }
                    }
                }
            }
            if (packetListener.a(packet)) {
                try {
                    NetworkManager.a(packet, packetListener);
                }
                catch (CancelledPacketHandleException time) {
                }
                catch (ServerStopRejectedExecutionException time) {
                }
                catch (RejectedExecutionException var6) {
                    this.a(IChatBaseComponent.c("multiplayer.disconnect.server_shutdown"));
                }
                catch (ClassCastException var7) {
                    i.error("Received {} that couldn't be processed", packet.getClass(), (Object)var7);
                    this.a(IChatBaseComponent.c("multiplayer.disconnect.invalid_packet"));
                }
                ++this.u;
            }
        }
    }

    private static <T extends PacketListener> void a(Packet<T> packet, PacketListener listener) {
        packet.a(listener);
    }

    private void b(ProtocolInfo<?> protocolInfo, PacketListener packetListener) {
        Validate.notNull((Object)packetListener, (String)"packetListener", (Object[])new Object[0]);
        EnumProtocolDirection packetFlow = packetListener.a();
        if (packetFlow != this.k) {
            throw new IllegalStateException("Trying to set listener for wrong side: connection is " + String.valueOf((Object)this.k) + ", but listener is " + String.valueOf((Object)packetFlow));
        }
        EnumProtocol connectionProtocol = packetListener.b();
        if (protocolInfo.a() != connectionProtocol) {
            throw new IllegalStateException("Listener protocol (" + String.valueOf((Object)connectionProtocol) + ") does not match requested one " + String.valueOf(protocolInfo));
        }
    }

    private static void a(ChannelFuture future) {
        try {
            future.syncUninterruptibly();
        }
        catch (Exception var2) {
            if (var2 instanceof ClosedChannelException) {
                i.info("Connection closed during protocol change");
            }
            throw var2;
        }
    }

    public <T extends PacketListener> void a(ProtocolInfo<T> protocolInfo, T packetInfo) {
        this.b(protocolInfo, packetInfo);
        if (protocolInfo.b() != this.f()) {
            throw new IllegalStateException("Invalid inbound protocol: " + String.valueOf((Object)protocolInfo.a()));
        }
        this.q = packetInfo;
        this.p = null;
        UnconfiguredPipelineHandler.b inboundConfigurationTask = UnconfiguredPipelineHandler.a(protocolInfo);
        BundlerInfo bundlerInfo = protocolInfo.d();
        if (bundlerInfo != null) {
            PacketBundlePacker packetBundlePacker = new PacketBundlePacker(bundlerInfo);
            inboundConfigurationTask = inboundConfigurationTask.andThen(context -> context.pipeline().addAfter("decoder", "bundler", (ChannelHandler)packetBundlePacker));
        }
        NetworkManager.a(this.n.writeAndFlush((Object)inboundConfigurationTask));
    }

    public void a(ProtocolInfo<?> protocolInfo) {
        if (protocolInfo.b() != this.g()) {
            throw new IllegalStateException("Invalid outbound protocol: " + String.valueOf((Object)protocolInfo.a()));
        }
        UnconfiguredPipelineHandler.d outboundConfigurationTask = UnconfiguredPipelineHandler.b(protocolInfo);
        BundlerInfo bundlerInfo = protocolInfo.d();
        if (bundlerInfo != null) {
            PacketBundleUnpacker packetBundleUnpacker = new PacketBundleUnpacker(bundlerInfo);
            outboundConfigurationTask = outboundConfigurationTask.andThen(context -> context.pipeline().addAfter("encoder", "unbundler", (ChannelHandler)packetBundleUnpacker));
        }
        boolean flag = protocolInfo.a() == EnumProtocol.d;
        NetworkManager.a(this.n.writeAndFlush((Object)outboundConfigurationTask.andThen(context -> {
            this.l = flag;
        })));
    }

    public void a(PacketListener packetListener) {
        if (this.q != null) {
            throw new IllegalStateException("Listener already set");
        }
        if (this.k != EnumProtocolDirection.a || packetListener.a() != EnumProtocolDirection.a || packetListener.b() != j.a()) {
            throw new IllegalStateException("Invalid initial listener");
        }
        this.q = packetListener;
    }

    public void a(String hostName, int port, PacketStatusOutListener packetListener) {
        this.a(hostName, port, StatusProtocols.b, StatusProtocols.d, packetListener, ClientIntent.a);
    }

    public void a(String hostName, int port, PacketLoginOutListener packetListener) {
        this.a(hostName, port, LoginProtocols.b, LoginProtocols.d, packetListener, ClientIntent.b);
    }

    public <S extends ServerboundPacketListener, C extends ClientboundPacketListener> void a(String hostName, int port, ProtocolInfo<S> serverboundProtocol, ProtocolInfo<C> clientbountProtocol, C packetListener, boolean isTransfer) {
        this.a(hostName, port, serverboundProtocol, clientbountProtocol, packetListener, isTransfer ? ClientIntent.c : ClientIntent.b);
    }

    private <S extends ServerboundPacketListener, C extends ClientboundPacketListener> void a(String hostName, int port, ProtocolInfo<S> serverboundProtocol, ProtocolInfo<C> clientboundProtocol, C packetListener, ClientIntent intention) {
        if (serverboundProtocol.a() != clientboundProtocol.a()) {
            throw new IllegalStateException("Mismatched initial protocols");
        }
        this.p = packetListener;
        this.a((NetworkManager connection) -> {
            this.a(clientboundProtocol, packetListener);
            connection.b(new PacketHandshakingInSetProtocol(SharedConstants.b().e(), hostName, port, intention), null, true);
            this.a(serverboundProtocol);
        });
    }

    public void a(Packet<?> packet) {
        this.a(packet, null);
    }

    public void a(Packet<?> packet, @Nullable PacketSendListener sendListener) {
        this.a(packet, sendListener, true);
    }

    public void a(Packet<?> packet, @Nullable PacketSendListener listener, boolean flush) {
        boolean connected = this.i();
        if (!connected && !this.preparing) {
            return;
        }
        packet.onPacketDispatch(this.getPlayer());
        if (connected && (InnerUtil.canSendImmediate(this, packet) || MCUtil.isMainThread() && packet.isReady() && this.m.isEmpty() && (packet.getExtraPackets() == null || packet.getExtraPackets().isEmpty()))) {
            this.b(packet, listener, flush);
        } else {
            boolean hasExtraPackets;
            List<Packet<?>> extraPackets = InnerUtil.buildExtraPackets(packet);
            boolean bl = hasExtraPackets = extraPackets != null && !extraPackets.isEmpty();
            if (!hasExtraPackets) {
                this.m.add(new PacketSendAction(packet, listener, flush));
            } else {
                ArrayList<PacketSendAction> actions = new ArrayList<PacketSendAction>(1 + extraPackets.size());
                actions.add(new PacketSendAction(packet, null, false));
                int i2 = 0;
                int len = extraPackets.size();
                while (i2 < len) {
                    Packet<?> extraPacket = extraPackets.get(i2);
                    boolean end = ++i2 == len;
                    actions.add(new PacketSendAction(extraPacket, end ? listener : null, end));
                }
                this.m.addAll(actions);
            }
            this.flushQueue();
        }
    }

    public void a(Consumer<NetworkManager> action) {
        if (this.i()) {
            this.flushQueue();
            action.accept(this);
        } else {
            this.m.add(new WrappedConsumer(action));
        }
    }

    private void b(Packet<?> packet, @Nullable PacketSendListener sendListener, boolean flush) {
        ++this.v;
        if (this.n.eventLoop().inEventLoop()) {
            this.c(packet, sendListener, flush);
        } else {
            this.n.eventLoop().execute(() -> this.c(packet, sendListener, flush));
        }
    }

    private void c(Packet<?> packet, @Nullable PacketSendListener sendListener, boolean flush) {
        EntityPlayer player = this.getPlayer();
        if (!this.i()) {
            packet.onPacketDispatchFinish(player, null);
            return;
        }
        try {
            ChannelFuture channelFuture;
            ChannelFuture channelFuture2 = channelFuture = flush ? this.n.writeAndFlush(packet) : this.n.write(packet);
            if (sendListener != null) {
                channelFuture.addListener(future -> {
                    if (future.isSuccess()) {
                        sendListener.a();
                    } else {
                        Packet<?> packet1 = sendListener.b();
                        if (packet1 != null) {
                            ChannelFuture channelFuture1 = this.n.writeAndFlush(packet1);
                            channelFuture1.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
                        }
                    }
                });
            }
            if (packet.hasFinishListener()) {
                channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> packet.onPacketDispatchFinish(player, (ChannelFuture)future)));
            }
            channelFuture.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
        catch (Exception e2) {
            i.error("NetworkException: {}", (Object)player, (Object)e2);
            this.a(IChatBaseComponent.a("disconnect.genericReason", new Object[]{"Internal Exception: " + e2.getMessage()}));
            packet.onPacketDispatchFinish(player, null);
        }
    }

    public void a() {
        if (this.i()) {
            this.q();
        } else {
            this.m.add(new WrappedConsumer(NetworkManager::q));
        }
    }

    private void q() {
        if (this.n.eventLoop().inEventLoop()) {
            this.n.flush();
        } else {
            this.n.eventLoop().execute(() -> this.n.flush());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flushQueue() {
        if (!this.i()) {
            return true;
        }
        if (MCUtil.isMainThread()) {
            return this.processQueue();
        }
        if (this.isPending) {
            Queue<WrappedConsumer> queue = this.m;
            synchronized (queue) {
                return this.processQueue();
            }
        }
        return false;
    }

    private boolean processQueue() {
        if (this.m.isEmpty()) {
            return true;
        }
        Iterator iterator = this.m.iterator();
        while (iterator.hasNext()) {
            WrappedConsumer queued = (WrappedConsumer)iterator.next();
            if (queued == null) {
                return true;
            }
            if (queued.isConsumed()) continue;
            if (queued instanceof PacketSendAction) {
                PacketSendAction packetSendAction = (PacketSendAction)queued;
                Packet<?> packet = packetSendAction.packet;
                if (!packet.isReady()) {
                    return false;
                }
            }
            iterator.remove();
            if (!queued.tryMarkConsumed()) continue;
            queued.accept(this);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void b() {
        block11: {
            TickablePacketListener tickablePacketListener;
            block12: {
                PacketListener packetListener;
                this.flushQueue();
                if (currTick != MinecraftServer.currentTick) {
                    currTick = MinecraftServer.currentTick;
                    joinAttemptsThisTick = 0;
                }
                if (!((packetListener = this.q) instanceof TickablePacketListener)) break block11;
                tickablePacketListener = (TickablePacketListener)packetListener;
                PacketListener packetListener2 = this.q;
                if (!(packetListener2 instanceof LoginListener)) break block12;
                LoginListener loginPacketListener = (LoginListener)packetListener2;
                if (loginPacketListener.h == LoginListener.EnumProtocolState.e && joinAttemptsThisTick++ >= MAX_PER_TICK) break block11;
            }
            PlayerConnectionUtils.packetProcessing.push(this.q);
            try {
                tickablePacketListener.d();
            }
            finally {
                PlayerConnectionUtils.packetProcessing.pop();
            }
        }
        if (!this.i() && !this.t) {
            this.n();
        }
        if (this.n != null && enableExplicitFlush) {
            this.n.eventLoop().execute(() -> this.n.flush());
        }
        if (this.y++ % 20 == 0) {
            this.c();
        }
        if (this.B != null) {
            this.B.a();
        }
    }

    protected void c() {
        this.x = MathHelper.h(0.75f, this.v, this.x);
        this.w = MathHelper.h(0.75f, this.u, this.w);
        this.v = 0;
        this.u = 0;
    }

    public SocketAddress d() {
        return this.o;
    }

    public String a(boolean logIps) {
        if (this.o == null) {
            return "local";
        }
        return logIps ? this.o.toString() : "IP hidden";
    }

    public void a(IChatBaseComponent message) {
        this.a(new DisconnectionDetails(message));
    }

    public void a(DisconnectionDetails disconnectionDetails) {
        this.preparing = false;
        this.clearPacketQueue();
        if (this.n == null) {
            this.A = disconnectionDetails;
        }
        if (this.i()) {
            this.n.close();
            this.r = disconnectionDetails;
        }
    }

    public boolean e() {
        return this.n instanceof LocalChannel || this.n instanceof LocalServerChannel;
    }

    public EnumProtocolDirection f() {
        return this.k;
    }

    public EnumProtocolDirection g() {
        return this.k.a();
    }

    public static NetworkManager a(InetSocketAddress address, boolean useEpollIfAvailable, @Nullable LocalSampleLogger sampleLogger) {
        NetworkManager connection = new NetworkManager(EnumProtocolDirection.b);
        if (sampleLogger != null) {
            connection.a(sampleLogger);
        }
        ChannelFuture channelFuture = NetworkManager.a(address, useEpollIfAvailable, connection);
        channelFuture.syncUninterruptibly();
        return connection;
    }

    public static ChannelFuture a(InetSocketAddress address, boolean useEpollIfAvailable, final NetworkManager connection) {
        EventLoopGroup eventLoopGroup;
        Class<NioSocketChannel> clazz;
        if (Epoll.isAvailable() && useEpollIfAvailable) {
            clazz = EpollSocketChannel.class;
            eventLoopGroup = (EventLoopGroup)f.get();
        } else {
            clazz = NioSocketChannel.class;
            eventLoopGroup = (EventLoopGroup)e.get();
        }
        return ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                try {
                    channel.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                ChannelPipeline channelPipeline = channel.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(30));
                NetworkManager.a(channelPipeline, EnumProtocolDirection.b, false, connection.B);
                connection.a(channelPipeline);
            }
        })).channel(clazz)).connect(address.getAddress(), address.getPort());
    }

    private static String b(boolean clientbound) {
        return clientbound ? "encoder" : "outbound_config";
    }

    private static String c(boolean serverbound) {
        return serverbound ? "decoder" : "inbound_config";
    }

    public void a(ChannelPipeline pipeline) {
        pipeline.addLast("hackfix", (ChannelHandler)new ChannelOutboundHandlerAdapter(this){

            public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
                super.write(channelHandlerContext, object, channelPromise);
            }
        }).addLast("packet_handler", (ChannelHandler)this);
    }

    public static void a(ChannelPipeline pipeline, EnumProtocolDirection flow, boolean memoryOnly, @Nullable BandwidthDebugMonitor bandwithDebugMonitor) {
        EnumProtocolDirection opposite = flow.a();
        boolean flag = flow == EnumProtocolDirection.a;
        boolean flag1 = opposite == EnumProtocolDirection.a;
        pipeline.addLast("splitter", (ChannelHandler)NetworkManager.a(bandwithDebugMonitor, memoryOnly)).addLast(new ChannelHandler[]{new FlowControlHandler()}).addLast(NetworkManager.c(flag), flag ? new PacketDecoder<PacketHandshakingInListener>(j) : new UnconfiguredPipelineHandler.a()).addLast("prepender", (ChannelHandler)NetworkManager.d(memoryOnly)).addLast(NetworkManager.b(flag1), flag1 ? new PacketEncoder<PacketHandshakingInListener>(j) : new UnconfiguredPipelineHandler.c());
    }

    private static ChannelOutboundHandler d(boolean memoryOnly) {
        return memoryOnly ? new LocalFrameEncoder() : new PacketPrepender();
    }

    private static ChannelInboundHandler a(@Nullable BandwidthDebugMonitor bandwithDebugMonitor, boolean memoryOnly) {
        if (!memoryOnly) {
            return new PacketSplitter(bandwithDebugMonitor);
        }
        return bandwithDebugMonitor != null ? new MonitoredLocalFrameDecoder(bandwithDebugMonitor) : new LocalFrameDecoder();
    }

    public static void a(ChannelPipeline pipeline, EnumProtocolDirection flow) {
        NetworkManager.a(pipeline, flow, true, null);
    }

    public static NetworkManager a(SocketAddress address) {
        final NetworkManager connection = new NetworkManager(EnumProtocolDirection.b);
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)g.get())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                ChannelPipeline channelPipeline = channel.pipeline();
                NetworkManager.a(channelPipeline, EnumProtocolDirection.b);
                connection.a(channelPipeline);
            }
        })).channel(LocalChannel.class)).connect(address).syncUninterruptibly();
        return connection;
    }

    public void setEncryptionKey(SecretKey key) throws CryptographyException {
        if (!this.s) {
            try {
                VelocityCipher decryptionCipher = ((VelocityCipherFactory)Natives.cipher.get()).forDecryption(key);
                VelocityCipher encryptionCipher = ((VelocityCipherFactory)Natives.cipher.get()).forEncryption(key);
                this.s = true;
                this.n.pipeline().addBefore("splitter", "decrypt", (ChannelHandler)new PacketDecrypter(decryptionCipher));
                this.n.pipeline().addBefore("prepender", "encrypt", (ChannelHandler)new PacketEncrypter(encryptionCipher));
            }
            catch (GeneralSecurityException e2) {
                throw new CryptographyException(e2);
            }
        }
    }

    public boolean h() {
        return this.s;
    }

    public boolean i() {
        return this.n != null && this.n.isOpen();
    }

    public boolean j() {
        return this.n == null;
    }

    @Nullable
    public PacketListener k() {
        return this.q;
    }

    @Nullable
    public DisconnectionDetails l() {
        return this.r;
    }

    public void m() {
        if (this.n != null) {
            this.n.config().setAutoRead(false);
        }
    }

    public void enableAutoRead() {
        if (this.n != null) {
            this.n.config().setAutoRead(true);
        }
    }

    public void a(int threshold, boolean validateDecompressed) {
        if (threshold >= 0) {
            VelocityCompressor compressor = ((VelocityCompressorFactory)Natives.compress.get()).create(GlobalConfiguration.get().misc.compressionLevel.or(-1));
            ChannelHandler channelHandler = this.n.pipeline().get("decompress");
            if (channelHandler instanceof PacketDecompressor) {
                PacketDecompressor compressionDecoder = (PacketDecompressor)channelHandler;
                compressionDecoder.setThreshold(compressor, threshold, validateDecompressed);
            } else {
                this.n.pipeline().addAfter("splitter", "decompress", (ChannelHandler)new PacketDecompressor(compressor, threshold, validateDecompressed));
            }
            channelHandler = this.n.pipeline().get("compress");
            if (channelHandler instanceof PacketCompressor) {
                PacketCompressor compressionEncoder = (PacketCompressor)channelHandler;
                compressionEncoder.a(threshold);
            } else {
                this.n.pipeline().addAfter("prepender", "compress", (ChannelHandler)new PacketCompressor(compressor, threshold));
            }
            this.n.pipeline().fireUserEventTriggered((Object)ConnectionEvent.COMPRESSION_THRESHOLD_SET);
        } else {
            if (this.n.pipeline().get("decompress") instanceof PacketDecompressor) {
                this.n.pipeline().remove("decompress");
            }
            if (this.n.pipeline().get("compress") instanceof PacketCompressor) {
                this.n.pipeline().remove("compress");
            }
            this.n.pipeline().fireUserEventTriggered((Object)ConnectionEvent.COMPRESSION_DISABLED);
        }
    }

    public void n() {
        if (this.n != null && !this.n.isOpen() && !this.t) {
            PacketListener packetListener1;
            this.t = true;
            PacketListener packetListener = this.k();
            PacketListener packetListener2 = packetListener1 = packetListener != null ? packetListener : this.p;
            if (packetListener1 != null) {
                DisconnectionDetails disconnectionDetails = Objects.requireNonNullElseGet(this.l(), () -> new DisconnectionDetails(IChatBaseComponent.c("multiplayer.disconnect.generic")));
                packetListener1.a(disconnectionDetails);
            }
            this.clearPacketQueue();
            if (packetListener instanceof ServerCommonPacketListenerImpl) {
                ServerCommonPacketListenerImpl commonPacketListener = (ServerCommonPacketListenerImpl)packetListener;
                GameProfile profile = commonPacketListener.j();
                new PlayerConnectionCloseEvent(profile.getId(), profile.getName(), ((InetSocketAddress)this.o).getAddress(), false).callEvent();
            } else if (packetListener instanceof LoginListener) {
                LoginListener loginListener = (LoginListener)packetListener;
                switch (loginListener.h) {
                    case e: 
                    case f: 
                    case g: 
                    case h: {
                        GameProfile profile = loginListener.k;
                        new PlayerConnectionCloseEvent(profile.getId(), profile.getName(), ((InetSocketAddress)this.o).getAddress(), false).callEvent();
                    }
                }
            }
        }
    }

    public float o() {
        return this.w;
    }

    public float p() {
        return this.x;
    }

    public void a(LocalSampleLogger bandwithLogger) {
        this.B = new BandwidthDebugMonitor(bandwithLogger);
    }

    public void clearPacketQueue() {
        EntityPlayer player = this.getPlayer();
        for (Consumer consumer : this.m) {
            if (!(consumer instanceof PacketSendAction)) continue;
            PacketSendAction packetSendAction = (PacketSendAction)consumer;
            Packet<?> packet = packetSendAction.packet;
            if (!packet.hasFinishListener()) continue;
            packet.onPacketDispatchFinish(player, null);
        }
        this.m.clear();
    }

    private static class InnerUtil {
        private InnerUtil() {
        }

        @Nullable
        private static List<Packet<?>> buildExtraPackets(Packet<?> packet) {
            List<Packet<?>> extra = packet.getExtraPackets();
            if (extra == null || extra.isEmpty()) {
                return null;
            }
            ArrayList ret = new ArrayList(1 + extra.size());
            InnerUtil.buildExtraPackets0(extra, ret);
            return ret;
        }

        private static void buildExtraPackets0(List<Packet<?>> extraPackets, List<Packet<?>> into) {
            for (Packet<?> extra : extraPackets) {
                into.add(extra);
                List<Packet<?>> extraExtra = extra.getExtraPackets();
                if (extraExtra == null || extraExtra.isEmpty()) continue;
                InnerUtil.buildExtraPackets0(extraExtra, into);
            }
        }

        private static boolean canSendImmediate(NetworkManager networkManager, Packet<?> packet) {
            return networkManager.isPending || networkManager.q.b() != EnumProtocol.b || packet instanceof ClientboundKeepAlivePacket || packet instanceof ClientboundPlayerChatPacket || packet instanceof ClientboundSystemChatPacket || packet instanceof ClientboundDisguisedChatPacket || packet instanceof PacketPlayOutTabComplete || packet instanceof ClientboundSetTitleTextPacket || packet instanceof ClientboundSetSubtitleTextPacket || packet instanceof ClientboundSetActionBarTextPacket || packet instanceof ClientboundSetTitlesAnimationPacket || packet instanceof ClientboundClearTitlesPacket || packet instanceof PacketPlayOutNamedSoundEffect || packet instanceof PacketPlayOutEntitySound || packet instanceof PacketPlayOutStopSound || packet instanceof PacketPlayOutWorldParticles || packet instanceof ClientboundPlayerInfoUpdatePacket || packet instanceof ClientboundPlayerInfoRemovePacket || packet instanceof PacketPlayOutBoss;
        }
    }

    private static final class PacketSendAction
    extends WrappedConsumer {
        private final Packet<?> packet;

        private PacketSendAction(Packet<?> packet, @Nullable PacketSendListener packetSendListener, boolean flush) {
            super(connection -> connection.b(packet, packetSendListener, flush));
            this.packet = packet;
        }
    }

    private static class WrappedConsumer
    implements Consumer<NetworkManager> {
        private final Consumer<NetworkManager> delegate;
        private final AtomicBoolean consumed = new AtomicBoolean(false);

        private WrappedConsumer(Consumer<NetworkManager> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void accept(NetworkManager connection) {
            this.delegate.accept(connection);
        }

        public boolean tryMarkConsumed() {
            return this.consumed.compareAndSet(false, true);
        }

        public boolean isConsumed() {
            return this.consumed.get();
        }
    }
}

