/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.minecraft.EnumChatFormat;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.TagVisitor;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import org.slf4j.Logger;

public class TextComponentTagVisitor
implements TagVisitor {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 8;
    private static final int c = 64;
    private static final int d = 128;
    private static final ByteCollection e = new ByteOpenHashSet(Arrays.asList((byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6));
    private static final EnumChatFormat f = EnumChatFormat.l;
    private static final EnumChatFormat g = EnumChatFormat.k;
    private static final EnumChatFormat h = EnumChatFormat.g;
    private static final EnumChatFormat i = EnumChatFormat.m;
    private static final Pattern j = Pattern.compile("[A-Za-z0-9._+-]+");
    private static final String k = "[";
    private static final String l = "]";
    private static final String m = ";";
    private static final String n = " ";
    private static final String o = "{";
    private static final String p = "}";
    private static final String q = "\n";
    private static final String r = ": ";
    private static final String s = String.valueOf(',');
    private static final String t = s + "\n";
    private static final String u = s + " ";
    private static final IChatBaseComponent v = IChatBaseComponent.b("<...>").a(EnumChatFormat.h);
    private static final IChatBaseComponent w = IChatBaseComponent.b("b").a(i);
    private static final IChatBaseComponent x = IChatBaseComponent.b("s").a(i);
    private static final IChatBaseComponent y = IChatBaseComponent.b("I").a(i);
    private static final IChatBaseComponent z = IChatBaseComponent.b("L").a(i);
    private static final IChatBaseComponent A = IChatBaseComponent.b("f").a(i);
    private static final IChatBaseComponent B = IChatBaseComponent.b("d").a(i);
    private static final IChatBaseComponent C = IChatBaseComponent.b("B").a(i);
    private final String D;
    private int E;
    private int F;
    private final IChatMutableComponent G = IChatBaseComponent.i();

    public TextComponentTagVisitor(String indentation) {
        this.D = indentation;
    }

    public IChatBaseComponent a(NBTBase tag) {
        tag.a(this);
        return this.G;
    }

    @Override
    public void a(NBTTagString tag) {
        String string = NBTTagString.b(tag.u_());
        String sub = string.substring(0, 1);
        IChatMutableComponent component = IChatBaseComponent.b(string.substring(1, string.length() - 1)).a(g);
        this.G.f(sub).b(component).f(sub);
    }

    @Override
    public void a(NBTTagByte tag) {
        this.G.b(IChatBaseComponent.b(String.valueOf(tag.l())).a(h)).b(w);
    }

    @Override
    public void a(NBTTagShort tag) {
        this.G.b(IChatBaseComponent.b(String.valueOf(tag.l())).a(h)).b(x);
    }

    @Override
    public void a(NBTTagInt tag) {
        this.G.b(IChatBaseComponent.b(String.valueOf(tag.l())).a(h));
    }

    @Override
    public void a(NBTTagLong tag) {
        this.G.b(IChatBaseComponent.b(String.valueOf(tag.l())).a(h)).b(z);
    }

    @Override
    public void a(NBTTagFloat tag) {
        this.G.b(IChatBaseComponent.b(String.valueOf(tag.k())).a(h)).b(A);
    }

    @Override
    public void a(NBTTagDouble tag) {
        this.G.b(IChatBaseComponent.b(String.valueOf(tag.j())).a(h)).b(B);
    }

    @Override
    public void a(NBTTagByteArray tag) {
        this.G.f(k).b(C).f(m);
        byte[] asByteArray = tag.e();
        for (int i2 = 0; i2 < asByteArray.length && i2 < 128; ++i2) {
            IChatMutableComponent mutableComponent = IChatBaseComponent.b(String.valueOf(asByteArray[i2])).a(h);
            this.G.f(n).b(mutableComponent).b(C);
            if (i2 == asByteArray.length - 1) continue;
            this.G.f(s);
        }
        if (asByteArray.length > 128) {
            this.G.b(v);
        }
        this.G.f(l);
    }

    @Override
    public void a(NBTTagIntArray tag) {
        this.G.f(k).b(y).f(m);
        int[] asIntArray = tag.g();
        for (int i2 = 0; i2 < asIntArray.length && i2 < 128; ++i2) {
            this.G.f(n).b(IChatBaseComponent.b(String.valueOf(asIntArray[i2])).a(h));
            if (i2 == asIntArray.length - 1) continue;
            this.G.f(s);
        }
        if (asIntArray.length > 128) {
            this.G.b(v);
        }
        this.G.f(l);
    }

    @Override
    public void a(NBTTagLongArray tag) {
        this.G.f(k).b(z).f(m);
        long[] asLongArray = tag.g();
        for (int i2 = 0; i2 < asLongArray.length && i2 < 128; ++i2) {
            IChatMutableComponent component = IChatBaseComponent.b(String.valueOf(asLongArray[i2])).a(h);
            this.G.f(n).b(component).b(z);
            if (i2 == asLongArray.length - 1) continue;
            this.G.f(s);
        }
        if (asLongArray.length > 128) {
            this.G.b(v);
        }
        this.G.f(l);
    }

    @Override
    public void a(NBTTagList tag) {
        if (tag.isEmpty()) {
            this.G.f("[]");
        } else if (this.F >= 64) {
            this.G.f(k).b(v).f(l);
        } else if (e.contains(tag.f()) && tag.size() <= 8) {
            this.G.f(k);
            for (int i2 = 0; i2 < tag.size(); ++i2) {
                if (i2 != 0) {
                    this.G.f(u);
                }
                this.a(tag.k(i2), false);
            }
            this.G.f(l);
        } else {
            this.G.f(k);
            if (!this.D.isEmpty()) {
                this.G.f(q);
            }
            String repeated = Strings.repeat((String)this.D, (int)(this.E + 1));
            for (int i1 = 0; i1 < tag.size() && i1 < 128; ++i1) {
                this.G.f(repeated);
                this.a(tag.k(i1), true);
                if (i1 == tag.size() - 1) continue;
                this.G.f(this.D.isEmpty() ? u : t);
            }
            if (tag.size() > 128) {
                this.G.f(repeated).b(v);
            }
            if (!this.D.isEmpty()) {
                this.G.f(q + Strings.repeat((String)this.D, (int)this.E));
            }
            this.G.f(l);
        }
    }

    @Override
    public void a(NBTTagCompound tag) {
        if (tag.g()) {
            this.G.f("{}");
        } else if (this.F >= 64) {
            this.G.f(o).b(v).f(p);
        } else {
            this.G.f(o);
            Collection<String> allKeys = tag.e();
            if (a.isDebugEnabled()) {
                ArrayList list = Lists.newArrayList(tag.e());
                Collections.sort(list);
                allKeys = list;
            }
            if (!this.D.isEmpty()) {
                this.G.f(q);
            }
            String repeated = Strings.repeat((String)this.D, (int)(this.E + 1));
            Iterator<String> iterator = allKeys.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                this.G.f(repeated).b(TextComponentTagVisitor.a(string)).f(r);
                this.a(tag.c(string), true);
                if (!iterator.hasNext()) continue;
                this.G.f(this.D.isEmpty() ? u : t);
            }
            if (!this.D.isEmpty()) {
                this.G.f(q + Strings.repeat((String)this.D, (int)this.E));
            }
            this.G.f(p);
        }
    }

    private void a(NBTBase tag, boolean indent) {
        if (indent) {
            ++this.E;
        }
        ++this.F;
        try {
            tag.a(this);
        }
        finally {
            if (indent) {
                --this.E;
            }
            --this.F;
        }
    }

    protected static IChatBaseComponent a(String text) {
        if (j.matcher(text).matches()) {
            return IChatBaseComponent.b(text).a(f);
        }
        String string = NBTTagString.b(text);
        String sub = string.substring(0, 1);
        IChatMutableComponent component = IChatBaseComponent.b(string.substring(1, string.length() - 1)).a(f);
        return IChatBaseComponent.b(sub).b(component).f(sub);
    }

    @Override
    public void a(NBTTagEnd tag) {
    }
}

