/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.TagVisitor;

public class StringTagVisitor
implements TagVisitor {
    private static final Pattern a = Pattern.compile("[A-Za-z0-9._+-]+");
    private final StringBuilder b = new StringBuilder();

    public String a(NBTBase tag) {
        tag.a(this);
        return this.b.toString();
    }

    @Override
    public void a(NBTTagString tag) {
        this.b.append(NBTTagString.b(tag.u_()));
    }

    @Override
    public void a(NBTTagByte tag) {
        this.b.append(tag.l()).append('b');
    }

    @Override
    public void a(NBTTagShort tag) {
        this.b.append(tag.l()).append('s');
    }

    @Override
    public void a(NBTTagInt tag) {
        this.b.append(tag.l());
    }

    @Override
    public void a(NBTTagLong tag) {
        this.b.append(tag.l()).append('L');
    }

    @Override
    public void a(NBTTagFloat tag) {
        this.b.append(tag.k()).append('f');
    }

    @Override
    public void a(NBTTagDouble tag) {
        this.b.append(tag.j()).append('d');
    }

    @Override
    public void a(NBTTagByteArray tag) {
        this.b.append("[B;");
        byte[] asByteArray = tag.e();
        for (int i2 = 0; i2 < asByteArray.length; ++i2) {
            if (i2 != 0) {
                this.b.append(',');
            }
            this.b.append(asByteArray[i2]).append('B');
        }
        this.b.append(']');
    }

    @Override
    public void a(NBTTagIntArray tag) {
        this.b.append("[I;");
        int[] asIntArray = tag.g();
        for (int i2 = 0; i2 < asIntArray.length; ++i2) {
            if (i2 != 0) {
                this.b.append(',');
            }
            this.b.append(asIntArray[i2]);
        }
        this.b.append(']');
    }

    @Override
    public void a(NBTTagLongArray tag) {
        this.b.append("[L;");
        long[] asLongArray = tag.g();
        for (int i2 = 0; i2 < asLongArray.length; ++i2) {
            if (i2 != 0) {
                this.b.append(',');
            }
            this.b.append(asLongArray[i2]).append('L');
        }
        this.b.append(']');
    }

    @Override
    public void a(NBTTagList tag) {
        this.b.append('[');
        for (int i2 = 0; i2 < tag.size(); ++i2) {
            if (i2 != 0) {
                this.b.append(',');
            }
            this.b.append(new StringTagVisitor().a(tag.k(i2)));
        }
        this.b.append(']');
    }

    @Override
    public void a(NBTTagCompound tag) {
        this.b.append('{');
        ArrayList list = Lists.newArrayList(tag.e());
        Collections.sort(list);
        for (String string : list) {
            if (this.b.length() != 1) {
                this.b.append(',');
            }
            this.b.append(StringTagVisitor.a(string)).append(':').append(new StringTagVisitor().a(tag.c(string)));
        }
        this.b.append('}');
    }

    protected static String a(String text) {
        return a.matcher(text).matches() ? text : NBTTagString.b(text);
    }

    @Override
    public void a(NBTTagEnd tag) {
        this.b.append("END");
    }
}

