/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;

public class NBTTagString
implements NBTBase {
    private static final int b = 36;
    public static final NBTTagType<NBTTagString> a = new NBTTagType.b<NBTTagString>(){

        public NBTTagString a(DataInput input, NBTReadLimiter accounter) throws IOException {
            return NBTTagString.a(1.d(input, accounter));
        }

        @Override
        public StreamTagVisitor.b a(DataInput input, StreamTagVisitor visitor, NBTReadLimiter accounter) throws IOException {
            return visitor.a(1.d(input, accounter));
        }

        private static String d(DataInput input, NBTReadLimiter nbtAccounter) throws IOException {
            nbtAccounter.b(36L);
            String utf = input.readUTF();
            nbtAccounter.a(2L, utf.length());
            return utf;
        }

        @Override
        public void b(DataInput input, NBTReadLimiter accounter) throws IOException {
            NBTTagString.a(input);
        }

        @Override
        public String a() {
            return "STRING";
        }

        @Override
        public String b() {
            return "TAG_String";
        }

        @Override
        public boolean d() {
            return true;
        }
    };
    private static final NBTTagString c = new NBTTagString("");
    private static final char w = '\"';
    private static final char x = '\'';
    private static final char y = '\\';
    private static final char z = '\u0000';
    private final String A;

    public static void a(DataInput input) throws IOException {
        input.skipBytes(input.readUnsignedShort());
    }

    private NBTTagString(String data) {
        Objects.requireNonNull(data, "Null string not allowed");
        this.A = data;
    }

    public static NBTTagString a(String data) {
        return data.isEmpty() ? c : new NBTTagString(data);
    }

    @Override
    public void a(DataOutput output) throws IOException {
        output.writeUTF(this.A);
    }

    @Override
    public int a() {
        return 36 + 2 * this.A.length();
    }

    @Override
    public byte b() {
        return 8;
    }

    public NBTTagType<NBTTagString> c() {
        return a;
    }

    @Override
    public String toString() {
        return NBTBase.super.u_();
    }

    public NBTTagString e() {
        return this;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof NBTTagString && Objects.equals(this.A, ((NBTTagString)other).A);
    }

    public int hashCode() {
        return this.A.hashCode();
    }

    @Override
    public String u_() {
        return this.A;
    }

    @Override
    public void a(TagVisitor visitor) {
        visitor.a(this);
    }

    public static String b(String text) {
        StringBuilder stringBuilder = new StringBuilder(" ");
        char c2 = '\u0000';
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char c1 = text.charAt(i2);
            if (c1 == '\\') {
                stringBuilder.append('\\');
            } else if (c1 == '\"' || c1 == '\'') {
                if (c2 == '\u0000') {
                    c2 = (char)(c1 == '\"' ? 39 : 34);
                }
                if (c2 == c1) {
                    stringBuilder.append('\\');
                }
            }
            stringBuilder.append(c1);
        }
        if (c2 == '\u0000') {
            c2 = '\"';
        }
        stringBuilder.setCharAt(0, c2);
        stringBuilder.append(c2);
        return stringBuilder.toString();
    }

    @Override
    public StreamTagVisitor.b a(StreamTagVisitor visitor) {
        return visitor.a(this.A);
    }
}

